/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchTileEntity;
import com.railwayteam.railways.mixin_interfaces.ISwitchDisabledEdge;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalPropagator;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackSwitch
extends SingleBlockEntityEdgePoint {
    private TrackNodeLocation switchPoint;
    private final List<TrackNodeLocation> exits = new ArrayList<TrackNodeLocation>();
    private static int selectionPriorityTicker = 0;
    @Nullable
    private TrackNodeLocation straightExit;
    @Nullable
    private TrackNodeLocation leftExit;
    @Nullable
    private TrackNodeLocation rightExit;
    @NotNull
    private TrackSwitchBlock.SwitchState switchState = TrackSwitchBlock.SwitchState.NORMAL;
    private boolean automatic;
    private boolean locked;
    private boolean autoTrainsSwitch;
    private int ticks = 0;
    boolean forceTickClient = false;

    @ApiStatus.Internal
    public static int getSelectionPriority() {
        return ++selectionPriorityTicker;
    }

    public boolean shouldAutoTrainsSwitch() {
        return this.autoTrainsSwitch;
    }

    void setAutoTrainsSwitch(boolean autoTrainsSwitch) {
        this.autoTrainsSwitch = autoTrainsSwitch;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public boolean isLocked() {
        return this.locked;
    }

    void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Nullable
    private TrackNodeLocation getExit(TrackSwitchBlock.SwitchState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case TrackSwitchBlock.SwitchState.NORMAL -> this.straightExit;
            case TrackSwitchBlock.SwitchState.REVERSE_RIGHT -> this.rightExit;
            case TrackSwitchBlock.SwitchState.REVERSE_LEFT -> this.leftExit;
        };
    }

    private Map<TrackSwitchBlock.SwitchState, Optional<TrackNodeLocation>> getExistingExits() {
        return Map.of(TrackSwitchBlock.SwitchState.NORMAL, Optional.ofNullable(this.straightExit), TrackSwitchBlock.SwitchState.REVERSE_LEFT, Optional.ofNullable(this.leftExit), TrackSwitchBlock.SwitchState.REVERSE_RIGHT, Optional.ofNullable(this.rightExit));
    }

    @ApiStatus.Internal
    @Nullable
    public TrackSwitchBlock.SwitchState getTargetState(TrackNodeLocation loc) {
        for (Map.Entry<TrackSwitchBlock.SwitchState, Optional<TrackNodeLocation>> entry : this.getExistingExits().entrySet()) {
            if (!entry.getValue().isPresent() || !entry.getValue().get().equals((Object)loc)) continue;
            return entry.getKey();
        }
        return null;
    }

    public EdgePointType<?> getType() {
        return CREdgePointTypes.SWITCH;
    }

    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return otherType == EdgePointType.SIGNAL;
    }

    public void blockEntityAdded(class_2586 tile, boolean front) {
        super.blockEntityAdded(tile, front);
        if (tile instanceof TrackSwitchTileEntity) {
            TrackSwitchTileEntity te = (TrackSwitchTileEntity)tile;
            te.calculateExits(this);
            this.automatic = te.isAutomatic();
            this.locked = te.isLocked();
        }
        this.notifyTrains(tile.method_10997());
    }

    public void onRemoved(TrackGraph graph) {
        this.exits.clear();
        this.sortExits();
        this.removeFromAllGraphs();
    }

    private void notifyTrains(class_1937 level) {
        TrackGraph graph = Create.RAILWAYS.sided((class_1936)level).getGraph((class_1936)level, (TrackNodeLocation)this.edgeLocation.getFirst());
        if (graph == null) {
            return;
        }
        TrackEdge edge = graph.getConnection(this.edgeLocation.map(arg_0 -> ((TrackGraph)graph).locateNode(arg_0)));
        if (edge == null) {
            return;
        }
        SignalPropagator.notifyTrains((TrackGraph)graph, (TrackEdge[])new TrackEdge[]{edge});
    }

    void updateExits(TrackNodeLocation switchPoint, Collection<TrackNodeLocation> newExits) {
        this.switchPoint = switchPoint;
        if (this.edgeLocation == null) {
            this.exits.clear();
            return;
        }
        class_243 forward = ((TrackNodeLocation)this.edgeLocation.getFirst()).getLocation().method_1035(((TrackNodeLocation)this.edgeLocation.getSecond()).getLocation());
        this.exits.clear();
        this.exits.addAll(newExits.stream().filter(e -> forward.method_1026(switchPoint.getLocation().method_1035(e.getLocation())) > 0.0).toList());
        this.sortExits();
        this.ensureValidState();
    }

    private void sortExits() {
        class_243 forward = ((TrackNodeLocation)this.edgeLocation.getFirst()).getLocation().method_1035(((TrackNodeLocation)this.edgeLocation.getSecond()).getLocation()).method_1029();
        this.exits.sort(Comparator.comparing(e -> {
            class_243 exitDir = this.switchPoint.getLocation().method_1035(e.getLocation());
            return forward.field_1352 * exitDir.field_1350 - forward.field_1350 * exitDir.field_1352;
        }));
        if (this.exits.size() == 1) {
            this.leftExit = null;
            this.straightExit = this.exits.get(0);
            this.rightExit = null;
        } else if (this.exits.size() == 2) {
            class_243 firstExitDir = this.switchPoint.getLocation().method_1035(this.exits.get(0).getLocation()).method_1029();
            class_243 secondExitDir = this.switchPoint.getLocation().method_1035(this.exits.get(1).getLocation()).method_1029();
            double firstExitRelativeDir = forward.field_1352 * firstExitDir.field_1350 - forward.field_1350 * firstExitDir.field_1352;
            double secondExitRelativeDir = forward.field_1352 * secondExitDir.field_1350 - forward.field_1350 * secondExitDir.field_1352;
            double cutoff = 0.2;
            if (firstExitRelativeDir < 0.0 && secondExitRelativeDir <= cutoff) {
                this.leftExit = this.exits.get(0);
                this.straightExit = this.exits.get(1);
                this.rightExit = null;
            } else if (firstExitRelativeDir >= -cutoff && secondExitRelativeDir > 0.0) {
                this.leftExit = null;
                this.straightExit = this.exits.get(0);
                this.rightExit = this.exits.get(1);
            } else {
                this.leftExit = this.exits.get(0);
                this.straightExit = null;
                this.rightExit = this.exits.get(1);
            }
        } else if (this.exits.size() == 3) {
            this.leftExit = this.exits.get(0);
            this.straightExit = this.exits.get(1);
            this.rightExit = this.exits.get(2);
        } else {
            this.leftExit = null;
            this.straightExit = null;
            this.rightExit = null;
        }
    }

    @Nullable
    TrackNodeLocation getSwitchPoint() {
        return this.switchPoint;
    }

    Collection<TrackNodeLocation> getExits() {
        return this.exits.stream().toList();
    }

    private boolean isStateValid(TrackSwitchBlock.SwitchState state) {
        if (state == null) {
            return false;
        }
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case TrackSwitchBlock.SwitchState.NORMAL -> this.hasStraightExit();
            case TrackSwitchBlock.SwitchState.REVERSE_RIGHT -> this.hasRightExit();
            case TrackSwitchBlock.SwitchState.REVERSE_LEFT -> this.hasLeftExit();
        };
    }

    private TrackSwitchBlock.SwitchState getValidSwitchState() {
        for (TrackSwitchBlock.SwitchState state : TrackSwitchBlock.SwitchState.values()) {
            if (!this.isStateValid(state)) continue;
            return state;
        }
        return TrackSwitchBlock.SwitchState.NORMAL;
    }

    void ensureValidState() {
        if (!this.isStateValid(this.switchState)) {
            this.switchState = this.getValidSwitchState();
        }
    }

    public boolean trySetSwitchState(@NotNull TrackSwitchBlock.SwitchState state) {
        if (this.isLocked()) {
            return false;
        }
        return this.setSwitchState(state);
    }

    public boolean setSwitchState(@NotNull TrackSwitchBlock.SwitchState state) {
        if (this.isStateValid(state) && this.switchState != state) {
            this.switchState = state;
            this.ticks = 10000;
            this.forceTickClient = true;
            return true;
        }
        return false;
    }

    @NotNull
    public TrackSwitchBlock.SwitchState getSwitchState() {
        return this.switchState;
    }

    @Nullable
    public TrackNodeLocation getSwitchTarget() {
        return switch (this.switchState) {
            default -> throw new IncompatibleClassChangeError();
            case TrackSwitchBlock.SwitchState.NORMAL -> this.straightExit;
            case TrackSwitchBlock.SwitchState.REVERSE_RIGHT -> this.rightExit;
            case TrackSwitchBlock.SwitchState.REVERSE_LEFT -> this.leftExit;
        };
    }

    public boolean hasStraightExit() {
        return this.straightExit != null;
    }

    public boolean hasLeftExit() {
        return this.leftExit != null;
    }

    public boolean hasRightExit() {
        return this.rightExit != null;
    }

    public void write(class_2487 nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        nbt.method_10566("SwitchPoint", (class_2520)this.switchPoint.write(dimensions));
        nbt.method_10566("Exits", (class_2520)NBTHelper.writeCompoundList(this.exits, e -> e.write(dimensions)));
        nbt.method_10582("SwitchState", this.switchState.method_15434());
        nbt.method_10556("Automatic", this.automatic);
        nbt.method_10556("Locked", this.locked);
        nbt.method_10556("AutoTrainsSwitch", this.autoTrainsSwitch);
    }

    public void write(class_2540 buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.writeInt(this.switchState.ordinal());
        buffer.writeBoolean(this.automatic);
        buffer.writeBoolean(this.locked);
        this.switchPoint.send(buffer, dimensions);
        buffer.method_34062(this.exits, (buf, e) -> e.send(buf, dimensions));
    }

    public void read(class_2487 nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        String exit = nbt.method_10558("SwitchState");
        try {
            this.switchState = TrackSwitchBlock.SwitchState.valueOf(exit.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            this.switchState = this.getValidSwitchState();
        }
        this.automatic = nbt.method_10577("Automatic");
        this.locked = nbt.method_10577("Locked");
        this.autoTrainsSwitch = nbt.method_10577("AutoTrainsSwitch");
        this.updateExits(TrackNodeLocation.read((class_2487)nbt.method_10562("SwitchPoint"), (DimensionPalette)dimensions), nbt.method_10554("Exits", 10).stream().map(t -> TrackNodeLocation.read((class_2487)((class_2487)t), (DimensionPalette)dimensions)).toList());
    }

    public void read(class_2540 buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        this.switchState = TrackSwitchBlock.SwitchState.values()[buffer.readInt()];
        this.automatic = buffer.readBoolean();
        this.locked = buffer.readBoolean();
        this.updateExits(TrackNodeLocation.receive((class_2540)buffer, (DimensionPalette)dimensions), buffer.method_34066(buf -> TrackNodeLocation.receive((class_2540)buf, (DimensionPalette)dimensions)));
    }

    boolean doForceTickClient() {
        if (this.forceTickClient) {
            this.forceTickClient = false;
            return true;
        }
        return false;
    }

    public void tick(TrackGraph graph, boolean preTrains) {
        super.tick(graph, preTrains);
        if (preTrains) {
            ++this.ticks;
            if (this.ticks < 10) {
                return;
            }
            this.ticks = 0;
            this.updateEdges(graph);
            if (this.automatic) {
                this.switchForEdges(graph);
            }
        }
    }

    public void updateEdges(TrackGraph graph) {
        this.updateEdges(graph, false);
    }

    public void setEdgesActive(TrackGraph graph) {
        this.updateEdges(graph, true);
    }

    private void updateEdges(TrackGraph graph, boolean forceActive) {
        TrackNodeLocation from = this.switchPoint;
        for (TrackNodeLocation to : this.exits) {
            TrackEdge reverseEdge;
            TrackNode toNode;
            Map connections;
            if (to == null || (connections = graph.getConnectionsFrom(toNode = graph.locateNode(to))) == null) continue;
            TrackNode closestFromNode = null;
            TrackEdge closestEdge = null;
            double closestDistance = Double.MAX_VALUE;
            for (Map.Entry otherEnd : connections.entrySet()) {
                double distance = ((TrackNode)otherEnd.getKey()).getLocation().method_10262((class_2382)from);
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closestEdge = (TrackEdge)otherEnd.getValue();
                closestFromNode = (TrackNode)otherEnd.getKey();
            }
            if (closestEdge != null) {
                ((ISwitchDisabledEdge)closestEdge.getEdgeData()).setEnabled(forceActive || this.getSwitchTarget() == to);
                ((ISwitchDisabledEdge)closestEdge.getEdgeData()).setAutomatic(!forceActive && this.automatic && !this.locked && this.autoTrainsSwitch);
            }
            if (closestFromNode == null || (reverseEdge = graph.getConnection(Couple.create(closestFromNode, (Object)toNode))) == null) continue;
            ((ISwitchDisabledEdge)reverseEdge.getEdgeData()).setEnabled(forceActive || this.getSwitchTarget() == to);
            ((ISwitchDisabledEdge)reverseEdge.getEdgeData()).setAutomatic(!forceActive && this.automatic && !this.locked && this.autoTrainsSwitch);
        }
    }

    private void switchForEdges(TrackGraph graph) {
        TrackNodeLocation from = this.switchPoint;
        TrackNodeLocation highestPriorityExit = null;
        int highestPriority = -100;
        for (TrackNodeLocation to : this.exits) {
            ISwitchDisabledEdge reverseSwitchEdge;
            TrackEdge reverseEdge;
            ISwitchDisabledEdge switchEdge;
            TrackNode toNode;
            Map connections;
            if (to == null || (connections = graph.getConnectionsFrom(toNode = graph.locateNode(to))) == null) continue;
            TrackNode closestFromNode = null;
            TrackEdge closestEdge = null;
            double closestDistance = Double.MAX_VALUE;
            for (Map.Entry otherEnd : connections.entrySet()) {
                double distance = ((TrackNode)otherEnd.getKey()).getLocation().method_10262((class_2382)from);
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closestEdge = (TrackEdge)otherEnd.getValue();
                closestFromNode = (TrackNode)otherEnd.getKey();
            }
            if (closestEdge != null && (switchEdge = (ISwitchDisabledEdge)closestEdge.getEdgeData()).isAutomaticallySelected()) {
                if (switchEdge.getAutomaticallySelectedPriority() > highestPriority) {
                    highestPriorityExit = to;
                    highestPriority = switchEdge.getAutomaticallySelectedPriority();
                }
                switchEdge.ackAutomaticSelection();
            }
            if (closestFromNode == null || (reverseEdge = graph.getConnection(Couple.create(closestFromNode, (Object)toNode))) == null || !(reverseSwitchEdge = (ISwitchDisabledEdge)reverseEdge.getEdgeData()).isAutomaticallySelected()) continue;
            if (reverseSwitchEdge.getAutomaticallySelectedPriority() > highestPriority) {
                highestPriorityExit = to;
                highestPriority = reverseSwitchEdge.getAutomaticallySelectedPriority();
            }
            reverseSwitchEdge.ackAutomaticSelection();
        }
        if (highestPriorityExit != null) {
            for (TrackSwitchBlock.SwitchState state : TrackSwitchBlock.SwitchState.values()) {
                if (highestPriorityExit != this.getExit(state)) continue;
                this.setSwitchState(state);
                break;
            }
        }
    }
}

