/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.google.common.collect.ImmutableList;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.content.custom_bogeys.CRBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.CategoryIcon;
import com.railwayteam.railways.content.custom_bogeys.invisible.InvisibleBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.monobogey.InvisibleMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.monobogey.MonoBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.selection_menu.BogeyCategoryHandlerClient;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class CRBogeyStyles {
    private static final Map<Pair<BogeyStyle, TrackMaterial.TrackType>, BogeyStyle> STYLES_FOR_GAUGES = new HashMap<Pair<BogeyStyle, TrackMaterial.TrackType>, BogeyStyle>();
    private static final Map<BogeyStyle, BogeyStyle> STYLES_TO_STANDARD_GAUGE = new HashMap<BogeyStyle, BogeyStyle>();
    private static final Set<BogeyStyle> SUB_LISTED_STYLES = new HashSet<BogeyStyle>();
    private static final Map<BogeyStyle, List<BogeyStyle>> SUB_STYLES = new HashMap<BogeyStyle, List<BogeyStyle>>();
    private static final List<BogeyStyle> EMPTY = ImmutableList.of();
    public static final BogeyStyle MONOBOGEY = CRBogeyStyles.create("monobogey", "monobogey").displayName((class_2561)Components.translatable((String)"railways.bogeys.styles.monobogey")).size(BogeySizes.SMALL, () -> MonoBogeyRenderer.SmallMonoBogeyRenderer::new, CRBlocks.MONO_BOGEY).build();
    public static final BogeyStyle INVISIBLE = CRBogeyStyles.create("invisible", Create.asResource((String)"standard")).displayName((class_2561)Components.translatable((String)"railways.bogeys.styles.invisible")).size(BogeySizes.SMALL, () -> InvisibleBogeyRenderer::new, CRBlocks.INVISIBLE_BOGEY).contactParticle((class_2394)new CubeParticleData()).build();
    public static final BogeyStyle INVISIBLE_MONOBOGEY = CRBogeyStyles.create("invisible_monobogey", "monobogey").displayName((class_2561)Components.translatable((String)"railways.bogeys.styles.invisible_monobogey")).size(BogeySizes.SMALL, () -> InvisibleBogeyRenderer::new, CRBlocks.INVISIBLE_MONO_BOGEY).contactParticle((class_2394)new CubeParticleData()).build();
    public static final String SINGLEAXLE_CYCLE_GROUP = "singleaxles";
    public static final String DOUBLEAXLE_CYCLE_GROUP = "doubleaxles";
    public static final String TRIPLEAXLE_CYCLE_GROUP = "tripleaxles";
    public static final String WIDE_DOUBLEAXLE_CYCLE_GROUP = "wide_doubleaxles";
    public static final BogeyStyle SINGLEAXLE = CRBogeyStyles.create("singleaxle", "singleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.SingleaxleBogeyRenderer::new, CRBlocks.SINGLEAXLE_BOGEY).build();
    public static final BogeyStyle LEAFSPRING = CRBogeyStyles.create("leafspring", "singleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.LeafspringBogeyRenderer::new, CRBlocks.SINGLEAXLE_BOGEY).build();
    public static final BogeyStyle COILSPRING = CRBogeyStyles.create("coilspring", "singleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.CoilspringBogeyRenderer::new, CRBlocks.SINGLEAXLE_BOGEY).build();
    public static final BogeyStyle FREIGHT = CRBogeyStyles.create("freight", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.FreightBogeyRenderer::new, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle ARCHBAR = CRBogeyStyles.create("archbar", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.ArchbarBogeyRenderer::new, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle PASSENGER = CRBogeyStyles.create("passenger", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.PassengerBogeyRenderer::new, CRBlocks.DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle MODERN = CRBogeyStyles.create("modern", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.ModernBogeyRenderer::new, CRBlocks.DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle BLOMBERG = CRBogeyStyles.create("blomberg", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.BlombergBogeyRenderer::new, CRBlocks.DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle Y25 = CRBogeyStyles.create("y25", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.Y25BogeyRenderer::new, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle HEAVYWEIGHT = CRBogeyStyles.create("heavyweight", "tripleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.HeavyweightBogeyRenderer::new, CRBlocks.TRIPLEAXLE_BOGEY).build();
    public static final BogeyStyle RADIAL = CRBogeyStyles.create("radial", "tripleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.RadialBogeyRenderer::new, CRBlocks.TRIPLEAXLE_BOGEY).build();
    public static final BogeyStyle WIDE_DEFAULT = CRBogeyStyles.create("wide_default", Create.asResource((String)"standard")).displayName((class_2561)Components.translatable((String)"railways.bogeys.styles.wide_default")).size(BogeySizes.SMALL, () -> CRBogeyRenderer.WideDefaultBogeyRenderer::new, CRBlocks.WIDE_DOUBLEAXLE_BOGEY).size(BogeySizes.LARGE, () -> CRBogeyRenderer.WideScotchYokeBogeyRenderer::new, CRBlocks.WIDE_SCOTCH_BOGEY).build();
    public static final BogeyStyle WIDE_COMICALLY_LARGE = CRBogeyStyles.create("wide_comically_large", Create.asResource((String)"standard")).displayName((class_2561)Components.translatable((String)"railways.bogeys.styles.wide_comically_large")).size(BogeySizes.LARGE, () -> CRBogeyRenderer.WideComicallyLargeScotchYokeBogeyRenderer::new, CRBlocks.WIDE_COMICALLY_LARGE_BOGEY).build();
    public static final BogeyStyle NARROW_DEFAULT = CRBogeyStyles.create("narrow_default", Create.asResource((String)"standard")).displayName((class_2561)Components.translatable((String)"railways.bogeys.styles.narrow_default")).size(BogeySizes.SMALL, () -> CRBogeyRenderer.NarrowSmallBogeyRenderer::new, CRBlocks.NARROW_SMALL_BOGEY).size(BogeySizes.LARGE, () -> CRBogeyRenderer.NarrowScotchYokeBogeyRenderer::new, CRBlocks.NARROW_SCOTCH_BOGEY).build();
    public static final BogeyStyle NARROW_DOUBLE_SCOTCH = CRBogeyStyles.create("narrow_double_scotch", Create.asResource((String)"standard")).displayName((class_2561)Components.translatable((String)"railways.bogeys.styles.narrow_double_scotch")).size(BogeySizes.LARGE, () -> CRBogeyRenderer.NarrowDoubleScotchYokeBogeyRenderer::new, CRBlocks.NARROW_DOUBLE_SCOTCH_BOGEY).build();

    public static void map(BogeyStyle from, TrackMaterial.TrackType toType, BogeyStyle toStyle) {
        CRBogeyStyles.map(from, toType, toStyle, true);
    }

    public static void map(BogeyStyle from, TrackMaterial.TrackType toType, BogeyStyle toStyle, boolean reverseToStandardGauge) {
        STYLES_FOR_GAUGES.put((Pair<BogeyStyle, TrackMaterial.TrackType>)Pair.of((Object)from, (Object)toType), toStyle);
        if (reverseToStandardGauge) {
            CRBogeyStyles.mapReverse(toStyle, from);
        }
    }

    public static void mapReverse(BogeyStyle gaugeStyle, BogeyStyle standardStyle) {
        STYLES_TO_STANDARD_GAUGE.put(gaugeStyle, standardStyle);
    }

    public static boolean styleFitsTrack(BogeyStyle style, TrackMaterial.TrackType trackType) {
        class_2248 class_22482 = style.getNextBlock(BogeySizes.LARGE);
        if (class_22482 instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogeyBlock = (AbstractBogeyBlock)class_22482;
            return bogeyBlock.getValidPathfindingTypes(style).contains(trackType) && trackType != CRTrackMaterials.CRTrackType.MONORAIL ^ bogeyBlock instanceof InvisibleMonoBogeyBlock;
        }
        return true;
    }

    public static Optional<BogeyStyle> getMapped(BogeyStyle from, TrackMaterial.TrackType toType) {
        return CRBogeyStyles.getMappedRecursive(from, toType, false);
    }

    private static Optional<BogeyStyle> getMappedRecursive(BogeyStyle from, TrackMaterial.TrackType toType, boolean recursive) {
        AbstractBogeyBlock bogeyBlock;
        class_2248 class_22482 = from.getNextBlock(BogeySizes.LARGE);
        if (class_22482 instanceof AbstractBogeyBlock && (bogeyBlock = (AbstractBogeyBlock)class_22482).getValidPathfindingTypes(from).contains(toType)) {
            return Optional.of(from);
        }
        Pair key = Pair.of((Object)from, (Object)toType);
        if (STYLES_FOR_GAUGES.containsKey(key)) {
            return Optional.of(STYLES_FOR_GAUGES.get(key));
        }
        if (toType == TrackMaterial.TrackType.STANDARD && STYLES_TO_STANDARD_GAUGE.containsKey(from)) {
            return Optional.of(STYLES_TO_STANDARD_GAUGE.get(from));
        }
        if (toType != TrackMaterial.TrackType.STANDARD && !recursive) {
            return CRBogeyStyles.getMappedRecursive(from, TrackMaterial.TrackType.STANDARD, true).flatMap(standardStyle -> CRBogeyStyles.getMappedRecursive(standardStyle, toType, true));
        }
        return Optional.empty();
    }

    public static Optional<BogeyStyle> getMapped(BogeyStyle from, TrackMaterial.TrackType toType, boolean forceFit) {
        AbstractBogeyBlock bogeyBlock;
        class_2248 class_22482;
        Optional<BogeyStyle> mapped = CRBogeyStyles.getMapped(from, toType);
        if (!forceFit || toType == TrackMaterial.TrackType.STANDARD && mapped.isEmpty()) {
            return mapped;
        }
        if (mapped.isEmpty() || (class_22482 = mapped.get().getNextBlock(BogeySizes.LARGE)) instanceof AbstractBogeyBlock && !(bogeyBlock = (AbstractBogeyBlock)class_22482).getValidPathfindingTypes(mapped.get()).contains(toType)) {
            return AllBogeyStyles.BOGEY_STYLES.values().stream().filter(style -> CRBogeyStyles.styleFitsTrack(style, toType)).findFirst();
        }
        return mapped;
    }

    public static void listUnder(BogeyStyle target, BogeyStyle parent) {
        SUB_LISTED_STYLES.add(target);
        List sub = SUB_STYLES.computeIfAbsent(parent, s -> new ArrayList());
        if (!sub.contains(target)) {
            sub.add(target);
        }
    }

    public static boolean hideInSelectionMenu(BogeyStyle style) {
        return SUB_LISTED_STYLES.contains(style);
    }

    public static List<BogeyStyle> getSubStyles(BogeyStyle style) {
        return SUB_STYLES.getOrDefault(style, EMPTY);
    }

    public static AllBogeyStyles.BogeyStyleBuilder create(String name, String cycleGroup) {
        return CRBogeyStyles.create(Railways.asResource(name), Railways.asResource(cycleGroup)).displayName((class_2561)Components.translatable((String)("railways.bogeys.styles." + name)));
    }

    public static AllBogeyStyles.BogeyStyleBuilder create(String name, class_2960 cycleGroup) {
        return CRBogeyStyles.create(Railways.asResource(name), cycleGroup);
    }

    public static AllBogeyStyles.BogeyStyleBuilder create(class_2960 name, class_2960 cycleGroup) {
        return new AllBogeyStyles.BogeyStyleBuilder(name, cycleGroup);
    }

    public static void register() {
        Railways.LOGGER.info("Registered bogey styles from railways");
        CRBogeyStyles.map(AllBogeyStyles.STANDARD, CRTrackMaterials.CRTrackType.WIDE_GAUGE, WIDE_DEFAULT);
        CRBogeyStyles.map(AllBogeyStyles.STANDARD, CRTrackMaterials.CRTrackType.NARROW_GAUGE, NARROW_DEFAULT);
        CRBogeyStyles.mapReverse(NARROW_DOUBLE_SCOTCH, AllBogeyStyles.STANDARD);
        CRBogeyStyles.mapReverse(WIDE_COMICALLY_LARGE, AllBogeyStyles.STANDARD);
        CRBogeyStyles.listUnder(WIDE_DEFAULT, AllBogeyStyles.STANDARD);
        CRBogeyStyles.listUnder(NARROW_DEFAULT, AllBogeyStyles.STANDARD);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient() {
        BogeyCategoryHandlerClient.registerStyleCategory(Create.asResource((String)"standard"), CategoryIcon.standardSupplier("default_icon"));
        BogeyCategoryHandlerClient.registerStyleCategory(SINGLEAXLE_CYCLE_GROUP, CategoryIcon.standardSupplier("singleaxle_icon"));
        BogeyCategoryHandlerClient.registerStyleCategory(DOUBLEAXLE_CYCLE_GROUP, CategoryIcon.standardSupplier("freight_icon"));
        BogeyCategoryHandlerClient.registerStyleCategory(TRIPLEAXLE_CYCLE_GROUP, CategoryIcon.standardSupplier("radial_icon"));
        if (Mods.EXTENDEDBOGEYS.isLoaded) {
            BogeyCategoryHandlerClient.registerStyleCategory("extendedbogeys", CategoryIcon.standardSupplier("eb_triple_axle_icon"));
        }
    }
}

