/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_4081;
import net.minecraft.class_4174;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.helpers.DynamicFood;

public class FoodHelper {
    public static float REGEN_EXHAUSTION_INCREMENT = 6.0f;
    public static float MAX_EXHAUSTION = 4.0f;

    public static boolean isFood(class_1799 itemStack) {
        if (itemStack.method_7909() == null) {
            return false;
        }
        return itemStack.method_7909().method_19263();
    }

    public static boolean canConsume(class_1799 itemStack, class_1657 player) {
        if (!FoodHelper.isFood(itemStack)) {
            return false;
        }
        class_4174 itemFood = itemStack.method_7909().method_19264();
        if (itemFood == null) {
            return false;
        }
        return player.method_7332(itemFood.method_19233());
    }

    public static FoodValues getDefaultFoodValues(class_1799 itemStack) {
        class_4174 itemFood = itemStack.method_7909().method_19264();
        int hunger = itemFood != null ? itemFood.method_19230() : 0;
        float saturationModifier = itemFood != null ? itemFood.method_19231() : 0.0f;
        return new FoodValues(hunger, saturationModifier);
    }

    public static FoodValues getModifiedFoodValues(class_1799 itemStack, class_1657 player) {
        if (itemStack.method_7909() instanceof DynamicFood) {
            DynamicFood food = (DynamicFood)itemStack.method_7909();
            int hunger = food.getDynamicHunger(itemStack, player);
            float saturationModifier = food.getDynamicSaturation(itemStack, player);
            return new FoodValues(hunger, saturationModifier);
        }
        return FoodHelper.getDefaultFoodValues(itemStack);
    }

    public static boolean isRotten(class_1799 itemStack) {
        if (!FoodHelper.isFood(itemStack)) {
            return false;
        }
        for (Pair effect : itemStack.method_7909().method_19264().method_19235()) {
            if (effect.getFirst() == null || ((class_1293)effect.getFirst()).method_5579() == null || ((class_1293)effect.getFirst()).method_5579().method_18792() != class_4081.field_18272) continue;
            return true;
        }
        return false;
    }

    public static float getEstimatedHealthIncrement(class_1799 itemStack, FoodValues modifiedFoodValues, class_1657 player) {
        if (!FoodHelper.isFood(itemStack)) {
            return 0.0f;
        }
        if (!player.method_7317()) {
            return 0.0f;
        }
        class_1702 stats = player.method_7344();
        class_1937 world = player.method_5770();
        int foodLevel = Math.min(stats.method_7586() + modifiedFoodValues.hunger, 20);
        float healthIncrement = 0.0f;
        if ((float)foodLevel >= 18.0f && world != null && world.method_8450().method_8355(class_1928.field_19395)) {
            float saturationLevel = Math.min(stats.method_7589() + modifiedFoodValues.getSaturationIncrement(), (float)foodLevel);
            float exhaustionLevel = stats.method_35219();
            healthIncrement = FoodHelper.getEstimatedHealthIncrement(foodLevel, saturationLevel, exhaustionLevel);
        }
        for (Pair effect : itemStack.method_7909().method_19264().method_19235()) {
            class_1293 effectInstance = (class_1293)effect.getFirst();
            if (effectInstance == null || effectInstance.method_5579() != class_1294.field_5924) continue;
            int amplifier = effectInstance.method_5578();
            int duration = effectInstance.method_5584();
            healthIncrement += (float)Math.floor(duration / Math.max(50 >> amplifier, 1));
            break;
        }
        return healthIncrement;
    }

    public static float getEstimatedHealthIncrement(int foodLevel, float saturationLevel, float exhaustionLevel) {
        float health = 0.0f;
        if (!Float.isFinite(exhaustionLevel) || !Float.isFinite(saturationLevel)) {
            return 0.0f;
        }
        while (foodLevel >= 18) {
            while (exhaustionLevel > MAX_EXHAUSTION) {
                exhaustionLevel -= MAX_EXHAUSTION;
                if (saturationLevel > 0.0f) {
                    saturationLevel = Math.max(saturationLevel - 1.0f, 0.0f);
                    continue;
                }
                --foodLevel;
            }
            if (foodLevel >= 20 && Float.compare(saturationLevel, Float.MIN_NORMAL) > 0) {
                float limitedSaturationLevel = Math.min(saturationLevel, REGEN_EXHAUSTION_INCREMENT);
                float exhaustionUntilAboveMax = Math.nextUp(MAX_EXHAUSTION) - exhaustionLevel;
                int numIterationsUntilAboveMax = Math.max(1, (int)Math.ceil(exhaustionUntilAboveMax / limitedSaturationLevel));
                health += limitedSaturationLevel / REGEN_EXHAUSTION_INCREMENT * (float)numIterationsUntilAboveMax;
                exhaustionLevel += limitedSaturationLevel * (float)numIterationsUntilAboveMax;
                continue;
            }
            if (foodLevel < 18) continue;
            health += 1.0f;
            exhaustionLevel += REGEN_EXHAUSTION_INCREMENT;
        }
        return health;
    }
}

