/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3122;
import net.minecraft.class_3124;
import net.minecraft.class_3218;
import net.minecraft.class_5843;
import net.minecraft.class_6795;
import net.minecraft.class_6797;
import net.minecraft.class_6817;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.LifeCycleAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.StructureWorldNBT;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeatureBuilder;
import org.betterx.bclib.api.v3.levelgen.features.BCLPlacedFeatureBuilder;
import org.betterx.bclib.api.v3.levelgen.features.config.TemplateFeatureConfig;
import org.betterx.betternether.BN;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.features.configured.NetherObjects;
import org.betterx.betternether.registry.features.configured.NetherTerrain;
import org.betterx.betternether.registry.features.configured.NetherTrees;
import org.betterx.betternether.registry.features.configured.NetherVegetation;
import org.betterx.betternether.registry.features.configured.NetherVines;
import org.betterx.betternether.registry.features.placed.NetherObjectsPlaced;
import org.betterx.betternether.registry.features.placed.NetherTerrainPlaced;
import org.betterx.betternether.registry.features.placed.NetherTreesPlaced;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.registry.features.placed.NetherVinesPlaced;
import org.betterx.betternether.world.features.AnchorTreeBranchFeature;
import org.betterx.betternether.world.features.AnchorTreeFeature;
import org.betterx.betternether.world.features.AnchorTreeRootFeature;
import org.betterx.betternether.world.features.BigBrownMushroomFeature;
import org.betterx.betternether.world.features.CavesFeature;
import org.betterx.betternether.world.features.CrystalFeature;
import org.betterx.betternether.world.features.JellyfishMushroomFeature;
import org.betterx.betternether.world.features.LucisFeature;
import org.betterx.betternether.world.features.MushroomFirFeature;
import org.betterx.betternether.world.features.NetherSakuraBushFeature;
import org.betterx.betternether.world.features.NetherSakuraFeature;
import org.betterx.betternether.world.features.OldWillowTree;
import org.betterx.betternether.world.features.PathsFeature;
import org.betterx.betternether.world.features.RubeusBushFeature;
import org.betterx.betternether.world.features.RubeusTreeFeature;
import org.betterx.betternether.world.features.SoulLilyFeature;
import org.betterx.betternether.world.features.TwistedVinesFeature;
import org.betterx.betternether.world.features.WartBushFeature;
import org.betterx.betternether.world.features.WartCapFeature;
import org.betterx.betternether.world.features.WartTreeFeature;
import org.betterx.betternether.world.features.WillowBushFeature;
import org.betterx.betternether.world.features.WillowTreeFeature;
import org.betterx.betternether.world.structures.city.CityStructure;

public class NetherFeatures {
    public static final class_3031<class_3111> JELLYFISH_MUSHROOM = BCLFeature.register((class_2960)BN.id("jellyfish_mushroom"), (class_3031)new JellyfishMushroomFeature());
    public static final class_3031<class_3111> OBSIDIAN_CRYSTAL = BCLFeature.register((class_2960)BN.id("obsidian_crystal"), (class_3031)new CrystalFeature());
    public static final class_3031<class_3111> WART_BUSH = BCLFeature.register((class_2960)BN.id("wart_bush"), (class_3031)new WartBushFeature());
    public static final RubeusTreeFeature RUBEUS_TREE = (RubeusTreeFeature)BCLFeature.register((class_2960)BN.id("rubeus_tree"), (class_3031)new RubeusTreeFeature());
    public static final MushroomFirFeature MUSHROOM_FIR = (MushroomFirFeature)BCLFeature.register((class_2960)BN.id("mushroom_fir"), (class_3031)new MushroomFirFeature());
    public static final BigBrownMushroomFeature BIG_BROWN_MUSHROOM = (BigBrownMushroomFeature)BCLFeature.register((class_2960)BN.id("big_brown_mushroom"), (class_3031)new BigBrownMushroomFeature());
    public static final class_3031<class_3111> RUBEUS_BUSH = BCLFeature.register((class_2960)BN.id("rubeus_bush"), (class_3031)new RubeusBushFeature());
    public static final class_3031<class_3111> LUCIS = BCLFeature.register((class_2960)BN.id("lucis"), (class_3031)new LucisFeature());
    public static final SoulLilyFeature SOUL_LILY = (SoulLilyFeature)BCLFeature.register((class_2960)BN.id("soul_lily"), (class_3031)new SoulLilyFeature());
    public static final WartTreeFeature WART_TREE = (WartTreeFeature)BCLFeature.register((class_2960)BN.id("wart_tree"), (class_3031)new WartTreeFeature());
    public static final WillowBushFeature WILLOW_BUSH = (WillowBushFeature)BCLFeature.register((class_2960)BN.id("willow_bush"), (class_3031)new WillowBushFeature());
    public static final WillowTreeFeature WILLOW_TREE = (WillowTreeFeature)BCLFeature.register((class_2960)BN.id("willow_tree"), (class_3031)new WillowTreeFeature());
    public static final OldWillowTree OLD_WILLOW_TREE = (OldWillowTree)BCLFeature.register((class_2960)BN.id("old_willow_tree"), (class_3031)new OldWillowTree());
    public static final NetherSakuraFeature SAKURA_TREE = (NetherSakuraFeature)BCLFeature.register((class_2960)BN.id("sakura_tree"), (class_3031)new NetherSakuraFeature());
    public static final NetherSakuraBushFeature SAKURA_BUSH = (NetherSakuraBushFeature)BCLFeature.register((class_2960)BN.id("sakura_bush"), (class_3031)new NetherSakuraBushFeature());
    public static final AnchorTreeBranchFeature ANCHOR_TREE_BRANCH = (AnchorTreeBranchFeature)BCLFeature.register((class_2960)BN.id("anchor_tree_branch"), (class_3031)new AnchorTreeBranchFeature());
    public static final AnchorTreeFeature ANCHOR_TREE = (AnchorTreeFeature)BCLFeature.register((class_2960)BN.id("anchor_tree"), (class_3031)new AnchorTreeFeature());
    public static final AnchorTreeRootFeature ANCHOR_TREE_ROOT = (AnchorTreeRootFeature)BCLFeature.register((class_2960)BN.id("anchor_tree_root"), (class_3031)new AnchorTreeRootFeature());
    public static final WartCapFeature WART_CAP = (WartCapFeature)BCLFeature.register((class_2960)BN.id("wart_cap"), (class_3031)new WartCapFeature());
    public static final TwistedVinesFeature TWISTING_VINES = (TwistedVinesFeature)BCLFeature.register((class_2960)BN.id("twisting_vines"), (class_3031)new TwistedVinesFeature());
    private static final List<BCLFeature> defaultFeatures = Lists.newArrayList();
    public static final BCLFeature<class_3122, class_3124> CINCINNASITE_ORE = NetherFeatures.registerOre("cincinnasite", NetherBlocks.CINCINNASITE_ORE, 10, 8, 0.0f, class_6817.field_36083, false);
    public static final BCLFeature<class_3122, class_3124> NETHER_RUBY_ORE = NetherFeatures.registerOre("nether_ruby", NetherBlocks.NETHER_RUBY_ORE, 3, 8, 0.0f, (class_6797)class_6795.method_39634((class_5843)class_5843.method_33846((int)32), (class_5843)class_5843.method_33849((int)32)), false);
    public static final BCLFeature<class_3122, class_3124> NETHER_RUBY_ORE_SOUL = NetherFeatures.registerOre("nether_ruby_soul", NetherBlocks.NETHER_RUBY_ORE, class_2246.field_22090, 5, 5, 0.1f, (class_6797)class_6795.method_39634((class_5843)class_5843.method_33846((int)32), (class_5843)class_5843.method_33845()), false);
    public static final BCLFeature<class_3122, class_3124> NETHER_RUBY_ORE_LARGE = NetherFeatures.registerOre("nether_ruby_large", NetherBlocks.NETHER_RUBY_ORE, 5, 5, 0.1f, (class_6797)class_6795.method_39634((class_5843)class_5843.method_33846((int)32), (class_5843)class_5843.method_33845()), false);
    public static final BCLFeature<class_3122, class_3124> NETHER_RUBY_ORE_RARE = NetherFeatures.registerOre("nether_ruby_rare", NetherBlocks.NETHER_RUBY_ORE, 2, 12, 0.0f, (class_6797)class_6795.method_39637((class_5843)class_5843.method_33846((int)70), (class_5843)class_5843.method_33845()), true);
    public static final BCLFeature<class_3122, class_3124> NETHER_LAPIS_ORE = NetherFeatures.registerOre("nether_lapis", NetherBlocks.NETHER_LAPIS_ORE, 14, 4, 0.0f, (class_6797)class_6795.method_39637((class_5843)class_5843.method_33846((int)32), (class_5843)class_5843.method_33849((int)10)), false);
    public static final BCLFeature<class_3122, class_3124> NETHER_REDSTONE_ORE = NetherFeatures.registerOre("nether_redstone", NetherBlocks.NETHER_REDSTONE_ORE, 1, 16, 0.3f, (class_6797)class_6795.method_39637((class_5843)class_5843.method_33846((int)8), (class_5843)class_5843.method_33846((int)40)), true);

    private static BCLFeature<class_3122, class_3124> registerOre(String name, class_2248 blockOre, class_2248 baseBlock, int veins, int veinSize, float airDiscardChance, class_6797 placement, boolean rare) {
        int veins1 = Configs.GENERATOR.getInt("generator.world.ores." + name, "vein_count", veins);
        BCLPlacedFeatureBuilder builder = BCLFeatureBuilder.startOre((class_2960)BetterNether.makeID(name + "_ore")).add(baseBlock, blockOre).veinSize(Configs.GENERATOR.getInt("generator.world.ores." + name, "vein_size", veinSize)).discardChanceOnAirExposure(Configs.GENERATOR.getFloat("generator.world.ores." + name, "air_discard_chance", airDiscardChance)).build().place().decoration(class_2893.class_2895.field_13177);
        if (rare) {
            builder.onceEvery(veins1);
        } else {
            builder.count(veins1);
        }
        ((BCLPlacedFeatureBuilder)((BCLPlacedFeatureBuilder)builder.modifier(new class_6797[]{placement})).squarePlacement()).onlyInBiome();
        return builder.build();
    }

    private static BCLFeature<class_3122, class_3124> registerOre(String name, class_2248 blockOre, int veins, int veinSize, float airDiscardChance, class_6797 placement, boolean rare) {
        return NetherFeatures.registerOre(name, blockOre, class_2246.field_10515, veins, veinSize, airDiscardChance, placement, rare);
    }

    public static StructureWorldNBT cfg(class_2960 location, int offsetY, StructurePlacementType type, float chance) {
        return TemplateFeatureConfig.cfg((class_2960)location, (int)offsetY, (StructurePlacementType)type, (float)chance);
    }

    public static BCLBiomeBuilder addDefaultFeatures(BCLBiomeBuilder builder) {
        return builder;
    }

    public static void addDefaultBNFeatures(BCLBiomeBuilder builder) {
        for (BCLFeature f : defaultFeatures) {
            builder.feature(f);
        }
    }

    public static BCLBiomeBuilder addDefaultOres(BCLBiomeBuilder builder) {
        return builder.feature(CINCINNASITE_ORE).feature(NETHER_RUBY_ORE_RARE).feature(NETHER_LAPIS_ORE).feature(NETHER_REDSTONE_ORE);
    }

    public static void modifyNonBNBiome(class_2960 biomeID, class_6880<class_1959> biome) {
        BiomeAPI.addBiomeFeature(biome, CINCINNASITE_ORE);
        BiomeAPI.addBiomeFeature(biome, NETHER_RUBY_ORE_RARE);
        BiomeAPI.addBiomeFeature(biome, NETHER_LAPIS_ORE);
        BiomeAPI.addBiomeFeature(biome, NETHER_REDSTONE_ORE);
        if (biomeID.equals((Object)BiomeAPI.SOUL_SAND_VALLEY_BIOME.getID())) {
            BiomeAPI.addBiomeFeature(biome, NETHER_RUBY_ORE_LARGE);
        }
        if (biomeID.equals((Object)BiomeAPI.CRIMSON_FOREST_BIOME.getID()) || biomeID.equals((Object)BiomeAPI.WARPED_FOREST_BIOME.getID())) {
            BiomeAPI.addBiomeFeature(biome, NETHER_RUBY_ORE);
        }
    }

    public static void register() {
        NetherVegetation.ensureStaticInitialization();
        NetherVegetationPlaced.ensureStaticInitialization();
        NetherVines.ensureStaticInitialization();
        NetherVinesPlaced.ensureStaticInitialization();
        NetherTrees.ensureStaticInitialization();
        NetherTreesPlaced.ensureStaticInitialization();
        NetherObjects.ensureStaticInitialization();
        NetherObjectsPlaced.ensureStaticInitialization();
        NetherTerrain.ensureStaticInitialization();
        NetherTerrainPlaced.ensureStaticInitialization();
        LifeCycleAPI.onLevelLoad(NetherFeatures::onWorldLoad);
    }

    public static void onWorldLoad(class_3218 level, long seed, class_2378<class_1959> registry) {
        CavesFeature.onLoad(seed);
        PathsFeature.onLoad(seed);
        CityStructure.initGenerator();
    }
}

