/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Locale;
import java.util.Optional;

public enum GraphicsState {
    DEFAULT,
    REDUCED,
    MINIMAL;

    public static final Codec<GraphicsState> CODEC;

    static {
        CODEC = new PrimitiveCodec<GraphicsState>(){

            public <T> T write(DynamicOps<T> ops, GraphicsState value) {
                return (T)ops.createString(value.toString().toLowerCase(Locale.ROOT));
            }

            public <T> DataResult<GraphicsState> read(DynamicOps<T> ops, T input) {
                Optional value = ops.getStringValue(input).get().left();
                if (value.isEmpty()) {
                    return DataResult.error(() -> "Graphics state must not be empty!");
                }
                return DataResult.success((Object)((Object)GraphicsState.valueOf(((String)value.get()).toUpperCase(Locale.ROOT))));
            }
        };
    }
}

