/*
 * Decompiled with CFR 0.152.
 */
package com.duperknight.stoneworksChat.client;

import com.duperknight.stoneworksChat.client.ChannelGuiListener;
import com.duperknight.stoneworksChat.client.ChatCommandListener;
import com.duperknight.stoneworksChat.client.ChatConfirmationListener;
import com.duperknight.stoneworksChat.client.HudOverlayRenderer;
import com.duperknight.stoneworksChat.client.config.ChatConfig;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class StoneworksChatClient
implements ClientModInitializer {
    public static final String MOD_ID = "stoneworks-chat";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"stoneworks-chat");
    public static String currentChannel = "public";
    public static String pendingChannel = null;
    public static Map<String, Map<String, Object>> channels = new HashMap<String, Map<String, Object>>();
    public static boolean modTriggeredChannelsList = false;
    private static boolean channelGuiWasOpen = false;
    private static long lastGuiCloseTime = 0L;
    private static final long GUI_CLOSE_DELAY = 10L;
    private static boolean guiTriggeredUpdate = false;
    private static boolean delayedCommandScheduled = false;

    public void onInitializeClient() {
        ChatConfig.load();
        ChatCommandListener.register();
        ChatConfirmationListener.register();
        ChannelGuiListener.register();
        HudOverlayRenderer.register();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean isChannelGui;
            ChatConfirmationListener.checkTimeout();
            class_437 current = client.field_1755;
            boolean bl = isChannelGui = current instanceof class_476 && current.method_25440().getString().equals("Channels");
            if (isChannelGui && !channelGuiWasOpen) {
                channelGuiWasOpen = true;
                guiTriggeredUpdate = false;
            } else if (!isChannelGui && channelGuiWasOpen) {
                channelGuiWasOpen = false;
                lastGuiCloseTime = System.currentTimeMillis();
                delayedCommandScheduled = false;
            } else if (!isChannelGui && !channelGuiWasOpen && lastGuiCloseTime > 0L) {
                long timeSinceClose = System.currentTimeMillis() - lastGuiCloseTime;
                if (timeSinceClose >= 10L && !guiTriggeredUpdate && !delayedCommandScheduled) {
                    if (ChatConfirmationListener.requestChannelListUpdate()) {
                        delayedCommandScheduled = true;
                    }
                    lastGuiCloseTime = 0L;
                } else if (guiTriggeredUpdate) {
                    lastGuiCloseTime = 0L;
                }
            }
            if (isChannelGui && !channelGuiWasOpen) {
                lastGuiCloseTime = 0L;
                delayedCommandScheduled = false;
            }
        });
    }

    public static void markGuiUpdateTriggered() {
        guiTriggeredUpdate = true;
    }

    public static void sendCommand(String command) {
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            class_634 handler;
            class_746 player = client.field_1724;
            class_634 class_6342 = handler = player != null ? player.field_3944 : null;
            if (handler != null) {
                handler.method_45730(command);
            } else {
                LOGGER.warn("Cannot send command, networkHandler is null");
            }
        } else {
            LOGGER.warn("Cannot send command, client or player is null");
        }
    }
}

