/*
 * Decompiled with CFR 0.152.
 */
package com.duperknight.stoneworksChat.client.config;

import com.duperknight.stoneworksChat.client.StoneworksChatClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"stoneworks-chat");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "stoneworks_chat.json");

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                Map config = (Map)GSON.fromJson((Reader)reader, type);
                Object cc = config.get("currentChannel");
                StoneworksChatClient.currentChannel = cc instanceof String ? (String)cc : "public";
                Object channelsObj = config.get("channels");
                HashMap<String, Map<String, Object>> loadedChannels = new HashMap<String, Map<String, Object>>();
                if (channelsObj instanceof Map) {
                    Map rawMap = (Map)channelsObj;
                    for (Map.Entry e : rawMap.entrySet()) {
                        Object object = e.getKey();
                        if (!(object instanceof String)) continue;
                        String key = (String)object;
                        object = e.getValue();
                        if (!(object instanceof Map)) continue;
                        Map inner = (Map)object;
                        HashMap innerMap = new HashMap();
                        for (Map.Entry ie : inner.entrySet()) {
                            Object k = ie.getKey();
                            if (!(k instanceof String)) continue;
                            String ik = (String)k;
                            innerMap.put(ik, ie.getValue());
                        }
                        loadedChannels.put(key, innerMap);
                    }
                }
                StoneworksChatClient.channels = loadedChannels;
                LOGGER.info("Loaded config: currentChannel = {}", (Object)StoneworksChatClient.currentChannel);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config {}", (Object)CONFIG_FILE.getAbsolutePath(), (Object)e);
            }
        } else {
            StoneworksChatClient.channels = new HashMap<String, Map<String, Object>>();
        }
        ChatConfig.ensureDefaultChannels();
    }

    public static void save() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("currentChannel", StoneworksChatClient.currentChannel);
        config.put("channels", StoneworksChatClient.channels);
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(config, (Appendable)writer);
            LOGGER.info("Saved config: currentChannel = {}", (Object)StoneworksChatClient.currentChannel);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config {}", (Object)CONFIG_FILE.getAbsolutePath(), (Object)e);
        }
    }

    private static void ensureDefaultChannels() {
        ChatConfig.addDefaultChannel("public", "Global", "white", new String[]{"/g", "/global"}, "Global Chat");
        ChatConfig.addDefaultChannel("LocalChat", "Local", "green", new String[]{"/l", "/local"}, "Local Chat");
        ChatConfig.addDefaultChannel("TradeChat", "Trade", "cyan", new String[]{"/tradechat", "/tc"}, "Trade Chat");
        ChatConfig.addDefaultChannel("RPChat", "Roleplay", "light_red", new String[]{"/rpc"}, "RP Chat");
    }

    private static void addDefaultChannel(String key, String display, String color, String[] aliases, String uiName) {
        if (!StoneworksChatClient.channels.containsKey(key)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("display", display);
            map.put("color", color);
            map.put("aliases", aliases);
            map.put("uiName", uiName);
            StoneworksChatClient.channels.put(key, map);
        }
    }
}

