/*
 * Decompiled with CFR 0.152.
 */
package com.duperknight.stoneworksChat.client;

import com.duperknight.stoneworksChat.client.Channel;
import com.duperknight.stoneworksChat.client.StoneworksChatClient;
import com.duperknight.stoneworksChat.client.config.ChatConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;

public class ChatConfirmationListener {
    private static final Pattern CONFIRM_PATTERN = Pattern.compile("you\\s+are\\s+now\\s+talking\\s+on\\s+(.+?)(?:\\s*[!.])?$", 2);
    private static boolean collectingChannels = false;
    private static final List<String> channelStatuses = new ArrayList<String>();
    private static boolean channelListPending = false;
    private static long lastChannelListTime = 0L;
    private static final long CHANNEL_LIST_COOLDOWN = 200L;
    private static long collectingStartTime = 0L;
    private static long lastStatusLineTime = 0L;
    private static final long LIST_IDLE_PROCESS_MS = 200L;
    private static final long LIST_EMPTY_THRESHOLD_MS = 800L;
    private static boolean muteStatusLinesActive = false;
    private static final Set<String> expectedNormalized = new HashSet<String>();
    private static final Set<String> seenNormalized = new HashSet<String>();
    private static long statusMuteStartTime = 0L;
    private static final long STATUS_MUTE_TIMEOUT_MS = 2000L;
    private static final Set<String> CANONICAL_KEYS = new HashSet<String>(Arrays.asList("public", "LocalChat", "TradeChat", "RPChat", "StaffChat2", "AdminChat"));

    public static void register() {
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            if (StoneworksChatClient.modTriggeredChannelsList) {
                return;
            }
            String content = message.getString().trim();
            if (content.equalsIgnoreCase("Channels list:") || content.equalsIgnoreCase("Channel list:")) {
                collectingChannels = true;
                channelStatuses.clear();
                lastStatusLineTime = collectingStartTime = System.currentTimeMillis();
                return;
            }
            if (collectingChannels && (content.endsWith(" Status: Receiving") || content.endsWith(" Status: Muted") || content.endsWith(" Status: Transmitting"))) {
                channelStatuses.add(content);
                lastStatusLineTime = System.currentTimeMillis();
                if (content.endsWith(" Status: Transmitting")) {
                    collectingChannels = false;
                    ChatConfirmationListener.processChannelList();
                    return;
                }
                return;
            }
            if (collectingChannels) {
                collectingChannels = false;
                ChatConfirmationListener.processChannelList();
                return;
            }
            Matcher matcher = CONFIRM_PATTERN.matcher(content);
            if (matcher.find()) {
                String confirmedChannel = matcher.group(1).trim();
                if (StoneworksChatClient.pendingChannel != null && confirmedChannel.equalsIgnoreCase(StoneworksChatClient.pendingChannel)) {
                    ChatConfirmationListener.setCurrentChannel(StoneworksChatClient.pendingChannel);
                } else {
                    String best = ChatConfirmationListener.findBestKeyForRaw(confirmedChannel);
                    if (best != null) {
                        ChatConfirmationListener.setCurrentChannel(best);
                        return;
                    }
                    if (!confirmedChannel.equalsIgnoreCase(StoneworksChatClient.currentChannel)) {
                        String key = ChatConfirmationListener.resolveOrCreateChannelKey(confirmedChannel);
                        ChatConfirmationListener.setCurrentChannel(key);
                    }
                }
            }
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            String content = message.getString().trim();
            if (StoneworksChatClient.modTriggeredChannelsList) {
                if (content.equalsIgnoreCase("Channels list:") || content.equalsIgnoreCase("Channel list:")) {
                    collectingChannels = true;
                    channelStatuses.clear();
                    lastStatusLineTime = collectingStartTime = System.currentTimeMillis();
                    ChatConfirmationListener.beginStatusMute();
                    return false;
                }
                if (collectingChannels && (content.endsWith(" Status: Receiving") || content.endsWith(" Status: Muted") || content.endsWith(" Status: Transmitting"))) {
                    channelStatuses.add(content);
                    lastStatusLineTime = System.currentTimeMillis();
                    if (content.endsWith(" Status: Transmitting")) {
                        collectingChannels = false;
                        ChatConfirmationListener.processChannelList();
                    }
                    ChatConfirmationListener.trackSeenFromStatusLine(content);
                    return false;
                }
            }
            if (muteStatusLinesActive && content.contains(" Status: ")) {
                ChatConfirmationListener.trackSeenFromStatusLine(content);
                return false;
            }
            return true;
        });
    }

    public static boolean canRequestUpdate() {
        long currentTime = System.currentTimeMillis();
        return !channelListPending && currentTime - lastChannelListTime >= 200L;
    }

    public static boolean requestChannelListUpdate() {
        long currentTime = System.currentTimeMillis();
        if (channelListPending) {
            return false;
        }
        if (currentTime - lastChannelListTime < 200L) {
            return false;
        }
        channelListPending = true;
        lastChannelListTime = currentTime;
        StoneworksChatClient.modTriggeredChannelsList = true;
        StoneworksChatClient.sendCommand("channels list");
        return true;
    }

    private static void setCurrentChannel(String newChannel) {
        if (newChannel == null) {
            return;
        }
        if (!newChannel.equals(StoneworksChatClient.currentChannel)) {
            StoneworksChatClient.currentChannel = newChannel;
            StoneworksChatClient.pendingChannel = null;
            ChatConfig.save();
        }
    }

    private static void processChannelList() {
        String transmittingKey = null;
        for (String status : channelStatuses) {
            String rawChannel;
            String[] parts = status.split(" Status: ");
            if (parts.length != 2 || !"Transmitting".equals(parts[1]) || (transmittingKey = ChatConfirmationListener.findBestKeyForRaw(rawChannel = parts[0].trim())) != null) continue;
            transmittingKey = ChatConfirmationListener.resolveOrCreateChannelKey(rawChannel);
        }
        if (transmittingKey != null) {
            ChatConfirmationListener.setCurrentChannel(transmittingKey);
        } else {
            ChatConfirmationListener.setCurrentChannel("public");
        }
        if (StoneworksChatClient.modTriggeredChannelsList) {
            StoneworksChatClient.modTriggeredChannelsList = false;
        }
        channelListPending = false;
        channelStatuses.clear();
    }

    private static String normalizeName(String s) {
        if (s == null) {
            return "";
        }
        String t = s.trim().toLowerCase();
        if ((t = t.replace(" ", "")).endsWith("chat")) {
            t = t.substring(0, t.length() - 4);
        }
        return t;
    }

    public static void checkTimeout() {
        long now = System.currentTimeMillis();
        if (collectingChannels) {
            if (!channelStatuses.isEmpty()) {
                if (now - lastStatusLineTime >= 200L) {
                    collectingChannels = false;
                    ChatConfirmationListener.processChannelList();
                    return;
                }
            } else if (now - collectingStartTime >= 800L) {
                collectingChannels = false;
                ChatConfirmationListener.processChannelList();
                return;
            }
        }
        if (channelListPending && now - lastChannelListTime > 5000L) {
            channelListPending = false;
            StoneworksChatClient.modTriggeredChannelsList = false;
        }
        if (muteStatusLinesActive) {
            boolean timedOut;
            boolean allSeen = !expectedNormalized.isEmpty() && seenNormalized.containsAll(expectedNormalized);
            boolean bl = timedOut = now - statusMuteStartTime > 2000L;
            if (allSeen || timedOut) {
                muteStatusLinesActive = false;
                expectedNormalized.clear();
                seenNormalized.clear();
            }
        }
    }

    private static String resolveOrCreateChannelKey(String rawName) {
        if (rawName == null || rawName.isEmpty()) {
            return "public";
        }
        String best = ChatConfirmationListener.findBestKeyForRaw(rawName);
        if (best != null) {
            return best;
        }
        String key = rawName;
        StoneworksChatClient.channels.put(key, new Channel(rawName, "white", List.of(), rawName));
        return key;
    }

    private static void beginStatusMute() {
        muteStatusLinesActive = true;
        expectedNormalized.clear();
        seenNormalized.clear();
        statusMuteStartTime = System.currentTimeMillis();
        for (String key : StoneworksChatClient.channels.keySet()) {
            if ("public".equalsIgnoreCase(key)) continue;
            expectedNormalized.add(ChatConfirmationListener.normalizeName(key));
        }
    }

    private static void trackSeenFromStatusLine(String content) {
        int idx = content.indexOf(" Status: ");
        if (idx > 0) {
            String raw = content.substring(0, idx).trim();
            String resolved = ChatConfirmationListener.findBestKeyForRaw(raw);
            if (resolved != null) {
                seenNormalized.add(ChatConfirmationListener.normalizeName(resolved));
            } else {
                seenNormalized.add(ChatConfirmationListener.normalizeName(raw));
            }
        }
    }

    private static boolean isCanonical(String key) {
        return CANONICAL_KEYS.contains(key);
    }

    private static String findBestKeyForRaw(String rawName) {
        Channel ch;
        if (rawName == null || rawName.isEmpty()) {
            return null;
        }
        String normalizedRaw = ChatConfirmationListener.normalizeName(rawName);
        for (String key : StoneworksChatClient.channels.keySet()) {
            if (!ChatConfirmationListener.isCanonical(key)) continue;
            if (ChatConfirmationListener.normalizeName(key).equals(normalizedRaw)) {
                return key;
            }
            ch = StoneworksChatClient.channels.get(key);
            if (ch == null) continue;
            if (ch.display() != null && ChatConfirmationListener.normalizeName(ch.display()).equals(normalizedRaw)) {
                return key;
            }
            if (ch.uiName() == null || !ChatConfirmationListener.normalizeName(ch.uiName()).equals(normalizedRaw)) continue;
            return key;
        }
        for (String key : StoneworksChatClient.channels.keySet()) {
            if (ChatConfirmationListener.normalizeName(key).equals(normalizedRaw)) {
                return key;
            }
            ch = StoneworksChatClient.channels.get(key);
            if (ch == null) continue;
            if (ch.display() != null && ChatConfirmationListener.normalizeName(ch.display()).equals(normalizedRaw)) {
                return key;
            }
            if (ch.uiName() == null || !ChatConfirmationListener.normalizeName(ch.uiName()).equals(normalizedRaw)) continue;
            return key;
        }
        return null;
    }
}

