/*
 * Decompiled with CFR 0.152.
 */
package com.duperknight.stoneworksChat.client;

import com.duperknight.stoneworksChat.client.Channel;
import com.duperknight.stoneworksChat.client.ChatCommandListener;
import com.duperknight.stoneworksChat.client.ChatConfirmationListener;
import com.duperknight.stoneworksChat.client.ClientCommands;
import com.duperknight.stoneworksChat.client.HudConfigScreen;
import com.duperknight.stoneworksChat.client.HudOverlayRenderer;
import com.duperknight.stoneworksChat.client.config.ChatConfig;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class StoneworksChatClient
implements ClientModInitializer {
    public static final String MOD_ID = "stoneworks-chat";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"stoneworks-chat");
    public static String currentChannel = "public";
    public static String pendingChannel = null;
    public static Map<String, Channel> channels = new HashMap<String, Channel>();
    public static boolean modTriggeredChannelsList = false;
    private static boolean channelGuiWasOpen = false;
    private static long lastGuiCloseTime = 0L;
    private static final long GUI_CLOSE_DELAY = 10L;
    private static boolean delayedCommandScheduled = false;
    public static int hudPosX = 10;
    public static int hudPosY = 10;
    public static TextAlign hudTextAlign = TextAlign.LEFT_TO_RIGHT;
    public static float hudScale = 1.0f;
    public static final float HUD_MIN_SCALE = 0.75f;
    public static final float HUD_MAX_SCALE = 4.0f;
    public static AnchorX hudAnchorX = null;
    public static AnchorY hudAnchorY = null;
    public static int hudOffsetX = -1;
    public static int hudOffsetY = -1;
    public static boolean hudVisible = true;
    public static boolean showHudTutorial = true;
    private static class_304 OPEN_HUD_CONFIG_KEY;
    private static class_304 TOGGLE_HUD_VISIBILITY_KEY;

    public void onInitializeClient() {
        ChatConfig.load();
        ChatCommandListener.register();
        ChatConfirmationListener.register();
        ClientCommands.register();
        HudOverlayRenderer.register();
        OPEN_HUD_CONFIG_KEY = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.stoneworks_chat.open_hud_config", 72, "key.categories.stoneworks_chat"));
        TOGGLE_HUD_VISIBILITY_KEY = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.stoneworks_chat.toggle_hud_visibility", 86, "key.categories.stoneworks_chat"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            long timeSinceClose;
            boolean isChannelGui;
            ChatConfirmationListener.checkTimeout();
            while (OPEN_HUD_CONFIG_KEY != null && OPEN_HUD_CONFIG_KEY.method_1436()) {
                class_437 parent = client.field_1755;
                client.method_1507((class_437)new HudConfigScreen(parent));
            }
            while (TOGGLE_HUD_VISIBILITY_KEY != null && TOGGLE_HUD_VISIBILITY_KEY.method_1436()) {
                hudVisible = !hudVisible;
                ChatConfig.save();
            }
            class_437 current = client.field_1755;
            boolean bl = isChannelGui = current instanceof class_476 && current.method_25440().getString().equals("Channels");
            if (isChannelGui && !channelGuiWasOpen) {
                channelGuiWasOpen = true;
            } else if (!isChannelGui && channelGuiWasOpen) {
                channelGuiWasOpen = false;
                lastGuiCloseTime = System.currentTimeMillis();
                delayedCommandScheduled = false;
            } else if (!(isChannelGui || channelGuiWasOpen || lastGuiCloseTime <= 0L || (timeSinceClose = System.currentTimeMillis() - lastGuiCloseTime) < 10L || delayedCommandScheduled)) {
                if (ChatConfirmationListener.requestChannelListUpdate()) {
                    delayedCommandScheduled = true;
                }
                lastGuiCloseTime = 0L;
            }
            if (isChannelGui && !channelGuiWasOpen) {
                lastGuiCloseTime = 0L;
                delayedCommandScheduled = false;
            }
        });
    }

    public static void sendCommand(String command) {
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            class_634 handler;
            class_746 player = client.field_1724;
            class_634 class_6342 = handler = player != null ? player.field_3944 : null;
            if (handler != null) {
                handler.method_45730(command);
            } else {
                LOGGER.warn("Cannot send command, networkHandler is null");
            }
        } else {
            LOGGER.warn("Cannot send command, client or player is null");
        }
    }

    public static enum TextAlign {
        LEFT_TO_RIGHT,
        CENTER,
        RIGHT_TO_LEFT;

    }

    public static enum AnchorX {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum AnchorY {
        TOP,
        CENTER,
        BOTTOM;

    }
}

