/*
 * Decompiled with CFR 0.152.
 */
package com.duperknight.stoneworksChat.client;

import com.duperknight.stoneworksChat.client.HudOverlayRenderer;
import com.duperknight.stoneworksChat.client.StoneworksChatClient;
import com.duperknight.stoneworksChat.client.config.ChatConfig;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class HudConfigScreen
extends class_437 {
    private final class_437 parent;
    private int currentX;
    private int currentY;
    private StoneworksChatClient.TextAlign currentAlign;
    private boolean dragging = false;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private int previewW = 0;
    private int previewH = 0;
    private boolean showTutorialPopup;
    private class_4185 tutorialOkBtn;
    private class_4185 tutorialDontShowBtn;
    private class_4185 alignmentBtn;
    private class_4185 doneBtn;
    private static final class_2960 ARROWS_TEX = class_2960.method_60655((String)"stoneworks-chat", (String)"tutorial/arrow_keys.png");
    private static final class_2960 SHIFT_TEX = class_2960.method_60655((String)"stoneworks-chat", (String)"tutorial/shift_key.png");
    private Integer arrowsWCache;
    private Integer arrowsHCache;
    private Integer shiftWCache;
    private Integer shiftHCache;

    public HudConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.stoneworks_chat.hud_config.title"));
        this.parent = parent;
        this.currentX = StoneworksChatClient.hudPosX;
        this.currentY = StoneworksChatClient.hudPosY;
        this.currentAlign = StoneworksChatClient.hudTextAlign;
    }

    protected void method_25426() {
        this.showTutorialPopup = StoneworksChatClient.showHudTutorial;
        int centerX = this.field_22789 / 2;
        int btnW = 200;
        int btnH = 20;
        int spacing = 6;
        try {
            Map<String, Object> channelInfo = StoneworksChatClient.channels.get(StoneworksChatClient.currentChannel);
            String display = channelInfo != null ? (String)channelInfo.get("display") : "";
            class_5250 previewText = class_2561.method_43469((String)"stoneworks_chat.chat_prefix", (Object[])new Object[]{display != null ? display : ""});
            int paddingX = 4;
            int paddingY = 3;
            int textW = this.field_22793.method_27525((class_5348)previewText);
            Objects.requireNonNull(this.field_22793);
            int textH = 9;
            int bgW = textW + paddingX * 2;
            int bgH = textH + paddingY * 2;
            this.previewW = bgW;
            this.previewH = bgH;
            if (StoneworksChatClient.hudAnchorX != null && StoneworksChatClient.hudAnchorY != null) {
                this.currentX = switch (StoneworksChatClient.hudAnchorX) {
                    case StoneworksChatClient.AnchorX.RIGHT -> this.field_22789 - StoneworksChatClient.hudOffsetX;
                    case StoneworksChatClient.AnchorX.CENTER -> this.field_22789 / 2 + StoneworksChatClient.hudOffsetX;
                    default -> StoneworksChatClient.hudOffsetX;
                };
                this.currentY = topY;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.alignmentBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43469((String)"screen.stoneworks_chat.hud_config.alignment", (Object[])new Object[]{this.alignLabelText()}), b -> {
            this.toggleAlign();
            b.method_25355((class_2561)class_2561.method_43469((String)"screen.stoneworks_chat.hud_config.alignment", (Object[])new Object[]{this.alignLabelText()}));
        }).method_46434(centerX - btnW / 2, this.field_22790 - (btnH * 2 + spacing + 12), btnW, btnH).method_46431());
        this.doneBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> {
            int topY;
            int leftX;
            StoneworksChatClient.hudTextAlign = this.currentAlign;
            int screenW = this.field_22789;
            int screenH = this.field_22790;
            int boxW = this.previewW;
            int boxH = this.previewH;
            int distLeft = leftX = (switch (this.currentAlign) {
                default -> throw new MatchException(null, null);
                case StoneworksChatClient.TextAlign.RIGHT_TO_LEFT -> this.currentX - boxW;
                case StoneworksChatClient.TextAlign.CENTER -> this.currentX - boxW / 2;
                case StoneworksChatClient.TextAlign.LEFT_TO_RIGHT -> this.currentX;
            });
            int distCenter = Math.abs(leftX + boxW / 2 - screenW / 2);
            int distRight = Math.abs(screenW - (leftX + boxW));
            StoneworksChatClient.hudAnchorX = distCenter <= distLeft && distCenter <= distRight ? StoneworksChatClient.AnchorX.CENTER : (distLeft <= distRight ? StoneworksChatClient.AnchorX.LEFT : StoneworksChatClient.AnchorX.RIGHT);
            int anchorLineX = switch (this.currentAlign) {
                default -> throw new MatchException(null, null);
                case StoneworksChatClient.TextAlign.LEFT_TO_RIGHT -> leftX;
                case StoneworksChatClient.TextAlign.CENTER -> leftX + boxW / 2;
                case StoneworksChatClient.TextAlign.RIGHT_TO_LEFT -> leftX + boxW;
            };
            switch (StoneworksChatClient.hudAnchorX) {
                case CENTER: {
                    StoneworksChatClient.hudOffsetX = anchorLineX - screenW / 2;
                    break;
                }
                case LEFT: {
                    StoneworksChatClient.hudOffsetX = anchorLineX;
                    break;
                }
                case RIGHT: {
                    StoneworksChatClient.hudOffsetX = screenW - anchorLineX;
                }
            }
            int distTop = topY = this.currentY;
            int distMid = Math.abs(topY + boxH / 2 - screenH / 2);
            int distBot = Math.abs(screenH - (topY + boxH));
            if (distMid <= distTop && distMid <= distBot) {
                StoneworksChatClient.hudAnchorY = StoneworksChatClient.AnchorY.CENTER;
                StoneworksChatClient.hudOffsetY = topY + boxH / 2 - screenH / 2;
            } else if (distTop <= distBot) {
                StoneworksChatClient.hudAnchorY = StoneworksChatClient.AnchorY.TOP;
                StoneworksChatClient.hudOffsetY = topY;
            } else {
                StoneworksChatClient.hudAnchorY = StoneworksChatClient.AnchorY.BOTTOM;
                StoneworksChatClient.hudOffsetY = screenH - (topY + boxH);
            }
            ChatConfig.save();
            this.method_25419();
        }).method_46434(centerX - btnW / 2, this.field_22790 - (btnH + 12), btnW, btnH).method_46431());
        this.tutorialOkBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.stoneworks_chat.hud_config.tutorial.ok"), b -> {
            this.showTutorialPopup = false;
            this.hideTutorialButtons();
        }).method_46434(centerX - 105, this.field_22790 / 2 + 60, 100, 20).method_46431());
        this.tutorialDontShowBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.stoneworks_chat.hud_config.tutorial.dont_show"), b -> {
            StoneworksChatClient.showHudTutorial = false;
            ChatConfig.save();
            this.showTutorialPopup = false;
            this.hideTutorialButtons();
        }).method_46434(centerX + 5, this.field_22790 / 2 + 60, 100, 20).method_46431());
        this.updateTutorialButtons();
    }

    private void toggleAlign() {
        boolean wasCenter;
        int boxW = this.previewW;
        boolean wasRtl = this.currentAlign == StoneworksChatClient.TextAlign.RIGHT_TO_LEFT;
        boolean bl = wasCenter = this.currentAlign == StoneworksChatClient.TextAlign.CENTER;
        int leftXBefore = wasRtl ? this.currentX - boxW : (wasCenter ? this.currentX - boxW / 2 : this.currentX);
        switch (this.currentAlign) {
            case LEFT_TO_RIGHT: {
                this.currentAlign = StoneworksChatClient.TextAlign.CENTER;
                break;
            }
            case CENTER: {
                this.currentAlign = StoneworksChatClient.TextAlign.RIGHT_TO_LEFT;
                break;
            }
            case RIGHT_TO_LEFT: {
                this.currentAlign = StoneworksChatClient.TextAlign.LEFT_TO_RIGHT;
            }
        }
        switch (this.currentAlign) {
            case LEFT_TO_RIGHT: {
                this.currentX = leftXBefore;
                break;
            }
            case CENTER: {
                this.currentX = leftXBefore + boxW / 2;
                break;
            }
            case RIGHT_TO_LEFT: {
                this.currentX = leftXBefore + boxW;
            }
        }
    }

    private class_2561 alignLabelText() {
        return switch (this.currentAlign) {
            default -> throw new MatchException(null, null);
            case StoneworksChatClient.TextAlign.LEFT_TO_RIGHT -> class_2561.method_43471((String)"screen.stoneworks_chat.hud_config.align.left_to_right");
            case StoneworksChatClient.TextAlign.CENTER -> class_2561.method_43471((String)"screen.stoneworks_chat.hud_config.align.center");
            case StoneworksChatClient.TextAlign.RIGHT_TO_LEFT -> class_2561.method_43471((String)"screen.stoneworks_chat.hud_config.align.right_to_left");
        };
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.method_25420(drawContext, mouseX, mouseY, delta);
        if (this.showTutorialPopup) {
            boolean dontPrevVis;
            if (this.alignmentBtn != null) {
                this.alignmentBtn.field_22764 = false;
            }
            if (this.doneBtn != null) {
                this.doneBtn.field_22764 = false;
            }
            boolean okPrevVis = this.tutorialOkBtn != null && this.tutorialOkBtn.field_22764;
            boolean bl = dontPrevVis = this.tutorialDontShowBtn != null && this.tutorialDontShowBtn.field_22764;
            if (this.tutorialOkBtn != null) {
                this.tutorialOkBtn.field_22764 = false;
            }
            if (this.tutorialDontShowBtn != null) {
                this.tutorialDontShowBtn.field_22764 = false;
            }
            super.method_25394(drawContext, mouseX, mouseY, delta);
            this.renderTutorialPanel(drawContext);
            if (this.tutorialOkBtn != null) {
                this.tutorialOkBtn.field_22764 = true;
                this.tutorialOkBtn.method_25394(drawContext, mouseX, mouseY, delta);
            }
            if (this.tutorialDontShowBtn != null) {
                this.tutorialDontShowBtn.field_22764 = true;
                this.tutorialDontShowBtn.method_25394(drawContext, mouseX, mouseY, delta);
            }
            if (!okPrevVis && this.tutorialOkBtn != null) {
                this.tutorialOkBtn.field_22764 = false;
            }
            if (!dontPrevVis && this.tutorialDontShowBtn != null) {
                this.tutorialDontShowBtn.field_22764 = false;
            }
            return;
        }
        if (this.alignmentBtn != null) {
            this.alignmentBtn.field_22764 = true;
        }
        if (this.doneBtn != null) {
            this.doneBtn.field_22764 = true;
        }
        super.method_25394(drawContext, mouseX, mouseY, delta);
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
        drawContext.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, 0xFFFFFF);
        Map<String, Object> channelInfo = StoneworksChatClient.channels.get(StoneworksChatClient.currentChannel);
        if (channelInfo != null) {
            String display = (String)channelInfo.get("display");
            String color = (String)channelInfo.get("color");
            class_5250 text = class_2561.method_43469((String)"stoneworks_chat.chat_prefix", (Object[])new Object[]{display != null ? display : ""});
            class_327 tr = class_310.method_1551().field_1772;
            int paddingX = 4;
            int paddingY = 3;
            int textW = tr.method_27525((class_5348)text);
            Objects.requireNonNull(tr);
            int textH = 9;
            int bgW = textW + paddingX * 2;
            int bgH = textH + paddingY * 2;
            this.previewW = bgW;
            this.previewH = bgH;
            boolean rtl = this.currentAlign == StoneworksChatClient.TextAlign.RIGHT_TO_LEFT;
            boolean centerAlign = this.currentAlign == StoneworksChatClient.TextAlign.CENTER;
            boolean shiftDown = HudConfigScreen.method_25442();
            if (this.dragging) {
                int leftXBefore = rtl ? this.currentX - bgW : (centerAlign ? this.currentX - bgW / 2 : this.currentX);
                int clampedLeftX = HudConfigScreen.clamp(leftXBefore, 0, this.field_22789 - bgW);
                int clampedY = HudConfigScreen.clamp(this.currentY, 0, this.field_22790 - bgH);
                int leftX = clampedLeftX;
                int yPos = clampedY;
                if (!shiftDown) {
                    int margin = 10;
                    int tolerance = 3;
                    int screenCenterX = this.field_22789 / 2;
                    int screenCenterY = this.field_22790 / 2;
                    int centerLeftX = screenCenterX - bgW / 2;
                    int rightLeftX = this.field_22789 - 10 - bgW;
                    if (Math.abs(leftX - 10) <= 3) {
                        leftX = 10;
                    } else if (Math.abs(leftX + bgW - (this.field_22789 - 10)) <= 3) {
                        leftX = rightLeftX;
                    } else if (Math.abs(leftX + bgW / 2 - screenCenterX) <= 3) {
                        leftX = centerLeftX;
                    }
                    int bottomY = this.field_22790 - 10 - bgH;
                    int centerTopY = screenCenterY - bgH / 2;
                    if (Math.abs(yPos - 10) <= 3) {
                        yPos = 10;
                    } else if (Math.abs(yPos + bgH - (this.field_22790 - 10)) <= 3) {
                        yPos = bottomY;
                    } else if (Math.abs(yPos + bgH / 2 - screenCenterY) <= 3) {
                        yPos = centerTopY;
                    }
                }
                this.currentY = yPos;
                int n = rtl ? leftX + bgW : (this.currentX = centerAlign ? leftX + bgW / 2 : leftX);
            }
            if (this.dragging && !shiftDown) {
                this.drawGuides(drawContext, bgW, bgH);
            }
            int leftX = rtl ? this.currentX - bgW : (centerAlign ? this.currentX - bgW / 2 : this.currentX);
            int bgColor = StoneworksChatClient.hudVisible ? Integer.MIN_VALUE : 0x40404040;
            drawContext.method_25294(leftX, this.currentY, leftX + bgW, this.currentY + bgH, bgColor);
            int borderColor = StoneworksChatClient.hudVisible ? -2130706433 : 0x60AAAAAA;
            drawContext.method_25294(leftX, this.currentY, leftX + bgW, this.currentY + 1, borderColor);
            drawContext.method_25294(leftX, this.currentY + bgH - 1, leftX + bgW, this.currentY + bgH, borderColor);
            drawContext.method_25294(leftX, this.currentY, leftX + 1, this.currentY + bgH, borderColor);
            drawContext.method_25294(leftX + bgW - 1, this.currentY, leftX + bgW, this.currentY + bgH, borderColor);
            int anchorXpx = switch (this.currentAlign) {
                default -> throw new MatchException(null, null);
                case StoneworksChatClient.TextAlign.LEFT_TO_RIGHT -> leftX;
                case StoneworksChatClient.TextAlign.CENTER -> leftX + bgW / 2;
                case StoneworksChatClient.TextAlign.RIGHT_TO_LEFT -> leftX + bgW;
            };
            int markerTop = Math.max(0, this.currentY - 4);
            drawContext.method_25294(anchorXpx, markerTop, anchorXpx + 1, this.currentY, -8339201);
            int textX = rtl ? leftX + bgW - paddingX - textW : (centerAlign ? leftX + Math.max(0, (bgW - textW) / 2) : leftX + paddingX);
            int textY = this.currentY + Math.round((float)(bgH - textH) / 2.0f) + 1;
            int colorCode = HudOverlayRenderer.getColorCode(color);
            if (StoneworksChatClient.hudVisible) {
                drawContext.method_51439(tr, (class_2561)text, textX, textY, colorCode, true);
            }
        }
        drawContext.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.stoneworks_chat.hud_config.drag_help"), this.field_22789 / 2, this.field_22790 - 84, 0xAAAAAA);
        class_5250 vis = class_2561.method_43471((String)(StoneworksChatClient.hudVisible ? "screen.stoneworks_chat.hud_config.visible" : "screen.stoneworks_chat.hud_config.hidden"));
        drawContext.method_27534(this.field_22793, (class_2561)vis, this.field_22789 / 2, this.field_22790 - 72, 0xCCCCCC);
        drawContext.method_51448().method_22909();
    }

    private void ensureTextureSizes() {
        if (this.arrowsWCache != null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_3300 rm = mc.method_1478();
        try {
            Optional res = rm.method_14486(ARROWS_TEX);
            res.ifPresent(r -> {
                try (InputStream is = r.method_14482();){
                    class_1011 img = class_1011.method_4309((InputStream)is);
                    this.arrowsWCache = img.method_4307();
                    this.arrowsHCache = img.method_4323();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            Optional res2 = rm.method_14486(SHIFT_TEX);
            res2.ifPresent(r -> {
                try (InputStream is = r.method_14482();){
                    class_1011 img = class_1011.method_4309((InputStream)is);
                    this.shiftWCache = img.method_4307();
                    this.shiftHCache = img.method_4323();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.arrowsWCache == null) {
            this.arrowsWCache = 64;
            this.arrowsHCache = 32;
        }
        if (this.shiftWCache == null) {
            this.shiftWCache = 48;
            this.shiftHCache = 32;
        }
    }

    private void renderTutorialPanel(class_332 ctx) {
        int blockStartX;
        this.ensureTextureSizes();
        int arrowsW = this.arrowsWCache;
        int arrowsH = this.arrowsHCache;
        int shiftW = this.shiftWCache;
        int shiftH = this.shiftHCache;
        int lineSpacing = 8;
        String arrowsLine = "- " + class_2561.method_43471((String)"screen.stoneworks_chat.hud_config.tutorial.move").getString();
        String shiftLine = "- " + class_2561.method_43471((String)"screen.stoneworks_chat.hud_config.tutorial.fast").getString();
        int arrowsTextW = this.field_22793.method_1727(arrowsLine);
        int shiftTextW = this.field_22793.method_1727(shiftLine);
        int spaceBetween = 8;
        int arrowsLineW = arrowsW + spaceBetween + arrowsTextW;
        int shiftLineW = shiftW + spaceBetween + shiftTextW;
        int contentBlockW = Math.max(arrowsLineW, shiftLineW);
        int popupW = Math.max(340, contentBlockW + 32);
        Objects.requireNonNull(this.field_22793);
        int n = Math.max(arrowsH, 9) + lineSpacing;
        Objects.requireNonNull(this.field_22793);
        int textBlockH = n + Math.max(shiftH, 9);
        int popupH = 30 + textBlockH + 54;
        int x = (this.field_22789 - popupW) / 2;
        int y = (this.field_22790 - popupH) / 2;
        ctx.method_25294(0, 0, this.field_22789, this.field_22790, -1610612736);
        ctx.method_25294(x, y, x + popupW, y + popupH, -1072360171);
        ctx.method_25294(x, y, x + popupW, y + 1, -1);
        ctx.method_25294(x, y + popupH - 1, x + popupW, y + popupH, -1);
        ctx.method_25294(x, y, x + 1, y + popupH, -1);
        ctx.method_25294(x + popupW - 1, y, x + popupW, y + popupH, -1);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.stoneworks_chat.hud_config.tutorial.title"), x + popupW / 2, y + 6, 0xFFFFFF);
        int contentY = y + 22;
        int arrowsImgX = blockStartX = x + (popupW - contentBlockW) / 2;
        ctx.method_25290(class_1921::method_62277, ARROWS_TEX, arrowsImgX, contentY, 0.0f, 0.0f, arrowsW, arrowsH, arrowsW, arrowsH);
        int arrowsTextX = arrowsImgX + arrowsW + spaceBetween;
        Objects.requireNonNull(this.field_22793);
        int arrowsTextY = contentY + (arrowsH - 9) / 2;
        ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)arrowsLine), arrowsTextX, arrowsTextY, 0xDDDDDD);
        Objects.requireNonNull(this.field_22793);
        int secondY = contentY + Math.max(arrowsH, 9) + lineSpacing;
        int shiftImgX = blockStartX;
        ctx.method_25290(class_1921::method_62277, SHIFT_TEX, shiftImgX, secondY, 0.0f, 0.0f, shiftW, shiftH, shiftW, shiftH);
        int shiftTextX = shiftImgX + shiftW + spaceBetween;
        Objects.requireNonNull(this.field_22793);
        int shiftTextYPos = secondY + (shiftH - 9) / 2;
        ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)shiftLine), shiftTextX, shiftTextYPos, 0xDDDDDD);
        if (this.tutorialOkBtn != null) {
            this.tutorialOkBtn.method_48229(x + popupW / 2 - 105, y + popupH - 26);
        }
        if (this.tutorialDontShowBtn != null) {
            this.tutorialDontShowBtn.method_48229(x + popupW / 2 + 5, y + popupH - 26);
        }
        this.updateTutorialButtons();
    }

    private void updateTutorialButtons() {
        if (this.tutorialOkBtn != null) {
            this.tutorialOkBtn.field_22764 = this.showTutorialPopup;
        }
        if (this.tutorialDontShowBtn != null) {
            this.tutorialDontShowBtn.field_22764 = this.showTutorialPopup;
        }
    }

    private void hideTutorialButtons() {
        if (this.tutorialOkBtn != null) {
            this.tutorialOkBtn.field_22764 = false;
        }
        if (this.tutorialDontShowBtn != null) {
            this.tutorialDontShowBtn.field_22764 = false;
        }
    }

    private void drawGuides(class_332 ctx, int boxW, int boxH) {
        int bottomY;
        int rightX;
        boolean centerAlign;
        int tolerance = 3;
        int margin = 10;
        int screenW = this.field_22789;
        int screenH = this.field_22790;
        boolean rtl = this.currentAlign == StoneworksChatClient.TextAlign.RIGHT_TO_LEFT;
        boolean bl = centerAlign = this.currentAlign == StoneworksChatClient.TextAlign.CENTER;
        int leftX = rtl ? this.currentX - boxW : (centerAlign ? this.currentX - boxW / 2 : this.currentX);
        int boxCenterX = leftX + boxW / 2;
        int boxCenterY = this.currentY + boxH / 2;
        int screenCenterX = screenW / 2;
        int screenCenterY = screenH / 2;
        int centerColor = -2130755456;
        int edgeColor = -2130728448;
        if (Math.abs(boxCenterX - screenCenterX) <= 3) {
            ctx.method_25294(screenCenterX, 0, screenCenterX + 1, screenH, centerColor);
        }
        if (Math.abs(boxCenterY - screenCenterY) <= 3) {
            ctx.method_25294(0, screenCenterY, screenW, screenCenterY + 1, centerColor);
        }
        if (Math.abs(leftX - 10) <= 3) {
            ctx.method_25294(10, 0, 11, screenH, edgeColor);
        }
        if (Math.abs(leftX + boxW - (rightX = screenW - 10)) <= 3) {
            ctx.method_25294(rightX, 0, rightX + 1, screenH, edgeColor);
        }
        if (Math.abs(this.currentY - 10) <= 3) {
            ctx.method_25294(0, 10, screenW, 11, edgeColor);
        }
        if (Math.abs(this.currentY + boxH - (bottomY = screenH - 10)) <= 3) {
            ctx.method_25294(0, bottomY, screenW, bottomY + 1, edgeColor);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.showTutorialPopup) {
            return super.method_25402(mouseX, mouseY, button);
        }
        if (button == 1 && this.hitPreview(mouseX, mouseY)) {
            StoneworksChatClient.hudVisible = !StoneworksChatClient.hudVisible;
            ChatConfig.save();
            return true;
        }
        if (button == 0 && this.hitPreview(mouseX, mouseY)) {
            this.dragging = true;
            int leftX = this.currentAlign == StoneworksChatClient.TextAlign.RIGHT_TO_LEFT ? this.currentX - this.previewW : (this.currentAlign == StoneworksChatClient.TextAlign.CENTER ? this.currentX - this.previewW / 2 : this.currentX);
            this.dragOffsetX = (int)mouseX - leftX;
            this.dragOffsetY = (int)mouseY - this.currentY;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.showTutorialPopup) {
            return false;
        }
        if (this.dragging && button == 0) {
            int leftX = (int)mouseX - this.dragOffsetX;
            this.currentY = (int)mouseY - this.dragOffsetY;
            if (null == this.currentAlign) {
                this.currentX = leftX;
                this.currentX = HudConfigScreen.clamp(this.currentX, 0, this.field_22789 - this.previewW);
            } else {
                switch (this.currentAlign) {
                    case RIGHT_TO_LEFT: {
                        this.currentX = leftX + this.previewW;
                        this.currentX = HudConfigScreen.clamp(this.currentX, this.previewW, this.field_22789);
                        break;
                    }
                    case CENTER: {
                        this.currentX = leftX + this.previewW / 2;
                        this.currentX = HudConfigScreen.clamp(this.currentX, this.previewW / 2, this.field_22789 - this.previewW / 2);
                        break;
                    }
                    default: {
                        this.currentX = leftX;
                        this.currentX = HudConfigScreen.clamp(this.currentX, 0, this.field_22789 - this.previewW);
                    }
                }
            }
            this.currentY = HudConfigScreen.clamp(this.currentY, 0, this.field_22790 - this.previewH);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.dragging && button == 0) {
            this.dragging = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25419() {
        class_310 c = this.field_22787;
        if (c != null) {
            c.method_1507(this.parent);
        }
    }

    private boolean hitPreview(double mouseX, double mouseY) {
        boolean centerAlign;
        boolean rtl = this.currentAlign == StoneworksChatClient.TextAlign.RIGHT_TO_LEFT;
        boolean bl = centerAlign = this.currentAlign == StoneworksChatClient.TextAlign.CENTER;
        int leftX = rtl ? this.currentX - this.previewW : (centerAlign ? this.currentX - this.previewW / 2 : this.currentX);
        return mouseX >= (double)leftX && mouseX <= (double)(leftX + this.previewW) && mouseY >= (double)this.currentY && mouseY <= (double)(this.currentY + this.previewH);
    }

    private static int clamp(int v, int min, int max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.showTutorialPopup) {
            if (keyCode == 256) {
                this.showTutorialPopup = false;
                this.hideTutorialButtons();
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        int step = HudConfigScreen.method_25442() ? 5 : 1;
        boolean handled = false;
        if (keyCode == 263) {
            this.currentX -= step;
            handled = true;
        } else if (keyCode == 262) {
            this.currentX += step;
            handled = true;
        }
        if (keyCode == 265) {
            this.currentY -= step;
            handled = true;
        } else if (keyCode == 264) {
            this.currentY += step;
            handled = true;
        }
        if (handled) {
            if (null == this.currentAlign) {
                this.currentX = HudConfigScreen.clamp(this.currentX, 0, this.field_22789 - this.previewW);
            } else {
                this.currentX = switch (this.currentAlign) {
                    case StoneworksChatClient.TextAlign.RIGHT_TO_LEFT -> HudConfigScreen.clamp(this.currentX, this.previewW, this.field_22789);
                    case StoneworksChatClient.TextAlign.CENTER -> HudConfigScreen.clamp(this.currentX, this.previewW / 2, this.field_22789 - this.previewW / 2);
                    default -> HudConfigScreen.clamp(this.currentX, 0, this.field_22789 - this.previewW);
                };
            }
            this.currentY = HudConfigScreen.clamp(this.currentY, 0, this.field_22790 - this.previewH);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

