/*
 * Decompiled with CFR 0.152.
 */
package com.duperknight.stoneworksChat.client;

import com.duperknight.stoneworksChat.client.HudConfigScreen;
import com.duperknight.stoneworksChat.client.StoneworksChatClient;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class HudOverlayRenderer {
    public static void register() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            class_310 mc = class_310.method_1551();
            if (mc != null && mc.field_1755 instanceof HudConfigScreen) {
                return;
            }
            if (!StoneworksChatClient.hudVisible) {
                return;
            }
            Map<String, Object> channelInfo = StoneworksChatClient.channels.get(StoneworksChatClient.currentChannel);
            if (channelInfo != null) {
                boolean useAnchorY;
                int leftX;
                boolean useAnchorX;
                String display = (String)channelInfo.get("display");
                String color = (String)channelInfo.get("color");
                class_5250 text = class_2561.method_43469((String)"stoneworks_chat.chat_prefix", (Object[])new Object[]{display != null ? display : ""});
                int screenW = drawContext.method_51421();
                int screenH = drawContext.method_51443();
                int xAnchor = StoneworksChatClient.hudPosX;
                int y = StoneworksChatClient.hudPosY;
                int colorCode = HudOverlayRenderer.getColorCode(color);
                class_327 tr = class_310.method_1551().field_1772;
                int paddingX = 4;
                int paddingY = 3;
                int textW = tr.method_27525((class_5348)text);
                Objects.requireNonNull(tr);
                int textH = 9;
                int bgW = textW + paddingX * 2;
                int bgH = textH + paddingY * 2;
                boolean rtl = StoneworksChatClient.hudTextAlign == StoneworksChatClient.TextAlign.RIGHT_TO_LEFT;
                boolean center = StoneworksChatClient.hudTextAlign == StoneworksChatClient.TextAlign.CENTER;
                boolean bl = useAnchorX = StoneworksChatClient.hudAnchorX == StoneworksChatClient.AnchorX.CENTER || StoneworksChatClient.hudOffsetX >= 0;
                if (useAnchorX) {
                    int anchorCoordX = switch (StoneworksChatClient.hudAnchorX) {
                        case StoneworksChatClient.AnchorX.RIGHT -> screenW - StoneworksChatClient.hudOffsetX;
                        case StoneworksChatClient.AnchorX.CENTER -> screenW / 2 + StoneworksChatClient.hudOffsetX;
                        default -> StoneworksChatClient.hudOffsetX;
                    };
                    leftX = rtl ? anchorCoordX - bgW : (center ? anchorCoordX - bgW / 2 : anchorCoordX);
                } else {
                    if (StoneworksChatClient.hudPosXFrac >= 0.0f) {
                        xAnchor = Math.round(StoneworksChatClient.hudPosXFrac * (float)screenW);
                    }
                    leftX = rtl ? xAnchor - bgW : (center ? xAnchor - bgW / 2 : xAnchor);
                }
                boolean bl2 = useAnchorY = StoneworksChatClient.hudAnchorY == StoneworksChatClient.AnchorY.CENTER || StoneworksChatClient.hudOffsetY >= 0;
                if (useAnchorY) {
                    switch (StoneworksChatClient.hudAnchorY) {
                        case BOTTOM: {
                            y = screenH - StoneworksChatClient.hudOffsetY - bgH;
                            break;
                        }
                        case CENTER: {
                            y = screenH / 2 - bgH / 2 + StoneworksChatClient.hudOffsetY;
                            break;
                        }
                        default: {
                            y = StoneworksChatClient.hudOffsetY;
                            break;
                        }
                    }
                } else if (StoneworksChatClient.hudPosYFrac >= 0.0f) {
                    y = Math.round(StoneworksChatClient.hudPosYFrac * (float)screenH);
                }
                drawContext.method_25294(leftX, y, leftX + bgW, y + bgH, Integer.MIN_VALUE);
                int textX = rtl ? leftX + bgW - paddingX - textW : (center ? leftX + Math.max(0, (bgW - textW) / 2) : leftX + paddingX);
                int textY = y + Math.round((float)(bgH - textH) / 2.0f) + 1;
                drawContext.method_51439(tr, (class_2561)text, textX, textY, colorCode, true);
            }
        });
    }

    public static int getColorCode(String color) {
        return switch (color.toLowerCase()) {
            case "green" -> 65280;
            case "white" -> 0xFFFFFF;
            case "light_red" -> 0xFF5555;
            case "cyan" -> 65535;
            case "red" -> 0xFF0000;
            case "yellow" -> 0xFFFF00;
            default -> 0xFFFFFF;
        };
    }
}

