/*
 * Decompiled with CFR 0.152.
 */
package com.duperknight.stoneworksChat.client;

import com.duperknight.stoneworksChat.client.Channel;
import com.duperknight.stoneworksChat.client.HudConfigScreen;
import com.duperknight.stoneworksChat.client.StoneworksChatClient;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class HudOverlayRenderer {
    public static void register() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            class_310 mc = class_310.method_1551();
            if (mc != null && mc.field_1755 instanceof HudConfigScreen) {
                return;
            }
            if (!StoneworksChatClient.hudVisible) {
                return;
            }
            Channel channelInfo = StoneworksChatClient.channels.get(StoneworksChatClient.currentChannel);
            if (channelInfo != null) {
                int leftX;
                boolean center;
                String display = channelInfo.display();
                String color = channelInfo.color();
                class_5250 text = class_2561.method_43469((String)"stoneworks_chat.chat_prefix", (Object[])new Object[]{display != null ? display : ""});
                int screenW = drawContext.method_51421();
                int screenH = drawContext.method_51443();
                int y = StoneworksChatClient.hudPosY;
                int colorCode = HudOverlayRenderer.getColorCode(color);
                class_327 tr = class_310.method_1551().field_1772;
                int paddingX = 4;
                int paddingY = 3;
                int textW = tr.method_27525((class_5348)text);
                Objects.requireNonNull(tr);
                int textH = 9;
                int bgW = textW + paddingX * 2;
                int bgH = textH + paddingY * 2;
                float scale = StoneworksChatClient.hudScale;
                int scaledBgW = Math.round((float)bgW * scale);
                int scaledBgH = Math.round((float)bgH * scale);
                boolean rtl = StoneworksChatClient.hudTextAlign == StoneworksChatClient.TextAlign.RIGHT_TO_LEFT;
                boolean bl = center = StoneworksChatClient.hudTextAlign == StoneworksChatClient.TextAlign.CENTER;
                if (StoneworksChatClient.hudOffsetX >= 0) {
                    float leftXf;
                    if (StoneworksChatClient.hudAnchorX == null) {
                        leftXf = StoneworksChatClient.hudPosX;
                    } else {
                        switch (StoneworksChatClient.hudAnchorX) {
                            case LEFT: {
                                leftXf = StoneworksChatClient.hudOffsetX;
                                break;
                            }
                            case CENTER: {
                                float centerLine = (float)screenW / 2.0f + (float)StoneworksChatClient.hudOffsetX;
                                leftXf = centerLine - (float)scaledBgW / 2.0f;
                                break;
                            }
                            case RIGHT: {
                                leftXf = screenW - StoneworksChatClient.hudOffsetX - scaledBgW;
                                break;
                            }
                            default: {
                                leftXf = StoneworksChatClient.hudPosX;
                            }
                        }
                    }
                    boolean centerAnchorX = StoneworksChatClient.hudAnchorX == StoneworksChatClient.AnchorX.CENTER;
                    leftX = centerAnchorX ? (int)Math.floor(leftXf + 1.0E-4f) : Math.round(leftXf);
                } else {
                    int alignLine = StoneworksChatClient.hudPosX;
                    switch (StoneworksChatClient.hudTextAlign) {
                        case LEFT_TO_RIGHT: {
                            leftX = alignLine;
                            break;
                        }
                        case CENTER: {
                            leftX = alignLine - scaledBgW / 2;
                            break;
                        }
                        default: {
                            leftX = alignLine - scaledBgW;
                        }
                    }
                }
                if (StoneworksChatClient.hudOffsetY >= 0) {
                    float topYf;
                    if (StoneworksChatClient.hudAnchorY == null) {
                        topYf = StoneworksChatClient.hudPosY;
                    } else {
                        switch (StoneworksChatClient.hudAnchorY) {
                            case TOP: {
                                topYf = StoneworksChatClient.hudOffsetY;
                                break;
                            }
                            case CENTER: {
                                float centerLineY = (float)screenH / 2.0f + (float)StoneworksChatClient.hudOffsetY;
                                topYf = centerLineY - (float)scaledBgH / 2.0f;
                                break;
                            }
                            case BOTTOM: {
                                topYf = screenH - StoneworksChatClient.hudOffsetY - scaledBgH;
                                break;
                            }
                            default: {
                                topYf = StoneworksChatClient.hudPosY;
                            }
                        }
                    }
                    boolean centerAnchorY = StoneworksChatClient.hudAnchorY == StoneworksChatClient.AnchorY.CENTER;
                    y = centerAnchorY ? (int)Math.floor(topYf + 1.0E-4f) : Math.round(topYf);
                } else {
                    y = StoneworksChatClient.hudPosY;
                }
                drawContext.method_25294(leftX, y, leftX + scaledBgW, y + scaledBgH, Integer.MIN_VALUE);
                int textX = rtl ? leftX + scaledBgW - Math.round((float)paddingX * scale) - Math.round((float)textW * scale) : (center ? leftX + Math.max(0, (scaledBgW - Math.round((float)textW * scale)) / 2) : leftX + Math.round((float)paddingX * scale));
                int textY = y + Math.round((float)(scaledBgH - Math.round((float)textH * scale)) / 2.0f) + 1;
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_46416((float)textX, (float)textY, 0.0f);
                drawContext.method_51448().method_22905(scale, scale, 1.0f);
                drawContext.method_51439(tr, (class_2561)text, 0, 0, colorCode, true);
                drawContext.method_51448().method_22909();
            }
        });
    }

    public static int getColorCode(String color) {
        if (color == null) {
            return 0xFFFFFF;
        }
        return switch (color.toLowerCase()) {
            case "green" -> 65280;
            case "white" -> 0xFFFFFF;
            case "light_red" -> 0xFF5555;
            case "cyan" -> 65535;
            case "red" -> 0xFF0000;
            case "yellow" -> 0xFFFF00;
            default -> 0xFFFFFF;
        };
    }
}

