/*
 * Decompiled with CFR 0.152.
 */
package com.duperknight.stoneworksChat.client.config;

import com.duperknight.stoneworksChat.client.Channel;
import com.duperknight.stoneworksChat.client.StoneworksChatClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"stoneworks-chat");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "stoneworks_chat.json");

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Object tut;
                Object visible;
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                Map config = (Map)GSON.fromJson((Reader)reader, type);
                Object cc = config.get("currentChannel");
                StoneworksChatClient.currentChannel = cc instanceof String ? (String)cc : "public";
                Object channelsObj = config.get("channels");
                HashMap<String, Channel> loadedChannels = new HashMap<String, Channel>();
                if (channelsObj instanceof Map) {
                    Map rawMap = (Map)channelsObj;
                    for (Map.Entry e : rawMap.entrySet()) {
                        String s;
                        List<String> aliases;
                        String s2;
                        String s3;
                        Object object = e.getKey();
                        if (!(object instanceof String)) continue;
                        String key = (String)object;
                        object = e.getValue();
                        if (!(object instanceof Map)) continue;
                        Map inner = (Map)object;
                        Object v = inner.get("display");
                        String display = v instanceof String ? (s3 = (String)v) : key;
                        Object v2 = inner.get("color");
                        String color = v2 instanceof String ? (s2 = (String)v2) : "white";
                        Object aliasesObj = inner.get("aliases");
                        if (aliasesObj instanceof List) {
                            List list = (List)aliasesObj;
                            aliases = list.stream().map(Object::toString).toList();
                        } else if (aliasesObj instanceof String[]) {
                            String[] arr = (String[])aliasesObj;
                            aliases = Arrays.asList(arr);
                        } else {
                            aliases = List.of();
                        }
                        Object v3 = inner.get("uiName");
                        String uiName = v3 instanceof String ? (s = (String)v3) : display;
                        loadedChannels.put(key, new Channel(display, color, aliases, uiName));
                    }
                }
                StoneworksChatClient.channels = loadedChannels;
                Object hudX = config.get("hudX");
                Object hudY = config.get("hudY");
                Object align = config.get("textAlign");
                Object anchorX = config.get("hudAnchorX");
                Object anchorY = config.get("hudAnchorY");
                Object offX = config.get("hudOffsetX");
                Object offY = config.get("hudOffsetY");
                Object scale = config.get("hudScale");
                if (hudX instanceof Number) {
                    Number nX = (Number)hudX;
                    StoneworksChatClient.hudPosX = nX.intValue();
                }
                if (hudY instanceof Number) {
                    Number nY = (Number)hudY;
                    StoneworksChatClient.hudPosY = nY.intValue();
                }
                if (anchorX instanceof String) {
                    String ax = (String)anchorX;
                    try {
                        StoneworksChatClient.hudAnchorX = StoneworksChatClient.AnchorX.valueOf(ax);
                    }
                    catch (Exception ignored) {
                        StoneworksChatClient.hudAnchorX = null;
                    }
                } else {
                    StoneworksChatClient.hudAnchorX = null;
                }
                if (anchorY instanceof String) {
                    String ay = (String)anchorY;
                    try {
                        StoneworksChatClient.hudAnchorY = StoneworksChatClient.AnchorY.valueOf(ay);
                    }
                    catch (Exception ignored) {
                        StoneworksChatClient.hudAnchorY = null;
                    }
                } else {
                    StoneworksChatClient.hudAnchorY = null;
                }
                if (offX instanceof Number) {
                    Number ox = (Number)offX;
                    StoneworksChatClient.hudOffsetX = ox.intValue();
                }
                if (offY instanceof Number) {
                    Number oy = (Number)offY;
                    StoneworksChatClient.hudOffsetY = oy.intValue();
                }
                if (scale instanceof Number) {
                    Number sc = (Number)scale;
                    StoneworksChatClient.hudScale = Math.max(0.75f, Math.min(4.0f, sc.floatValue()));
                }
                if (align instanceof String) {
                    String s = (String)align;
                    StoneworksChatClient.hudTextAlign = "rtl".equalsIgnoreCase(s) ? StoneworksChatClient.TextAlign.RIGHT_TO_LEFT : ("center".equalsIgnoreCase(s) ? StoneworksChatClient.TextAlign.CENTER : StoneworksChatClient.TextAlign.LEFT_TO_RIGHT);
                }
                if ((visible = config.get("hudVisible")) instanceof Boolean) {
                    Boolean bv = (Boolean)visible;
                    StoneworksChatClient.hudVisible = bv;
                }
                if ((tut = config.get("showHudTutorial")) instanceof Boolean) {
                    Boolean bt = (Boolean)tut;
                    StoneworksChatClient.showHudTutorial = bt;
                }
                LOGGER.info("Loaded config: currentChannel = {}", (Object)StoneworksChatClient.currentChannel);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config {}", (Object)CONFIG_FILE.getAbsolutePath(), (Object)e);
            }
        } else {
            StoneworksChatClient.channels = new HashMap<String, Channel>();
        }
        ChatConfig.ensureDefaultChannels();
    }

    public static void save() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("currentChannel", StoneworksChatClient.currentChannel);
        HashMap channelsOut = new HashMap();
        for (Map.Entry<String, Channel> e : StoneworksChatClient.channels.entrySet()) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            Channel ch = e.getValue();
            if (ch.display() != null) {
                m.put("display", ch.display());
            }
            if (ch.color() != null) {
                m.put("color", ch.color());
            }
            if (ch.aliases() != null) {
                m.put("aliases", ch.aliases());
            }
            if (ch.uiName() != null) {
                m.put("uiName", ch.uiName());
            }
            channelsOut.put(e.getKey(), m);
        }
        config.put("channels", channelsOut);
        config.put("hudX", StoneworksChatClient.hudPosX);
        config.put("hudY", StoneworksChatClient.hudPosY);
        String align = switch (StoneworksChatClient.hudTextAlign) {
            default -> throw new MatchException(null, null);
            case StoneworksChatClient.TextAlign.LEFT_TO_RIGHT -> "ltr";
            case StoneworksChatClient.TextAlign.CENTER -> "center";
            case StoneworksChatClient.TextAlign.RIGHT_TO_LEFT -> "rtl";
        };
        config.put("textAlign", align);
        config.put("hudVisible", StoneworksChatClient.hudVisible);
        if (StoneworksChatClient.hudAnchorX != null) {
            config.put("hudAnchorX", StoneworksChatClient.hudAnchorX.name());
        }
        if (StoneworksChatClient.hudAnchorY != null) {
            config.put("hudAnchorY", StoneworksChatClient.hudAnchorY.name());
        }
        config.put("hudOffsetX", StoneworksChatClient.hudOffsetX);
        config.put("hudOffsetY", StoneworksChatClient.hudOffsetY);
        config.put("showHudTutorial", StoneworksChatClient.showHudTutorial);
        config.put("hudScale", Float.valueOf(StoneworksChatClient.hudScale));
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(config, (Appendable)writer);
            LOGGER.info("Saved config: currentChannel = {}", (Object)StoneworksChatClient.currentChannel);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config {}", (Object)CONFIG_FILE.getAbsolutePath(), (Object)e);
        }
    }

    private static void ensureDefaultChannels() {
        ChatConfig.addDefaultChannel("public", "Global", "white", new String[]{"/g", "/global"});
        ChatConfig.addDefaultChannel("LocalChat", "Local", "green", new String[]{"/l", "/local"});
        ChatConfig.addDefaultChannel("TradeChat", "Trade", "cyan", new String[]{"/tradechat", "/tc"});
        ChatConfig.addDefaultChannel("RPChat", "Roleplay", "light_red", new String[]{"/rpc"});
    }

    private static void addDefaultChannel(String key, String display, String color, String[] aliases) {
        if (!StoneworksChatClient.channels.containsKey(key)) {
            StoneworksChatClient.channels.put(key, new Channel(display, color, Arrays.asList(aliases), display));
        }
    }
}

