/*
 * Decompiled with CFR 0.152.
 */
package fr.silv.constants;

import java.time.LocalTime;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class DaylightCycle {
    private static final LocalTime FullMoonStart1 = LocalTime.of(2, 0);
    private static final LocalTime FullMoonEnd1 = LocalTime.of(2, 15);
    private static final LocalTime FullMoonStart2 = LocalTime.of(10, 0);
    private static final LocalTime FullMoonEnd2 = LocalTime.of(10, 15);
    private static final LocalTime FullMoonStart3 = LocalTime.of(18, 0);
    private static final LocalTime FullMoonEnd3 = LocalTime.of(18, 15);

    public static boolean isFullMoon(LocalTime now) {
        return now.isAfter(FullMoonStart1) && now.isBefore(FullMoonEnd1) || now.isAfter(FullMoonStart2) && now.isBefore(FullMoonEnd2) || now.isAfter(FullMoonStart3) && now.isBefore(FullMoonEnd3);
    }

    public static boolean isNight(LocalTime now) {
        int minute = now.getMinute();
        return minute < 15;
    }

    public static boolean isMorning(LocalTime now) {
        int minute = now.getMinute();
        return minute >= 15 && minute < 30;
    }

    public static boolean isAfternoon(LocalTime now) {
        int minute = now.getMinute();
        return minute >= 30 && minute < 45;
    }

    public static boolean isEvening(LocalTime now) {
        int minute = now.getMinute();
        return minute >= 45;
    }

    public static boolean isHerbShopOpen(LocalTime now) {
        int second;
        int minute = now.getMinute();
        int total = minute * 60 + (second = now.getSecond());
        return total < 600 || total >= 3000;
    }

    public static boolean isCocktailAndMonkeyShopOpen(LocalTime now) {
        int second;
        int minute = now.getMinute();
        int total = minute * 60 + (second = now.getSecond());
        return total >= 2700 && total < 2925;
    }

    public static boolean isItalianRestaurantOpen(LocalTime now) {
        int second;
        int minute = now.getMinute();
        int total = minute * 60 + (second = now.getSecond());
        return total >= 2925 || total < 750;
    }
}

