/*
 * Decompiled with CFR 0.152.
 */
package fr.silv.hud;

import fr.silv.model.ConfigOption;
import fr.silv.model.MineboxStat;
import fr.silv.utils.ItemStatUtils;
import fr.silv.utils.ModConfig;
import fr.silv.utils.StatTextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class DisplayStats {
    private static List<MineboxStat> cachedStatsTotal = new ArrayList<MineboxStat>();
    private static List<MineboxStat> cachedHandStats = new ArrayList<MineboxStat>();
    private static List<MineboxStat> cachedPlayerStats = new ArrayList<MineboxStat>();
    private static Logger DisplayStatsLogger = LogManager.getLogger(DisplayStats.class);
    public static final Set<String> ALL_STATS = Set.of("mbx.stats.fortune", "mbx.stats.luck", "mbx.stats.intelligence", "mbx.stats.strength", "mbx.stats.health", "mbx.stats.agility", "mbx.stats.wisdom", "mbx.stats.defense");

    public static void register() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (ModConfig.statToggle == ConfigOption.OFF) {
                return;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1690.field_1842) {
                return;
            }
            class_327 textRenderer = client.field_1772;
            List<MineboxStat> stats = DisplayStats.getCombinedStats(client);
            if (stats.isEmpty()) {
                return;
            }
            int screenHeight = client.method_22683().method_4502();
            Objects.requireNonNull(textRenderer);
            int lineHeight = 9 + 2;
            int totalHeight = stats.size() * lineHeight;
            int y = Math.abs(screenHeight - totalHeight) / 2;
            int x = 4;
            for (MineboxStat stat : stats) {
                Object statString = "";
                if (ModConfig.statToggle == ConfigOption.SIMPLE) {
                    statString = StatTextUtils.formatStatSimple(stat.getStat()) + " " + stat.getValue();
                } else if (ModConfig.statToggle == ConfigOption.ADVANCED) {
                    statString = StatTextUtils.formatStatAdvanced(stat.getStat()) + ": " + stat.getValue();
                }
                class_2561 text = StatTextUtils.statColor((String)statString, stat.getStat());
                drawContext.method_27535(textRenderer, text, x, y, -1);
                y += lineHeight;
            }
        });
    }

    public static List<MineboxStat> getCombinedStats(class_310 client) {
        class_1799 main;
        List<MineboxStat> statsPlayer = new ArrayList<MineboxStat>();
        ArrayList<MineboxStat> statsItem = new ArrayList();
        if (client.field_1724 == null) {
            return statsPlayer;
        }
        class_1799 slot9 = client.field_1724.method_31548().method_5438(9);
        if (!slot9.method_7960()) {
            statsPlayer = DisplayStats.getStats(slot9, false);
        }
        if (!(main = client.field_1724.method_6047()).method_7960()) {
            statsItem = DisplayStats.getStats(main, true);
        }
        if (ItemStatUtils.areEquals(cachedPlayerStats, statsPlayer) && ItemStatUtils.areEquals(cachedHandStats, statsItem)) {
            return cachedStatsTotal;
        }
        cachedPlayerStats = new ArrayList<MineboxStat>(statsPlayer);
        cachedHandStats = new ArrayList<MineboxStat>(statsItem);
        block0: for (MineboxStat statPlayer : statsPlayer) {
            for (MineboxStat statItem : statsItem) {
                if (!statPlayer.getStat().equals(statItem.getStat())) continue;
                statPlayer.setValue(statPlayer.getValue() + statItem.getValue());
                continue block0;
            }
        }
        cachedStatsTotal = new ArrayList<MineboxStat>(statsPlayer);
        return statsPlayer;
    }

    private static List<MineboxStat> getStats(class_1799 stack, boolean includeBonus) {
        class_9290 lore = (class_9290)stack.method_58694(class_9334.field_49632);
        if (lore == null) {
            return new ArrayList<MineboxStat>();
        }
        List lines = lore.comp_2400();
        ArrayList<MineboxStat> stats = new ArrayList<MineboxStat>();
        for (class_2561 line : lines) {
            MineboxStat stat = includeBonus ? ItemStatUtils.extractStatsFromLineWithBonus(line, ALL_STATS) : ItemStatUtils.extractStatsFromLine(line, ALL_STATS);
            if (stat == null) continue;
            stats.add(stat);
        }
        return stats;
    }
}

