/*
 * Decompiled with CFR 0.152.
 */
package fr.silv.items;

import fr.silv.utils.ItemStatUtils;
import fr.silv.utils.ModConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class CustomItemDurabilityHandler {
    private static final Logger CustomItemDurabilityHandlerLogger = LogManager.getLogger(CustomItemDurabilityHandler.class);
    private static final Map<class_1799, Integer> durabilityCache = new WeakHashMap<class_1799, Integer>();
    private static final Map<class_1799, Integer> nbtHashCache = new WeakHashMap<class_1799, Integer>();
    private static final Map<String, Map<String, int[]>> statsCache = new HashMap<String, Map<String, int[]>>();
    private static final List<String> SUPPORTED_PREFIXES = List.of("hammer_", "vein_", "watering_can_", "sponge_", "bucket_", "laborer_", "basket_seeds_", "block_stick_", "leaf_blower");

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!ModConfig.durabilityToggle) {
                return;
            }
            class_746 player = client.field_1724;
            if (player != null) {
                CustomItemDurabilityHandler.scanInventory((List<class_1799>)player.method_31548().method_67533());
                CustomItemDurabilityHandler.scanItem(player.method_6079());
                if (player.field_7512 != null) {
                    for (class_1735 slot : player.field_7512.field_7761) {
                        CustomItemDurabilityHandler.scanItem(slot.method_7677());
                    }
                }
            }
        });
    }

    private static void scanInventory(List<class_1799> inventory) {
        for (class_1799 item : inventory) {
            CustomItemDurabilityHandler.scanItem(item);
        }
    }

    private static void scanItem(class_1799 item) {
        if (item == null || item.method_7960()) {
            return;
        }
        class_9279 nbtComponent = (class_9279)item.method_58694(class_9334.field_49628);
        if (nbtComponent == null) {
            return;
        }
        class_2487 nbt = nbtComponent.method_57461();
        int nbtHash = nbt.toString().hashCode();
        Integer previousHash = nbtHashCache.get(item);
        if (previousHash != null && previousHash == nbtHash) {
            return;
        }
        nbtHashCache.put(item, nbtHash);
        if (nbt.method_10550("mbitems:display").isPresent() && (Integer)nbt.method_10550("mbitems:display").get() == 1) {
            return;
        }
        if (nbt.method_10558("mbitems:id").isEmpty()) {
            return;
        }
        String id = (String)nbt.method_10558("mbitems:id").get();
        if (nbt.method_10562("mbitems:persistent").isEmpty()) {
            return;
        }
        class_2487 persistent = (class_2487)nbt.method_10562("mbitems:persistent").get();
        if (id.contains("haversack") || id.contains("block_infinite_chest")) {
            Object[] amountInside = CustomItemDurabilityHandler.getHaverackAmountInside(item);
            if (amountInside != null) {
                try {
                    int current = Integer.parseInt(amountInside[0]);
                    int max = Integer.parseInt((String)amountInside[1]);
                    CustomItemDurabilityHandlerLogger.info("[Durability] Haversack Detected: ID=" + id + " Current=" + current + " Max=" + max);
                    CustomItemDurabilityHandler.applyDurability(item, current, max);
                }
                catch (NumberFormatException e) {
                    CustomItemDurabilityHandlerLogger.error("[Durability] Error parsing haversack values: " + Arrays.toString(amountInside));
                }
            }
        } else if (CustomItemDurabilityHandler.startsWithSupportedPrefix(id)) {
            int[] durabilityRange;
            Map<String, int[]> stats = statsCache.get(id);
            if (stats == null) {
                CustomItemDurabilityHandlerLogger.info("[Durability] Loading stats for: " + id);
                stats = ItemStatUtils.getStatsFor(id);
                statsCache.put(id, stats);
            }
            if ((durabilityRange = stats.get("mbx.durability")) != null && durabilityRange.length > 0) {
                int max = durabilityRange[0];
                if (persistent.method_10550("mbitems:durability").isEmpty()) {
                    return;
                }
                int current = (Integer)persistent.method_10550("mbitems:durability").get();
                CustomItemDurabilityHandlerLogger.info("[Durability] Tool Detected: ID=" + id + " Current=" + current + " Max=" + max);
                CustomItemDurabilityHandler.applyDurability(item, current, max);
            } else {
                CustomItemDurabilityHandlerLogger.error("[Durability] No durability data found for: " + id);
            }
        }
    }

    private static boolean startsWithSupportedPrefix(String id) {
        for (String prefix : SUPPORTED_PREFIXES) {
            if (!id.startsWith(prefix)) continue;
            return true;
        }
        return id.startsWith("harvester_") && !id.contains("lumberjack") && !id.contains("fisher") && !id.contains("miner") && !id.contains("alchemist");
    }

    private static void applyDurability(class_1799 item, int current, int max) {
        Integer previousMax;
        if (current < 0 || max <= 0 || max < current) {
            CustomItemDurabilityHandlerLogger.error("[Durability] Invalid durability values: current=" + current + ", max=" + max);
            return;
        }
        Integer previous = durabilityCache.get(item);
        int damage = max - current;
        if (previous != null && previous == damage) {
            return;
        }
        if (item.method_58694(class_9334.field_49630) != null) {
            CustomItemDurabilityHandlerLogger.info("[Durability] Removing unbreakable flag for item.");
            item.method_57381(class_9334.field_49630);
        }
        if ((previousMax = (Integer)item.method_58694(class_9334.field_50072)) == null || previousMax != max) {
            item.method_57379(class_9334.field_50072, (Object)max);
        }
        item.method_57379(class_9334.field_49629, (Object)damage);
        durabilityCache.put(item, damage);
        CustomItemDurabilityHandlerLogger.info("[Durability] Set durability: " + current + "/" + max + " (Damage=" + damage + ")");
    }

    public static String[] getHaverackAmountInside(class_1799 item) {
        class_9290 loreComponent = (class_9290)item.method_58694(class_9334.field_49632);
        if (loreComponent != null) {
            for (class_2561 lore : loreComponent.comp_2400()) {
                String[] parts;
                String text;
                String string;
                class_2588 translatable;
                class_7417 class_74172 = lore.method_10851();
                if (!(class_74172 instanceof class_2588) || !"mbx.items.infinite_bag.amount_inside".equals((translatable = (class_2588)class_74172).method_11022())) continue;
                Object arg = translatable.method_11023()[0];
                if (arg instanceof class_2561) {
                    class_2561 t = (class_2561)arg;
                    string = t.getString();
                } else {
                    String s;
                    string = arg instanceof String ? (s = (String)arg) : null;
                }
                if ((text = string) == null || !text.contains("/") || (parts = text.split("/")).length != 2) continue;
                return parts;
            }
        }
        return null;
    }
}

