/*
 * Decompiled with CFR 0.152.
 */
package fr.silv.items;

import fr.silv.model.MineboxStat;
import fr.silv.utils.ItemStatUtils;
import fr.silv.utils.StatTextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class CustomItemTooltipHandler {
    private static final Logger CustomItemTooltipHandler = LogManager.getLogger(CustomItemTooltipHandler.class);
    private static final Map<class_1799, Long> recentLogs = new WeakHashMap<class_1799, Long>();
    private static final long LOG_THROTTLE_MS = 5000L;
    private static final Map<String, Integer> STAT_WEIGHTS = Map.of("mbx.stats.fortune", 1, "mbx.stats.agility", 1, "mbx.stats.strength", 1, "mbx.stats.luck", 1, "mbx.stats.intelligence", 1, "mbx.stats.wisdom", 1, "mbx.stats.defense", 1, "mbx.stats.health", 1);

    public static void addStatRangesToTooltip(class_1799 stack, class_1792.class_9635 context, class_1836 type, List<class_2561> lines) {
        Map<String, int[]> statRanges;
        boolean canLog;
        class_9279 nbtComponent = (class_9279)stack.method_58694(class_9334.field_49628);
        if (nbtComponent == null) {
            return;
        }
        class_2487 nbt = nbtComponent.method_57461();
        if (!nbt.method_10545("mbitems:id")) {
            return;
        }
        if (nbt.method_10550("mbitems:display").isPresent() && (Integer)nbt.method_10550("mbitems:display").get() == 1) {
            return;
        }
        if (nbt.method_10562("mbitems:persistent").isEmpty()) {
            return;
        }
        class_2487 persistent = (class_2487)nbt.method_10562("mbitems:persistent").get();
        if (persistent.toString().equals("{}")) {
            return;
        }
        if (nbt.method_10558("mbitems:id").isEmpty()) {
            return;
        }
        String itemId = (String)nbt.method_10558("mbitems:id").get();
        long now = System.currentTimeMillis();
        Long lastLogTime = recentLogs.get(stack);
        boolean bl = canLog = lastLogTime == null || now - lastLogTime > 5000L;
        if (canLog) {
            CustomItemTooltipHandler.info("[Tooltip] Processing item: " + itemId);
            recentLogs.put(stack, now);
        }
        if ((statRanges = ItemStatUtils.getStatsFor(itemId)).isEmpty()) {
            return;
        }
        Set<String> statKeys = statRanges.keySet();
        HashMap<String, Integer> actualStats = new HashMap<String, Integer>();
        for (int i = 0; i < lines.size(); ++i) {
            int[] range;
            class_2561 line = lines.get(i);
            MineboxStat stat = ItemStatUtils.extractStatsFromLine(line, statKeys);
            if (stat == null || (range = statRanges.get(stat.getStat().toLowerCase())) == null) continue;
            StringBuilder suffix = new StringBuilder(" [");
            suffix.append(range[0]);
            if (range[0] != range[1]) {
                suffix.append(" | ").append(range[1]);
            }
            suffix.append("]");
            class_5250 newLine = line.method_27661().method_10852(StatTextUtils.statColor(suffix.toString(), stat.getStat().toUpperCase()));
            lines.set(i, (class_2561)newLine);
            actualStats.put(stat.getStat().toLowerCase(), stat.getValue());
        }
        if (persistent.method_10562("mbitems:stats").isEmpty()) {
            return;
        }
        class_2487 stats = (class_2487)persistent.method_10562("mbitems:stats").get();
        if (stats.toString().equals("{}")) {
            return;
        }
        if (!actualStats.isEmpty()) {
            int score = (int)fr.silv.items.CustomItemTooltipHandler.computeGlobalStatScore(actualStats, statRanges);
            class_2583 style = fr.silv.items.CustomItemTooltipHandler.getColorFromScore(score);
            class_5250 scoreLine = lines.getFirst().method_27661().method_10852((class_2561)class_2561.method_43470((String)(" " + score + "%")).method_10862(style.method_10982(Boolean.valueOf(true))));
            lines.set(0, (class_2561)scoreLine);
            if (canLog) {
                CustomItemTooltipHandler.info("[Tooltip] Global score for item " + itemId + ": " + score + "%");
            }
        }
    }

    private static double computeGlobalStatScore(Map<String, Integer> actualStats, Map<String, int[]> statRanges) {
        double totalWeightedScore = 0.0;
        double totalWeight = 0.0;
        for (Map.Entry<String, int[]> entry : statRanges.entrySet()) {
            String statKey = entry.getKey().toLowerCase();
            int min = entry.getValue()[0];
            int max = entry.getValue()[1];
            if (max <= min) continue;
            Integer actualValue = actualStats.get(statKey);
            if (actualValue == null) {
                actualValue = 0;
            }
            Integer weight = STAT_WEIGHTS.get(statKey);
            double filledRatio = (double)(actualValue - min) / (double)(max - min);
            totalWeightedScore += filledRatio * (double)weight.intValue();
            totalWeight += (double)weight.intValue();
        }
        return totalWeight == 0.0 ? 0.0 : totalWeightedScore / totalWeight * 100.0;
    }

    public static class_2583 getColorFromScore(int score) {
        score = Math.max(0, Math.min(score, 100));
        int red = (int)((double)(255 * (100 - score)) / 100.0);
        int green = (int)((double)(255 * score) / 100.0);
        int rgb = red << 16 | green << 8;
        return class_2583.field_24360.method_27703(class_5251.method_27717((int)rgb)).method_10982(Boolean.valueOf(true));
    }
}

