/*
 * Decompiled with CFR 0.152.
 */
package fr.silv.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.silv.model.MineboxStat;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_7417;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class ItemStatUtils {
    private static final Logger ItemStatsRangeLoaderLogger = LogManager.getLogger(ItemStatUtils.class);
    private static final Map<String, Map<String, int[]>> statRanges = new HashMap<String, Map<String, int[]>>();

    public static void load() {
        try (InputStream input = ItemStatUtils.class.getClassLoader().getResourceAsStream("assets/mineboxtools/mineboxItemsStats.json");){
            ItemStatsRangeLoaderLogger.info("Loading item stats ranges from JSON file...");
            if (input != null) {
                String json = new String(input.readAllBytes(), StandardCharsets.UTF_8);
                JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
                for (Map.Entry itemEntry : root.entrySet()) {
                    String itemId = (String)itemEntry.getKey();
                    JsonObject stats = ((JsonElement)itemEntry.getValue()).getAsJsonObject();
                    HashMap<String, int[]> itemStats = new HashMap<String, int[]>();
                    for (Map.Entry stat : stats.entrySet()) {
                        JsonElement value = (JsonElement)stat.getValue();
                        if (value.isJsonArray()) {
                            JsonArray arr = value.getAsJsonArray();
                            if (arr.size() != 2) continue;
                            int[] range = new int[]{arr.get(0).getAsInt(), arr.get(1).getAsInt()};
                            itemStats.put((String)stat.getKey(), range);
                            continue;
                        }
                        if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isNumber()) continue;
                        int val = value.getAsInt();
                        itemStats.put((String)stat.getKey(), new int[]{val, val});
                    }
                    statRanges.put(itemId, itemStats);
                }
            }
            ItemStatsRangeLoaderLogger.info("Item stats ranges loaded successfully.");
        }
        catch (Exception e) {
            ItemStatsRangeLoaderLogger.error("Failed to load item stats ranges from JSON file.", (Throwable)e);
        }
    }

    public static Map<String, int[]> getStatsFor(String itemId) {
        return statRanges.getOrDefault(itemId, Collections.emptyMap());
    }

    public static MineboxStat extractStatsFromLine(class_2561 line, Set<String> validKeys) {
        class_2588 content = ItemStatUtils.findTranslatable(line, validKeys);
        if (content == null) {
            return null;
        }
        String key = content.method_11022();
        if (!validKeys.contains(key)) {
            return null;
        }
        List<class_2561> flat = ItemStatUtils.flattenText(line);
        for (class_2561 segment : flat) {
            class_2588 trContent;
            class_7417 class_74172 = segment.method_10851();
            if (class_74172 instanceof class_2588 && (trContent = (class_2588)class_74172).method_11022().equals("mbx.bonus")) continue;
            String raw = segment.getString();
            Matcher matcher = Pattern.compile("-?\\d+").matcher(raw);
            if (!matcher.find()) continue;
            try {
                int value = Integer.parseInt(matcher.group());
                return new MineboxStat(key, value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static MineboxStat extractStatsFromLineWithBonus(class_2561 line, Set<String> validKeys) {
        class_2588 content = ItemStatUtils.findTranslatable(line, validKeys);
        if (content == null) {
            return null;
        }
        String key = content.method_11022();
        if (!validKeys.contains(key)) {
            return null;
        }
        List<class_2561> flat = ItemStatUtils.flattenText(line);
        Integer baseValue = null;
        Integer bonusValue = null;
        Integer pendingNumber = null;
        Pattern intPat = Pattern.compile("[+-]?\\d+");
        for (class_2561 segment : flat) {
            class_7417 class_74172;
            String raw = segment.getString();
            Matcher m = intPat.matcher(raw);
            if (m.find()) {
                try {
                    pendingNumber = Integer.parseInt(m.group());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!((class_74172 = segment.method_10851()) instanceof class_2588)) continue;
            class_2588 tr = (class_2588)class_74172;
            String k = tr.method_11022();
            if (k.startsWith("mbx.stats.")) {
                if (pendingNumber == null || baseValue != null) continue;
                baseValue = pendingNumber;
                pendingNumber = null;
                continue;
            }
            if (!k.equals("mbx.bonus") || pendingNumber == null || bonusValue != null) continue;
            bonusValue = pendingNumber;
            pendingNumber = null;
        }
        if (baseValue == null && pendingNumber != null) {
            baseValue = pendingNumber;
        }
        if (baseValue == null) {
            return null;
        }
        int total = baseValue + (bonusValue != null ? bonusValue : 0);
        return new MineboxStat(key, total);
    }

    private static List<class_2561> flattenText(class_2561 text) {
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        result.add(text);
        for (class_2561 sibling : text.method_10855()) {
            result.addAll(ItemStatUtils.flattenText(sibling));
        }
        return result;
    }

    private static class_2588 findTranslatable(class_2561 text, Set<String> validKeys) {
        class_2588 content;
        class_7417 class_74172 = text.method_10851();
        if (class_74172 instanceof class_2588 && validKeys.contains((content = (class_2588)class_74172).method_11022())) {
            return content;
        }
        for (class_2561 sibling : text.method_10855()) {
            class_2588 result = ItemStatUtils.findTranslatable(sibling, validKeys);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static boolean areEquals(List<MineboxStat> listA, List<MineboxStat> listB) {
        if (listA.size() != listB.size()) {
            return false;
        }
        for (MineboxStat statA : listA) {
            boolean found = false;
            for (MineboxStat statB : listB) {
                if (!statA.getStat().equals(statB.getStat()) || statA.getValue() != statB.getValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

