/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.sdk.java.groups;

import dev.httpmarco.polocloud.common.future.FutureConverterKt;
import dev.httpmarco.polocloud.shared.groups.Group;
import dev.httpmarco.polocloud.shared.groups.SharedGroupProvider;
import dev.httpmarco.polocloud.v1.groups.FindGroupRequest;
import dev.httpmarco.polocloud.v1.groups.GroupControllerGrpc;
import dev.httpmarco.polocloud.v1.groups.GroupDeleteRequest;
import io.grpc.ManagedChannel;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupProvider
implements SharedGroupProvider<Group> {
    private final GroupControllerGrpc.GroupControllerBlockingStub blockingStub;
    private final GroupControllerGrpc.GroupControllerFutureStub futureStub;

    public GroupProvider(ManagedChannel channel) {
        this.blockingStub = GroupControllerGrpc.newBlockingStub(channel);
        this.futureStub = GroupControllerGrpc.newFutureStub(channel);
    }

    @Override
    @NotNull
    public List<Group> findAll() {
        return this.blockingStub.find(FindGroupRequest.getDefaultInstance()).getGroupsList().stream().map(Group.Companion::bindSnapshot).toList();
    }

    @Override
    @Nullable
    public Group find(@NotNull String name) {
        return this.blockingStub.find(FindGroupRequest.newBuilder().setName(name).build()).getGroupsList().stream().map(Group.Companion::bindSnapshot).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public CompletableFuture<List<Group>> findAllAsync() {
        return FutureConverterKt.completableFromGuava(this.futureStub.find(FindGroupRequest.newBuilder().build()), findGroupResponse -> findGroupResponse.getGroupsList().stream().map(Group.Companion::bindSnapshot).toList());
    }

    @Override
    public CompletableFuture<Group> findAsync(@NotNull String name) {
        return FutureConverterKt.completableFromGuava(this.futureStub.find(FindGroupRequest.newBuilder().setName(name).build()), findGroupResponse -> findGroupResponse.getGroupsList().stream().map(Group.Companion::bindSnapshot).findFirst().orElse(null));
    }

    @Override
    @Nullable
    public Group create(@NotNull Group group) {
        return Group.Companion.bindSnapshot(this.blockingStub.create(group.toSnapshot()));
    }

    @Override
    @NotNull
    public CompletableFuture<Group> createAsync(@NotNull Group group) {
        return FutureConverterKt.completableFromGuava(this.futureStub.create(group.toSnapshot()), Group.Companion::bindSnapshot);
    }

    @Override
    public Group update(@NotNull Group group) {
        return Group.Companion.bindSnapshot(this.blockingStub.update(group.toSnapshot()));
    }

    @Override
    public CompletableFuture<Group> updateAsync(@NotNull Group group) {
        return FutureConverterKt.completableFromGuava(this.futureStub.update(group.toSnapshot()), Group.Companion::bindSnapshot);
    }

    @Override
    @Nullable
    public Group delete(@NotNull String name) {
        return Group.Companion.bindSnapshot(this.blockingStub.delete(GroupDeleteRequest.newBuilder().setName(name).build()));
    }
}

