/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.sdk.java.information;

import dev.httpmarco.polocloud.shared.information.AggregateCloudInformation;
import dev.httpmarco.polocloud.shared.information.CloudInformation;
import dev.httpmarco.polocloud.shared.information.SharedCloudInformationProvider;
import dev.httpmarco.polocloud.v1.information.CloudInformationCleanUpRequest;
import dev.httpmarco.polocloud.v1.information.CloudInformationControllerGrpc;
import dev.httpmarco.polocloud.v1.information.CloudInformationFindAllRequest;
import dev.httpmarco.polocloud.v1.information.CloudInformationFindAverageRequest;
import dev.httpmarco.polocloud.v1.information.CloudInformationFindDaysRequest;
import dev.httpmarco.polocloud.v1.information.CloudInformationFindHoursRequest;
import dev.httpmarco.polocloud.v1.information.CloudInformationFindMinutesRequest;
import dev.httpmarco.polocloud.v1.information.CloudInformationFindRequest;
import io.grpc.ManagedChannel;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CloudInformationProvider
implements SharedCloudInformationProvider<CloudInformation> {
    private final CloudInformationControllerGrpc.CloudInformationControllerBlockingStub blockingStub;

    public CloudInformationProvider(ManagedChannel channel) {
        this.blockingStub = CloudInformationControllerGrpc.newBlockingStub(channel);
    }

    @Override
    @NotNull
    public CloudInformation find() {
        return CloudInformation.Companion.bindSnapshot(this.blockingStub.find(CloudInformationFindRequest.getDefaultInstance()).getInformation(0));
    }

    @Override
    @NotNull
    public List<CloudInformation> find(long from, long to) {
        return this.blockingStub.find(CloudInformationFindRequest.newBuilder().setFrom(from).setTo(to).build()).getInformationList().stream().map(CloudInformation.Companion::bindSnapshot).toList();
    }

    @Override
    @NotNull
    public List<CloudInformation> findAll() {
        return this.blockingStub.findAll(CloudInformationFindAllRequest.getDefaultInstance()).getInformationList().stream().map(CloudInformation.Companion::bindSnapshot).toList();
    }

    @Override
    @NotNull
    public List<AggregateCloudInformation> findMinutes(long from, long to) {
        return this.blockingStub.findMinutes(CloudInformationFindMinutesRequest.newBuilder().setFrom(from).setTo(to).build()).getInformationList().stream().map(AggregateCloudInformation.Companion::bindSnapshot).toList();
    }

    @Override
    @NotNull
    public List<AggregateCloudInformation> findHours(long from, long to) {
        return this.blockingStub.findHours(CloudInformationFindHoursRequest.newBuilder().setFrom(from).setTo(to).build()).getInformationList().stream().map(AggregateCloudInformation.Companion::bindSnapshot).toList();
    }

    @Override
    @NotNull
    public List<AggregateCloudInformation> findDays(long from, long to) {
        return this.blockingStub.findDays(CloudInformationFindDaysRequest.newBuilder().setFrom(from).setTo(to).build()).getInformationList().stream().map(AggregateCloudInformation.Companion::bindSnapshot).toList();
    }

    @Override
    @NotNull
    public AggregateCloudInformation findAverage(long from, long to) {
        return AggregateCloudInformation.Companion.bindSnapshot(this.blockingStub.findAverage(CloudInformationFindAverageRequest.newBuilder().setFrom(from).setTo(to).build()).getInformation());
    }

    @Override
    public void cleanup(long maxAgeMillis) {
        this.blockingStub.cleanUp(CloudInformationCleanUpRequest.newBuilder().setMaxAgeMillis(maxAgeMillis).build());
    }
}

