/*
 * Decompiled with CFR 0.152.
 */
package fun.moystudio.openlink;

import com.google.gson.Gson;
import com.mojang.datafixers.util.Pair;
import fun.moystudio.openlink.gui.SettingScreen;
import fun.moystudio.openlink.json.JsonIP;
import fun.moystudio.openlink.logic.LanConfig;
import fun.moystudio.openlink.network.Request;
import fun.moystudio.openlink.network.Uris;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OpenLink {
    public static final String MOD_ID = "openlink";
    public static final Logger LOGGER = LogManager.getLogger((String)"OpenLink");
    public static final String CONFIG_DIR = "config" + File.separator + "openlink" + File.separator;
    public static Preferences PREFERENCES;
    public static String EXECUTABLE_FILE_STORAGE_PATH;
    public static boolean disabled;
    public static String VERSION;
    public static String LOADER;
    public static String LOADER_VERSION;
    public static List<Pair<String, Class<?>>> CONFLICT_CLASS;
    public static int PREFER_CLASSIFY;
    private static final List<Pair<String, String>> CONFLICT_CLASS_NAME;

    public static void init(String version, String loader, String loader_version) throws Exception {
        VERSION = version;
        LOADER = loader;
        LOADER_VERSION = loader_version;
        LOGGER.info("Initializing OpenLink on " + loader + " " + loader_version);
        EXECUTABLE_FILE_STORAGE_PATH = String.valueOf(Path.of(OpenLink.getLocalStoragePos(), new String[0]).resolve(".openlink")) + File.separator;
        LOGGER.info("OpenLink Storage Path: " + EXECUTABLE_FILE_STORAGE_PATH);
        PREFERENCES = Preferences.userNodeForPackage(OpenLink.class);
        PREFER_CLASSIFY = OpenLink.getPreferClassify();
        File configdir = new File(CONFIG_DIR);
        File exedir = new File(EXECUTABLE_FILE_STORAGE_PATH);
        File logdir = new File(EXECUTABLE_FILE_STORAGE_PATH + File.separator + "logs" + File.separator);
        configdir.mkdirs();
        exedir.mkdirs();
        logdir.mkdirs();
        LanConfig.readConfig();
        LanConfig.writeConfig();
        SettingScreen.sensitiveInfoHiding = PREFERENCES.getBoolean("setting_sensitive_info_hiding", false);
        PREFERENCES.putBoolean("setting_sensitive_info_hiding", SettingScreen.sensitiveInfoHiding);
        CONFLICT_CLASS_NAME.forEach(className -> {
            try {
                Class<?> clazz = Class.forName((String)className.getSecond());
                CONFLICT_CLASS.add(Pair.of((Object)((String)className.getFirst()), clazz));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        LOGGER.info("\n   ____                       _       _         _\n  / __ \\                     | |     (_)       | |\n | |  | | _ __    ___  _ __  | |      _  _ __  | | __\n | |  | || '_ \\  / _ \\| '_ \\ | |     | || '_ \\ | |/ /\n | |__| || |_) ||  __/| | | || |____ | || | | ||   <\n  \\____/ | .__/  \\___||_| |_||______||_||_| |_||_|\\_\\\n         | |\n         |_|\n");
    }

    private static String getLocalStoragePos() {
        Path userHome1 = Paths.get(Objects.requireNonNullElse(System.getProperty("user.home"), "./"), new String[0]);
        Path userHome2 = Paths.get(Objects.requireNonNullElse(System.getenv("HOME"), "./"), new String[0]);
        Path userHome3 = Paths.get(Objects.requireNonNullElse(System.getenv("USERPROFILE"), "./"), new String[0]);
        Path userHome = !userHome2.toString().equals("./") ? userHome2 : (!userHome3.toString().equals("./") ? userHome3 : (!userHome1.toString().equals("./") ? userHome1 : Paths.get("./", new String[0])));
        userHome = userHome.toAbsolutePath();
        userHome.toFile().mkdirs();
        String macAppSupport = System.getProperty("os.name").contains("OS X") ? userHome.resolve("Library/Application Support").toString() : null;
        String localAppData = System.getenv("LocalAppData");
        String xdgDataHome = System.getenv("XDG_DATA_HOME");
        if (xdgDataHome == null) {
            xdgDataHome = userHome.resolve(".local/share").toString();
        }
        return Stream.of(localAppData, macAppSupport).filter(Objects::nonNull).findFirst().orElse(xdgDataHome);
    }

    private static int getPreferClassify() {
        Gson gson = new Gson();
        int preferClassify = -1;
        try {
            String json = (String)Request.POST(Uris.ipstackUri.toString(), Request.DEFAULT_HEADER, "{}").getFirst();
            JsonIP jsonIP = (JsonIP)gson.fromJson(json, JsonIP.class);
            preferClassify = jsonIP.country.equals("CN") ? 1 : (jsonIP.country.equals("HK") || jsonIP.country.equals("TW") || jsonIP.country.equals("MO") ? 2 : 3);
            LOGGER.info("User Country Code: " + jsonIP.country + ", Prefer Classify: " + preferClassify);
        }
        catch (Exception ignored) {
            LOGGER.warn("Can not get user country! Ignoring...");
        }
        return preferClassify;
    }

    static {
        disabled = false;
        CONFLICT_CLASS = new ArrayList();
        CONFLICT_CLASS_NAME = Arrays.asList(Pair.of((Object)"mcwifipnp", (Object)"io.github.satxm.mcwifipnp.ShareToLanScreenNew"), Pair.of((Object)"lanserverproperties", (Object)"rikka.lanserverproperties.ModifyLanScreen"), Pair.of((Object)"easylan", (Object)"org.xiaoxian.gui.GuiShareToLanEdit.GuiShareToLanModified"));
    }
}

