/*
 * Decompiled with CFR 0.152.
 */
package fun.moystudio.openlink.frpc;

import com.mojang.datafixers.util.Pair;
import fun.moystudio.openlink.OpenLink;
import fun.moystudio.openlink.frpc.Frpc;
import fun.moystudio.openlink.logic.EventCallbacks;
import fun.moystudio.openlink.logic.Extract;
import fun.moystudio.openlink.logic.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FrpcManager {
    private final Map<String, Pair<String, ? extends Frpc>> frpcImplInstances = new HashMap<String, Pair<String, ? extends Frpc>>();
    private final Map<String, Path> frpcExecutableFiles = new HashMap<String, Path>();
    private String currentFrpcId = null;
    private Process frpcProcess = null;
    private static final Logger LOGGER = LogManager.getLogger((String)"OpenLink/FrpcManager");
    private static FrpcManager INSTANCE = null;
    public boolean initialized = false;

    public static FrpcManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FrpcManager();
        }
        return INSTANCE;
    }

    public void init() {
        this.currentFrpcId = OpenLink.PREFERENCES.get("frpc_id", "openfrp");
        ServiceLoader<Frpc> loader = ServiceLoader.load(Frpc.class);
        loader.forEach(instance -> this.frpcImplInstances.put(instance.id(), (Pair<String, ? extends Frpc>)Pair.of((Object)instance.name(), (Object)instance)));
        for (String id : this.frpcImplInstances.keySet()) {
            Path path = this.getFrpcExecutableFileByDirectory(this.getFrpcStoragePathById(id));
            if (path == null) continue;
            this.frpcExecutableFiles.put(id, path);
        }
        StringBuilder sb = new StringBuilder("Loading " + this.frpcImplInstances.size() + " FrpcImpls:");
        for (Map.Entry<String, Pair<String, ? extends Frpc>> pair : this.frpcImplInstances.entrySet()) {
            sb.append(String.format("\n\t- %s %s", pair.getKey(), pair.getValue().getSecond()));
        }
        LOGGER.info(sb.toString());
        this.initialized = true;
    }

    public Path getFrpcImplExecutableFile(String id) {
        return this.isExecutableFileExist(id) ? this.frpcExecutableFiles.get(id) : null;
    }

    public String getCurrentFrpcId() {
        return this.currentFrpcId;
    }

    public Frpc getCurrentFrpcInstance() {
        return (Frpc)this.frpcImplInstances.get(this.currentFrpcId).getSecond();
    }

    public String getCurrentFrpcName() {
        return (String)this.frpcImplInstances.get(this.currentFrpcId).getFirst();
    }

    public void setCurrentFrpcId(String id) {
        if (this.frpcImplInstances.containsKey(id)) {
            try {
                ((Frpc)this.frpcImplInstances.get(id).getSecond()).init();
            }
            catch (Exception e) {
                LOGGER.error("Cannot set the current frpc id to {}: cannot initialize this frpc implementation.", (Object)id);
            }
            this.currentFrpcId = id;
            OpenLink.PREFERENCES.put("frpc_id", id);
            EventCallbacks.hasUpdate = (Boolean)((Pair)this.getFrpcImplDetail(this.getCurrentFrpcId()).getSecond()).getSecond();
        } else {
            LOGGER.error("Cannot set the current frpc id to {}: this frpc implementation is not loaded.", (Object)id);
        }
    }

    public List<Pair<Pair<String, String>, Pair<String, Boolean>>> getFrpcImplDetailList() {
        ArrayList<Pair<Pair<String, String>, Pair<String, Boolean>>> list = new ArrayList<Pair<Pair<String, String>, Pair<String, Boolean>>>();
        this.frpcImplInstances.forEach((id, nameAndInstance) -> list.add(Pair.of((Object)Pair.of((Object)id, (Object)((String)nameAndInstance.getFirst())), (Object)Pair.of((Object)(this.frpcExecutableFiles.containsKey(id) ? ((Frpc)nameAndInstance.getSecond()).getFrpcVersion(this.frpcExecutableFiles.get(id)) : null), (Object)((Frpc)nameAndInstance.getSecond()).isOutdated(this.getFrpcImplExecutableFile((String)id))))));
        return list;
    }

    public Pair<String, Pair<String, Boolean>> getFrpcImplDetail(String id) {
        Pair<String, ? extends Frpc> nameAndInstance = this.frpcImplInstances.get(id);
        return Pair.of((Object)((String)nameAndInstance.getFirst()), (Object)Pair.of((Object)(this.frpcExecutableFiles.containsKey(id) ? ((Frpc)nameAndInstance.getSecond()).getFrpcVersion(this.frpcExecutableFiles.get(id)) : null), (Object)((Frpc)nameAndInstance.getSecond()).isOutdated(this.getFrpcImplExecutableFile(id))));
    }

    public void updateFrpcByIds(String ... ids) {
        for (String id : ids) {
            if (!this.frpcImplInstances.containsKey(id)) continue;
            Frpc instance = (Frpc)this.frpcImplInstances.get(id).getSecond();
            boolean overridden = instance.downloadFrpc(this.getFrpcStoragePathById(id));
            if (overridden) {
                Path path = this.getFrpcExecutableFileByDirectory(this.getFrpcStoragePathById(id));
                if (path == null) {
                    LOGGER.error("Cannot use the downloading logic override of {}: cannot find the frpc executable file in storage directory.", this.frpcImplInstances.get(id).getFirst());
                    continue;
                }
                this.frpcExecutableFiles.put(id, path);
                LOGGER.info("Downloaded {}'s frpc executable file(download logic is overridden).", this.frpcImplInstances.get(id).getFirst());
                continue;
            }
            Path executableFile = this.downloadFrpcById(id);
            if (executableFile == null) {
                LOGGER.error("Frpc '{}' cannot be downloaded.", this.frpcImplInstances.get(id).getFirst());
                continue;
            }
            this.frpcExecutableFiles.put(id, executableFile);
            LOGGER.info("Downloaded {}'s frpc executable file automatically.", this.frpcImplInstances.get(id).getFirst());
        }
    }

    private Path downloadFrpcById(String id) {
        if (this.frpcImplInstances.containsKey(id)) {
            List<String> urls = ((Frpc)this.frpcImplInstances.get(id).getSecond()).getUpdateFileUrls();
            if (urls == null) {
                LOGGER.error("Cannot download frpc by id '{}': no download urls provided by frpc implementation.", (Object)id);
                return null;
            }
            boolean flag = false;
            Path executableFilePath = null;
            for (String s : urls) {
                try {
                    URL url = new URL(s);
                    BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
                    executableFilePath = this.getFrpcStoragePathById(id).resolve(url.getFile().substring(url.getFile().lastIndexOf(47) + 1));
                    FileOutputStream outputStream = new FileOutputStream(executableFilePath.toFile());
                    outputStream.write(inputStream.readAllBytes());
                    inputStream.close();
                    outputStream.close();
                    LOGGER.info("Frpc downloaded successfully!");
                    flag = true;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!flag) {
                LOGGER.error("Cannot download frpc by id '{}': all the frpc download urls cannot use.", (Object)id);
                return null;
            }
            if (((Frpc)this.frpcImplInstances.get(id).getSecond()).isArchive()) {
                try {
                    Extract.ExtractBySuffix(executableFilePath.toFile().getAbsoluteFile());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("Cannot extract frpc archive by id '{}'!", (Object)id);
                    return null;
                }
                executableFilePath.toFile().getAbsoluteFile().delete();
                executableFilePath = this.getFrpcExecutableFileByDirectory(this.getFrpcStoragePathById(id));
            }
            if (executableFilePath == null) {
                LOGGER.error("An error occurred while getting the frpc executable file path!");
            } else {
                LOGGER.info("Frpc executable file path is found successfully!");
            }
            return executableFilePath;
        }
        LOGGER.error("Cannot download frpc by id '{}': this frpc implementation is not loaded.", (Object)id);
        return null;
    }

    public Path getFrpcStoragePathById(String id) {
        if (this.frpcImplInstances.containsKey(id)) {
            Path override = ((Frpc)this.frpcImplInstances.get(id).getSecond()).frpcDirPathOverride(Path.of(OpenLink.EXECUTABLE_FILE_STORAGE_PATH + id, new String[0]));
            if (override != null) {
                override.toFile().mkdirs();
            } else {
                Path.of(OpenLink.EXECUTABLE_FILE_STORAGE_PATH + id, new String[0]).toFile().mkdirs();
            }
            return override != null ? override : Path.of(OpenLink.EXECUTABLE_FILE_STORAGE_PATH + id, new String[0]);
        }
        LOGGER.error("Cannot get frpc storage path by id '{}': this frpc implementation is not loaded.", (Object)id);
        return null;
    }

    public Path getFrpcExecutableFileByDirectory(Path dir) {
        final Path[] res = new Path[]{null};
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                @NotNull
                public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) {
                    if (file.toFile().getName().lastIndexOf(46) == -1 || file.toFile().getName().endsWith(".exe")) {
                        res[0] = file;
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            return null;
        }
        return res[0];
    }

    public boolean isExecutableFileExist(String id) {
        return this.frpcExecutableFiles.containsKey(id) && this.frpcExecutableFiles.get(id) != null;
    }

    public void stop() {
        if (!this.initialized) {
            return;
        }
        this.getCurrentFrpcInstance().stopFrpcProcess(this.frpcProcess);
        this.frpcProcess = null;
    }

    public boolean start(int i, String val) {
        String ip;
        Frpc frpc = this.getCurrentFrpcInstance();
        try {
            ip = frpc.createProxy(i, val);
            if (!this.frpcExecutableFiles.containsKey(this.currentFrpcId)) {
                LOGGER.error("Cannot start frpc: cannot find the frpc executable file.");
                return false;
            }
            LocalTime localTime = LocalTime.now();
            LocalDate localDate = LocalDate.now();
            File logFile = new File(OpenLink.EXECUTABLE_FILE_STORAGE_PATH + "logs" + File.separator + localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "_" + localTime.getHour() + "." + localTime.getMinute() + "." + localTime.getSecond() + "_" + Minecraft.getInstance().getSingleplayerServer().getWorldData().getLevelName() + ".log");
            logFile.createNewFile();
            LOGGER.info("Frpc Log File Path:" + String.valueOf(logFile));
            new FileOutputStream(logFile).write((Minecraft.getInstance().getSingleplayerServer().getWorldData().getLevelName() + "\n" + localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "\n" + localTime.format(DateTimeFormatter.ofPattern("hh:mm:ss")) + "\n" + i + "\n" + this.getCurrentFrpcName() + "\n").getBytes(StandardCharsets.UTF_8));
            this.frpcProcess = frpc.createFrpcProcess(this.frpcExecutableFiles.get(this.currentFrpcId), i, val);
            new Thread(() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.frpcProcess.getInputStream()));){
                    String line;
                    FileOutputStream fo = new FileOutputStream(logFile, true);
                    while ((line = reader.readLine()) != null) {
                        String[] parts;
                        fo.write("\n".getBytes(StandardCharsets.UTF_8));
                        for (String part : parts = line.split("\u001b\\[")) {
                            if (part.isEmpty()) continue;
                            String text = part.substring(part.indexOf("m") + 1);
                            fo.write(text.getBytes(StandardCharsets.UTF_8));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, "Frpc logger").start();
        }
        catch (Exception e) {
            e.printStackTrace();
            Minecraft.getInstance().gui.getChat().addMessage((Component)Utils.literalText("\u00a74[OpenLink] " + e.getClass().getName() + ":" + e.getMessage()));
            Minecraft.getInstance().gui.getChat().addMessage(Utils.proxyRestartText());
            return false;
        }
        Minecraft.getInstance().gui.getChat().addMessage(Utils.proxyStartText(ip));
        return true;
    }
}

