/*
 * Decompiled with CFR 0.152.
 */
package fun.moystudio.openlink.frpc;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.mojang.datafixers.util.Pair;
import fun.moystudio.openlink.OpenLink;
import fun.moystudio.openlink.frpc.Frpc;
import fun.moystudio.openlink.gui.LoginScreen;
import fun.moystudio.openlink.gui.NodeSelectionScreen;
import fun.moystudio.openlink.json.JsonDownloadFile;
import fun.moystudio.openlink.json.JsonNewProxy;
import fun.moystudio.openlink.json.JsonNode;
import fun.moystudio.openlink.json.JsonResponseWithData;
import fun.moystudio.openlink.json.JsonTotalAndList;
import fun.moystudio.openlink.json.JsonUserInfo;
import fun.moystudio.openlink.json.JsonUserProxy;
import fun.moystudio.openlink.logic.LanConfig;
import fun.moystudio.openlink.logic.Utils;
import fun.moystudio.openlink.network.Request;
import fun.moystudio.openlink.network.SSLUtils;
import fun.moystudio.openlink.network.Uris;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OpenFrpFrpcImpl
implements Frpc {
    private static OpenFrpFrpcImpl INSTANCE = null;
    private String frpcVersion = null;
    private String latestVersion = null;
    private String latestFolderName = "OF_0.61.1_4df06100_250122/";
    private String osArch;
    private String osName;
    private String archiveSuffix;
    private long proxyId;
    private static final Logger LOGGER = LogManager.getLogger(OpenFrpFrpcImpl.class);
    public static long nodeId = -1L;
    public static final int MAX_TRAFFIC_STORAGE = 4;
    public static String Authorization = null;
    public static String token = null;
    public List<String> downloadUrls = new ArrayList<String>();
    Path lastFrpcExecutablePath = null;

    @Override
    public void init() throws Exception {
        String os_arch = System.getProperty("os.arch").toLowerCase();
        String os_name = System.getProperty("os.name");
        if (os_arch.contains("i386")) {
            os_arch = "386";
        }
        if (os_name.contains("Windows")) {
            this.osName = "windows";
        } else if (os_name.contains("OS X")) {
            this.osName = "darwin";
            os_arch = os_arch.equals("x86_64") ? "amd64" : "arm64";
        } else if (os_name.contains("Linux") || os_name.contains("Unix")) {
            this.osName = "linux";
        } else if (os_name.contains("FreeBSD")) {
            this.osName = "freebsd";
        } else {
            LOGGER.error("Unsupported operating system detected!");
            throw new Exception("[OpenLink] Unsupported operating system detected!");
        }
        this.osArch = os_arch;
        this.archiveSuffix = this.osName.equals("windows") ? ".zip" : ".tar.gz";
        Gson gson = new Gson();
        JsonResponseWithData response = (JsonResponseWithData)gson.fromJson((String)Request.GET(String.valueOf(Uris.openFrpAPIUri) + "commonQuery/get?key=software", Request.DEFAULT_HEADER).getFirst(), new TypeToken<JsonResponseWithData<JsonDownloadFile>>(){}.getType());
        ((JsonDownloadFile)response.data).source.forEach(source2 -> this.downloadUrls.add(source2.value + "/"));
        OpenFrpFrpcImpl.readSession();
    }

    @Override
    public String id() {
        return "openfrp";
    }

    @Override
    public String name() {
        return "OpenFrp";
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public boolean isOutdated(Path frpcExecutablePath) {
        return this.checkUpdate(frpcExecutablePath);
    }

    @Override
    public boolean downloadFrpc(Path downloadDir) {
        return false;
    }

    @Override
    public List<String> getUpdateFileUrls() {
        ArrayList<String> list = new ArrayList<String>();
        this.downloadUrls.forEach(url -> list.add(url + this.latestFolderName + "frpc_" + this.osName + "_" + this.osArch + this.archiveSuffix));
        return list;
    }

    @Override
    public Process createFrpcProcess(Path frpcExecutableFilePath, int localPort, @Nullable String remotePort) throws Exception {
        nodeId = -1L;
        ArrayList<String> list = new ArrayList<String>(List.of(OpenLink.PREFERENCES.get("traffic_storage", "").split(";")));
        while (list.size() >= 4) {
            list.remove(0);
        }
        list.add(String.format(Locale.getDefault(), "%tD %tT", new Date(), new Date()) + "," + ((JsonUserInfo)OpenFrpFrpcImpl.getUserInfo().data).traffic);
        OpenLink.PREFERENCES.put("traffic_storage", String.join((CharSequence)";", list));
        return new ProcessBuilder(frpcExecutableFilePath.toFile().getAbsolutePath(), "-u", token, "-p", String.valueOf(this.proxyId)).redirectErrorStream(true).start();
    }

    @Override
    public String createProxy(int localPort, @Nullable String remotePort) throws Exception {
        int end;
        int start;
        Gson gson = new Gson();
        if (SSLUtils.sslIgnored) {
            Minecraft.getInstance().gui.getChat().addMessage((Component)Utils.translatableText("text.openlink.sslwarning", new Object[0]));
        }
        Minecraft.getInstance().gui.getChat().addMessage((Component)Utils.translatableText("text.openlink.creatingproxy", new Object[0]));
        Pair<String, Map<String, List<String>>> response = Request.POST(String.valueOf(Uris.openFrpAPIUri) + "frp/api/getUserProxies", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), "{}");
        JsonResponseWithData userProxies = (JsonResponseWithData)gson.fromJson((String)response.getFirst(), new TypeToken<JsonResponseWithData<JsonTotalAndList<JsonUserProxy>>>(){}.getType());
        for (JsonUserProxy jsonUserProxy : ((JsonTotalAndList)userProxies.data).list) {
            if (!jsonUserProxy.proxyName.contains("openlink_mc_")) continue;
            try {
                Request.POST(String.valueOf(Uris.openFrpAPIUri) + "frp/api/forceOff", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), "{\"proxy_id\":" + jsonUserProxy.id + "}");
                Request.POST(String.valueOf(Uris.openFrpAPIUri) + "frp/api/removeProxy", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), "{\"proxy_id\":" + jsonUserProxy.id + "}");
                LOGGER.info("Deleted proxy: {}", (Object)jsonUserProxy.proxyName);
            }
            catch (Exception e) {
                break;
            }
        }
        Thread.sleep(1000L);
        response = Request.POST(String.valueOf(Uris.openFrpAPIUri) + "frp/api/getUserProxies", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), "{}");
        userProxies = (JsonResponseWithData)gson.fromJson((String)response.getFirst(), new TypeToken<JsonResponseWithData<JsonTotalAndList<JsonUserProxy>>>(){}.getType());
        JsonResponseWithData<JsonUserInfo> userinfo = OpenFrpFrpcImpl.getUserInfo();
        if (((JsonUserInfo)userinfo.data).proxies == ((JsonTotalAndList)userProxies.data).total) {
            throw new Exception(Utils.translatableText("text.openlink.userproxieslimited", new Object[0]).getString());
        }
        JsonResponseWithData<JsonTotalAndList<JsonNode>> nodelist = OpenFrpFrpcImpl.getNodeList();
        JsonNode node = null;
        for (Object node1 : ((JsonTotalAndList)nodelist.data).list) {
            if (((JsonNode)node1).id != nodeId) continue;
            node = node1;
            break;
        }
        if (node == null) {
            LOGGER.info("Selecting node...");
            ArrayList<JsonNode> canUseNodes = new ArrayList<JsonNode>();
            for (JsonNode now : ((JsonTotalAndList)nodelist.data).list) {
                int usergroupnumber;
                int groupnumber1 = 5;
                if (now.group.contains("svip")) {
                    groupnumber1 = 3;
                }
                if (now.group.contains("vip")) {
                    groupnumber1 = 2;
                }
                if (now.group.contains("normal")) {
                    groupnumber1 = 1;
                }
                if (groupnumber1 > (usergroupnumber = ((JsonUserInfo)userinfo.data).group.contains("svip") ? 3 : (((JsonUserInfo)userinfo.data).group.contains("vip") ? 2 : 1)) || !now.protocolSupport.tcp || now.status != 200L || now.fullyLoaded || now.needRealname && !((JsonUserInfo)userinfo.data).realname) continue;
                canUseNodes.add(now);
            }
            if (canUseNodes.isEmpty()) {
                throw new Exception("Unable to use any node???");
            }
            canUseNodes.sort((o1, o2) -> {
                if (OpenLink.PREFER_CLASSIFY != -1 && o1.classify != o2.classify && o1.classify == (long)OpenLink.PREFER_CLASSIFY != (o2.classify == (long)OpenLink.PREFER_CLASSIFY)) {
                    return o1.classify == (long)OpenLink.PREFER_CLASSIFY ? -1 : 1;
                }
                if (!o1.group.equals(o2.group)) {
                    int first = 5;
                    int second = 5;
                    if (o1.group.contains("svip")) {
                        first = 3;
                    }
                    if (o1.group.contains("vip")) {
                        first = 2;
                    }
                    if (o1.group.contains("normal")) {
                        first = 1;
                    }
                    if (o2.group.contains("svip")) {
                        second = 3;
                    }
                    if (o2.group.contains("vip")) {
                        second = 2;
                    }
                    if (o2.group.contains("normal")) {
                        second = 1;
                    }
                    return first > second ? -1 : 1;
                }
                if (Math.abs(o1.bandwidth * o1.bandwidthMagnification - o2.bandwidth * o2.bandwidthMagnification) < 1.0E-5) {
                    return o2.bandwidth * o2.bandwidthMagnification > o1.bandwidth * o1.bandwidthMagnification ? 1 : -1;
                }
                if (((JsonUserInfo)userinfo.data).realname && o1.needRealname != o2.needRealname) {
                    return o1.needRealname ? -1 : 1;
                }
                return 0;
            });
            node = (JsonNode)canUseNodes.get(0);
        }
        LOGGER.info("Selected node: id:{} allow_port:{} group:{}", (Object)node.id, (Object)node.allowPort, (Object)node.group);
        JsonNewProxy newProxy = new JsonNewProxy();
        newProxy.name = "openlink_mc_" + localPort;
        newProxy.local_port = String.valueOf(localPort);
        newProxy.node_id = node.id;
        Random random = new Random();
        if (node.allowPort == null || node.allowPort.isBlank()) {
            start = 30000;
            end = 60000;
        } else {
            start = Integer.parseInt(node.allowPort.substring(1, 6));
            end = Integer.parseInt(node.allowPort.substring(7, 12));
        }
        boolean found = false;
        for (int j = 1; j <= 5; ++j) {
            newProxy.remote_port = random.nextInt(end - start + 1) + start;
            if (remotePort != null && !remotePort.isBlank() && j == 1) {
                newProxy.remote_port = Integer.parseInt(remotePort);
            }
            response = Request.POST(String.valueOf(Uris.openFrpAPIUri) + "frp/api/newProxy", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), gson.toJson((Object)newProxy));
            LOGGER.info("Try {}: remote_port:{} flag:{} msg:{}", (Object)j, (Object)remotePort, (Object)((JsonResponseWithData)gson.fromJson((String)((String)response.getFirst()), JsonResponseWithData.class)).flag, (Object)((JsonResponseWithData)gson.fromJson((String)((String)response.getFirst()), JsonResponseWithData.class)).msg);
            if (!((JsonResponseWithData)gson.fromJson((String)((String)response.getFirst()), JsonResponseWithData.class)).flag) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new Exception(Utils.translatableText("text.openlink.remoteportnotfound", new Object[0]).getString());
        }
        LanConfig.cfg.last_port_value = String.valueOf(newProxy.remote_port).equals(remotePort) ? remotePort : "";
        response = Request.POST(String.valueOf(Uris.openFrpAPIUri) + "frp/api/getUserProxies", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), "{}");
        userProxies = (JsonResponseWithData)gson.fromJson((String)response.getFirst(), new TypeToken<JsonResponseWithData<JsonTotalAndList<JsonUserProxy>>>(){}.getType());
        JsonUserProxy runningproxy = null;
        for (JsonUserProxy jsonUserProxy : ((JsonTotalAndList)userProxies.data).list) {
            if (!jsonUserProxy.proxyName.equals("openlink_mc_" + localPort)) continue;
            runningproxy = jsonUserProxy;
            break;
        }
        if (runningproxy == null) {
            throw new Exception("Can not find the proxy???");
        }
        nodeId = node.id;
        this.proxyId = runningproxy.id;
        return runningproxy.connectAddress;
    }

    @Override
    public String getFrpcVersion(Path frpcExecutableFilePath) {
        try {
            this.frpcVersion = new String(Runtime.getRuntime().exec(new String[]{frpcExecutableFilePath.toFile().getAbsolutePath(), "-v"}).getInputStream().readAllBytes(), StandardCharsets.UTF_8).split("_")[1];
            return this.frpcVersion;
        }
        catch (Exception e) {
            return "does not exists";
        }
    }

    @Override
    public void logOut() {
        Authorization = null;
        OpenFrpFrpcImpl.writeSession();
    }

    public static Frpc getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OpenFrpFrpcImpl();
        }
        return INSTANCE;
    }

    private boolean checkUpdate(Path path) {
        JsonResponseWithData frpcVersionJson;
        Gson gson = new Gson();
        try {
            frpcVersionJson = (JsonResponseWithData)gson.fromJson((String)Request.GET(String.valueOf(Uris.openFrpAPIUri) + "commonQuery/get?key=software", Request.DEFAULT_HEADER).getFirst(), new TypeToken<JsonResponseWithData<JsonDownloadFile>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        boolean result = false;
        this.latestVersion = ((JsonDownloadFile)frpcVersionJson.data).latest_ver;
        this.latestFolderName = ((JsonDownloadFile)frpcVersionJson.data).latest_full + "/";
        if (path == null || !path.toFile().exists()) {
            LOGGER.warn("The frpc executable file does not exist!");
            result = true;
        } else {
            this.getFrpcVersion(path);
            if (!this.frpcVersion.equals(this.latestVersion)) {
                LOGGER.info("A frpc update was found! Latest version:{} Old version:{}", (Object)this.latestVersion, (Object)this.frpcVersion);
                result = true;
            }
        }
        return result;
    }

    @Override
    public void stopFrpcProcess(Process process) {
        if (process != null) {
            process.destroy();
            if (Authorization != null) {
                try {
                    Pair<String, Map<String, List<String>>> response = Request.POST(Uris.openFrpAPIUri.toString() + "frp/api/getUserProxies", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), "{}");
                    Gson gson = new Gson();
                    JsonResponseWithData userProxies = (JsonResponseWithData)gson.fromJson((String)response.getFirst(), new TypeToken<JsonResponseWithData<JsonTotalAndList<JsonUserProxy>>>(){}.getType());
                    for (JsonUserProxy jsonUserProxy : ((JsonTotalAndList)userProxies.data).list) {
                        if (!jsonUserProxy.proxyName.contains("openlink_mc_")) continue;
                        try {
                            Request.POST(String.valueOf(Uris.openFrpAPIUri) + "frp/api/forceOff", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), "{\"proxy_id\":" + jsonUserProxy.id + "}");
                            Request.POST(String.valueOf(Uris.openFrpAPIUri) + "frp/api/removeProxy", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), "{\"proxy_id\":" + jsonUserProxy.id + "}");
                            LOGGER.info("Deleted proxy: {}", (Object)jsonUserProxy.proxyName);
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getPanelUrl() {
        return "https://console.openfrp.net/fastlogin?auth=" + Authorization;
    }

    @Override
    public Screen getNodeSelectionScreen(Screen lastScreen) {
        return new NodeSelectionScreen(lastScreen);
    }

    @Override
    public Screen getLoginScreen(Screen lastScreen) {
        return new LoginScreen(lastScreen);
    }

    @Override
    public ResourceLocation getIcon() {
        return Utils.createResourceLocation("openlink", "textures/gui/openfrp_icon.png");
    }

    @Override
    public boolean isLoggedIn() {
        return Authorization != null;
    }

    public static void writeSession() {
        OpenLink.PREFERENCES.put("authorization", Objects.requireNonNullElse(Authorization, "null"));
    }

    public static void readSession() {
        Authorization = OpenLink.PREFERENCES.get("authorization", null);
        if (Authorization == null || Authorization.equals("null")) {
            Authorization = null;
            LOGGER.warn("The session does not exists in user preferences!");
            return;
        }
        try {
            JsonResponseWithData<JsonUserInfo> responseWithData = OpenFrpFrpcImpl.getUserInfo();
            if (responseWithData == null || !responseWithData.flag) {
                Authorization = null;
                OpenFrpFrpcImpl.writeSession();
                LOGGER.warn("The session has been expired!");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonResponseWithData<JsonUserInfo> getUserInfo() throws Exception {
        if (Authorization == null) {
            return null;
        }
        Gson gson = new Gson();
        Pair<String, Map<String, List<String>>> response = Request.POST(Uris.openFrpAPIUri.toString() + "frp/api/getUserInfo", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), "{}");
        JsonResponseWithData res = (JsonResponseWithData)gson.fromJson((String)response.getFirst(), new TypeToken<JsonResponseWithData<JsonUserInfo>>(){}.getType());
        if (res.data != null) {
            token = ((JsonUserInfo)res.data).token;
        }
        return res;
    }

    public static JsonResponseWithData<JsonTotalAndList<JsonNode>> getNodeList() throws Exception {
        if (Authorization == null) {
            return null;
        }
        Gson gson = new Gson();
        Pair<String, Map<String, List<String>>> response = Request.POST(Uris.openFrpAPIUri.toString() + "frp/api/getNodeList", Request.getHeaderWithAuthorization(Request.DEFAULT_HEADER, Authorization), "{}");
        return (JsonResponseWithData)gson.fromJson((String)response.getFirst(), new TypeToken<JsonResponseWithData<JsonTotalAndList<JsonNode>>>(){}.getType());
    }
}

