/*
 * Decompiled with CFR 0.152.
 */
package fun.moystudio.openlink.gui;

import com.mojang.datafixers.util.Pair;
import fun.moystudio.openlink.OpenLink;
import fun.moystudio.openlink.gui.NewShareToLanScreen;
import fun.moystudio.openlink.logic.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConflictSelectionScreen
extends Screen {
    public MultiLineLabel text;
    ConflictSelectionList conflictSelectionList;
    public static Pair<String, Class<?>> canOpen;

    public ConflictSelectionScreen(String conflictModId) {
        super((Component)Utils.translatableText("text.openlink.conflict", conflictModId));
    }

    protected void init() {
        canOpen = null;
        this.text = MultiLineLabel.create((Font)this.font, (Component)this.title, (int)(this.width - 50));
        this.conflictSelectionList = new ConflictSelectionList(this.minecraft);
        this.addWidget((GuiEventListener)this.conflictSelectionList);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            ConflictSelectionList.Entry entry = (ConflictSelectionList.Entry)this.conflictSelectionList.getSelected();
            if (entry != null) {
                try {
                    canOpen = Pair.of((Object)entry.modid, entry.clazz);
                    this.minecraft.setScreen((Screen)entry.clazz.getDeclaredConstructor(Screen.class).newInstance(new Object[]{null}));
                }
                catch (Exception e) {
                    canOpen = null;
                    throw new RuntimeException(e);
                }
            }
        }).bounds(this.width / 2 - 100, this.height - 38, 200, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.conflictSelectionList.render(guiGraphics, i, j, f);
        this.text.renderCentered(guiGraphics, this.width / 2, 16, 16, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, (Component)Utils.translatableText("text.openlink.conflict_tip", new Object[0]), this.width / 2, this.height - 58, 0xFFFFFF);
    }

    class ConflictSelectionList
    extends ObjectSelectionList<Entry> {
        public ConflictSelectionList(Minecraft minecraft) {
            super(minecraft, ConflictSelectionScreen.this.width, ConflictSelectionScreen.this.height - 65 + 4 - 32, 32, 18);
            for (Pair<String, Class<?>> classPair : OpenLink.CONFLICT_CLASS) {
                this.addEntry((AbstractSelectionList.Entry)new Entry((String)classPair.getFirst(), (Class)classPair.getSecond()));
            }
            this.setSelected((AbstractSelectionList.Entry)((Entry)((Object)this.children().get(this.addEntry((AbstractSelectionList.Entry)new Entry("openlink", NewShareToLanScreen.class))))));
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((Entry)this.getSelected()));
            }
        }

        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        protected void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
            ConflictSelectionScreen.this.renderBackground(guiGraphics, i, j, f);
        }

        public boolean isFocused() {
            return ConflictSelectionScreen.this.getFocused() == this;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            public String modid;
            public Class<?> clazz;

            public Entry(String modid, Class<?> clazz) {
                this.modid = modid;
                this.clazz = clazz;
            }

            @NotNull
            public Component getNarration() {
                return Utils.translatableText("narrator.select", this.modid);
            }

            public boolean mouseClicked(double d, double e, int i) {
                if (i == 0) {
                    this.select();
                    return true;
                }
                return false;
            }

            private void select() {
                ConflictSelectionList.this.setSelected((AbstractSelectionList.Entry)this);
            }

            public void render(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
                guiGraphics.drawCenteredString(ConflictSelectionScreen.this.font, this.modid + ": " + this.clazz.getSimpleName(), ConflictSelectionList.this.width / 2, j + 1, 0xFFFFFF);
            }
        }
    }
}

