/*
 * Decompiled with CFR 0.152.
 */
package fun.moystudio.openlink.gui;

import com.mojang.datafixers.util.Pair;
import fun.moystudio.openlink.logic.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class LineChartWidget
extends AbstractWidget {
    public List<Pair<String, Long>> dataPoints;
    public int x2;
    public int y2;
    public int width;
    public int height;
    public Font font;
    public Component labelX;
    public Component labelY;

    public LineChartWidget(Font font, int x1, int y1, int x2, int y2, Component labelX, Component labelY, List<Pair<String, Long>> dataPoints) {
        super(x1, y1, x2 - x1 + 1, y2 - y1 + 1, (Component)Utils.emptyText());
        this.font = font;
        this.dataPoints = dataPoints;
        this.labelX = labelX;
        this.labelY = labelY;
        this.x2 = x2;
        this.y2 = y2;
        this.width = x2 - x1 + 1;
        this.height = y2 - y1 + 1;
    }

    private void drawLine(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            guiGraphics.fill(x1, y1, x1 + 1, y1 + 1, color);
            if (x1 == x2 && y1 == y2) break;
            int e2 = err * 2;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        int beginX = this.getX();
        int beginY = this.y2;
        int endX = this.x2;
        int endY = this.getY();
        int x1 = this.getX();
        Pair maxDataVal = this.dataPoints.stream().max(Comparator.comparingLong(Pair::getSecond)).orElse(new Pair((Object)"nope", (Object)1L));
        if (this.dataPoints.size() > 1 && this.font.width(String.format("%.1f", (Long)maxDataVal.getSecond())) > this.font.width("114")) {
            beginX = x1 += this.font.width(String.format("%.1f", (Long)maxDataVal.getSecond())) - this.font.width("114");
            this.width = this.x2 - x1 + 1;
        }
        guiGraphics.hLine(beginX, endX, beginY, -1);
        guiGraphics.vLine(beginX, beginY, endY, -1);
        if (this.dataPoints.size() > 1) {
            int k;
            for (int k2 = 1; k2 <= 5; ++k2) {
                int y = beginY - k2 * (this.height - 5) / 5;
                guiGraphics.hLine(beginX, endX, y, Integer.MAX_VALUE);
            }
            float xScale = (float)(this.width - 10) / (float)(this.dataPoints.size() - 1);
            float yScale = (float)(this.height - 5) / (float)((Long)maxDataVal.getSecond()).longValue();
            for (int k3 = 0; k3 < this.dataPoints.size() - 1; ++k3) {
                int x11 = (int)((float)(beginX + 5) + (float)k3 * xScale);
                int y1 = (int)((float)beginY - (float)((Long)this.dataPoints.get(k3).getSecond()).longValue() * yScale);
                int x2 = (int)((float)(beginX + 5) + (float)(k3 + 1) * xScale);
                int y2 = (int)((float)beginY - (float)((Long)this.dataPoints.get(k3 + 1).getSecond()).longValue() * yScale);
                this.drawLine(guiGraphics, x11, y1, x2, y2, 2137443583);
            }
            ArrayList<Integer> dataX = new ArrayList<Integer>();
            boolean tooltip = false;
            int tooltipindex = 0;
            for (k = 0; k < this.dataPoints.size(); ++k) {
                int pointScale = 2;
                int pointX = (int)((float)(beginX + 5) + (float)k * xScale);
                int pointY = (int)((float)beginY - (float)((Long)this.dataPoints.get(k).getSecond()).longValue() * yScale);
                dataX.add(pointX);
                if (i >= pointX - pointScale && i <= pointX + pointScale && j >= pointY - pointScale && j <= pointY + pointScale) {
                    pointScale = pointScale * 3 / 2;
                    tooltip = true;
                    tooltipindex = k;
                }
                guiGraphics.fill(pointX - pointScale, pointY - pointScale, pointX + pointScale, pointY + pointScale, -10040065);
            }
            if (tooltip) {
                guiGraphics.renderComponentTooltip(this.font, Arrays.stream(new Component[]{Utils.literalText((String)this.dataPoints.get(tooltipindex).getFirst() + ", " + String.valueOf(this.dataPoints.get(tooltipindex).getSecond()) + "MiB")}).toList(), i, j);
            }
            for (k = 0; k < dataX.size(); ++k) {
                String toRender = (String)this.dataPoints.get(k).getFirst();
                if (toRender.contains(" ")) {
                    String[] arrayToRender = toRender.split(" ");
                    guiGraphics.drawCenteredString(this.font, arrayToRender[0], ((Integer)dataX.get(k)).intValue(), this.y2 + 5, 0xFFFFFF);
                    String string = arrayToRender[1];
                    int n = (Integer)dataX.get(k);
                    Objects.requireNonNull(this.font);
                    guiGraphics.drawCenteredString(this.font, string, n, this.y2 + 5 + 9, 0xFFFFFF);
                    continue;
                }
                guiGraphics.drawCenteredString(this.font, toRender, ((Integer)dataX.get(k)).intValue(), this.y2 + 5, 0xFFFFFF);
            }
            for (k = 1; k <= 5; ++k) {
                int y = beginY - k * (this.height - 5) / 5;
                guiGraphics.drawString(this.font, String.format("%.1f", (double)((long)k * (Long)maxDataVal.getSecond()) / 5.0), x1 - this.font.width(String.format("%.1f", (double)((long)k * (Long)maxDataVal.getSecond()) / 5.0)), y - 3, 0xFFFFFF);
            }
        } else {
            guiGraphics.drawCenteredString(this.font, (Component)Utils.translatableText("text.openlink.nodata", new Object[0]), this.getX() + (this.x2 - this.getX()) / 2, this.getY() + (this.y2 - this.getY()) / 2, 2137443583);
        }
        guiGraphics.drawCenteredString(this.font, this.labelX, this.x2 - 10, this.y2 - 10, 0xFFFFFF);
        guiGraphics.drawString(this.font, this.labelY, x1, this.getY() - 5, 0xFFFFFF);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

