/*
 * Decompiled with CFR 0.152.
 */
package fun.moystudio.openlink.gui;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import fun.moystudio.openlink.frpc.FrpcManager;
import fun.moystudio.openlink.frpc.OpenFrpFrpcImpl;
import fun.moystudio.openlink.gui.ConfirmScreenWithLanguageButton;
import fun.moystudio.openlink.json.JsonResponseWithData;
import fun.moystudio.openlink.json.JsonUserInfo;
import fun.moystudio.openlink.logic.Utils;
import fun.moystudio.openlink.logic.WebBrowser;
import fun.moystudio.openlink.network.LoginGetCodeHttpServer;
import fun.moystudio.openlink.network.Request;
import fun.moystudio.openlink.network.Uris;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class LoginScreen
extends Screen {
    Screen lastscreen;
    MultiLineLabel loginTips;
    EditBox authorization;
    WebBrowser browser;

    public LoginScreen(Screen last) {
        super((Component)Utils.translatableText("gui.openlink.loginscreentitle", new Object[0]));
        this.authorization = new EditBox(Minecraft.getInstance().font, this.width / 2 - 200, this.height / 6 * 3, 355, 20, (Component)Utils.translatableText("text.openlink.authorization", new Object[0]));
        this.browser = new WebBrowser(Uris.openidLoginUri.toString());
        this.lastscreen = last;
    }

    protected void init() {
        this.loginTips = MultiLineLabel.create((Font)this.font, (Component)Utils.translatableText("text.openlink.logintips", new Object[0]), (int)(this.width - 50));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Utils.translatableText("text.openlink.fastlogin", new Object[0]), button -> {
            Gson gson = new Gson();
            LoginGetCodeHttpServer codeHttpServer = new LoginGetCodeHttpServer();
            codeHttpServer.start();
            try {
                JsonResponseWithData response = (JsonResponseWithData)gson.fromJson((String)Request.POST("https://api.openfrp.net/oauth2/login?redirect_url=http://localhost:" + codeHttpServer.port, Request.DEFAULT_HEADER, "{}").getFirst(), new TypeToken<JsonResponseWithData<String>>(this){}.getType());
                new WebBrowser((String)response.data).openBrowser();
                this.minecraft.keyboardHandler.setClipboard((String)response.data);
                button.active = false;
                this.minecraft.setScreen((Screen)new ConfirmScreenWithLanguageButton(confirmed -> {
                    if (OpenFrpFrpcImpl.Authorization != null) {
                        this.onClose();
                    }
                }, (Component)Utils.translatableText("text.openlink.fastlogin", new Object[0]), (Component)Utils.translatableText("text.openlink.fastloginconfirm", new Object[0])));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.onClose();
            }
        }).bounds(this.width / 2 - 100, this.height / 6 * 2, 200, 20).build());
        this.authorization.setMaxLength(100);
        this.authorization.setX(this.width / 2 - 200);
        this.authorization.setY(this.height / 2);
        this.addRenderableWidget((GuiEventListener)this.authorization);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            OpenFrpFrpcImpl.Authorization = this.authorization.getValue();
            try {
                JsonResponseWithData<JsonUserInfo> response = OpenFrpFrpcImpl.getUserInfo();
                if (response != null && response.flag) {
                    this.onClose();
                } else {
                    OpenFrpFrpcImpl.Authorization = null;
                }
            }
            catch (Exception e) {
                OpenFrpFrpcImpl.Authorization = null;
            }
            OpenFrpFrpcImpl.writeSession();
        }).bounds(this.width / 2 + 160, this.height / 2, 40, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Utils.translatableText("text.openlink.no_account", new Object[0]), button -> this.browser.openBrowser()).bounds(this.width / 2 - 100, this.height / 6 * 4, 200, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        MutableComponent mutableComponent = Utils.translatableText("text.openlink.frptip", FrpcManager.getInstance().getCurrentFrpcName());
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, (Component)mutableComponent, 0, this.height - 9, 0xFFFFFF);
        this.loginTips.renderCentered(guiGraphics, this.width / 2, 15, 16, 0xFFFFFF);
    }

    public void tick() {
        if (this.authorization.getValue().isBlank()) {
            this.authorization.setSuggestion(Utils.translatableText("text.openlink.authorization", new Object[0]).getString());
        } else {
            this.authorization.setSuggestion("");
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastscreen);
    }
}

