/*
 * Decompiled with CFR 0.152.
 */
package fun.moystudio.openlink.gui;

import fun.moystudio.openlink.OpenLink;
import fun.moystudio.openlink.frpc.FrpcManager;
import fun.moystudio.openlink.gui.ImageButtonWithHoveredState;
import fun.moystudio.openlink.gui.SettingScreen;
import fun.moystudio.openlink.logic.LanConfig;
import fun.moystudio.openlink.logic.OnlineModeTabs;
import fun.moystudio.openlink.logic.UUIDFixer;
import fun.moystudio.openlink.logic.Utils;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.level.GameType;

public class NewShareToLanScreen
extends Screen {
    private static final Component ALLOW_COMMANDS_LABEL = Utils.translatableText("selectWorld.allowCommands", new Object[0]);
    private static final Component GAME_MODE_LABEL = Utils.translatableText("selectWorld.gameMode", new Object[0]);
    private static final Component INFO_TEXT = Utils.translatableText("lanServer.otherPlayers", new Object[0]);
    private final Screen lastScreen;
    private GameType gameMode = GameType.SURVIVAL;
    private static final ResourceLocation SETTING = Utils.createResourceLocation("openlink", "widget/setting_button");
    private static final ResourceLocation SETTING_HOVERED = Utils.createResourceLocation("openlink", "widget/setting_button");
    EditBox editBox;
    EditBox editBox2;
    CycleButton<Boolean> usingfrp;
    CycleButton<OnlineModeTabs> onlinemode;
    CycleButton<Boolean> allowpvp;
    Button nodeselection;
    boolean couldShare = true;

    public NewShareToLanScreen(Screen screen) {
        super((Component)Utils.translatableText("lanServer.title", new Object[0]));
        this.lastScreen = screen;
    }

    public void tick() {
        this.couldShare = true;
        String val2 = this.editBox2.getValue();
        if (val2.isBlank()) {
            this.editBox2.setSuggestion(Utils.translatableText("text.openlink.local_port", new Object[0]).getString());
        } else {
            this.editBox2.setSuggestion("");
        }
        if (!(val2.length() >= 4 && val2.length() <= 5 || val2.isBlank())) {
            this.couldShare = false;
        }
        boolean _0 = true;
        for (int i = 0; i < val2.length(); ++i) {
            if (i == 0 && val2.charAt(i) == '0') {
                this.couldShare = false;
            }
            if (val2.charAt(i) != '0') {
                _0 = false;
            }
            if (Character.isDigit(val2.charAt(i))) continue;
            this.couldShare = false;
        }
        if (_0 && !val2.isBlank()) {
            this.couldShare = false;
        }
        if (OpenLink.disabled) {
            return;
        }
        String val = this.editBox.getValue();
        this.editBox.setVisible(LanConfig.cfg.use_frp);
        if (!FrpcManager.getInstance().getCurrentFrpcInstance().isLoggedIn()) {
            LanConfig.cfg.use_frp = false;
            this.editBox.setValue("");
            this.usingfrp.setValue((Object)false);
            this.usingfrp.active = false;
            this.editBox.active = false;
            this.nodeselection.active = false;
            return;
        }
        this.usingfrp.active = true;
        if (val.isBlank()) {
            this.editBox.setSuggestion(Utils.translatableText("text.openlink.remote_port", new Object[0]).getString());
            return;
        }
        this.editBox.setSuggestion("");
        if (LanConfig.cfg.use_frp) {
            if (val.length() != 5) {
                this.couldShare = false;
                return;
            }
            _0 = true;
            for (int i = 0; i < val.length(); ++i) {
                if (i == 0 && val.charAt(i) == '0') {
                    this.couldShare = false;
                    return;
                }
                if (val.charAt(i) != '0') {
                    _0 = false;
                }
                if (Character.isDigit(val.charAt(i))) continue;
                this.couldShare = false;
                return;
            }
            if (_0) {
                this.couldShare = false;
            }
        }
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)CycleButton.builder(GameType::getShortDisplayName).withValues((Object[])new GameType[]{GameType.SURVIVAL, GameType.SPECTATOR, GameType.CREATIVE, GameType.ADVENTURE}).withInitialValue((Object)this.gameMode).create(this.width / 2 - 155, 100, 150, 20, GAME_MODE_LABEL, (cycleButton, gameType) -> {
            this.gameMode = gameType;
        }));
        this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)LanConfig.cfg.allow_commands).create(this.width / 2 + 5, 100, 150, 20, ALLOW_COMMANDS_LABEL, (cycleButton, boolean_) -> {
            LanConfig.cfg.allow_commands = boolean_;
        }));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Utils.translatableText("lanServer.start", new Object[0]), button1 -> {
            int i;
            if (!this.couldShare) {
                return;
            }
            this.minecraft.setScreen(null);
            int n = i = this.editBox2.getValue().isBlank() ? HttpUtil.getAvailablePort() : Integer.parseInt(this.editBox2.getValue());
            if (!this.minecraft.getSingleplayerServer().publishServer(this.gameMode, LanConfig.cfg.allow_commands, i)) {
                this.minecraft.gui.getChat().addMessage((Component)Utils.translatableText("commands.publish.failed", new Object[0]));
                this.minecraft.updateTitle();
                return;
            }
            this.minecraft.gui.getChat().addMessage((Component)Utils.translatableText("commands.publish.started", i));
            this.minecraft.updateTitle();
            this.minecraft.getSingleplayerServer().setUsesAuthentication(LanConfig.getAuthMode() == OnlineModeTabs.ONLINE_MODE);
            this.minecraft.getSingleplayerServer().setPvpAllowed(LanConfig.cfg.allow_pvp);
            UUIDFixer.EnableUUIDFixer = LanConfig.getAuthMode() == OnlineModeTabs.OFFLINE_FIXUUID;
            UUIDFixer.ForceOfflinePlayers = Collections.emptyList();
            try {
                LanConfig.writeConfig();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (OpenLink.disabled) {
                return;
            }
            if (!LanConfig.cfg.use_frp) {
                return;
            }
            new Thread(() -> FrpcManager.getInstance().start(i, this.editBox.getValue()), "Frpc starter").start();
        }).bounds(this.width / 2 - 155, this.height - 28, 150, 20).tooltip(this.getToolTip()).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen(this.lastScreen)).bounds(this.width / 2 + 5, this.height - 28, 150, 20).build());
        this.editBox2 = new EditBox(this.font, this.width / 2 - (OpenLink.disabled || !LanConfig.cfg.use_frp ? 75 : 155), OpenLink.disabled ? 160 : 190, 150, 20, (Component)Utils.translatableText("text.openlink.local_port", new Object[0]));
        this.editBox2.setSuggestion(Utils.translatableText("text.openlink.local_port", new Object[0]).getString());
        this.addRenderableWidget((GuiEventListener)this.editBox2);
        this.onlinemode = CycleButton.builder(o -> o.component).withValues((Object[])OnlineModeTabs.values()).withInitialValue((Object)LanConfig.getAuthMode()).create(this.width / 2 - 155, 130, 150, 20, (Component)Utils.translatableText("text.openlink.onlinemodebutton", new Object[0]), (button, o) -> LanConfig.setAuthMode(o));
        this.allowpvp = CycleButton.onOffBuilder((boolean)LanConfig.cfg.allow_pvp).create(this.width / 2 + 5, 130, 150, 20, (Component)Utils.translatableText("mco.configure.world.pvp", new Object[0]), (cycleButton, object) -> {
            LanConfig.cfg.allow_pvp = object;
        });
        this.addRenderableWidget((GuiEventListener)this.onlinemode);
        this.addRenderableWidget((GuiEventListener)this.allowpvp);
        if (OpenLink.disabled) {
            return;
        }
        this.editBox = new EditBox(this.font, this.width / 2 + 5, 190, 150, 20, (Component)Utils.translatableText("text.openlink.remote_port", new Object[0]));
        this.editBox.setSuggestion(Utils.translatableText("text.openlink.remote_port", new Object[0]).getString());
        this.editBox.setValue(LanConfig.cfg.last_port_value);
        this.addRenderableWidget((GuiEventListener)this.editBox);
        this.nodeselection = Button.builder((Component)Utils.translatableText("gui.openlink.nodeselectionscreentitle", new Object[0]), button -> this.minecraft.setScreen(FrpcManager.getInstance().getCurrentFrpcInstance().getNodeSelectionScreen(this))).bounds(this.width / 2 + 5, 160, 150, 20).build();
        this.nodeselection.active = LanConfig.cfg.use_frp && FrpcManager.getInstance().getCurrentFrpcInstance().getNodeSelectionScreen(this) != null;
        this.usingfrp = CycleButton.onOffBuilder((boolean)LanConfig.cfg.use_frp).create(this.width / 2 - 155, 160, 150, 20, (Component)Utils.translatableText("text.openlink.usingfrp", new Object[0]), (cycleButton, bool) -> {
            LanConfig.cfg.use_frp = bool;
            this.editBox.active = bool;
            this.nodeselection.active = bool;
            this.editBox2.setX(this.width / 2 - (OpenLink.disabled || bool == false ? 75 : 155));
        });
        this.addRenderableWidget((GuiEventListener)this.nodeselection);
        this.addRenderableWidget((GuiEventListener)this.usingfrp);
        this.addRenderableWidget((GuiEventListener)new ImageButtonWithHoveredState(this.width / 2 + 5 + 150 + 10, this.height - 28, 20, 20, SETTING, SETTING_HOVERED, button -> this.minecraft.setScreen((Screen)new SettingScreen(new NewShareToLanScreen(this.lastScreen)))));
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 50, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, INFO_TEXT, this.width / 2, 82, 0xFFFFFF);
        MutableComponent mutableComponent = Utils.translatableText("text.openlink.frptip", FrpcManager.getInstance().getCurrentFrpcName());
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, (Component)mutableComponent, 0, this.height - 9, 0xFFFFFF);
    }

    private Tooltip getToolTip() {
        if (OpenLink.disabled) {
            return Tooltip.create((Component)Utils.emptyText());
        }
        if (!FrpcManager.getInstance().getCurrentFrpcInstance().isLoggedIn()) {
            return Tooltip.create((Component)Utils.translatableText("text.openlink.lanlogintips", new Object[0]));
        }
        return Tooltip.create((Component)Utils.emptyText());
    }
}

