/*
 * Decompiled with CFR 0.152.
 */
package fun.moystudio.openlink.gui;

import fun.moystudio.openlink.frpc.OpenFrpFrpcImpl;
import fun.moystudio.openlink.json.JsonNode;
import fun.moystudio.openlink.json.JsonTotalAndList;
import fun.moystudio.openlink.logic.Utils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class NodeSelectionScreen
extends Screen {
    Screen lastscreen;
    NodeSelectionList selectionList;
    Button done;

    public NodeSelectionScreen(Screen lastscreen) {
        super((Component)Utils.translatableText("gui.openlink.nodeselectionscreentitle", new Object[0]));
        this.lastscreen = lastscreen;
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastscreen);
    }

    protected void init() {
        if (this.selectionList == null) {
            this.selectionList = new NodeSelectionList(this.minecraft);
        }
        this.selectionList.changePos(this.width, this.height, 32, this.height - 65 + 4);
        this.done = Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            if (this.selectionList == null || this.selectionList.getSelected() == null || ((NodeSelectionList.Entry)this.selectionList.getSelected()).node.id == -1L) {
                OpenFrpFrpcImpl.nodeId = -1L;
                this.minecraft.setScreen(this.lastscreen);
                return;
            }
            OpenFrpFrpcImpl.nodeId = ((NodeSelectionList.Entry)this.selectionList.getSelected()).node.id;
            this.minecraft.setScreen(this.lastscreen);
        }).bounds(this.width / 2 - 100, this.height - 38, 200, 20).build();
        this.addWidget((GuiEventListener)this.done);
        this.addWidget((GuiEventListener)this.selectionList);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        if (this.selectionList != null) {
            this.selectionList.render(guiGraphics, i, j, f);
        }
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 16, 0xFFFFFF);
        this.done.render(guiGraphics, i, j, f);
    }

    class NodeSelectionList
    extends ObjectSelectionList<Entry> {
        public NodeSelectionList(Minecraft minecraft) {
            super(minecraft, NodeSelectionScreen.this.width, NodeSelectionScreen.this.height - 65 + 4 - 32, 32, 40);
            JsonNode nothing = new JsonNode();
            nothing.name = CommonComponents.GUI_BACK.getString();
            nothing.id = -1L;
            nothing.status = 200L;
            nothing.description = Utils.translatableText("text.openlink.node_autoselect", new Object[0]).getString();
            Entry entry = new Entry(nothing);
            this.addEntry((AbstractSelectionList.Entry)entry);
            this.setSelected((AbstractSelectionList.Entry)entry);
            new Thread(() -> {
                try {
                    List nodes = ((JsonTotalAndList)OpenFrpFrpcImpl.getNodeList().data).list;
                    for (JsonNode node : nodes) {
                        Entry entry1 = new Entry(node);
                        this.addEntry((AbstractSelectionList.Entry)entry1);
                        if (node.id != OpenFrpFrpcImpl.nodeId) continue;
                        this.setSelected((AbstractSelectionList.Entry)entry1);
                        this.centerScrollOn((AbstractSelectionList.Entry)entry1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.minecraft.setScreen(NodeSelectionScreen.this.lastscreen);
                }
            }, "Request thread").start();
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((Entry)this.getSelected()));
            }
        }

        public void changePos(int width, int height, int y0, int y1) {
            this.setY(y0);
            this.setSize(width, y1 - y0);
        }

        public boolean isFocused() {
            return NodeSelectionScreen.this.getFocused() == this;
        }

        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            JsonNode node;

            public Entry(JsonNode node) {
                this.node = node;
            }

            @NotNull
            public Component getNarration() {
                return Utils.translatableText("narrator.select", this.node.name);
            }

            public boolean mouseClicked(double d, double e, int i) {
                if (i == 0) {
                    this.select();
                    return true;
                }
                return false;
            }

            private void select() {
                NodeSelectionList.this.setSelected((AbstractSelectionList.Entry)this);
            }

            public void render(GuiGraphics guiGraphics, int i, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float f) {
                guiGraphics.fill(x, y, x + entryWidth, y + entryHeight, -1892996309);
                Object group = null;
                if (this.node.group != null) {
                    group = this.node.group.split(";")[0].toUpperCase();
                    if (((String)group).equals("VIP")) {
                        group = "\u00a7e\u00a7l" + (String)group;
                    }
                    if (((String)group).equals("SVIP")) {
                        group = "\u00a76\u00a7l" + (String)group;
                    }
                }
                guiGraphics.drawString(((NodeSelectionList)NodeSelectionList.this).minecraft.font, "#" + this.node.id + " " + this.node.name + (String)(group != null && !((String)group).equals("ADMIN") && !((String)group).equals("DEV") ? " " + (String)group : ""), x + 4, y + 4, -1);
                guiGraphics.drawString(((NodeSelectionList)NodeSelectionList.this).minecraft.font, this.node.description, x + 4, y + 4 + (entryHeight - 4) / 2, -1);
                guiGraphics.drawString(((NodeSelectionList)NodeSelectionList.this).minecraft.font, (Component)(this.node.fullyLoaded || this.node.status != 200L ? Utils.translatableText("text.openlink.node_unavailable", new Object[0]) : (this.node.needRealname ? Utils.translatableText("text.openlink.node_needrealname", new Object[0]) : Utils.translatableText("text.openlink.node_available", new Object[0]))), x + entryWidth - 4 - ((NodeSelectionList)NodeSelectionList.this).minecraft.font.width((FormattedText)(this.node.fullyLoaded || this.node.status != 200L ? Utils.translatableText("text.openlink.node_unavailable", new Object[0]) : (this.node.needRealname ? Utils.translatableText("text.openlink.node_needrealname", new Object[0]) : Utils.translatableText("text.openlink.node_available", new Object[0])))), y + 4, -1);
                guiGraphics.drawString(((NodeSelectionList)NodeSelectionList.this).minecraft.font, this.node.bandwidth + "Mbps" + (String)(this.node.bandwidthMagnification > 1.0 ? " * " + this.node.bandwidthMagnification : ""), x + entryWidth - 4 - ((NodeSelectionList)NodeSelectionList.this).minecraft.font.width(this.node.bandwidth + "Mbps" + (String)(this.node.bandwidthMagnification > 1.0 ? " * " + this.node.bandwidthMagnification : "")), y + 4 + (entryHeight - 4) / 2, -1);
            }
        }
    }
}

