/*
 * Decompiled with CFR 0.152.
 */
package fun.moystudio.openlink.gui;

import com.mojang.datafixers.util.Pair;
import fun.moystudio.openlink.OpenLink;
import fun.moystudio.openlink.frpc.FrpcManager;
import fun.moystudio.openlink.frpc.OpenFrpFrpcImpl;
import fun.moystudio.openlink.gui.ChartWidget;
import fun.moystudio.openlink.gui.ComponentWidget;
import fun.moystudio.openlink.gui.ImageWidget;
import fun.moystudio.openlink.gui.LineChartWidget;
import fun.moystudio.openlink.gui.SettingScreenButton;
import fun.moystudio.openlink.gui.WebTextureResourceLocation;
import fun.moystudio.openlink.json.JsonResponseWithData;
import fun.moystudio.openlink.json.JsonUserInfo;
import fun.moystudio.openlink.logic.SettingTabs;
import fun.moystudio.openlink.logic.Utils;
import fun.moystudio.openlink.logic.WebBrowser;
import fun.moystudio.openlink.mixin.IScreenAccessor;
import fun.moystudio.openlink.network.Uris;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SettingScreen
extends Screen {
    MultiLineLabel title;
    Screen lastscreen;
    SettingTabs tab = SettingTabs.USER;
    SettingTabs lasttab = null;
    SettingScreenButton buttonLog;
    SettingScreenButton buttonInfo;
    SettingScreenButton buttonUser;
    SettingScreenButton buttonSetting;
    JsonResponseWithData<JsonUserInfo> userInfo = null;
    List<Renderable> renderableTabWidgets;
    List<Renderable> tabLog = new ArrayList<Renderable>();
    List<Renderable> tabInfo = new ArrayList<Renderable>();
    List<Renderable> tabUser = new ArrayList<Renderable>();
    List<Renderable> tabLogin_User = new ArrayList<Renderable>();
    List<Renderable> tabSetting = new ArrayList<Renderable>();
    public static List<InfoObjectSelectionList.Information> informationList;
    public static final ResourceLocation BACKGROUND_SETTING;
    public static boolean sensitiveInfoHiding;
    String avatarSha256 = null;

    public SettingScreen(Screen last) {
        super((Component)Utils.translatableText("gui.openlink.settingscreentitle", new Object[0]));
        informationList = SettingScreen.getInformationList(FrpcManager.getInstance().getCurrentFrpcInstance().getFrpcVersion(FrpcManager.getInstance().getFrpcImplExecutableFile(FrpcManager.getInstance().getCurrentFrpcId())), OpenLink.VERSION, OpenLink.LOADER + " " + OpenLink.LOADER_VERSION);
        this.lastscreen = last;
    }

    private static List<InfoObjectSelectionList.Information> getInformationList(Object ... objects) {
        String[] lines = Utils.translatableText("text.openlink.info", objects).getString().split("\n");
        ArrayList<InfoObjectSelectionList.Information> informations = new ArrayList<InfoObjectSelectionList.Information>();
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            if (line.charAt(0) == '1') {
                informations.add(new InfoObjectSelectionList.Information((Component)Utils.literalText(line.substring(1)), true));
                continue;
            }
            if (line.charAt(0) == '0') {
                informations.add(new InfoObjectSelectionList.Information((Component)Utils.literalText(line.substring(1)), false));
                continue;
            }
            informations.add(new InfoObjectSelectionList.Information((Component)Utils.literalText(line), false));
        }
        return informations;
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastscreen);
    }

    protected void init() {
        InfoObjectSelectionList infoObjectSelectionList;
        this.title = MultiLineLabel.create((Font)this.font, (Component[])new Component[]{Utils.translatableText("gui.openlink.settingscreentitle", new Object[0])});
        int i = (this.width - 10) / 4;
        this.buttonUser = new SettingScreenButton(5, 40, i, 20, SettingTabs.USER.component, button -> {
            this.tab = SettingTabs.USER;
        });
        this.buttonLog = new SettingScreenButton(5 + i, 40, i, 20, SettingTabs.LOG.component, button -> {
            this.tab = SettingTabs.LOG;
        });
        this.buttonInfo = new SettingScreenButton(5 + i * 2, 40, i, 20, SettingTabs.INFO.component, button -> {
            this.tab = SettingTabs.INFO;
        });
        this.buttonSetting = new SettingScreenButton(5 + i * 3, 40, i, 20, SettingTabs.SETTING.component, button -> {
            this.tab = SettingTabs.SETTING;
        });
        this.addRenderableWidget((GuiEventListener)this.buttonLog);
        this.addRenderableWidget((GuiEventListener)this.buttonInfo);
        this.addRenderableWidget((GuiEventListener)this.buttonUser);
        this.addRenderableWidget((GuiEventListener)this.buttonSetting);
        if (FrpcManager.getInstance().getCurrentFrpcId().equals("openfrp")) {
            ResourceLocation lastlocationimage = !this.tabUser.isEmpty() ? ((ImageWidget)this.tabUser.get((int)0)).texture : Utils.createResourceLocation("openlink", "textures/gui/default_avatar.png");
            MutableComponent lastcomponent1 = this.tabUser.size() >= 2 ? ((ComponentWidget)this.tabUser.get(1)).getMessage() : Utils.emptyText();
            MutableComponent lastcomponent2 = this.tabUser.size() >= 3 ? ((ComponentWidget)this.tabUser.get(2)).getMessage() : Utils.emptyText();
            MutableComponent lastcomponent3 = this.tabUser.size() >= 4 ? ((ComponentWidget)this.tabUser.get(3)).getMessage() : Utils.emptyText();
            MutableComponent lastcomponent4 = this.tabUser.size() >= 5 ? ((ComponentWidget)this.tabUser.get(4)).getMessage() : Utils.emptyText();
            MutableComponent lastcomponent5 = this.tabUser.size() >= 6 ? ((ComponentWidget)this.tabUser.get(5)).getMessage() : Utils.emptyText();
            int lastx2 = this.tabUser.size() >= 3 ? ((ComponentWidget)this.tabUser.get(2)).getX() : 10;
            List<Pair<String, Long>> lastdatapoints = this.tabUser.size() >= 7 ? ((LineChartWidget)this.tabUser.get((int)6)).dataPoints : this.readTraffic();
            this.tabUser.clear();
            int j = Math.min((this.width - 20) / 4, (this.height - 75) / 5 * 3);
            this.tabUser.add((Renderable)new ImageWidget(10, 65, 0, 0, j, j, j, j, lastlocationimage));
            this.tabUser.add((Renderable)new ComponentWidget(this.font, 10, 65 + j + 5, 0xFFFFFF, (Component)lastcomponent1, false));
            this.tabUser.add((Renderable)new ComponentWidget(this.font, lastx2, 65 + j + 5, 0xACACAC, (Component)lastcomponent2, false));
            this.tabUser.add((Renderable)new ComponentWidget(this.font, 10, 65 + j + 5 + 10, 0xACACAC, (Component)lastcomponent3, false));
            this.tabUser.add((Renderable)new ComponentWidget(this.font, 10, 65 + j + 5 + 20, 0xACACAC, (Component)lastcomponent4, false));
            this.tabUser.add((Renderable)new ComponentWidget(this.font, 10, 65 + j + 5 + 30, 0xACACAC, (Component)lastcomponent5, false));
            this.tabUser.add((Renderable)new LineChartWidget(this.font, 10 + j + 20, 70, this.width - 20, 60 + this.height - 75 - 15, (Component)Utils.translatableText("text.openlink.x_axis_label", new Object[0]), (Component)Utils.translatableText("text.openlink.y_axis_label", new Object[0]), lastdatapoints));
            this.tabUser.add((Renderable)Button.builder((Component)Utils.translatableText("text.openlink.logout", new Object[0]), button -> {
                FrpcManager.getInstance().getCurrentFrpcInstance().logOut();
                this.minecraft.setScreen((Screen)new SettingScreen(this.lastscreen));
            }).bounds(10, 65 + j + 5 + 40, j, 20).build());
        } else {
            this.tabUser.clear();
            this.tabUser.add((Renderable)Button.builder((Component)Utils.translatableText("text.openlink.logout", new Object[0]), button -> {
                FrpcManager.getInstance().getCurrentFrpcInstance().logOut();
                this.minecraft.setScreen((Screen)new SettingScreen(this.lastscreen));
            }).bounds(this.width / 2 - 20, this.height / 2 - 10, 40, 20).build());
        }
        LogObjectSelectionList lastlogselectionlist = !this.tabLog.isEmpty() ? (LogObjectSelectionList)this.tabLog.get(0) : new LogObjectSelectionList(this.minecraft, this.buttonSetting.getX() + this.buttonSetting.getWidth() - 5, this.height - 5 - 65, 5, 65, this.buttonSetting.getX() + this.buttonSetting.getWidth(), this.height - 5, 40);
        lastlogselectionlist.changePos(this.buttonSetting.getX() + this.buttonSetting.getWidth() - 5, this.height - 5 - 65, 5, 65, this.buttonSetting.getX() + this.buttonSetting.getWidth(), this.height - 5);
        if (!this.tabInfo.isEmpty()) {
            infoObjectSelectionList = (InfoObjectSelectionList)this.tabInfo.get(0);
        } else {
            int n = this.buttonSetting.getX() + this.buttonSetting.getWidth() - 5;
            int n2 = this.buttonSetting.getX() + this.buttonSetting.getWidth();
            int n3 = informationList.size();
            Objects.requireNonNull(this.minecraft.font);
            infoObjectSelectionList = new InfoObjectSelectionList(this.minecraft, n, this.height - 5 - 65, 5, 65, n2, this.height - 5, n3 * (9 + 5) + 5);
        }
        InfoObjectSelectionList lastinfoselectionlist = infoObjectSelectionList;
        lastinfoselectionlist.changePos(this.buttonSetting.getX() + this.buttonSetting.getWidth() - 5, this.height - 5 - 65, 5, 65, this.buttonSetting.getX() + this.buttonSetting.getWidth(), this.height - 5);
        this.tabLogin_User.clear();
        this.tabLog.clear();
        this.tabSetting.clear();
        this.tabInfo.clear();
        Screen loginScreen = FrpcManager.getInstance().getCurrentFrpcInstance().getLoginScreen(new SettingScreen(this.lastscreen));
        ResourceLocation icon = FrpcManager.getInstance().getCurrentFrpcInstance().getIcon();
        if (loginScreen != null && icon == null) {
            this.tabLogin_User.add((Renderable)Button.builder((Component)Utils.translatableText("text.openlink.login", new Object[0]), button -> this.minecraft.setScreen(loginScreen)).bounds(this.width / 2 - 20, (this.height - 75) / 2 + 60 - 10, 40, 20).build());
        } else if (loginScreen == null && icon != null) {
            this.tabLogin_User.add((Renderable)new ImageWidget(this.width / 2 - 32, (this.height - 75) / 2 + 60 - 32, 0, 0, 64, 64, 64, 64, icon));
        } else if (loginScreen != null) {
            this.tabLogin_User.add((Renderable)new ImageWidget(this.width / 2 - 20 - 32, (this.height - 75) / 2 + 60 - 32, 0, 0, 64, 64, 64, 64, icon));
            this.tabLogin_User.add((Renderable)Button.builder((Component)Utils.translatableText("text.openlink.login", new Object[0]), button -> this.minecraft.setScreen(loginScreen)).bounds(this.width / 2 + 20, (this.height - 75) / 2 + 60 - 10, 40, 20).build());
        } else {
            this.tabLogin_User.add((Renderable)new ComponentWidget(this.font, this.width / 2, (this.height - 75) / 2 + 60 - 10, 0xFFFFFF, (Component)Utils.translatableText("temp.openlink.tobedone", new Object[0]), true));
        }
        this.tabLog.add((Renderable)lastlogselectionlist);
        this.tabInfo.add((Renderable)lastinfoselectionlist);
        this.tabSetting.add((Renderable)new ChartWidget(10, 65, this.buttonSetting.getX() + this.buttonSetting.getWidth() - 10 - 5, 40, (Component)Utils.translatableText("text.openlink.secure", new Object[0]), -1892996309));
        this.tabSetting.add((Renderable)new ComponentWidget(this.font, 15, 87, 0xFFFFFF, (Component)Utils.translatableText("setting.openlink.information_show", new Object[0]), false));
        this.tabSetting.add((Renderable)CycleButton.onOffBuilder((boolean)sensitiveInfoHiding).displayOnlyValue().create(this.buttonSetting.getX() + this.buttonSetting.getWidth() - 75 - 5, 80, 75, 20, (Component)Utils.translatableText("setting.information_show", new Object[0]), (cycleButton, object) -> {
            sensitiveInfoHiding = object;
            OpenLink.PREFERENCES.putBoolean("setting_sensitive_info_hiding", (boolean)object);
        }));
        String url = FrpcManager.getInstance().getCurrentFrpcInstance().getPanelUrl();
        if (url != null) {
            this.tabSetting.add((Renderable)Button.builder((Component)Utils.translatableText("text.openlink.webpanel", FrpcManager.getInstance().getCurrentFrpcName()), button -> {
                this.minecraft.keyboardHandler.setClipboard(url);
                new WebBrowser(url).openBrowser();
            }).bounds(this.width / 2 - 75, 135, 150, 20).build());
        }
    }

    public List<? extends GuiEventListener> getChildrenWithTabRenderables() {
        List<GuiEventListener> list = ((IScreenAccessor)((Object)this)).getChildren();
        if (this.renderableTabWidgets != null) {
            this.renderableTabWidgets.forEach(widget -> {
                if (widget instanceof GuiEventListener) {
                    GuiEventListener guiEventListener = (GuiEventListener)widget;
                    list.add(guiEventListener);
                }
            });
        }
        return list;
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (this.renderableTabWidgets != null) {
            for (Renderable widget : this.renderableTabWidgets) {
                GuiEventListener guiEventListener;
                if (!(widget instanceof GuiEventListener) || !((guiEventListener = (GuiEventListener)widget) instanceof AbstractButton) || !guiEventListener.mouseClicked(d, e, i)) continue;
                this.setFocused(guiEventListener);
                if (i == 0) {
                    this.setDragging(true);
                }
                return true;
            }
        }
        return super.mouseClicked(d, e, i);
    }

    public void mouseMoved(double d, double e) {
        if (this.renderableTabWidgets != null) {
            this.renderableTabWidgets.forEach(widget -> {
                if (widget instanceof GuiEventListener) {
                    GuiEventListener guiEventListener = (GuiEventListener)widget;
                    guiEventListener.mouseMoved(d, e);
                }
            });
        }
    }

    @NotNull
    public Optional<GuiEventListener> getChildAt(double d, double e) {
        Optional toReturn = super.getChildAt(d, e);
        if (toReturn.isEmpty() && this.renderableTabWidgets != null) {
            for (Renderable widget : this.renderableTabWidgets) {
                GuiEventListener guiEventListener;
                if (!(widget instanceof GuiEventListener) || !(guiEventListener = (GuiEventListener)widget).isMouseOver(d, e)) continue;
                return Optional.of(guiEventListener);
            }
        }
        return toReturn;
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBackground(guiGraphics, i, j, f);
        guiGraphics.blit(RenderType::guiTextured, BACKGROUND_SETTING, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        guiGraphics.fill(5, 60, this.buttonSetting.getX() + this.buttonSetting.getWidth(), this.height - 5, -1895825408);
        this.title.renderCentered(guiGraphics, this.width / 2, 15);
        if (this.renderableTabWidgets != null) {
            this.renderableTabWidgets.forEach(widget -> widget.render(guiGraphics, i, j, f));
        }
        if (((IScreenAccessor)((Object)this)).getRenderables() != null) {
            ((IScreenAccessor)((Object)this)).getRenderables().forEach(widget -> widget.render(guiGraphics, i, j, f));
        }
    }

    private void onTab() {
        boolean first = this.lasttab != this.tab;
        switch (this.tab) {
            case LOG: {
                this.buttonLog.active = false;
                this.buttonInfo.active = true;
                this.buttonUser.active = true;
                this.buttonSetting.active = true;
                if (first) {
                    final LogObjectSelectionList selectionList = (LogObjectSelectionList)this.tabLog.get(0);
                    new Thread(() -> {
                        final ArrayList<LogObjectSelectionList.Entry> entries = new ArrayList<LogObjectSelectionList.Entry>();
                        Path logsPath = Path.of(OpenLink.EXECUTABLE_FILE_STORAGE_PATH + "logs" + File.separator, new String[0]);
                        try {
                            Files.walkFileTree(logsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                                @Override
                                @NotNull
                                public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                                    File logFile = file.toFile();
                                    if (logFile.isFile() && logFile.getName().endsWith(".log")) {
                                        FileInputStream fis = new FileInputStream(logFile);
                                        String logContent = new String(fis.readAllBytes(), StandardCharsets.UTF_8);
                                        String[] lines = logContent.split("\n");
                                        entries.add(selectionList.ofEntry(logFile.getPath(), lines[0], lines[1], lines[2], lines[3], lines[4]));
                                    }
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        entries.sort((o1, o2) -> {
                            if (o2.date.compareTo(o1.date) == 0) {
                                return o2.startTime.compareTo(o1.startTime);
                            }
                            return o2.date.compareTo(o1.date);
                        });
                        selectionList.replaceEntriesByList(entries);
                    }, "Log read thread").start();
                }
                this.renderableTabWidgets = this.tabLog;
                break;
            }
            case SETTING: {
                this.buttonLog.active = true;
                this.buttonInfo.active = true;
                this.buttonUser.active = true;
                this.buttonSetting.active = false;
                this.renderableTabWidgets = this.tabSetting;
                break;
            }
            case USER: {
                this.buttonLog.active = true;
                this.buttonInfo.active = true;
                this.buttonUser.active = false;
                this.buttonSetting.active = true;
                if (!FrpcManager.getInstance().getCurrentFrpcInstance().isLoggedIn()) {
                    this.renderableTabWidgets = this.tabLogin_User;
                    return;
                }
                if (this.avatarSha256 != null) {
                    ImageWidget widget = (ImageWidget)this.tabUser.get(0);
                    widget.texture = new WebTextureResourceLocation((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001.png?s=400"}, (String)Uris.weavatarUri.toString(), (String)this.avatarSha256))).location;
                    this.tabUser.set(0, (Renderable)widget);
                    this.avatarSha256 = null;
                }
                if (first && FrpcManager.getInstance().getCurrentFrpcId().equals("openfrp")) {
                    ImageWidget nowavatar = (ImageWidget)this.tabUser.get(0);
                    ComponentWidget nowuser = (ComponentWidget)this.tabUser.get(1);
                    ComponentWidget nowid = (ComponentWidget)this.tabUser.get(2);
                    ComponentWidget nowemail = (ComponentWidget)this.tabUser.get(3);
                    ComponentWidget nowgroup = (ComponentWidget)this.tabUser.get(4);
                    ComponentWidget nowproxy = (ComponentWidget)this.tabUser.get(5);
                    LineChartWidget nowtraffic = (LineChartWidget)this.tabUser.get(6);
                    nowuser.setMessage((Component)Utils.translatableText("text.openlink.loading", new Object[0]));
                    nowid.setMessage((Component)Utils.emptyText());
                    nowemail.setMessage((Component)Utils.emptyText());
                    nowgroup.setMessage((Component)Utils.emptyText());
                    nowproxy.setMessage((Component)Utils.emptyText());
                    this.tabUser.set(1, (Renderable)nowuser);
                    new Thread(() -> {
                        try {
                            this.userInfo = OpenFrpFrpcImpl.getUserInfo();
                            if (this.userInfo == null || !this.userInfo.flag) {
                                OpenFrpFrpcImpl.Authorization = null;
                                OpenFrpFrpcImpl.writeSession();
                                throw new Exception("[OpenLink] Session expired!");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.renderableTabWidgets = this.tabLogin_User;
                            return;
                        }
                        MessageDigest messageDigest = null;
                        try {
                            messageDigest = MessageDigest.getInstance("SHA-256");
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            // empty catch block
                        }
                        StringBuilder sha256 = new StringBuilder();
                        for (byte b : messageDigest.digest(((JsonUserInfo)this.userInfo.data).email.toLowerCase().getBytes(StandardCharsets.UTF_8))) {
                            sha256.append(String.format("%02x", b));
                        }
                        this.avatarSha256 = sha256.toString();
                        nowuser.setMessage((Component)Utils.literalText(((JsonUserInfo)this.userInfo.data).username));
                        nowid.setMessage((Component)Utils.literalText("#" + ((JsonUserInfo)this.userInfo.data).id));
                        nowid.setX(10 + nowuser.font.width((FormattedText)nowuser.getMessage()) + 1);
                        nowemail.setMessage((Component)Utils.literalText((sensitiveInfoHiding ? "\u00a7k" : "") + ((JsonUserInfo)this.userInfo.data).email));
                        nowgroup.setMessage((Component)Utils.literalText(((JsonUserInfo)this.userInfo.data).friendlyGroup));
                        nowproxy.setMessage((Component)Utils.translatableText("text.openlink.proxycount", ((JsonUserInfo)this.userInfo.data).used, ((JsonUserInfo)this.userInfo.data).proxies));
                        List<Pair<String, Long>> dataPoints = this.readTraffic();
                        dataPoints.add((Pair<String, Long>)new Pair((Object)Utils.translatableText("text.openlink.now", new Object[0]).getString(), (Object)((JsonUserInfo)this.userInfo.data).traffic));
                        nowtraffic.dataPoints = dataPoints;
                        this.tabUser.set(0, (Renderable)nowavatar);
                        this.tabUser.set(1, (Renderable)nowuser);
                        this.tabUser.set(2, (Renderable)nowid);
                        this.tabUser.set(3, (Renderable)nowemail);
                        this.tabUser.set(4, (Renderable)nowgroup);
                        this.tabUser.set(5, (Renderable)nowproxy);
                    }, "Request thread").start();
                }
                this.renderableTabWidgets = this.tabUser;
                break;
            }
            case INFO: {
                this.buttonLog.active = true;
                this.buttonInfo.active = false;
                this.buttonUser.active = true;
                this.buttonSetting.active = true;
                this.renderableTabWidgets = this.tabInfo;
            }
        }
    }

    public void tick() {
        if (OpenLink.disabled) {
            this.onClose();
        }
        try {
            this.onTab();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onClose();
        }
        this.lasttab = this.tab;
    }

    public List<Pair<String, Long>> readTraffic() {
        String origin = OpenLink.PREFERENCES.get("traffic_storage", "");
        String[] spilt = origin.split(";");
        ArrayList<Pair<String, Long>> res = new ArrayList<Pair<String, Long>>();
        for (String s : spilt) {
            if (s.isEmpty()) continue;
            String[] split = s.split(",");
            res.add((Pair<String, Long>)new Pair((Object)split[0], (Object)Long.parseLong(split[1])));
        }
        return res;
    }

    static {
        BACKGROUND_SETTING = Utils.createResourceLocation("openlink", "textures/gui/background_setting.png");
    }

    public static class InfoObjectSelectionList
    extends ObjectSelectionList<Entry> {
        public int x0;
        public int y0;
        public int x1;
        public int y1;

        public InfoObjectSelectionList(Minecraft minecraft, int width, int height, int x0, int y0, int x1, int y1, int itemHeight) {
            super(minecraft, width, height, y0, itemHeight);
            this.addEntry((AbstractSelectionList.Entry)new Entry(informationList));
            this.setPosition(x0, y0);
            this.setSize(width, height - y0);
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        }

        public void renderListBackground(GuiGraphics guiGraphics) {
        }

        public void changePos(int width, int height, int x0, int y0, int x1, int y1) {
            this.setPosition(x0, y0);
            this.setSize(width, height - y0);
            this.width = width;
            this.height = height;
            this.y0 = y0;
            this.y1 = y1;
            this.x0 = x0;
            this.x1 = x1;
        }

        public int getRowWidth() {
            return this.width - 20;
        }

        public static class Entry
        extends ObjectSelectionList.Entry<Entry> {
            public List<Information> informations;

            public Entry(List<Information> informations) {
                this.informations = informations;
            }

            @NotNull
            public Component getNarration() {
                MutableComponent res = Utils.emptyText();
                this.informations.forEach(info -> res.append(info.component));
                return res;
            }

            public void render(GuiGraphics guiGraphics, int i, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float f) {
                for (int i1 = 0; i1 < this.informations.size(); ++i1) {
                    Objects.requireNonNull(Minecraft.getInstance().font);
                    this.informations.get(i1).render(guiGraphics, x, y + i1 * (9 + 5), entryWidth);
                }
            }

            public boolean mouseClicked(double d, double e, int i) {
                for (Information information : this.informations) {
                    if (!information.mouseClicked(d, e, i)) continue;
                    return true;
                }
                return super.mouseClicked(d, e, i);
            }
        }

        public static class Information
        implements GuiEventListener {
            public boolean inChart;
            public Component component;

            public Information(Component component, boolean inChart) {
                this.inChart = inChart;
                this.component = component;
            }

            public void render(GuiGraphics guiGraphics, int x, int y, int width) {
                if (this.inChart) {
                    Objects.requireNonNull(Minecraft.getInstance().font);
                    guiGraphics.fill(x, y, x + width, y + 9 + 5, -1892996309);
                }
                guiGraphics.drawString(Minecraft.getInstance().font, this.component, x + (this.inChart ? 4 : 0), y + 2, -1);
            }

            public boolean mouseClicked(double d, double e, int i) {
                if (this.component.getString().contains("\u00a7n")) {
                    new WebBrowser(Uris.advertiseUri.toString()).openBrowser();
                    return true;
                }
                return false;
            }

            public void setFocused(boolean bl) {
            }

            public boolean isFocused() {
                return false;
            }
        }
    }

    public class LogObjectSelectionList
    extends ObjectSelectionList<Entry> {
        public int x0;
        public int y0;
        public int x1;
        public int y1;

        public LogObjectSelectionList(Minecraft minecraft, int width, int height, int x0, int y0, int x1, int y1, int itemHeight) {
            super(minecraft, width, height, y0, itemHeight);
            this.setPosition(x0, y0);
            this.setSize(width, height - y0);
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((Entry)this.getSelected()));
            }
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        }

        public void renderListBackground(GuiGraphics guiGraphics) {
        }

        public void changePos(int width, int height, int x0, int y0, int x1, int y1) {
            this.setPosition(x0, y0);
            this.setSize(width, height - y0);
            this.width = width;
            this.height = height;
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        }

        public int getRowWidth() {
            return this.width - 20;
        }

        public Entry ofEntry(String filePath, String levelName, String date, String startTime, String proxyid, String provider) {
            return new Entry(filePath, levelName, date, startTime, proxyid, provider);
        }

        public void replaceEntriesByList(List<Entry> entries) {
            this.clearEntries();
            entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        }

        public boolean isFocused() {
            return SettingScreen.this.getFocused() == this;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            public final String filePath;
            public final String levelName;
            public final String date;
            public final String startTime;
            public final String port;
            public final String provider;

            public Entry(String filePath, String levelName, String date, String startTime, String port, String provider) {
                this.filePath = filePath;
                this.levelName = levelName;
                this.date = date;
                this.startTime = startTime;
                this.port = port;
                this.provider = provider;
            }

            public boolean mouseClicked(double d, double e, int i) {
                if (i == 0) {
                    if (LogObjectSelectionList.this.getSelected() == this) {
                        Util.getPlatform().openFile(new File(this.filePath));
                        return true;
                    }
                    this.select();
                    return true;
                }
                return false;
            }

            @NotNull
            public Component getNarration() {
                return Utils.translatableText("narrator.select", this.provider + " " + this.startTime + " " + this.levelName);
            }

            private void select() {
                LogObjectSelectionList.this.setSelected((AbstractSelectionList.Entry)this);
            }

            public void render(GuiGraphics guiGraphics, int i, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float f) {
                guiGraphics.fill(x, y, x + entryWidth, y + entryHeight, -1892996309);
                guiGraphics.drawString(((LogObjectSelectionList)LogObjectSelectionList.this).minecraft.font, this.date + " " + this.startTime, x + 4, y + 4, -1879048193);
                guiGraphics.drawString(((LogObjectSelectionList)LogObjectSelectionList.this).minecraft.font, this.levelName, x + 4, y + 4 + (entryHeight - 4) / 2, -1879048193);
                guiGraphics.drawString(((LogObjectSelectionList)LogObjectSelectionList.this).minecraft.font, this.port, x + entryWidth - 4 - ((LogObjectSelectionList)LogObjectSelectionList.this).minecraft.font.width(this.port), y + 4, -1879048193);
                guiGraphics.drawString(((LogObjectSelectionList)LogObjectSelectionList.this).minecraft.font, this.provider, x + entryWidth - 4 - ((LogObjectSelectionList)LogObjectSelectionList.this).minecraft.font.width(this.provider), y + 4 + (entryHeight - 4) / 2, -1879048193);
                if (isHovered) {
                    guiGraphics.renderTooltip(((LogObjectSelectionList)LogObjectSelectionList.this).minecraft.font, (Component)Utils.translatableText("text.openlink.doubleclick", new File(this.filePath).getName()), mouseX, mouseY);
                }
            }
        }
    }
}

