/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin;

import com.auditor.plugin.alerts.AlertManager;
import com.auditor.plugin.analysis.AnomalyDetector;
import com.auditor.plugin.commands.AuditorCommand;
import com.auditor.plugin.database.SQLiteManager;
import com.auditor.plugin.economy.EconomyHealthMonitor;
import com.auditor.plugin.economy.TransactionListener;
import com.auditor.plugin.economy.VaultHook;
import com.auditor.plugin.gui.GUIManager;
import com.auditor.plugin.integrations.AuditorPlaceholders;
import com.auditor.plugin.utils.ConfigManager;
import com.auditor.plugin.utils.MessageManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AuditorPlugin
extends JavaPlugin {
    private static AuditorPlugin instance;
    private SQLiteManager database;
    private VaultHook vaultHook;
    private GUIManager guiManager;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private AnomalyDetector anomalyDetector;
    private AlertManager alertManager;
    private EconomyHealthMonitor economyHealthMonitor;

    public void onEnable() {
        instance = this;
        this.getLogger().info("Starting Auditor plugin initialization...");
        if (!this.setupVault()) {
            this.getLogger().severe("Vault not found! Plugin disabled.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Vault integration successful!");
        try {
            this.configManager = new ConfigManager(this);
            this.getLogger().info("Configuration manager initialized!");
            this.messageManager = new MessageManager(this);
            this.getLogger().info("Message manager initialized!");
            this.database = new SQLiteManager(this);
            this.getLogger().info("Database manager created!");
            if (!this.database.initialize()) {
                this.getLogger().severe("Failed to initialize database! Plugin disabled.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            this.getLogger().info("Database initialized successfully!");
            this.guiManager = new GUIManager(this);
            this.getLogger().info("GUI manager initialized!");
            this.anomalyDetector = new AnomalyDetector(this);
            this.getLogger().info("Anomaly detector initialized!");
            this.alertManager = new AlertManager(this);
            this.getLogger().info("Alert manager initialized!");
            this.economyHealthMonitor = new EconomyHealthMonitor(this);
            this.getLogger().info("Economy health monitor initialized!");
            this.registerEvents();
            this.getLogger().info("Event listeners registered!");
            this.registerCommands();
            this.getLogger().info("Commands registered!");
            this.setupPlaceholderAPI();
        }
        catch (Exception e) {
            this.getLogger().severe("Error during plugin initialization: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Auditor v" + this.getDescription().getVersion() + " has been enabled successfully!");
    }

    public void onDisable() {
        if (this.database != null) {
            this.database.close();
        }
        this.getLogger().info("Auditor has been disabled!");
    }

    private boolean setupVault() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        this.vaultHook = new VaultHook(this);
        return this.vaultHook.setupEconomy();
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new TransactionListener(this), (Plugin)this);
    }

    private void registerCommands() {
        try {
            AuditorCommand auditorCommand = new AuditorCommand(this);
            if (this.getCommand("auditor") != null) {
                this.getCommand("auditor").setExecutor((CommandExecutor)auditorCommand);
                this.getCommand("auditor").setTabCompleter((TabCompleter)auditorCommand);
                this.getLogger().info("Successfully registered /auditor command with executor and tab completer!");
            } else {
                this.getLogger().severe("Failed to register /auditor command - command not found in plugin.yml!");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Error registering commands: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setupPlaceholderAPI() {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                new AuditorPlaceholders(this).register();
                this.getLogger().info("PlaceholderAPI integration enabled!");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to register PlaceholderAPI integration: " + e.getMessage());
            }
        } else {
            this.getLogger().info("PlaceholderAPI not found, skipping integration.");
        }
    }

    public static AuditorPlugin getInstance() {
        return instance;
    }

    public SQLiteManager getDatabase() {
        return this.database;
    }

    public VaultHook getVaultHook() {
        return this.vaultHook;
    }

    public GUIManager getGUIManager() {
        return this.guiManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public AnomalyDetector getAnomalyDetector() {
        return this.anomalyDetector;
    }

    public AlertManager getAlertManager() {
        return this.alertManager;
    }

    public EconomyHealthMonitor getEconomyHealthMonitor() {
        return this.economyHealthMonitor;
    }
}

