/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.alerts;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.alerts.DiscordWebhook;
import com.auditor.plugin.models.Alert;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AlertManager {
    private final AuditorPlugin plugin;

    public AlertManager(AuditorPlugin plugin) {
        this.plugin = plugin;
    }

    public void processAlert(Alert alert) {
        this.notifyOnlineStaff(alert);
        if (!this.plugin.getConfigManager().getDiscordWebhook().isEmpty()) {
            this.sendDiscordNotification(alert);
        }
    }

    private void notifyOnlineStaff(Alert alert) {
        String alertMessage = this.formatAlertMessage(alert);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("auditor.alerts.receive")) continue;
            player.sendMessage(alertMessage);
        }
        this.plugin.getLogger().warning(alertMessage);
    }

    private String formatAlertMessage(Alert alert) {
        String severityColor = this.getSeverityColor(alert.getSeverity());
        return this.plugin.getMessageManager().getPrefix() + severityColor + "[" + alert.getSeverity() + "] " + alert.getTitle() + " - " + alert.getDescription();
    }

    private String getSeverityColor(String severity) {
        switch (severity.toUpperCase()) {
            case "LOW": {
                return "\u00a7a";
            }
            case "MEDIUM": {
                return "\u00a7e";
            }
            case "HIGH": {
                return "\u00a76";
            }
            case "CRITICAL": {
                return "\u00a7c";
            }
        }
        return "\u00a77";
    }

    private void sendDiscordNotification(Alert alert) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                DiscordWebhook webhook = new DiscordWebhook(this.plugin.getConfigManager().getDiscordWebhook());
                webhook.setUsername("Auditor");
                webhook.setAvatarUrl("https://i.imgur.com/4M34hi2.png");
                DiscordWebhook.EmbedObject embed = new DiscordWebhook.EmbedObject();
                embed.setTitle(alert.getTitle());
                embed.setDescription(alert.getDescription());
                embed.setColor(this.getSeverityColorInt(alert.getSeverity()));
                embed.addField("Severity", alert.getSeverity(), true);
                embed.addField("Type", alert.getAlertType(), true);
                embed.addField("Timestamp", String.valueOf(alert.getCreatedAt()), true);
                webhook.addEmbed(embed);
                webhook.execute();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send Discord notification: " + e.getMessage());
            }
        });
    }

    private int getSeverityColorInt(String severity) {
        switch (severity.toUpperCase()) {
            case "LOW": {
                return 65280;
            }
            case "MEDIUM": {
                return 0xFFFF00;
            }
            case "HIGH": {
                return 0xFF6600;
            }
            case "CRITICAL": {
                return 0xFF0000;
            }
        }
        return 0x808080;
    }

    public void resolveAlert(long alertId, String resolvedBy) {
    }

    public List<Alert> getActiveAlerts() {
        return this.plugin.getDatabase().getActiveAlerts();
    }
}

