/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.alerts;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DiscordWebhook {
    private final String url;
    private String content;
    private String username;
    private String avatarUrl;
    private boolean tts;
    private List<EmbedObject> embeds = new ArrayList<EmbedObject>();

    public DiscordWebhook(String url) {
        this.url = url;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public void setTts(boolean tts) {
        this.tts = tts;
    }

    public void addEmbed(EmbedObject embed) {
        this.embeds.add(embed);
    }

    public void execute() throws IOException {
        if (this.content == null && this.embeds.isEmpty()) {
            throw new IllegalArgumentException("Set content or add at least one EmbedObject");
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "Java-DiscordWebhook-BY-Gelox_");
        connection.setDoOutput(true);
        OutputStream stream = connection.getOutputStream();
        stream.write(this.toJSONString().getBytes());
        stream.flush();
        stream.close();
        connection.getInputStream().close();
        connection.disconnect();
    }

    private String toJSONString() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (this.content != null) {
            json.put("content", this.content);
        }
        if (this.username != null) {
            json.put("username", this.username);
        }
        if (this.avatarUrl != null) {
            json.put("avatar_url", this.avatarUrl);
        }
        json.put("tts", this.tts);
        if (!this.embeds.isEmpty()) {
            ArrayList embedObjects = new ArrayList();
            for (EmbedObject embed : this.embeds) {
                HashMap<String, Object> embedJson = new HashMap<String, Object>();
                embedJson.put("title", embed.getTitle());
                embedJson.put("description", embed.getDescription());
                embedJson.put("url", embed.getUrl());
                if (embed.getColor() != null) {
                    Color color = embed.getColor();
                    int rgb = color.getRed();
                    rgb = (rgb << 8) + color.getGreen();
                    rgb = (rgb << 8) + color.getBlue();
                    embedJson.put("color", rgb);
                }
                EmbedObject.Footer embedFooter = embed.getFooter();
                EmbedObject.Image embedImage = embed.getImage();
                EmbedObject.Thumbnail embedThumbnail = embed.getThumbnail();
                EmbedObject.Author embedAuthor = embed.getAuthor();
                List<EmbedObject.Field> embedFields = embed.getFields();
                if (embedFooter != null) {
                    HashMap<String, String> embedFooterJson = new HashMap<String, String>();
                    embedFooterJson.put("text", embedFooter.getText());
                    embedFooterJson.put("icon_url", embedFooter.getIconUrl());
                    embedJson.put("footer", embedFooterJson);
                }
                if (embedImage != null) {
                    HashMap<String, String> embedImageJson = new HashMap<String, String>();
                    embedImageJson.put("url", embedImage.getUrl());
                    embedJson.put("image", embedImageJson);
                }
                if (embedThumbnail != null) {
                    HashMap<String, String> embedThumbnailJson = new HashMap<String, String>();
                    embedThumbnailJson.put("url", embedThumbnail.getUrl());
                    embedJson.put("thumbnail", embedThumbnailJson);
                }
                if (embedAuthor != null) {
                    HashMap<String, String> embedAuthorJson = new HashMap<String, String>();
                    embedAuthorJson.put("name", embedAuthor.getName());
                    embedAuthorJson.put("url", embedAuthor.getUrl());
                    embedAuthorJson.put("icon_url", embedAuthor.getIconUrl());
                    embedJson.put("author", embedAuthorJson);
                }
                ArrayList embedFieldObjects = new ArrayList();
                for (EmbedObject.Field embedField : embedFields) {
                    HashMap<String, Object> embedFieldJson = new HashMap<String, Object>();
                    embedFieldJson.put("name", embedField.getName());
                    embedFieldJson.put("value", embedField.getValue());
                    embedFieldJson.put("inline", embedField.isInline());
                    embedFieldObjects.add(embedFieldJson);
                }
                embedJson.put("fields", embedFieldObjects.toArray());
                embedObjects.add(embedJson);
            }
            json.put("embeds", embedObjects.toArray());
        }
        return this.toJSONString(json);
    }

    private String toJSONString(Object object) {
        try {
            if (object instanceof Map) {
                Map map = (Map)object;
                StringBuilder json = new StringBuilder("{");
                Set keys = map.keySet();
                int index = 0;
                for (Object key : keys) {
                    json.append(this.toJSONString(key)).append(":").append(this.toJSONString(map.get(key)));
                    if (++index >= keys.size()) continue;
                    json.append(",");
                }
                json.append("}");
                return json.toString();
            }
            if (object.getClass().isArray()) {
                StringBuilder json = new StringBuilder("[");
                int length = Array.getLength(object);
                for (int index = 0; index < length; ++index) {
                    json.append(this.toJSONString(Array.get(object, index)));
                    if (index >= length - 1) continue;
                    json.append(",");
                }
                json.append("]");
                return json.toString();
            }
            if (object instanceof String) {
                return "\"" + object.toString().replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
            }
            return object.toString();
        }
        catch (Exception e) {
            return "null";
        }
    }

    public static class EmbedObject {
        private String title;
        private String description;
        private String url;
        private Color color;
        private Footer footer;
        private Thumbnail thumbnail;
        private Image image;
        private Author author;
        private List<Field> fields = new ArrayList<Field>();

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUrl() {
            return this.url;
        }

        public Color getColor() {
            return this.color;
        }

        public Footer getFooter() {
            return this.footer;
        }

        public Thumbnail getThumbnail() {
            return this.thumbnail;
        }

        public Image getImage() {
            return this.image;
        }

        public Author getAuthor() {
            return this.author;
        }

        public List<Field> getFields() {
            return this.fields;
        }

        public EmbedObject setTitle(String title) {
            this.title = title;
            return this;
        }

        public EmbedObject setDescription(String description) {
            this.description = description;
            return this;
        }

        public EmbedObject setUrl(String url) {
            this.url = url;
            return this;
        }

        public EmbedObject setColor(Color color) {
            this.color = color;
            return this;
        }

        public EmbedObject setColor(int color) {
            this.color = new Color(color);
            return this;
        }

        public EmbedObject setFooter(String text, String icon) {
            this.footer = new Footer(text, icon);
            return this;
        }

        public EmbedObject setThumbnail(String url) {
            this.thumbnail = new Thumbnail(url);
            return this;
        }

        public EmbedObject setImage(String url) {
            this.image = new Image(url);
            return this;
        }

        public EmbedObject setAuthor(String name, String url, String icon) {
            this.author = new Author(name, url, icon);
            return this;
        }

        public EmbedObject addField(String name, String value, boolean inline) {
            this.fields.add(new Field(name, value, inline));
            return this;
        }

        public static class Footer {
            private String text;
            private String iconUrl;

            private Footer(String text, String iconUrl) {
                this.text = text;
                this.iconUrl = iconUrl;
            }

            private String getText() {
                return this.text;
            }

            private String getIconUrl() {
                return this.iconUrl;
            }
        }

        public static class Thumbnail {
            private String url;

            private Thumbnail(String url) {
                this.url = url;
            }

            private String getUrl() {
                return this.url;
            }
        }

        public static class Image {
            private String url;

            private Image(String url) {
                this.url = url;
            }

            private String getUrl() {
                return this.url;
            }
        }

        public static class Author {
            private String name;
            private String url;
            private String iconUrl;

            private Author(String name, String url, String iconUrl) {
                this.name = name;
                this.url = url;
                this.iconUrl = iconUrl;
            }

            private String getName() {
                return this.name;
            }

            private String getUrl() {
                return this.url;
            }

            private String getIconUrl() {
                return this.iconUrl;
            }
        }

        public static class Field {
            private String name;
            private String value;
            private boolean inline;

            private Field(String name, String value, boolean inline) {
                this.name = name;
                this.value = value;
                this.inline = inline;
            }

            private String getName() {
                return this.name;
            }

            private String getValue() {
                return this.value;
            }

            private boolean isInline() {
                return this.inline;
            }
        }
    }
}

