/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.analysis;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.analysis.RiskAssessment;
import com.auditor.plugin.models.Alert;
import com.auditor.plugin.models.PlayerProfile;
import com.auditor.plugin.models.TransactionData;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;

public class AnomalyDetector {
    private final AuditorPlugin plugin;
    private final RiskAssessment riskAssessment;

    public AnomalyDetector(AuditorPlugin plugin) {
        this.plugin = plugin;
        this.riskAssessment = new RiskAssessment(plugin);
    }

    public void analyzeTransaction(TransactionData transaction) {
        if (!this.plugin.getConfigManager().isAlertsEnabled()) {
            return;
        }
        FileConfiguration alertsConfig = this.plugin.getConfigManager().getAlertsConfig();
        this.checkLargeTransaction(transaction, alertsConfig);
        this.checkSpendingSpike(transaction, alertsConfig);
        this.checkPossibleDuplication(transaction, alertsConfig);
        this.riskAssessment.updatePlayerRisk(transaction.getPlayerUUID());
    }

    private void checkLargeTransaction(TransactionData transaction, FileConfiguration config) {
        if (!config.getBoolean("thresholds.large_transaction.enabled", true)) {
            return;
        }
        double threshold = config.getDouble("thresholds.large_transaction.amount", 50000.0);
        String severity = config.getString("thresholds.large_transaction.severity", "HIGH");
        if (Math.abs(transaction.getAmount()) >= threshold) {
            Alert alert = new Alert("LARGE_TRANSACTION", severity, transaction.getPlayerUUID(), 0L, "Large Transaction Detected", String.format("Player %s made a large transaction of $%.2f", transaction.getPlayerName(), transaction.getAmount()));
            this.plugin.getDatabase().insertAlert(alert);
            this.plugin.getAlertManager().processAlert(alert);
        }
    }

    private void checkSpendingSpike(TransactionData transaction, FileConfiguration config) {
        if (!config.getBoolean("thresholds.spending_spike.enabled", true)) {
            return;
        }
        if (transaction.getAmount() >= 0.0) {
            return;
        }
        double multiplier = config.getDouble("thresholds.spending_spike.multiplier", 5.0);
        double minimumAmount = config.getDouble("thresholds.spending_spike.minimum_amount", 1000.0);
        String severity = config.getString("thresholds.spending_spike.severity", "MEDIUM");
        PlayerProfile profile = this.plugin.getDatabase().getPlayerProfile(transaction.getPlayerUUID());
        if (profile == null || profile.getAverageTransaction() == 0.0) {
            return;
        }
        double spentAmount = Math.abs(transaction.getAmount());
        double averageSpending = profile.getAverageTransaction();
        if (spentAmount >= minimumAmount && spentAmount >= averageSpending * multiplier) {
            Alert alert = new Alert("SPENDING_SPIKE", severity, transaction.getPlayerUUID(), 0L, "Spending Spike Detected", String.format("Player %s spent $%.2f, which is %.1fx their average of $%.2f", transaction.getPlayerName(), spentAmount, spentAmount / averageSpending, averageSpending));
            this.plugin.getDatabase().insertAlert(alert);
            this.plugin.getAlertManager().processAlert(alert);
        }
    }

    private void checkPossibleDuplication(TransactionData transaction, FileConfiguration config) {
        if (!config.getBoolean("thresholds.possible_duplication.enabled", true)) {
            return;
        }
        if (transaction.getAmount() <= 0.0) {
            return;
        }
        double threshold = config.getDouble("thresholds.possible_duplication.amount", 100000.0);
        long timeframeMinutes = config.getLong("thresholds.possible_duplication.timeframe_minutes", 1L);
        String severity = config.getString("thresholds.possible_duplication.severity", "CRITICAL");
        if (transaction.getAmount() >= threshold) {
            long timeframeMs = timeframeMinutes * 60L * 1000L;
            long cutoffTime = transaction.getTimestamp() - timeframeMs;
            if (this.hasRecentLargeGain(transaction.getPlayerUUID(), threshold, cutoffTime)) {
                Alert alert = new Alert("POSSIBLE_DUPLICATION", severity, transaction.getPlayerUUID(), 0L, "Possible Money Duplication", String.format("Player %s gained $%.2f within %d minute(s) - possible duplication!", transaction.getPlayerName(), transaction.getAmount(), timeframeMinutes));
                this.plugin.getDatabase().insertAlert(alert);
                this.plugin.getAlertManager().processAlert(alert);
            }
        }
    }

    private boolean hasRecentLargeGain(UUID playerUUID, double amount, long cutoffTime) {
        return false;
    }
}

