/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.analysis;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.models.PlayerProfile;
import com.auditor.plugin.models.TransactionData;
import java.util.List;
import java.util.UUID;

public class RiskAssessment {
    private final AuditorPlugin plugin;

    public RiskAssessment(AuditorPlugin plugin) {
        this.plugin = plugin;
    }

    public void updatePlayerRisk(UUID playerUUID) {
        PlayerProfile profile = this.plugin.getDatabase().getPlayerProfile(playerUUID);
        if (profile == null) {
            return;
        }
        List<TransactionData> recentTransactions = this.plugin.getDatabase().getPlayerTransactions(playerUUID, 100);
        int riskScore = this.calculateRiskScore(profile, recentTransactions);
        String riskLevel = this.determineRiskLevel(riskScore);
        this.updatePlayerRiskInDatabase(playerUUID, riskScore, riskLevel);
    }

    private int calculateRiskScore(PlayerProfile profile, List<TransactionData> transactions) {
        int score = 0;
        score += this.calculateTransactionFrequencyRisk(transactions);
        score += this.calculateAmountVarianceRisk(transactions);
        score += this.calculateBehaviorPatternRisk(profile, transactions);
        score += this.calculateTimePatternRisk(transactions);
        return Math.max(0, Math.min(100, score += this.calculateBalanceFluctuationRisk(profile)));
    }

    private int calculateTransactionFrequencyRisk(List<TransactionData> transactions) {
        if (transactions.isEmpty()) {
            return 0;
        }
        long currentTime = System.currentTimeMillis();
        long last24Hours = currentTime - 86400000L;
        long last1Hour = currentTime - 3600000L;
        long recentCount24h = transactions.stream().mapToLong(TransactionData::getTimestamp).filter(time -> time > last24Hours).count();
        long recentCount1h = transactions.stream().mapToLong(TransactionData::getTimestamp).filter(time -> time > last1Hour).count();
        int risk = 0;
        if (recentCount1h > 20L) {
            risk += 15;
        } else if (recentCount1h > 10L) {
            risk += 8;
        }
        if (recentCount24h > 100L) {
            risk += 10;
        } else if (recentCount24h > 50L) {
            risk += 5;
        }
        return risk;
    }

    private int calculateAmountVarianceRisk(List<TransactionData> transactions) {
        if (transactions.size() < 5) {
            return 0;
        }
        double totalAmount = 0.0;
        double maxTransaction = 0.0;
        int largeTransactionCount = 0;
        for (TransactionData transaction : transactions) {
            double amount = Math.abs(transaction.getAmount());
            totalAmount += amount;
            maxTransaction = Math.max(maxTransaction, amount);
            if (!(amount > 50000.0)) continue;
            ++largeTransactionCount;
        }
        double averageAmount = totalAmount / (double)transactions.size();
        int risk = 0;
        if (maxTransaction > averageAmount * 10.0 && maxTransaction > 10000.0) {
            risk += 20;
        }
        if ((double)largeTransactionCount > (double)transactions.size() * 0.1) {
            risk += 15;
        }
        return risk;
    }

    private int calculateBehaviorPatternRisk(PlayerProfile profile, List<TransactionData> transactions) {
        double spentToEarnedRatio;
        int risk = 0;
        double d = spentToEarnedRatio = profile.getTotalEarned() > 0.0 ? profile.getTotalSpent() / profile.getTotalEarned() : 0.0;
        if (spentToEarnedRatio > 5.0) {
            risk += 15;
        } else if (spentToEarnedRatio > 2.0) {
            risk += 8;
        }
        if (profile.getLargestTransaction() > profile.getAverageTransaction() * 20.0) {
            risk += 10;
        }
        return risk;
    }

    private int calculateTimePatternRisk(List<TransactionData> transactions) {
        if (transactions.size() < 10) {
            return 0;
        }
        int risk = 0;
        int nightTransactions = 0;
        int rapidSequenceCount = 0;
        for (int i = 0; i < transactions.size(); ++i) {
            TransactionData current = transactions.get(i);
            long hour = current.getTimestamp() / 3600000L % 24L;
            if (hour >= 23L || hour <= 6L) {
                ++nightTransactions;
            }
            if (i <= 0) continue;
            TransactionData previous = transactions.get(i - 1);
            long timeDiff = Math.abs(current.getTimestamp() - previous.getTimestamp());
            if (timeDiff >= 5000L) continue;
            ++rapidSequenceCount;
        }
        if ((double)nightTransactions > (double)transactions.size() * 0.6) {
            risk += 8;
        }
        if ((double)rapidSequenceCount > (double)transactions.size() * 0.3) {
            risk += 12;
        }
        return risk;
    }

    private int calculateBalanceFluctuationRisk(PlayerProfile profile) {
        int risk = 0;
        if (profile.getAverageTransaction() > 100000.0) {
            risk += 5;
        }
        if (profile.getTotalTransactions() > 1000) {
            risk += 3;
        }
        return risk;
    }

    private String determineRiskLevel(int score) {
        if (score >= 75) {
            return "CRITICAL";
        }
        if (score >= 50) {
            return "HIGH";
        }
        if (score >= 25) {
            return "MEDIUM";
        }
        return "LOW";
    }

    private void updatePlayerRiskInDatabase(UUID playerUUID, int riskScore, String riskLevel) {
    }
}

