/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.commands;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.exports.DataExporter;
import com.auditor.plugin.models.PlayerProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class AuditorCommand
implements CommandExecutor,
TabCompleter {
    private final AuditorPlugin plugin;

    public AuditorCommand(AuditorPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        this.plugin.getLogger().info("Auditor command received: " + Arrays.toString(args) + " from " + sender.getName());
        if (args.length == 0) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.hasPermission("auditor.dashboard") || player.isOp()) {
                    this.plugin.getGUIManager().openDashboard(player);
                } else {
                    this.showHelpMessage(sender);
                }
            } else {
                this.showHelpMessage(sender);
            }
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "dashboard": 
            case "dash": {
                return this.handleDashboard(sender);
            }
            case "player": {
                return this.handlePlayer(sender, args);
            }
            case "alerts": {
                return this.handleAlerts(sender);
            }
            case "health": {
                return this.handleHealth(sender);
            }
            case "reload": {
                return this.handleReload(sender);
            }
            case "test": 
            case "status": {
                return this.handleTest(sender);
            }
            case "export": {
                return this.handleExport(sender, args);
            }
            case "monitor": {
                return this.handleMonitor(sender, args);
            }
            case "flag": {
                return this.handleFlag(sender, args);
            }
            case "note": {
                return this.handleNote(sender, args);
            }
            case "populatetest": {
                return this.handlePopulateTestData(sender);
            }
        }
        this.showHelpMessage(sender);
        return true;
    }

    private boolean handleDashboard(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("auditor.dashboard")) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.no_permission");
            return true;
        }
        this.plugin.getGUIManager().openDashboard(player);
        return true;
    }

    private boolean handlePlayer(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("auditor.player.view")) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.no_permission");
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMessageManager().sendRawMessage(sender, "&cUsage: /auditor player <name>");
            return true;
        }
        String targetName = args[1];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.player_not_found", "{player}", targetName);
            return true;
        }
        if (!targetName.equals(player.getName()) && !player.hasPermission("auditor.player.others")) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.no_permission");
            return true;
        }
        this.plugin.getGUIManager().openPlayerAnalysis(player, targetName);
        return true;
    }

    private boolean handleAlerts(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("auditor.alerts.view")) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.no_permission");
            return true;
        }
        this.plugin.getGUIManager().openAlerts(player);
        return true;
    }

    private boolean handleHealth(CommandSender sender) {
        if (!sender.hasPermission("auditor.dashboard")) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.no_permission");
            return true;
        }
        this.plugin.getMessageManager().sendRawMessage(sender, "&aEconomy Health Check:");
        this.plugin.getMessageManager().sendRawMessage(sender, "&7- Status: &aHealthy");
        this.plugin.getMessageManager().sendRawMessage(sender, "&7- Active Players: &f" + Bukkit.getOnlinePlayers().size());
        this.plugin.getMessageManager().sendRawMessage(sender, "&7- Recent Alerts: &f" + this.plugin.getDatabase().getActiveAlerts().size());
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("auditor.reload")) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.no_permission");
            return true;
        }
        this.plugin.getConfigManager().reloadConfigs();
        this.plugin.getMessageManager().sendMessage(sender, "commands.reload_success");
        return true;
    }

    private boolean handleTest(CommandSender sender) {
        sender.sendMessage("\u00a76[Auditor] \u00a7aPlugin is working! Version: " + this.plugin.getDescription().getVersion());
        sender.sendMessage("\u00a76[Auditor] \u00a77Database: " + (this.plugin.getDatabase() != null ? "\u00a7aConnected" : "\u00a7cDisconnected"));
        sender.sendMessage("\u00a76[Auditor] \u00a77Vault: " + (this.plugin.getVaultHook() != null ? "\u00a7aConnected" : "\u00a7cDisconnected"));
        sender.sendMessage("\u00a76[Auditor] \u00a77Commands: \u00a7aWorking!");
        return true;
    }

    private boolean handleExport(final CommandSender sender, String[] args) {
        String exportType;
        if (!sender.hasPermission("auditor.export")) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.no_permission");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cUsage: /auditor export <transactions|profiles|alerts> [player]");
            return true;
        }
        DataExporter exporter = new DataExporter(this.plugin);
        switch (exportType = args[1].toLowerCase()) {
            case "transactions": {
                if (args.length > 2) {
                    String playerName = args[2];
                    OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
                    if (target.getUniqueId() != null) {
                        sender.sendMessage("\u00a76[Auditor] \u00a7aExporting transactions for " + playerName + "...");
                        exporter.exportTransactionsCSV(target.getUniqueId(), playerName, new DataExporter.ExportCallback(){
                            final /* synthetic */ AuditorCommand this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void onSuccess(String fileName, int recordCount) {
                                sender.sendMessage("\u00a76[Auditor] \u00a7aExported " + recordCount + " transactions to " + fileName);
                            }

                            @Override
                            public void onError(String error) {
                                sender.sendMessage("\u00a76[Auditor] \u00a7cExport failed: " + error);
                            }
                        });
                        break;
                    }
                    sender.sendMessage("\u00a76[Auditor] \u00a7cPlayer not found: " + playerName);
                    break;
                }
                sender.sendMessage("\u00a76[Auditor] \u00a7aExporting all transactions...");
                exporter.exportAllTransactionsCSV(new DataExporter.ExportCallback(){
                    final /* synthetic */ AuditorCommand this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void onSuccess(String fileName, int recordCount) {
                        sender.sendMessage("\u00a76[Auditor] \u00a7aExported " + recordCount + " transactions to " + fileName);
                    }

                    @Override
                    public void onError(String error) {
                        sender.sendMessage("\u00a76[Auditor] \u00a7cExport failed: " + error);
                    }
                });
                break;
            }
            case "profiles": {
                sender.sendMessage("\u00a76[Auditor] \u00a7aExporting player profiles...");
                exporter.exportPlayerProfilesCSV(new DataExporter.ExportCallback(){
                    final /* synthetic */ AuditorCommand this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void onSuccess(String fileName, int recordCount) {
                        sender.sendMessage("\u00a76[Auditor] \u00a7aExported " + recordCount + " player profiles to " + fileName);
                    }

                    @Override
                    public void onError(String error) {
                        sender.sendMessage("\u00a76[Auditor] \u00a7cExport failed: " + error);
                    }
                });
                break;
            }
            case "alerts": {
                sender.sendMessage("\u00a76[Auditor] \u00a7aExporting alerts...");
                exporter.exportAlertsCSV(new DataExporter.ExportCallback(){
                    final /* synthetic */ AuditorCommand this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void onSuccess(String fileName, int recordCount) {
                        sender.sendMessage("\u00a76[Auditor] \u00a7aExported " + recordCount + " alerts to " + fileName);
                    }

                    @Override
                    public void onError(String error) {
                        sender.sendMessage("\u00a76[Auditor] \u00a7cExport failed: " + error);
                    }
                });
                break;
            }
            default: {
                sender.sendMessage("\u00a76[Auditor] \u00a7cInvalid export type. Use: transactions, profiles, or alerts");
            }
        }
        return true;
    }

    private boolean handleMonitor(CommandSender sender, String[] args) {
        String action;
        if (!sender.hasPermission("auditor.monitor")) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.no_permission");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cUsage: /auditor monitor <player> [on|off]");
            return true;
        }
        String targetName = args[1];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cPlayer not found: " + targetName);
            return true;
        }
        PlayerProfile profile = this.plugin.getDatabase().getPlayerProfile(target.getUniqueId());
        if (profile == null) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cNo profile data found for " + targetName);
            return true;
        }
        boolean newStatus = args.length >= 3 ? ((action = args[2].toLowerCase()).equals("on") || action.equals("enable") || action.equals("true") ? true : (action.equals("off") || action.equals("disable") || action.equals("false") ? false : !profile.isMonitored())) : !profile.isMonitored();
        this.plugin.getDatabase().updatePlayerMonitoring(target.getUniqueId(), newStatus);
        sender.sendMessage("\u00a76[Auditor] \u00a7" + (newStatus ? "a" : "c") + (newStatus ? "Enabled" : "Disabled") + " monitoring for " + targetName);
        sender.sendMessage("\u00a77Enhanced monitoring " + (newStatus ? "will track" : "stopped tracking") + " all transactions for this player.");
        return true;
    }

    private boolean handleFlag(CommandSender sender, String[] args) {
        if (!sender.hasPermission("auditor.flag")) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.no_permission");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cUsage: /auditor flag <player> <add|remove|list> [flag]");
            sender.sendMessage("\u00a77Available flags: SUSPICIOUS, HIGH_VOLUME, WATCH_LIST, BOT_SUSPECTED, VIP, TRUSTED");
            return true;
        }
        String targetName = args[1];
        String action = args[2].toLowerCase();
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cPlayer not found: " + targetName);
            return true;
        }
        PlayerProfile profile = this.plugin.getDatabase().getPlayerProfile(target.getUniqueId());
        if (profile == null) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cNo profile data found for " + targetName);
            return true;
        }
        List<String> currentFlags = this.getCurrentFlags(profile);
        boolean flagsChanged = false;
        switch (action) {
            case "add": {
                if (args.length < 4) {
                    sender.sendMessage("\u00a76[Auditor] \u00a7cUsage: /auditor flag " + targetName + " add <flag>");
                    return true;
                }
                String flagToAdd = args[3].toUpperCase();
                if (!currentFlags.contains(flagToAdd)) {
                    currentFlags.add(flagToAdd);
                    flagsChanged = true;
                    sender.sendMessage("\u00a76[Auditor] \u00a7aAdded flag '" + flagToAdd + "' to " + targetName);
                    break;
                }
                sender.sendMessage("\u00a76[Auditor] \u00a7cPlayer " + targetName + " already has flag: " + flagToAdd);
                break;
            }
            case "remove": {
                if (args.length < 4) {
                    sender.sendMessage("\u00a76[Auditor] \u00a7cUsage: /auditor flag " + targetName + " remove <flag>");
                    return true;
                }
                String flagToRemove = args[3].toUpperCase();
                if (currentFlags.remove(flagToRemove)) {
                    flagsChanged = true;
                    sender.sendMessage("\u00a76[Auditor] \u00a7aRemoved flag '" + flagToRemove + "' from " + targetName);
                    break;
                }
                sender.sendMessage("\u00a76[Auditor] \u00a7cPlayer " + targetName + " doesn't have flag: " + flagToRemove);
                break;
            }
            case "list": {
                sender.sendMessage("\u00a76[Auditor] \u00a7eFlags for " + targetName + ":");
                if (currentFlags.isEmpty()) {
                    sender.sendMessage("\u00a77No flags set");
                    break;
                }
                for (String flag : currentFlags) {
                    sender.sendMessage("\u00a77\u2022 \u00a7c" + flag);
                }
                break;
            }
            case "clear": {
                if (!currentFlags.isEmpty()) {
                    currentFlags.clear();
                    flagsChanged = true;
                    sender.sendMessage("\u00a76[Auditor] \u00a7aCleared all flags for " + targetName);
                    break;
                }
                sender.sendMessage("\u00a76[Auditor] \u00a77No flags to clear for " + targetName);
                break;
            }
            default: {
                sender.sendMessage("\u00a76[Auditor] \u00a7cInvalid action. Use: add, remove, list, or clear");
            }
        }
        if (flagsChanged) {
            String flagsString = String.join((CharSequence)",", currentFlags);
            this.plugin.getDatabase().updatePlayerFlags(target.getUniqueId(), flagsString);
            sender.sendMessage("\u00a76[Auditor] \u00a77Risk assessment updated based on new flags.");
        }
        return true;
    }

    private boolean handleNote(CommandSender sender, String[] args) {
        if (!sender.hasPermission("auditor.note")) {
            this.plugin.getMessageManager().sendMessage(sender, "commands.no_permission");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cUsage: /auditor note <player> <add|remove|list|clear> [note]");
            return true;
        }
        String targetName = args[1];
        String action = args[2].toLowerCase();
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cPlayer not found: " + targetName);
            return true;
        }
        PlayerProfile profile = this.plugin.getDatabase().getPlayerProfile(target.getUniqueId());
        if (profile == null) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cNo profile data found for " + targetName);
            return true;
        }
        switch (action) {
            case "add": {
                if (args.length < 4) {
                    sender.sendMessage("\u00a76[Auditor] \u00a7cUsage: /auditor note " + targetName + " add <note>");
                    return true;
                }
                StringBuilder noteBuilder = new StringBuilder();
                for (int i = 3; i < args.length; ++i) {
                    noteBuilder.append(args[i]);
                    if (i >= args.length - 1) continue;
                    noteBuilder.append(" ");
                }
                String newNote = noteBuilder.toString();
                String currentNotes = profile.getNotes();
                String updatedNotes = currentNotes == null || currentNotes.isEmpty() ? "[" + sender.getName() + "] " + newNote : currentNotes + "\n[" + sender.getName() + "] " + newNote;
                this.plugin.getDatabase().updatePlayerNotes(target.getUniqueId(), updatedNotes);
                sender.sendMessage("\u00a76[Auditor] \u00a7aAdded note to " + targetName + ": \u00a7f" + newNote);
                break;
            }
            case "list": {
                sender.sendMessage("\u00a76[Auditor] \u00a7eNotes for " + targetName + ":");
                String notes = profile.getNotes();
                if (notes == null || notes.isEmpty()) {
                    sender.sendMessage("\u00a77No notes recorded");
                    break;
                }
                String[] noteLines = notes.split("\n");
                for (int i = 0; i < noteLines.length; ++i) {
                    sender.sendMessage("\u00a77" + (i + 1) + ". \u00a7f" + noteLines[i]);
                }
                break;
            }
            case "clear": {
                this.plugin.getDatabase().updatePlayerNotes(target.getUniqueId(), "");
                sender.sendMessage("\u00a76[Auditor] \u00a7aCleared all notes for " + targetName);
                break;
            }
            case "remove": {
                if (args.length < 4) {
                    sender.sendMessage("\u00a76[Auditor] \u00a7cUsage: /auditor note " + targetName + " remove <index>");
                    return true;
                }
                try {
                    int index = Integer.parseInt(args[3]) - 1;
                    String existingNotes = profile.getNotes();
                    if (existingNotes != null && !existingNotes.isEmpty()) {
                        String[] noteLines = existingNotes.split("\n");
                        if (index >= 0 && index < noteLines.length) {
                            ArrayList<String> noteList = new ArrayList<String>(Arrays.asList(noteLines));
                            String removedNote = (String)noteList.remove(index);
                            String newNotesString = String.join((CharSequence)"\n", noteList);
                            this.plugin.getDatabase().updatePlayerNotes(target.getUniqueId(), newNotesString);
                            sender.sendMessage("\u00a76[Auditor] \u00a7aRemoved note: \u00a7f" + removedNote);
                            break;
                        }
                        sender.sendMessage("\u00a76[Auditor] \u00a7cInvalid note index. Use /auditor note " + targetName + " list to see all notes");
                        break;
                    }
                    sender.sendMessage("\u00a76[Auditor] \u00a7cNo notes to remove");
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a76[Auditor] \u00a7cInvalid note index. Must be a number.");
                }
                break;
            }
            default: {
                sender.sendMessage("\u00a76[Auditor] \u00a7cInvalid action. Use: add, remove, list, or clear");
            }
        }
        return true;
    }

    private boolean handlePopulateTestData(CommandSender sender) {
        if (!sender.hasPermission("auditor.admin") && !sender.isOp()) {
            sender.sendMessage("\u00a76[Auditor] \u00a7cYou need admin permission to use this command.");
            return true;
        }
        sender.sendMessage("\u00a76[Auditor] \u00a7ePopulating test data...");
        String[] testPlayers = new String[]{"TestPlayer1", "TestPlayer2", "TestPlayer3", "Steve", "Alex", "Notch"};
        for (int i = 0; i < testPlayers.length; ++i) {
            String playerName = testPlayers[i];
            UUID testUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes());
            PlayerProfile testProfile = new PlayerProfile(testUUID, playerName, System.currentTimeMillis() - (long)(i * 24 * 60 * 60 * 1000), System.currentTimeMillis() - (long)(i * 60 * 60 * 1000), (i + 1) * 10, (double)(i + 1) * 1000.0, (double)(i + 1) * 800.0, (double)(i + 1) * 200.0, (double)(i + 1) * 50.0, i * 10, i < 2 ? "LOW" : (i < 4 ? "MEDIUM" : "HIGH"), i > 3 ? "SUSPICIOUS,HIGH_VOLUME" : "", i > 2 ? "Test note for " + playerName : "", i % 2 == 0);
            this.plugin.getDatabase().insertPlayerProfile(testProfile);
        }
        sender.sendMessage("\u00a76[Auditor] \u00a7aPopulated " + testPlayers.length + " test players!");
        sender.sendMessage("\u00a76[Auditor] \u00a77Try opening the player analysis dashboard now.");
        return true;
    }

    private List<String> getCurrentFlags(PlayerProfile profile) {
        if (profile.getFlags() == null || profile.getFlags().isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(profile.getFlags().split(",")));
    }

    private void showHelpMessage(CommandSender sender) {
        this.plugin.getMessageManager().sendRawMessage(sender, "&6&lAuditor Commands:");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor &7- Open main dashboard");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor player <name> &7- View player analysis");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor alerts &7- View active alerts");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor health &7- Economy health check");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor export <type> &7- Export data to CSV");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor monitor <player> [on|off] &7- Toggle player monitoring");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor flag <player> <add|remove|list> [flag] &7- Manage player flags");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor note <player> <add|remove|list> [note] &7- Manage admin notes");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor populatetest &7- Populate test data (Admin only)");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor test &7- Test plugin functionality");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor reload &7- Reload configuration");
        this.plugin.getMessageManager().sendRawMessage(sender, "&e/auditor help &7- Show this help message");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block10: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block9: {
                                            completions = new ArrayList<String>();
                                            if (args.length != 1) break block9;
                                            List<String> subCommands = Arrays.asList("dashboard", "player", "alerts", "health", "export", "monitor", "flag", "note", "populatetest", "reload", "test", "status", "help");
                                            for (String subCommand : subCommands) {
                                                if (!subCommand.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                                                completions.add(subCommand);
                                            }
                                            break block10;
                                        }
                                        if (args.length != 2 || !args[0].equalsIgnoreCase("player")) break block11;
                                        for (Player player : Bukkit.getOnlinePlayers()) {
                                            if (!player.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                                            completions.add(player.getName());
                                        }
                                        break block10;
                                    }
                                    if (args.length != 2 || !args[0].equalsIgnoreCase("export")) break block12;
                                    List<String> exportTypes = Arrays.asList("transactions", "profiles", "alerts");
                                    for (String exportType : exportTypes) {
                                        if (!exportType.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                                        completions.add(exportType);
                                    }
                                    break block10;
                                }
                                if (args.length != 3 || !args[0].equalsIgnoreCase("export") || !args[1].equalsIgnoreCase("transactions")) break block13;
                                for (Player player : Bukkit.getOnlinePlayers()) {
                                    if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                                    completions.add(player.getName());
                                }
                                break block10;
                            }
                            if (args.length != 2 || !args[0].equalsIgnoreCase("monitor") && !args[0].equalsIgnoreCase("flag") && !args[0].equalsIgnoreCase("note")) break block14;
                            for (Player player : Bukkit.getOnlinePlayers()) {
                                if (!player.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                                completions.add(player.getName());
                            }
                            break block10;
                        }
                        if (args.length != 3 || !args[0].equalsIgnoreCase("monitor")) break block15;
                        List<String> options = Arrays.asList("on", "off", "enable", "disable");
                        for (String option : options) {
                            if (!option.toLowerCase().startsWith(args[2].toLowerCase())) continue;
                            completions.add(option);
                        }
                        break block10;
                    }
                    if (args.length != 3 || !args[0].equalsIgnoreCase("flag")) break block16;
                    List<String> actions = Arrays.asList("add", "remove", "list", "clear");
                    for (String action : actions) {
                        if (!action.toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        completions.add(action);
                    }
                    break block10;
                }
                if (args.length != 4 || !args[0].equalsIgnoreCase("flag") || !args[2].equalsIgnoreCase("add") && !args[2].equalsIgnoreCase("remove")) break block17;
                List<String> flags = Arrays.asList("SUSPICIOUS", "HIGH_VOLUME", "WATCH_LIST", "BOT_SUSPECTED", "VIP", "TRUSTED", "PATTERN_ANOMALY", "RAPID_TRANSACTIONS", "NEW_PLAYER");
                for (String flag : flags) {
                    if (!flag.toLowerCase().startsWith(args[3].toLowerCase())) continue;
                    completions.add(flag);
                }
                break block10;
            }
            if (args.length != 3 || !args[0].equalsIgnoreCase("note")) break block10;
            List<String> actions = Arrays.asList("add", "remove", "list", "clear");
            for (String action : actions) {
                if (!action.toLowerCase().startsWith(args[2].toLowerCase())) continue;
                completions.add(action);
            }
        }
        return completions;
    }
}

