/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.database;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.models.Alert;
import com.auditor.plugin.models.PlayerProfile;
import com.auditor.plugin.models.TransactionData;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SQLiteManager {
    private final AuditorPlugin plugin;
    private Connection connection;
    private final String databasePath;

    public SQLiteManager(AuditorPlugin plugin) {
        this.plugin = plugin;
        this.databasePath = plugin.getDataFolder().getAbsolutePath() + File.separator + "auditor.db";
    }

    public boolean initialize() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            Class.forName("com.auditor.libs.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.databasePath);
            this.createTables();
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to initialize database: " + e.getMessage());
            return false;
        }
    }

    private void createTables() throws SQLException {
        String[] queries;
        for (String query : queries = new String[]{"CREATE TABLE IF NOT EXISTS transactions (id INTEGER PRIMARY KEY AUTOINCREMENT,player_uuid TEXT NOT NULL,player_name TEXT NOT NULL,amount REAL NOT NULL,transaction_type TEXT NOT NULL,source_plugin TEXT,source_command TEXT,target_player_uuid TEXT,balance_before REAL,balance_after REAL,timestamp INTEGER NOT NULL,world_name TEXT,location_x INTEGER,location_y INTEGER,location_z INTEGER,additional_data TEXT)", "CREATE TABLE IF NOT EXISTS player_profiles (player_uuid TEXT PRIMARY KEY,player_name TEXT NOT NULL,first_seen INTEGER NOT NULL,last_activity INTEGER NOT NULL,total_transactions INTEGER DEFAULT 0,total_spent REAL DEFAULT 0,total_earned REAL DEFAULT 0,largest_transaction REAL DEFAULT 0,average_transaction REAL DEFAULT 0,risk_score INTEGER DEFAULT 0,risk_level TEXT DEFAULT 'LOW',flags TEXT,notes TEXT,is_monitored BOOLEAN DEFAULT 0)", "CREATE TABLE IF NOT EXISTS alerts (id INTEGER PRIMARY KEY AUTOINCREMENT,alert_type TEXT NOT NULL,severity TEXT NOT NULL,player_uuid TEXT,transaction_id INTEGER,title TEXT NOT NULL,description TEXT NOT NULL,created_at INTEGER NOT NULL,resolved_at INTEGER,resolved_by TEXT,is_resolved BOOLEAN DEFAULT 0,auto_generated BOOLEAN DEFAULT 1)", "CREATE TABLE IF NOT EXISTS economy_snapshots (id INTEGER PRIMARY KEY AUTOINCREMENT,snapshot_date INTEGER NOT NULL,total_players INTEGER,active_players INTEGER,total_money_circulation REAL,transaction_volume_24h REAL,health_score INTEGER,inflation_rate REAL,wealth_distribution_gini REAL,top_10_percent_wealth REAL,alert_count INTEGER,notes TEXT)", "CREATE TABLE IF NOT EXISTS config_data (key TEXT PRIMARY KEY,value TEXT NOT NULL,updated_at INTEGER NOT NULL)", "CREATE INDEX IF NOT EXISTS idx_transactions_player ON transactions(player_uuid)", "CREATE INDEX IF NOT EXISTS idx_transactions_timestamp ON transactions(timestamp)", "CREATE INDEX IF NOT EXISTS idx_alerts_player ON alerts(player_uuid)", "CREATE INDEX IF NOT EXISTS idx_alerts_resolved ON alerts(is_resolved)"}) {
            try (PreparedStatement stmt = this.connection.prepareStatement(query);){
                stmt.execute();
            }
        }
    }

    public void insertTransaction(final TransactionData transaction) {
        new BukkitRunnable(this){
            final /* synthetic */ SQLiteManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    String query = "INSERT INTO transactions (player_uuid, player_name, amount, transaction_type, source_plugin, source_command, target_player_uuid, balance_before, balance_after, timestamp, world_name, location_x, location_y, location_z, additional_data) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    try (PreparedStatement stmt = this.this$0.connection.prepareStatement(query);){
                        stmt.setString(1, transaction.getPlayerUUID().toString());
                        stmt.setString(2, transaction.getPlayerName());
                        stmt.setDouble(3, transaction.getAmount());
                        stmt.setString(4, transaction.getTransactionType());
                        stmt.setString(5, transaction.getSourcePlugin());
                        stmt.setString(6, transaction.getSourceCommand());
                        stmt.setString(7, transaction.getTargetPlayerUUID() != null ? transaction.getTargetPlayerUUID().toString() : null);
                        stmt.setDouble(8, transaction.getBalanceBefore());
                        stmt.setDouble(9, transaction.getBalanceAfter());
                        stmt.setLong(10, transaction.getTimestamp());
                        stmt.setString(11, transaction.getWorldName());
                        stmt.setInt(12, transaction.getLocationX());
                        stmt.setInt(13, transaction.getLocationY());
                        stmt.setInt(14, transaction.getLocationZ());
                        stmt.setString(15, transaction.getAdditionalData());
                        stmt.executeUpdate();
                        this.this$0.updatePlayerProfile(transaction);
                    }
                }
                catch (SQLException e) {
                    this.this$0.plugin.getLogger().warning("Failed to insert transaction: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void updatePlayerProfile(TransactionData transaction) throws SQLException {
        block19: {
            String selectQuery = "SELECT * FROM player_profiles WHERE player_uuid = ?";
            String insertQuery = "INSERT INTO player_profiles (player_uuid, player_name, first_seen, last_activity, total_transactions, total_spent, total_earned, largest_transaction, average_transaction, risk_score, risk_level, flags, notes, is_monitored) VALUES (?, ?, ?, ?, 1, ?, ?, ?, ?, 0, 'LOW', '', '', 0)";
            String updateQuery = "UPDATE player_profiles SET player_name = ?, last_activity = ?, total_transactions = total_transactions + 1, total_spent = total_spent + ?, total_earned = total_earned + ?, largest_transaction = MAX(largest_transaction, ?) WHERE player_uuid = ?";
            try (PreparedStatement selectStmt = this.connection.prepareStatement(selectQuery);){
                selectStmt.setString(1, transaction.getPlayerUUID().toString());
                ResultSet rs = selectStmt.executeQuery();
                if (rs.next()) {
                    try (PreparedStatement updateStmt = this.connection.prepareStatement(updateQuery);){
                        updateStmt.setString(1, transaction.getPlayerName());
                        updateStmt.setLong(2, transaction.getTimestamp());
                        updateStmt.setDouble(3, transaction.getAmount() < 0.0 ? Math.abs(transaction.getAmount()) : 0.0);
                        updateStmt.setDouble(4, transaction.getAmount() > 0.0 ? transaction.getAmount() : 0.0);
                        updateStmt.setDouble(5, Math.abs(transaction.getAmount()));
                        updateStmt.setString(6, transaction.getPlayerUUID().toString());
                        updateStmt.executeUpdate();
                        break block19;
                    }
                }
                try (PreparedStatement insertStmt = this.connection.prepareStatement(insertQuery);){
                    insertStmt.setString(1, transaction.getPlayerUUID().toString());
                    insertStmt.setString(2, transaction.getPlayerName());
                    insertStmt.setLong(3, transaction.getTimestamp());
                    insertStmt.setLong(4, transaction.getTimestamp());
                    insertStmt.setDouble(5, transaction.getAmount() < 0.0 ? Math.abs(transaction.getAmount()) : 0.0);
                    insertStmt.setDouble(6, transaction.getAmount() > 0.0 ? transaction.getAmount() : 0.0);
                    insertStmt.setDouble(7, Math.abs(transaction.getAmount()));
                    insertStmt.setDouble(8, Math.abs(transaction.getAmount()));
                    insertStmt.executeUpdate();
                    this.plugin.getLogger().info("[Database] Created new player profile for " + transaction.getPlayerName() + " (UUID: " + transaction.getPlayerUUID() + ")");
                }
            }
        }
        this.updateAverageTransaction(transaction.getPlayerUUID());
    }

    private void updateAverageTransaction(UUID playerUUID) throws SQLException {
        String query = "UPDATE player_profiles SET average_transaction = (SELECT AVG(ABS(amount)) FROM transactions WHERE player_uuid = ?) WHERE player_uuid = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setString(1, playerUUID.toString());
            stmt.setString(2, playerUUID.toString());
            stmt.executeUpdate();
        }
    }

    public List<TransactionData> getPlayerTransactions(UUID playerUUID, int limit) {
        ArrayList<TransactionData> transactions = new ArrayList<TransactionData>();
        String query = "SELECT * FROM transactions WHERE player_uuid = ? ORDER BY timestamp DESC LIMIT ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setString(1, playerUUID.toString());
            stmt.setInt(2, limit);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                transactions.add(this.createTransactionFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to get player transactions: " + e.getMessage());
        }
        return transactions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlayerProfile getPlayerProfile(UUID playerUUID) {
        String query = "SELECT * FROM player_profiles WHERE player_uuid = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setString(1, playerUUID.toString());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            PlayerProfile playerProfile = this.createPlayerProfileFromResultSet(rs);
            return playerProfile;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to get player profile: " + e.getMessage());
        }
        return null;
    }

    public void insertAlert(final Alert alert) {
        new BukkitRunnable(this){
            final /* synthetic */ SQLiteManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    String query = "INSERT INTO alerts (alert_type, severity, player_uuid, transaction_id, title, description, created_at, auto_generated) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                    try (PreparedStatement stmt = this.this$0.connection.prepareStatement(query);){
                        stmt.setString(1, alert.getAlertType());
                        stmt.setString(2, alert.getSeverity());
                        stmt.setString(3, alert.getPlayerUUID() != null ? alert.getPlayerUUID().toString() : null);
                        stmt.setLong(4, alert.getTransactionId());
                        stmt.setString(5, alert.getTitle());
                        stmt.setString(6, alert.getDescription());
                        stmt.setLong(7, alert.getCreatedAt());
                        stmt.setBoolean(8, alert.isAutoGenerated());
                        stmt.executeUpdate();
                    }
                }
                catch (SQLException e) {
                    this.this$0.plugin.getLogger().warning("Failed to insert alert: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public List<Alert> getActiveAlerts() {
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        String query = "SELECT * FROM alerts WHERE is_resolved = 0 ORDER BY created_at DESC";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                alerts.add(this.createAlertFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to get active alerts: " + e.getMessage());
        }
        return alerts;
    }

    public List<TransactionData> getRecentTransactions(int limit) {
        ArrayList<TransactionData> transactions = new ArrayList<TransactionData>();
        String query = "SELECT * FROM transactions ORDER BY timestamp DESC LIMIT ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setInt(1, limit);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                transactions.add(this.createTransactionFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to get recent transactions: " + e.getMessage());
        }
        return transactions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getTotalTransactionVolume(long timeframeDays) {
        PreparedStatement stmt;
        block7: {
            long cutoffTime = System.currentTimeMillis() - timeframeDays * 24L * 60L * 60L * 1000L;
            String query = "SELECT SUM(ABS(amount)) FROM transactions WHERE timestamp > ?";
            try {
                double d;
                stmt = this.connection.prepareStatement(query);
                try {
                    stmt.setLong(1, cutoffTime);
                    ResultSet rs = stmt.executeQuery();
                    if (!rs.next()) break block7;
                    d = rs.getDouble(1);
                    if (stmt == null) return d;
                }
                catch (Throwable throwable) {
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                stmt.close();
                return d;
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning("Failed to get transaction volume: " + e.getMessage());
                return 0.0;
            }
        }
        if (stmt == null) return 0.0;
        stmt.close();
        return 0.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTransactionCount(long timeframeDays) {
        long cutoffTime = System.currentTimeMillis() - timeframeDays * 24L * 60L * 60L * 1000L;
        String query = "SELECT COUNT(*) FROM transactions WHERE timestamp > ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setLong(1, cutoffTime);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to get transaction count: " + e.getMessage());
        }
        return 0;
    }

    public List<PlayerProfile> getTopPlayersByTransactions(int limit) {
        ArrayList<PlayerProfile> players = new ArrayList<PlayerProfile>();
        String query = "SELECT * FROM player_profiles ORDER BY total_transactions DESC LIMIT ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setInt(1, limit);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                players.add(this.createPlayerProfileFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to get top players by transactions: " + e.getMessage());
        }
        return players;
    }

    public List<PlayerProfile> getTopPlayersBySpent(int limit) {
        ArrayList<PlayerProfile> players = new ArrayList<PlayerProfile>();
        String query = "SELECT * FROM player_profiles ORDER BY total_spent DESC LIMIT ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setInt(1, limit);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                players.add(this.createPlayerProfileFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to get top players by spent: " + e.getMessage());
        }
        return players;
    }

    public List<PlayerProfile> getTopPlayersByEarned(int limit) {
        ArrayList<PlayerProfile> players = new ArrayList<PlayerProfile>();
        String query = "SELECT * FROM player_profiles ORDER BY total_earned DESC LIMIT ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            stmt.setInt(1, limit);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                players.add(this.createPlayerProfileFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to get top players by earned: " + e.getMessage());
        }
        return players;
    }

    public List<PlayerProfile> getHighRiskPlayers() {
        ArrayList<PlayerProfile> players = new ArrayList<PlayerProfile>();
        String query = "SELECT * FROM player_profiles WHERE risk_level IN ('HIGH', 'CRITICAL') ORDER BY risk_score DESC";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                players.add(this.createPlayerProfileFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to get high risk players: " + e.getMessage());
        }
        return players;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTotalPlayerCount() {
        String query = "SELECT COUNT(*) FROM player_profiles";
        try (PreparedStatement stmt = this.connection.prepareStatement(query);){
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to get total player count: " + e.getMessage());
        }
        return 0;
    }

    private TransactionData createTransactionFromResultSet(ResultSet rs) throws SQLException {
        return new TransactionData(UUID.fromString(rs.getString("player_uuid")), rs.getString("player_name"), rs.getDouble("amount"), rs.getString("transaction_type"), rs.getString("source_plugin"), rs.getString("source_command"), rs.getString("target_player_uuid") != null ? UUID.fromString(rs.getString("target_player_uuid")) : null, rs.getDouble("balance_before"), rs.getDouble("balance_after"), rs.getLong("timestamp"), rs.getString("world_name"), rs.getInt("location_x"), rs.getInt("location_y"), rs.getInt("location_z"), rs.getString("additional_data"));
    }

    private PlayerProfile createPlayerProfileFromResultSet(ResultSet rs) throws SQLException {
        return new PlayerProfile(UUID.fromString(rs.getString("player_uuid")), rs.getString("player_name"), rs.getLong("first_seen"), rs.getLong("last_activity"), rs.getInt("total_transactions"), rs.getDouble("total_spent"), rs.getDouble("total_earned"), rs.getDouble("largest_transaction"), rs.getDouble("average_transaction"), rs.getInt("risk_score"), rs.getString("risk_level"), rs.getString("flags"), rs.getString("notes"), rs.getBoolean("is_monitored"));
    }

    private Alert createAlertFromResultSet(ResultSet rs) throws SQLException {
        return new Alert(rs.getLong("id"), rs.getString("alert_type"), rs.getString("severity"), rs.getString("player_uuid") != null ? UUID.fromString(rs.getString("player_uuid")) : null, rs.getLong("transaction_id"), rs.getString("title"), rs.getString("description"), rs.getLong("created_at"), rs.getLong("resolved_at"), rs.getString("resolved_by"), rs.getBoolean("is_resolved"), rs.getBoolean("auto_generated"));
    }

    public void insertPlayerProfile(PlayerProfile profile) {
        String insertQuery = "INSERT OR REPLACE INTO player_profiles (player_uuid, player_name, first_seen, last_activity, total_transactions, total_spent, total_earned, largest_transaction, average_transaction, risk_score, risk_level, flags, notes, is_monitored) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement(insertQuery);){
            stmt.setString(1, profile.getPlayerUUID().toString());
            stmt.setString(2, profile.getPlayerName());
            stmt.setLong(3, profile.getFirstSeen());
            stmt.setLong(4, profile.getLastActivity());
            stmt.setInt(5, profile.getTotalTransactions());
            stmt.setDouble(6, profile.getTotalSpent());
            stmt.setDouble(7, profile.getTotalEarned());
            stmt.setDouble(8, profile.getLargestTransaction());
            stmt.setDouble(9, profile.getAverageTransaction());
            stmt.setInt(10, profile.getRiskScore());
            stmt.setString(11, profile.getRiskLevel());
            stmt.setString(12, profile.getFlags());
            stmt.setString(13, profile.getNotes());
            stmt.setBoolean(14, profile.isMonitored());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to insert player profile for " + profile.getPlayerName() + ": " + e.getMessage());
        }
    }

    public void updatePlayerFlags(UUID playerUUID, String flags) {
        String updateQuery = "UPDATE player_profiles SET flags = ? WHERE player_uuid = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(updateQuery);){
            stmt.setString(1, flags);
            stmt.setString(2, playerUUID.toString());
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected > 0) {
                this.plugin.getLogger().info("Updated flags for player " + playerUUID + " to: " + flags);
                this.updateRiskAssessment(playerUUID);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to update player flags: " + e.getMessage());
        }
    }

    public void updatePlayerNotes(UUID playerUUID, String notes) {
        String updateQuery = "UPDATE player_profiles SET notes = ? WHERE player_uuid = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(updateQuery);){
            stmt.setString(1, notes);
            stmt.setString(2, playerUUID.toString());
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected > 0) {
                this.plugin.getLogger().info("Updated notes for player " + playerUUID);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to update player notes: " + e.getMessage());
        }
    }

    public void updatePlayerMonitoring(UUID playerUUID, boolean isMonitored) {
        String updateQuery = "UPDATE player_profiles SET is_monitored = ? WHERE player_uuid = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(updateQuery);){
            stmt.setBoolean(1, isMonitored);
            stmt.setString(2, playerUUID.toString());
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected > 0) {
                this.plugin.getLogger().info("Updated monitoring status for player " + playerUUID + " to: " + isMonitored);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to update player monitoring status: " + e.getMessage());
        }
    }

    private void updateRiskAssessment(UUID playerUUID) {
        PlayerProfile profile = this.getPlayerProfile(playerUUID);
        if (profile == null) {
            return;
        }
        int riskScore = this.calculateRiskScore(profile);
        String riskLevel = this.determineRiskLevel(riskScore);
        String updateQuery = "UPDATE player_profiles SET risk_score = ?, risk_level = ? WHERE player_uuid = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(updateQuery);){
            stmt.setInt(1, riskScore);
            stmt.setString(2, riskLevel);
            stmt.setString(3, playerUUID.toString());
            stmt.executeUpdate();
            this.plugin.getLogger().info("Updated risk assessment for player " + playerUUID + ": " + riskLevel + " (" + riskScore + ")");
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to update risk assessment: " + e.getMessage());
        }
    }

    private int calculateRiskScore(PlayerProfile profile) {
        String flags;
        int score = 0;
        if (profile.getTotalTransactions() > 100) {
            score += 20;
        }
        if (profile.getLargestTransaction() > 10000.0) {
            score += 25;
        }
        if (profile.getAverageTransaction() > 1000.0) {
            score += 15;
        }
        if ((flags = profile.getFlags()) != null && !flags.isEmpty()) {
            if (flags.contains("SUSPICIOUS")) {
                score += 30;
            }
            if (flags.contains("HIGH_VOLUME")) {
                score += 20;
            }
            if (flags.contains("BOT_SUSPECTED")) {
                score += 40;
            }
            if (flags.contains("PATTERN_ANOMALY")) {
                score += 35;
            }
            if (flags.contains("RAPID_TRANSACTIONS")) {
                score += 25;
            }
            if (flags.contains("WATCH_LIST")) {
                score += 15;
            }
            if (flags.contains("TRUSTED")) {
                score -= 20;
            }
            if (flags.contains("VIP")) {
                score -= 10;
            }
        }
        return Math.max(0, Math.min(100, score));
    }

    private String determineRiskLevel(int riskScore) {
        if (riskScore >= 70) {
            return "CRITICAL";
        }
        if (riskScore >= 50) {
            return "HIGH";
        }
        if (riskScore >= 30) {
            return "MEDIUM";
        }
        return "LOW";
    }

    public void resolveAlert(long alertId, String resolvedBy) {
        String updateQuery = "UPDATE alerts SET is_resolved = 1, resolved_at = ?, resolved_by = ? WHERE id = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(updateQuery);){
            stmt.setLong(1, System.currentTimeMillis());
            stmt.setString(2, resolvedBy);
            stmt.setLong(3, alertId);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected > 0) {
                this.plugin.getLogger().info("Resolved alert " + alertId + " by " + resolvedBy);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to resolve alert: " + e.getMessage());
        }
    }

    public void reopenAlert(long alertId) {
        String updateQuery = "UPDATE alerts SET is_resolved = 0, resolved_at = NULL, resolved_by = NULL WHERE id = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(updateQuery);){
            stmt.setLong(1, alertId);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected > 0) {
                this.plugin.getLogger().info("Reopened alert " + alertId);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to reopen alert: " + e.getMessage());
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to close database connection: " + e.getMessage());
        }
    }
}

