/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.economy;

import com.auditor.plugin.AuditorPlugin;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EconomyHealthMonitor {
    private final AuditorPlugin plugin;
    private double totalCirculation;
    private double averagePlayerBalance;
    private double medianBalance;
    private int healthScore;
    private String healthStatus;
    private double inflationRate;
    private double wealthConcentration;

    public EconomyHealthMonitor(AuditorPlugin plugin) {
        this.plugin = plugin;
        this.startHealthMonitoring();
    }

    private void startHealthMonitoring() {
        int intervalMinutes = this.plugin.getConfigManager().getHealthCalculationInterval();
        long intervalTicks = (long)intervalMinutes * 60L * 20L;
        new BukkitRunnable(){

            public void run() {
                EconomyHealthMonitor.this.calculateEconomyHealth();
            }
        }.runTaskTimer((Plugin)this.plugin, 200L, intervalTicks);
    }

    public void calculateEconomyHealth() {
        new BukkitRunnable(){

            public void run() {
                try {
                    ArrayList<Double> playerBalances = new ArrayList<Double>();
                    double totalBalance = 0.0;
                    int activePlayers = 0;
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (EconomyHealthMonitor.this.plugin.getVaultHook() == null) continue;
                        double balance = EconomyHealthMonitor.this.plugin.getVaultHook().getBalance(player.getName());
                        playerBalances.add(balance);
                        totalBalance += balance;
                        ++activePlayers;
                    }
                    EconomyHealthMonitor.this.totalCirculation = totalBalance;
                    EconomyHealthMonitor.this.averagePlayerBalance = activePlayers > 0 ? totalBalance / (double)activePlayers : 0.0;
                    EconomyHealthMonitor.this.medianBalance = EconomyHealthMonitor.this.calculateMedian(playerBalances);
                    EconomyHealthMonitor.this.wealthConcentration = EconomyHealthMonitor.this.calculateWealthConcentration(playerBalances);
                    EconomyHealthMonitor.this.healthScore = EconomyHealthMonitor.this.calculateHealthScore();
                    EconomyHealthMonitor.this.healthStatus = EconomyHealthMonitor.this.determineHealthStatus(EconomyHealthMonitor.this.healthScore);
                    EconomyHealthMonitor.this.plugin.getLogger().info("Economy Health Updated - Score: " + EconomyHealthMonitor.this.healthScore + "/100 (" + EconomyHealthMonitor.this.healthStatus + ")");
                }
                catch (Exception e) {
                    EconomyHealthMonitor.this.plugin.getLogger().warning("Error calculating economy health: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private double calculateMedian(List<Double> balances) {
        if (balances.isEmpty()) {
            return 0.0;
        }
        balances.sort(Double::compareTo);
        int size = balances.size();
        if (size % 2 == 0) {
            return (balances.get(size / 2 - 1) + balances.get(size / 2)) / 2.0;
        }
        return balances.get(size / 2);
    }

    private double calculateWealthConcentration(List<Double> balances) {
        if (balances.size() < 2) {
            return 0.0;
        }
        double totalWealth = balances.stream().mapToDouble(Double::doubleValue).sum();
        if (totalWealth <= 0.0) {
            return 0.0;
        }
        balances.sort(Double::compareTo);
        int topPercent = Math.max(1, balances.size() / 10);
        double topWealthSum = 0.0;
        for (int i = balances.size() - topPercent; i < balances.size(); ++i) {
            topWealthSum += balances.get(i).doubleValue();
        }
        return topWealthSum / totalWealth * 100.0;
    }

    private int calculateHealthScore() {
        int score = 100;
        if (this.wealthConcentration > 80.0) {
            score -= 20;
        } else if (this.wealthConcentration > 60.0) {
            score -= 10;
        }
        if (this.averagePlayerBalance < 1000.0) {
            score -= 15;
        } else if (this.averagePlayerBalance > 1000000.0) {
            score -= 10;
        }
        int activeAlerts = this.plugin.getDatabase().getActiveAlerts().size();
        if (activeAlerts > 10) {
            score -= 25;
        } else if (activeAlerts > 5) {
            score -= 15;
        } else if (activeAlerts > 0) {
            score -= 5;
        }
        return Math.max(0, Math.min(100, score));
    }

    private String determineHealthStatus(int score) {
        if (score >= 90) {
            return "Excellent";
        }
        if (score >= 75) {
            return "Good";
        }
        if (score >= 60) {
            return "Fair";
        }
        if (score >= 40) {
            return "Poor";
        }
        return "Critical";
    }

    public double getTotalCirculation() {
        return this.totalCirculation;
    }

    public double getAveragePlayerBalance() {
        return this.averagePlayerBalance;
    }

    public double getMedianBalance() {
        return this.medianBalance;
    }

    public int getHealthScore() {
        return this.healthScore;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public double getInflationRate() {
        return this.inflationRate;
    }

    public double getWealthConcentration() {
        return this.wealthConcentration;
    }
}

