/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.economy;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.models.TransactionData;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TransactionListener
implements Listener {
    private final AuditorPlugin plugin;
    private final Map<UUID, Double> playerBalances;
    private final Map<UUID, Long> lastTransactionTime;
    private final Map<UUID, String> pendingCommands;

    public TransactionListener(AuditorPlugin plugin) {
        this.plugin = plugin;
        this.playerBalances = new ConcurrentHashMap<UUID, Double>();
        this.lastTransactionTime = new ConcurrentHashMap<UUID, Long>();
        this.pendingCommands = new ConcurrentHashMap<UUID, String>();
        this.initializePlayerBalances();
        this.startBalanceMonitoring();
    }

    private void initializePlayerBalances() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : TransactionListener.this.plugin.getServer().getOnlinePlayers()) {
                    if (TransactionListener.this.plugin.getVaultHook() == null) continue;
                    double balance = TransactionListener.this.plugin.getVaultHook().getBalance(player.getName());
                    TransactionListener.this.playerBalances.put(player.getUniqueId(), balance);
                }
                TransactionListener.this.plugin.getLogger().info("Initialized balances for " + TransactionListener.this.playerBalances.size() + " online players");
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        if (this.plugin.getVaultHook() != null) {
            new BukkitRunnable(this){
                final /* synthetic */ TransactionListener this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    double balance = this.this$0.plugin.getVaultHook().getBalance(player.getName());
                    this.this$0.playerBalances.put(player.getUniqueId(), balance);
                }
            }.runTaskLater((Plugin)this.plugin, 20L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerUUID = event.getPlayer().getUniqueId();
        this.playerBalances.remove(playerUUID);
        this.lastTransactionTime.remove(playerUUID);
        this.pendingCommands.remove(playerUUID);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        final Player player = event.getPlayer();
        final String command = event.getMessage().toLowerCase();
        if (this.isEconomyCommand(command)) {
            this.pendingCommands.put(player.getUniqueId(), command);
            new BukkitRunnable(this){
                final /* synthetic */ TransactionListener this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.checkBalanceChange(player, "COMMAND", command.split(" ")[0]);
                    this.this$0.pendingCommands.remove(player.getUniqueId());
                }
            }.runTaskLater((Plugin)this.plugin, 5L);
        }
    }

    private boolean isEconomyCommand(String command) {
        String[] economyCommands;
        for (String ecoCmd : economyCommands = new String[]{"/pay", "/money", "/balance", "/bal", "/eco", "/economy", "/sell", "/buy", "/shop", "/trade", "/auction", "/ah", "/withdraw", "/deposit", "/bank", "/baltop", "/balancetop", "/essentials:pay", "/essentials:balance", "/essentials:eco", "/cmi pay", "/cmi balance", "/cmi money", "/cmi eco", "/tne pay", "/tne balance", "/tne money", "/coins", "/tokens", "/currency", "/cash", "/funds"}) {
            if (!command.startsWith(ecoCmd + " ") && !command.equals(ecoCmd)) continue;
            return true;
        }
        return false;
    }

    private void startBalanceMonitoring() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : TransactionListener.this.plugin.getServer().getOnlinePlayers()) {
                    if (player.hasPermission("auditor.bypass")) continue;
                    try {
                        double previousBalance;
                        double currentBalance = TransactionListener.this.plugin.getVaultHook().getBalance(player.getName());
                        UUID playerUUID = player.getUniqueId();
                        if (TransactionListener.this.playerBalances.containsKey(playerUUID) && Math.abs(currentBalance - (previousBalance = ((Double)TransactionListener.this.playerBalances.get(playerUUID)).doubleValue())) >= 0.01) {
                            double difference = currentBalance - previousBalance;
                            String source = TransactionListener.this.determineTransactionSource(player, difference);
                            String command = (String)TransactionListener.this.pendingCommands.get(playerUUID);
                            TransactionListener.this.logTransaction(player, difference, previousBalance, currentBalance, TransactionListener.this.determineTransactionType(difference, source), source, command);
                            TransactionListener.this.lastTransactionTime.put(playerUUID, System.currentTimeMillis());
                        }
                        TransactionListener.this.playerBalances.put(playerUUID, currentBalance);
                    }
                    catch (Exception e) {
                        TransactionListener.this.plugin.getLogger().warning("Error monitoring balance for " + player.getName() + ": " + e.getMessage());
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 40L, 40L);
    }

    private String determineTransactionSource(Player player, double amount) {
        if (this.pendingCommands.containsKey(player.getUniqueId())) {
            return "COMMAND";
        }
        if (amount > 0.0) {
            return "INCOME";
        }
        return "EXPENSE";
    }

    private String determineTransactionType(double amount, String source) {
        if (source.equals("COMMAND")) {
            return amount > 0.0 ? "COMMAND_RECEIVE" : "COMMAND_SPEND";
        }
        if (amount > 0.0) {
            return "GAIN";
        }
        return "LOSS";
    }

    private void checkBalanceChange(Player player, String type, String command) {
        double previousBalance;
        if (player.hasPermission("auditor.bypass")) {
            return;
        }
        double currentBalance = this.plugin.getVaultHook().getBalance(player.getName());
        UUID playerUUID = player.getUniqueId();
        if (this.playerBalances.containsKey(playerUUID) && Math.abs(currentBalance - (previousBalance = this.playerBalances.get(playerUUID).doubleValue())) > 0.01) {
            double difference = currentBalance - previousBalance;
            this.logTransaction(player, difference, previousBalance, currentBalance, type, "COMMAND", command);
        }
        this.playerBalances.put(playerUUID, currentBalance);
    }

    private void logTransaction(Player player, double amount, double balanceBefore, double balanceAfter, String type, String source, String command) {
        TransactionData transaction = new TransactionData(player.getUniqueId(), player.getName(), amount, type, source, command, null, balanceBefore, balanceAfter, System.currentTimeMillis(), player.getWorld().getName(), player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ(), null);
        this.plugin.getDatabase().insertTransaction(transaction);
        if (this.plugin.getAnomalyDetector() != null) {
            this.plugin.getAnomalyDetector().analyzeTransaction(transaction);
        }
    }
}

