/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.economy;

import com.auditor.plugin.AuditorPlugin;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook {
    private final AuditorPlugin plugin;
    private Economy economy;

    public VaultHook(AuditorPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean setupEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public double getBalance(String playerName) {
        if (this.economy == null) {
            return 0.0;
        }
        return this.economy.getBalance(playerName);
    }

    public boolean hasAccount(String playerName) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.hasAccount(playerName);
    }

    public boolean withdraw(String playerName, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.withdrawPlayer(playerName, amount).transactionSuccess();
    }

    public boolean deposit(String playerName, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.depositPlayer(playerName, amount).transactionSuccess();
    }

    public String formatCurrency(double amount) {
        if (this.economy == null) {
            return String.valueOf(amount);
        }
        return this.economy.format(amount);
    }

    public String getCurrencyName() {
        if (this.economy == null) {
            return "Money";
        }
        return this.economy.currencyNamePlural();
    }
}

