/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.exports;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.models.Alert;
import com.auditor.plugin.models.PlayerProfile;
import com.auditor.plugin.models.TransactionData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DataExporter {
    private final AuditorPlugin plugin;
    private final SimpleDateFormat dateFormat;

    public DataExporter(AuditorPlugin plugin) {
        this.plugin = plugin;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    }

    public void exportTransactionsCSV(final UUID playerUUID, final String playerName, final ExportCallback callback) {
        new BukkitRunnable(this){
            final /* synthetic */ DataExporter this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    final List<TransactionData> transactions = this.this$0.plugin.getDatabase().getPlayerTransactions(playerUUID, 10000);
                    File exportDir = new File(this.this$0.plugin.getDataFolder(), "exports");
                    if (!exportDir.exists()) {
                        exportDir.mkdirs();
                    }
                    String timestamp = this.this$0.dateFormat.format(new Date());
                    final File csvFile = new File(exportDir, "transactions_" + playerName + "_" + timestamp + ".csv");
                    try (FileWriter writer = new FileWriter(csvFile);){
                        writer.write("Timestamp,Player,Amount,Type,Source,Command,BalanceBefore,BalanceAfter,World,X,Y,Z\n");
                        for (TransactionData transaction : transactions) {
                            writer.write(String.format("%s,%s,%.2f,%s,%s,%s,%.2f,%.2f,%s,%d,%d,%d\n", new Date(transaction.getTimestamp()), transaction.getPlayerName(), transaction.getAmount(), transaction.getTransactionType(), transaction.getSourcePlugin() != null ? transaction.getSourcePlugin() : "", transaction.getSourceCommand() != null ? transaction.getSourceCommand() : "", transaction.getBalanceBefore(), transaction.getBalanceAfter(), transaction.getWorldName() != null ? transaction.getWorldName() : "", transaction.getLocationX(), transaction.getLocationY(), transaction.getLocationZ()));
                        }
                    }
                    new BukkitRunnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            callback.onSuccess(csvFile.getName(), transactions.size());
                        }
                    }.runTask((Plugin)this.this$0.plugin);
                }
                catch (Exception e) {
                    new BukkitRunnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            callback.onError("Failed to export transactions: " + e.getMessage());
                        }
                    }.runTask((Plugin)this.this$0.plugin);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void exportAllTransactionsCSV(final ExportCallback callback) {
        new BukkitRunnable(this){
            final /* synthetic */ DataExporter this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    File exportDir = new File(this.this$0.plugin.getDataFolder(), "exports");
                    if (!exportDir.exists()) {
                        exportDir.mkdirs();
                    }
                    String timestamp = this.this$0.dateFormat.format(new Date());
                    final File csvFile = new File(exportDir, "all_transactions_" + timestamp + ".csv");
                    try (FileWriter writer = new FileWriter(csvFile);){
                        writer.write("Timestamp,Player,Amount,Type,Source,Command,BalanceBefore,BalanceAfter,World,X,Y,Z\n");
                        final int totalExported = this.this$0.exportAllTransactionsToWriter(writer);
                        new BukkitRunnable(this){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                callback.onSuccess(csvFile.getName(), totalExported);
                            }
                        }.runTask((Plugin)this.this$0.plugin);
                    }
                }
                catch (Exception e) {
                    new BukkitRunnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            callback.onError("Failed to export all transactions: " + e.getMessage());
                        }
                    }.runTask((Plugin)this.this$0.plugin);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void exportPlayerProfilesCSV(final ExportCallback callback) {
        new BukkitRunnable(this){
            final /* synthetic */ DataExporter this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    File exportDir = new File(this.this$0.plugin.getDataFolder(), "exports");
                    if (!exportDir.exists()) {
                        exportDir.mkdirs();
                    }
                    String timestamp = this.this$0.dateFormat.format(new Date());
                    final File csvFile = new File(exportDir, "player_profiles_" + timestamp + ".csv");
                    try (FileWriter writer = new FileWriter(csvFile);){
                        writer.write("PlayerUUID,PlayerName,FirstSeen,LastActivity,TotalTransactions,TotalSpent,TotalEarned,LargestTransaction,AverageTransaction,RiskScore,RiskLevel,IsMonitored\n");
                        final int totalExported = this.this$0.exportPlayerProfilesToWriter(writer);
                        new BukkitRunnable(this){
                            final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                callback.onSuccess(csvFile.getName(), totalExported);
                            }
                        }.runTask((Plugin)this.this$0.plugin);
                    }
                }
                catch (Exception e) {
                    new BukkitRunnable(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            callback.onError("Failed to export player profiles: " + e.getMessage());
                        }
                    }.runTask((Plugin)this.this$0.plugin);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void exportAlertsCSV(final ExportCallback callback) {
        new BukkitRunnable(this){
            final /* synthetic */ DataExporter this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    final List<Alert> alerts = this.this$0.plugin.getDatabase().getActiveAlerts();
                    File exportDir = new File(this.this$0.plugin.getDataFolder(), "exports");
                    if (!exportDir.exists()) {
                        exportDir.mkdirs();
                    }
                    String timestamp = this.this$0.dateFormat.format(new Date());
                    final File csvFile = new File(exportDir, "alerts_" + timestamp + ".csv");
                    try (FileWriter writer = new FileWriter(csvFile);){
                        writer.write("ID,Type,Severity,PlayerUUID,Title,Description,CreatedAt,IsResolved,AutoGenerated\n");
                        for (Alert alert : alerts) {
                            writer.write(String.format("%d,%s,%s,%s,%s,%s,%s,%s,%s\n", alert.getId(), alert.getAlertType(), alert.getSeverity(), alert.getPlayerUUID() != null ? alert.getPlayerUUID().toString() : "", alert.getTitle().replace(",", ";"), alert.getDescription().replace(",", ";"), new Date(alert.getCreatedAt()), alert.isResolved(), alert.isAutoGenerated()));
                        }
                    }
                    new BukkitRunnable(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            callback.onSuccess(csvFile.getName(), alerts.size());
                        }
                    }.runTask((Plugin)this.this$0.plugin);
                }
                catch (Exception e) {
                    new BukkitRunnable(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            callback.onError("Failed to export alerts: " + e.getMessage());
                        }
                    }.runTask((Plugin)this.this$0.plugin);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private int exportAllTransactionsToWriter(FileWriter writer) throws IOException {
        List<TransactionData> allTransactions = this.plugin.getDatabase().getRecentTransactions(10000);
        for (TransactionData transaction : allTransactions) {
            writer.write(String.format("%s,%s,%.2f,%s,%s,%s,%.2f,%.2f,%s,%d,%d,%d\n", new Date(transaction.getTimestamp()), transaction.getPlayerName(), transaction.getAmount(), transaction.getTransactionType(), transaction.getSourcePlugin() != null ? transaction.getSourcePlugin() : "", transaction.getSourceCommand() != null ? transaction.getSourceCommand() : "", transaction.getBalanceBefore(), transaction.getBalanceAfter(), transaction.getWorldName() != null ? transaction.getWorldName() : "", transaction.getLocationX(), transaction.getLocationY(), transaction.getLocationZ()));
        }
        return allTransactions.size();
    }

    private int exportPlayerProfilesToWriter(FileWriter writer) throws IOException {
        List<PlayerProfile> topPlayers = this.plugin.getDatabase().getTopPlayersByTransactions(1000);
        for (PlayerProfile profile : topPlayers) {
            writer.write(String.format("%s,%s,%s,%s,%d,%.2f,%.2f,%.2f,%.2f,%d,%s,%s\n", profile.getPlayerUUID().toString(), profile.getPlayerName(), new Date(profile.getFirstSeen()), new Date(profile.getLastActivity()), profile.getTotalTransactions(), profile.getTotalSpent(), profile.getTotalEarned(), profile.getLargestTransaction(), profile.getAverageTransaction(), profile.getRiskScore(), profile.getRiskLevel(), profile.isMonitored()));
        }
        return topPlayers.size();
    }

    public static interface ExportCallback {
        public void onSuccess(String var1, int var2);

        public void onError(String var1);
    }
}

