/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.Alert;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class AlertDetailsGUI
extends BaseGUI {
    private final Alert alert;
    private boolean isResolved = false;

    public AlertDetailsGUI(AuditorPlugin plugin, Player player, Alert alert) {
        super(plugin, player, "\u00a7c\u00a7lAlert Details: " + alert.getTitle(), 54);
        this.alert = alert;
        this.isResolved = alert.isResolved();
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        this.inventory.setItem(4, this.createAlertInfoItem());
        this.inventory.setItem(13, this.createSeverityItem());
        this.inventory.setItem(22, this.createPlayerInfoItem());
        this.inventory.setItem(31, this.createTransactionInfoItem());
        this.inventory.setItem(40, this.createResolveToggleItem());
        this.inventory.setItem(42, this.createInvestigatePlayerItem());
        this.inventory.setItem(44, this.createRecommendedActionsItem());
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createRefreshItem());
        this.inventory.setItem(53, this.createExportItem());
    }

    private ItemStack createAlertInfoItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Detailed alert information");
        lore.add("");
        lore.add("\u00a7bAlert ID: \u00a7f" + this.alert.getId());
        lore.add("\u00a7bTitle: \u00a7f" + this.alert.getTitle());
        lore.add("\u00a7bDescription: \u00a7f" + this.alert.getDescription());
        lore.add("\u00a7bAlert Type: \u00a7f" + this.alert.getAlertType());
        lore.add("\u00a7bCreated: \u00a7f" + this.formatTime(this.alert.getCreatedAt()));
        lore.add("\u00a7bAuto-Generated: " + (this.alert.isAutoGenerated() ? "\u00a7aYes" : "\u00a77No"));
        if (this.isResolved) {
            lore.add("");
            lore.add("\u00a7aResolved: \u00a7f" + this.formatTime(this.alert.getResolvedAt()));
            lore.add("\u00a7aResolved By: \u00a7f" + (this.alert.getResolvedBy() != null ? this.alert.getResolvedBy() : "Unknown"));
        }
        return this.createItem(Material.BOOK, "\u00a76\u00a7lAlert Information", lore);
    }

    private ItemStack createSeverityItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Alert severity and priority level");
        lore.add("");
        lore.add("\u00a7bSeverity: " + this.getSeverityColor(this.alert.getSeverity()) + this.alert.getSeverity());
        lore.add("");
        switch (this.alert.getSeverity().toUpperCase()) {
            case "CRITICAL": {
                lore.add("\u00a7c\u00a7lCRITICAL PRIORITY:");
                lore.add("\u00a7c\u2022 Immediate investigation required");
                lore.add("\u00a7c\u2022 Potential security threat");
                lore.add("\u00a7c\u2022 High impact on economy");
                break;
            }
            case "HIGH": {
                lore.add("\u00a76\u00a7lHIGH PRIORITY:");
                lore.add("\u00a76\u2022 Investigation recommended");
                lore.add("\u00a76\u2022 Significant impact possible");
                lore.add("\u00a76\u2022 Monitor closely");
                break;
            }
            case "MEDIUM": {
                lore.add("\u00a7e\u00a7lMEDIUM PRIORITY:");
                lore.add("\u00a7e\u2022 Monitor situation");
                lore.add("\u00a7e\u2022 Review if pattern continues");
                lore.add("\u00a7e\u2022 Moderate concern");
                break;
            }
            case "LOW": {
                lore.add("\u00a7a\u00a7lLOW PRIORITY:");
                lore.add("\u00a7a\u2022 Informational only");
                lore.add("\u00a7a\u2022 No immediate action required");
                lore.add("\u00a7a\u2022 Routine monitoring");
            }
        }
        Material material = this.getSeverityMaterial(this.alert.getSeverity());
        return this.createItem(material, this.getSeverityColor(this.alert.getSeverity()) + "\u00a7lSeverity: " + this.alert.getSeverity(), lore);
    }

    private ItemStack createPlayerInfoItem() {
        ArrayList<String> lore = new ArrayList<String>();
        if (this.alert.getPlayerUUID() != null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.alert.getPlayerUUID());
            String playerName = offlinePlayer.getName() != null ? offlinePlayer.getName() : "Unknown";
            lore.add("\u00a77Related player information");
            lore.add("");
            lore.add("\u00a7bPlayer: \u00a7f" + playerName);
            lore.add("\u00a7bPlayer UUID: \u00a7f" + this.alert.getPlayerUUID().toString());
            lore.add("\u00a7bStatus: " + (offlinePlayer.isOnline() ? "\u00a7aOnline" : "\u00a77Offline"));
            if (offlinePlayer.isOnline()) {
                lore.add("\u00a7bJoined: \u00a7f" + this.formatTime(offlinePlayer.getFirstPlayed()));
                lore.add("\u00a7bLast Seen: \u00a7fCurrently Online");
            } else {
                lore.add("\u00a7bFirst Played: \u00a7f" + this.formatTime(offlinePlayer.getFirstPlayed()));
                lore.add("\u00a7bLast Seen: \u00a7f" + this.formatTime(offlinePlayer.getLastPlayed()));
            }
            lore.add("");
            lore.add("\u00a7eClick to analyze this player");
        } else {
            lore.add("\u00a77No specific player associated");
            lore.add("");
            lore.add("\u00a77This alert is system-wide");
            lore.add("\u00a77or related to general activity");
        }
        Material material = this.alert.getPlayerUUID() != null ? Material.PLAYER_HEAD : Material.BARRIER;
        String title = this.alert.getPlayerUUID() != null ? "\u00a7b\u00a7lRelated Player" : "\u00a77\u00a7lNo Player";
        return this.createItem(material, title, lore);
    }

    private ItemStack createTransactionInfoItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Transaction-related information");
        lore.add("");
        if (this.alert.getTransactionId() > 0L) {
            lore.add("\u00a7bTransaction ID: \u00a7f" + this.alert.getTransactionId());
            lore.add("\u00a7bTransaction Type: \u00a7fEconomy Activity");
            lore.add("");
            lore.add("\u00a7eClick to view transaction details");
        } else {
            lore.add("\u00a77No specific transaction associated");
            lore.add("");
            lore.add("\u00a77This alert may be related to:");
            lore.add("\u00a77\u2022 Pattern analysis");
            lore.add("\u00a77\u2022 System monitoring");
            lore.add("\u00a77\u2022 General activity detection");
        }
        Material material = this.alert.getTransactionId() > 0L ? Material.EMERALD : Material.GRAY_STAINED_GLASS;
        String title = this.alert.getTransactionId() > 0L ? "\u00a7a\u00a7lTransaction Details" : "\u00a77\u00a7lNo Transaction";
        return this.createItem(material, title, lore);
    }

    private ItemStack createResolveToggleItem() {
        ArrayList<String> lore = new ArrayList<String>();
        if (this.isResolved) {
            lore.add("\u00a77This alert has been resolved");
            lore.add("");
            lore.add("\u00a7aResolved: \u00a7f" + this.formatTime(this.alert.getResolvedAt()));
            lore.add("\u00a7aResolved By: \u00a7f" + (this.alert.getResolvedBy() != null ? this.alert.getResolvedBy() : "Unknown"));
            lore.add("");
            lore.add("\u00a7cClick to reopen this alert");
        } else {
            lore.add("\u00a77Mark this alert as resolved");
            lore.add("");
            lore.add("\u00a77This will:");
            lore.add("\u00a77\u2022 Remove from active alerts");
            lore.add("\u00a77\u2022 Record resolution time");
            lore.add("\u00a77\u2022 Log your name as resolver");
            lore.add("");
            lore.add("\u00a7aClick to resolve alert");
        }
        Material material = this.isResolved ? Material.RED_STAINED_GLASS : Material.LIME_STAINED_GLASS;
        String title = this.isResolved ? "\u00a7c\u00a7lReopen Alert" : "\u00a7a\u00a7lResolve Alert";
        return this.createItem(material, title, lore);
    }

    private ItemStack createInvestigatePlayerItem() {
        ArrayList<String> lore = new ArrayList<String>();
        if (this.alert.getPlayerUUID() != null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.alert.getPlayerUUID());
            String playerName = offlinePlayer.getName() != null ? offlinePlayer.getName() : "Unknown";
            lore.add("\u00a77Open player analysis for investigation");
            lore.add("");
            lore.add("\u00a7bTarget Player: \u00a7f" + playerName);
            lore.add("");
            lore.add("\u00a77This will open:");
            lore.add("\u00a77\u2022 Player analysis GUI");
            lore.add("\u00a77\u2022 Transaction history");
            lore.add("\u00a77\u2022 Risk assessment");
            lore.add("\u00a77\u2022 Flag management");
            lore.add("");
            lore.add("\u00a7eClick to investigate player");
        } else {
            lore.add("\u00a77No specific player to investigate");
            lore.add("");
            lore.add("\u00a77This alert is not player-specific");
            lore.add("\u00a77Consider reviewing:");
            lore.add("\u00a77\u2022 System settings");
            lore.add("\u00a77\u2022 Economy overview");
            lore.add("\u00a77\u2022 Global activity patterns");
        }
        Material material = this.alert.getPlayerUUID() != null ? Material.COMPASS : Material.GRAY_STAINED_GLASS;
        String title = this.alert.getPlayerUUID() != null ? "\u00a79\u00a7lInvestigate Player" : "\u00a77\u00a7lNo Investigation";
        return this.createItem(material, title, lore);
    }

    private ItemStack createRecommendedActionsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Recommended actions for this alert");
        lore.add("");
        switch (this.alert.getSeverity().toUpperCase()) {
            case "CRITICAL": {
                lore.add("\u00a7c\u00a7lIMMEDIATE ACTIONS:");
                lore.add("\u00a7c\u2022 Investigate player immediately");
                lore.add("\u00a7c\u2022 Review recent transactions");
                lore.add("\u00a7c\u2022 Consider temporary monitoring");
                lore.add("\u00a7c\u2022 Alert other staff members");
                lore.add("\u00a7c\u2022 Document findings");
                break;
            }
            case "HIGH": {
                lore.add("\u00a76\u00a7lRECOMMENDED ACTIONS:");
                lore.add("\u00a76\u2022 Investigate within 24 hours");
                lore.add("\u00a76\u2022 Review player activity");
                lore.add("\u00a76\u2022 Increase monitoring level");
                lore.add("\u00a76\u2022 Check for patterns");
                break;
            }
            case "MEDIUM": {
                lore.add("\u00a7e\u00a7lSUGGESTED ACTIONS:");
                lore.add("\u00a7e\u2022 Monitor situation");
                lore.add("\u00a7e\u2022 Review if pattern continues");
                lore.add("\u00a7e\u2022 Check weekly reports");
                lore.add("\u00a7e\u2022 Document observations");
                break;
            }
            case "LOW": {
                lore.add("\u00a7a\u00a7lOPTIONAL ACTIONS:");
                lore.add("\u00a7a\u2022 Note for future reference");
                lore.add("\u00a7a\u2022 Include in routine reports");
                lore.add("\u00a7a\u2022 Monitor as part of regular checks");
            }
        }
        lore.add("");
        lore.add("\u00a77These are AI-generated suggestions");
        lore.add("\u00a77Use your judgment for appropriate action");
        return this.createItem(Material.WRITABLE_BOOK, "\u00a7d\u00a7lRecommended Actions", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to alerts overview");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack to Alerts", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh alert information");
        lore.add("\u00a77Updates status and details");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    private ItemStack createExportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export alert details to file");
        lore.add("\u00a77Creates detailed report");
        return this.createItem(Material.PAPER, "\u00a7f\u00a7lExport Report", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 22: {
                if (this.alert.getPlayerUUID() == null) break;
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.alert.getPlayerUUID());
                String playerName = offlinePlayer.getName() != null ? offlinePlayer.getName() : "Unknown";
                this.plugin.getGUIManager().openPlayerAnalysis(this.player, playerName);
                break;
            }
            case 31: {
                if (this.alert.getTransactionId() <= 0L) break;
                this.refresh();
                break;
            }
            case 40: {
                this.toggleResolved();
                break;
            }
            case 42: {
                if (this.alert.getPlayerUUID() == null) break;
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.alert.getPlayerUUID());
                String playerName = offlinePlayer.getName() != null ? offlinePlayer.getName() : "Unknown";
                this.plugin.getGUIManager().openPlayerAnalysis(this.player, playerName);
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openAlerts(this.player);
                break;
            }
            case 49: {
                this.refresh();
                break;
            }
            case 53: {
                this.refresh();
            }
        }
    }

    private void toggleResolved() {
        boolean bl = this.isResolved = !this.isResolved;
        if (this.isResolved) {
            this.plugin.getDatabase().resolveAlert(this.alert.getId(), this.player.getName());
        } else {
            this.plugin.getDatabase().reopenAlert(this.alert.getId());
        }
        this.refresh();
    }

    private String getSeverityColor(String severity) {
        switch (severity.toUpperCase()) {
            case "LOW": {
                return "\u00a7a";
            }
            case "MEDIUM": {
                return "\u00a7e";
            }
            case "HIGH": {
                return "\u00a76";
            }
            case "CRITICAL": {
                return "\u00a7c";
            }
        }
        return "\u00a77";
    }

    private Material getSeverityMaterial(String severity) {
        switch (severity.toUpperCase()) {
            case "LOW": {
                return Material.LIME_STAINED_GLASS;
            }
            case "MEDIUM": {
                return Material.YELLOW_STAINED_GLASS;
            }
            case "HIGH": {
                return Material.ORANGE_STAINED_GLASS;
            }
            case "CRITICAL": {
                return Material.RED_STAINED_GLASS;
            }
        }
        return Material.GRAY_STAINED_GLASS;
    }
}

