/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.Alert;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class AlertsGUI
extends BaseGUI {
    private final List<Alert> alerts;
    private int currentPage;
    private final int itemsPerPage = 28;

    public AlertsGUI(AuditorPlugin plugin, Player player) {
        super(plugin, player, "\u00a7c\u00a7lActive Alerts", 54);
        this.alerts = plugin.getDatabase().getActiveAlerts();
        this.currentPage = 0;
    }

    @Override
    protected void setupItems() {
        this.inventory.clear();
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        if (this.alerts.isEmpty()) {
            this.inventory.setItem(22, this.createNoAlertsItem());
        } else {
            this.displayAlerts();
            this.setupPagination();
        }
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createRefreshItem());
    }

    private void displayAlerts() {
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, this.alerts.size());
        int slot = 10;
        for (int i = startIndex; i < endIndex; ++i) {
            if (slot == 17 || slot == 26 || slot == 35) {
                slot += 3;
            }
            if (slot >= 44) break;
            Alert alert = this.alerts.get(i);
            this.inventory.setItem(slot, this.createAlertItem(alert, i));
            ++slot;
        }
    }

    private ItemStack createAlertItem(Alert alert, int index) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77" + alert.getDescription());
        lore.add("");
        lore.add("\u00a7bSeverity: " + this.getSeverityColor(alert.getSeverity()) + alert.getSeverity());
        lore.add("\u00a7bCreated: \u00a7f" + this.formatTime(alert.getCreatedAt()));
        if (alert.getPlayerUUID() != null) {
            lore.add("\u00a7bPlayer: \u00a7f" + alert.getPlayerUUID().toString());
        }
        lore.add("");
        lore.add("\u00a7eClick to view details and manage");
        Material material = this.getSeverityMaterial(alert.getSeverity());
        return this.createItem(material, this.getSeverityColor(alert.getSeverity()) + "\u00a7l" + alert.getTitle(), lore);
    }

    private ItemStack createNoAlertsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77No active alerts at this time");
        lore.add("");
        lore.add("\u00a7aYour economy is running smoothly!");
        return this.createItem(Material.LIME_STAINED_GLASS, "\u00a7a\u00a7lNo Active Alerts", lore);
    }

    private void setupPagination() {
        ArrayList<String> lore;
        int totalPages = (int)Math.ceil((double)this.alerts.size() / 28.0);
        if (this.currentPage > 0) {
            lore = new ArrayList<String>();
            lore.add("\u00a77Go to previous page");
            lore.add("\u00a77Page " + this.currentPage + " of " + totalPages);
            this.inventory.setItem(48, this.createItem(Material.ARROW, "\u00a7a\u00a7lPrevious Page", lore));
        }
        if (this.currentPage < totalPages - 1) {
            lore = new ArrayList();
            lore.add("\u00a77Go to next page");
            lore.add("\u00a77Page " + (this.currentPage + 2) + " of " + totalPages);
            this.inventory.setItem(50, this.createItem(Material.ARROW, "\u00a7a\u00a7lNext Page", lore));
        }
        ArrayList<String> pageInfo = new ArrayList<String>();
        pageInfo.add("\u00a77Total Alerts: \u00a7f" + this.alerts.size());
        pageInfo.add("\u00a77Current Page: \u00a7f" + (this.currentPage + 1) + "/" + totalPages);
        this.inventory.setItem(4, this.createItem(Material.PAPER, "\u00a76\u00a7lPage Information", pageInfo));
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to dashboard");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack to Dashboard", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh alerts list");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    private String getSeverityColor(String severity) {
        switch (severity.toUpperCase()) {
            case "LOW": {
                return "\u00a7a";
            }
            case "MEDIUM": {
                return "\u00a7e";
            }
            case "HIGH": {
                return "\u00a76";
            }
            case "CRITICAL": {
                return "\u00a7c";
            }
        }
        return "\u00a77";
    }

    private Material getSeverityMaterial(String severity) {
        switch (severity.toUpperCase()) {
            case "LOW": {
                return Material.LIME_STAINED_GLASS;
            }
            case "MEDIUM": {
                return Material.YELLOW_STAINED_GLASS;
            }
            case "HIGH": {
                return Material.ORANGE_STAINED_GLASS;
            }
            case "CRITICAL": {
                return Material.RED_STAINED_GLASS;
            }
        }
        return Material.GRAY_STAINED_GLASS;
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 45: {
                this.plugin.getGUIManager().openDashboard(this.player);
                break;
            }
            case 48: {
                if (this.currentPage <= 0) break;
                --this.currentPage;
                this.setupItems();
                break;
            }
            case 49: {
                this.alerts.clear();
                this.alerts.addAll(this.plugin.getDatabase().getActiveAlerts());
                this.currentPage = 0;
                this.setupItems();
                break;
            }
            case 50: {
                int totalPages = (int)Math.ceil((double)this.alerts.size() / 28.0);
                if (this.currentPage >= totalPages - 1) break;
                ++this.currentPage;
                this.setupItems();
                break;
            }
            default: {
                int alertIndex = this.getAlertIndexFromSlot(slot);
                if (alertIndex < 0 || alertIndex >= this.alerts.size()) break;
                Alert alert = this.alerts.get(alertIndex);
                this.plugin.getGUIManager().openAlertDetails(this.player, alert);
            }
        }
    }

    private int getAlertIndexFromSlot(int slot) {
        if (slot < 10 || slot > 43) {
            return -1;
        }
        int row = (slot - 10) / 9;
        int col = (slot - 10) % 9;
        if (col > 6) {
            return -1;
        }
        int slotInPage = row * 7 + col;
        return this.currentPage * 28 + slotInPage;
    }
}

