/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class BaseGUI {
    protected final AuditorPlugin plugin;
    protected final Player player;
    protected final Inventory inventory;
    protected final int size;
    protected final String title;

    public BaseGUI(AuditorPlugin plugin, Player player, String title, int size) {
        this.plugin = plugin;
        this.player = player;
        this.title = title;
        this.size = size;
        this.inventory = Bukkit.createInventory(null, (int)size, (String)title);
    }

    public void open() {
        this.setupItems();
        this.player.openInventory(this.inventory);
    }

    public void refresh() {
        this.inventory.clear();
        this.setupItems();
    }

    protected abstract void setupItems();

    public abstract void handleClick(int var1, ClickType var2);

    public Inventory getInventory() {
        return this.inventory;
    }

    protected ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    protected ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    protected void fillBorder(Material material) {
        int i;
        ItemStack borderItem = this.createItem(material, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, borderItem);
        }
        for (i = this.size - 9; i < this.size; ++i) {
            this.inventory.setItem(i, borderItem);
        }
        for (i = 9; i < this.size - 9; i += 9) {
            this.inventory.setItem(i, borderItem);
            this.inventory.setItem(i + 8, borderItem);
        }
    }

    protected String formatNumber(double number) {
        if (number >= 1000000.0) {
            return String.format("%.1fM", number / 1000000.0);
        }
        if (number >= 1000.0) {
            return String.format("%.1fK", number / 1000.0);
        }
        return String.format("%.2f", number);
    }

    protected String formatTime(long timestamp) {
        long diff = System.currentTimeMillis() - timestamp;
        long seconds = diff / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d ago";
        }
        if (hours > 0L) {
            return hours + "h ago";
        }
        if (minutes > 0L) {
            return minutes + "m ago";
        }
        return seconds + "s ago";
    }
}

