/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.Alert;
import com.auditor.plugin.models.PlayerProfile;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class DashboardGUI
extends BaseGUI {
    public DashboardGUI(AuditorPlugin plugin, Player player) {
        super(plugin, player, "\u00a76\u00a7lAuditor Dashboard", 54);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        this.inventory.setItem(10, this.createEconomyHealthItem());
        this.inventory.setItem(12, this.createPlayerAnalysisItem());
        this.inventory.setItem(14, this.createAlertsItem());
        this.inventory.setItem(16, this.createReportsItem());
        this.inventory.setItem(28, this.createTransactionVolumeItem());
        this.inventory.setItem(30, this.createTopPlayersItem());
        this.inventory.setItem(32, this.createSettingsItem());
        this.inventory.setItem(34, this.createExportItem());
        this.inventory.setItem(49, this.createRefreshItem());
    }

    private ItemStack createEconomyHealthItem() {
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        double monthVolume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        List<Alert> alerts = this.plugin.getDatabase().getActiveAlerts();
        double healthScore = this.calculateHealthScore(monthVolume, totalPlayers, alerts.size());
        String healthStatus = this.getHealthStatus(healthScore);
        String healthColor = this.getHealthColor(healthScore);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77View the overall health of");
        lore.add("\u00a77your server's economy");
        lore.add("");
        lore.add("\u00a7bHealth Score: " + healthColor + String.format("%.1f/100", healthScore));
        lore.add("\u00a7bStatus: " + healthColor + healthStatus);
        lore.add("\u00a7bActive Players: \u00a7f" + totalPlayers);
        lore.add("\u00a7bMonthly Volume: \u00a7f$" + this.formatNumber(monthVolume));
        lore.add("\u00a7bActive Alerts: \u00a7f" + alerts.size());
        lore.add("");
        lore.add("\u00a7eClick to view details");
        return this.createItem(Material.EMERALD, "\u00a7a\u00a7lEconomy Health", lore);
    }

    private ItemStack createPlayerAnalysisItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Analyze individual player");
        lore.add("\u00a77transaction patterns and behavior");
        lore.add("");
        lore.add("\u00a7eClick to search players");
        return this.createItem(Material.PLAYER_HEAD, "\u00a7b\u00a7lPlayer Analysis", lore);
    }

    private ItemStack createAlertsItem() {
        List<Alert> activeAlerts = this.plugin.getDatabase().getActiveAlerts();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77View and manage active alerts");
        lore.add("");
        lore.add("\u00a7cActive Alerts: \u00a7f" + activeAlerts.size());
        if (!activeAlerts.isEmpty()) {
            lore.add("");
            lore.add("\u00a7cRecent Alerts:");
            for (int i = 0; i < Math.min(3, activeAlerts.size()); ++i) {
                Alert alert = activeAlerts.get(i);
                lore.add("\u00a77- " + alert.getTitle());
            }
        }
        lore.add("");
        lore.add("\u00a7eClick to view all alerts");
        Material material = activeAlerts.isEmpty() ? Material.LIME_STAINED_GLASS : Material.RED_STAINED_GLASS;
        return this.createItem(material, "\u00a7c\u00a7lAlerts", lore);
    }

    private ItemStack createReportsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Generate detailed reports");
        lore.add("\u00a77about economy activity");
        lore.add("");
        lore.add("\u00a7eClick to access reports");
        return this.createItem(Material.BOOK, "\u00a76\u00a7lReports", lore);
    }

    private ItemStack createTransactionVolumeItem() {
        int todayTransactions = this.plugin.getDatabase().getTransactionCount(1L);
        double todayVolume = this.plugin.getDatabase().getTotalTransactionVolume(1L);
        int weeklyTransactions = this.plugin.getDatabase().getTransactionCount(7L);
        double weeklyVolume = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77View transaction volume");
        lore.add("\u00a77and activity statistics");
        lore.add("");
        lore.add("\u00a7bToday's Transactions: \u00a7f" + todayTransactions);
        lore.add("\u00a7bToday's Volume: \u00a7f$" + this.formatNumber(todayVolume));
        lore.add("\u00a7bWeekly Transactions: \u00a7f" + weeklyTransactions);
        lore.add("\u00a7bWeekly Volume: \u00a7f$" + this.formatNumber(weeklyVolume));
        lore.add("");
        lore.add("\u00a7eClick for detailed stats");
        return this.createItem(Material.GOLD_INGOT, "\u00a7e\u00a7lTransaction Volume", lore);
    }

    private ItemStack createTopPlayersItem() {
        List<PlayerProfile> topPlayers = this.plugin.getDatabase().getTopPlayersByTransactions(3);
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77View top players by");
        lore.add("\u00a77various economic metrics");
        lore.add("");
        lore.add("\u00a7bTotal Players: \u00a7f" + totalPlayers);
        if (!topPlayers.isEmpty()) {
            lore.add("\u00a7bTop 3 Most Active:");
            for (int i = 0; i < topPlayers.size(); ++i) {
                PlayerProfile profile = topPlayers.get(i);
                lore.add("\u00a77" + (i + 1) + ". " + profile.getPlayerName() + " (" + profile.getTotalTransactions() + ")");
            }
        } else {
            lore.add("\u00a77No player data available yet");
        }
        lore.add("");
        lore.add("\u00a7eClick to view rankings");
        return this.createItem(Material.DIAMOND, "\u00a7b\u00a7lTop Players", lore);
    }

    private ItemStack createSettingsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Configure Auditor settings");
        lore.add("\u00a77and monitoring options");
        lore.add("");
        lore.add("\u00a7eClick to open settings");
        return this.createItem(Material.REDSTONE, "\u00a7c\u00a7lSettings", lore);
    }

    private ItemStack createExportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export data for external");
        lore.add("\u00a77analysis and reporting");
        lore.add("");
        lore.add("\u00a7eClick to export data");
        return this.createItem(Material.PAPER, "\u00a7f\u00a7lExport Data", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh dashboard data");
        lore.add("");
        lore.add("\u00a7eClick to refresh");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 10: {
                this.showEconomyHealthSummary();
                break;
            }
            case 12: {
                this.plugin.getGUIManager().openPlayerSelection(this.player);
                break;
            }
            case 14: {
                this.plugin.getGUIManager().openAlerts(this.player);
                break;
            }
            case 16: {
                this.plugin.getGUIManager().openReports(this.player);
                break;
            }
            case 28: {
                this.plugin.getGUIManager().openTransactionVolume(this.player);
                break;
            }
            case 30: {
                this.plugin.getGUIManager().openTopPlayers(this.player);
                break;
            }
            case 32: {
                this.plugin.getGUIManager().openSettings(this.player);
                break;
            }
            case 34: {
                this.player.closeInventory();
                this.player.sendMessage("\u00a76[Auditor] \u00a7eTo export data, use: \u00a7f/auditor export <transactions|profiles|alerts>");
                break;
            }
            case 49: {
                this.refresh();
                this.player.sendMessage("\u00a76[Auditor] \u00a7aDashboard refreshed!");
            }
        }
    }

    private double calculateHealthScore(double monthVolume, int totalPlayers, int alertCount) {
        double volumeScore = Math.min(monthVolume / 10000.0 * 25.0, 25.0);
        double playerScore = Math.min((double)totalPlayers / 50.0 * 25.0, 25.0);
        double activityScore = 25.0;
        double alertScore = alertCount < 5 ? 25.0 : (double)(25 - (alertCount - 5) * 2);
        return Math.min(100.0, volumeScore + playerScore + activityScore + Math.max(0.0, alertScore));
    }

    private String getHealthStatus(double score) {
        if (score >= 80.0) {
            return "Excellent";
        }
        if (score >= 60.0) {
            return "Good";
        }
        if (score >= 40.0) {
            return "Fair";
        }
        if (score >= 20.0) {
            return "Poor";
        }
        return "Critical";
    }

    private String getHealthColor(double score) {
        if (score >= 80.0) {
            return "\u00a7a";
        }
        if (score >= 60.0) {
            return "\u00a7e";
        }
        if (score >= 40.0) {
            return "\u00a76";
        }
        if (score >= 20.0) {
            return "\u00a7c";
        }
        return "\u00a74";
    }

    private void showEconomyHealthSummary() {
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        double monthVolume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        List<Alert> alerts = this.plugin.getDatabase().getActiveAlerts();
        double healthScore = this.calculateHealthScore(monthVolume, totalPlayers, alerts.size());
        String healthStatus = this.getHealthStatus(healthScore);
        this.player.sendMessage("\u00a76[Auditor] \u00a7eEconomy Health Summary:");
        this.player.sendMessage("\u00a77\u2022 Health Score: " + this.getHealthColor(healthScore) + String.format("%.1f/100", healthScore));
        this.player.sendMessage("\u00a77\u2022 Status: " + this.getHealthColor(healthScore) + healthStatus);
        this.player.sendMessage("\u00a77\u2022 Active Players: \u00a7f" + totalPlayers);
        this.player.sendMessage("\u00a77\u2022 Monthly Volume: \u00a7f$" + this.formatNumber(monthVolume));
        this.player.sendMessage("\u00a77\u2022 Active Alerts: \u00a7f" + alerts.size());
        this.player.sendMessage("\u00a77Use the Reports section for detailed analysis.");
    }
}

