/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.exports.DataExporter;
import com.auditor.plugin.gui.BaseGUI;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ExportSettingsGUI
extends BaseGUI {
    private final DataExporter exporter;
    private String selectedExportType = "transactions";
    private String selectedPlayer = "all";
    private int selectedTimeframe = 30;

    public ExportSettingsGUI(AuditorPlugin plugin, Player player) {
        super(plugin, player, "\u00a7f\u00a7lData Export Settings", 54);
        this.exporter = new DataExporter(plugin);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        this.inventory.setItem(4, this.createExportOverviewItem());
        this.inventory.setItem(10, this.createTransactionExportItem());
        this.inventory.setItem(11, this.createPlayerProfileExportItem());
        this.inventory.setItem(12, this.createAlertExportItem());
        this.inventory.setItem(13, this.createCustomExportItem());
        this.inventory.setItem(19, this.createAllPlayersItem());
        this.inventory.setItem(20, this.createSpecificPlayerItem());
        this.inventory.setItem(21, this.createOnlinePlayersItem());
        this.inventory.setItem(22, this.createTopPlayersItem());
        this.inventory.setItem(28, this.createTimeframe7DaysItem());
        this.inventory.setItem(29, this.createTimeframe30DaysItem());
        this.inventory.setItem(30, this.createTimeframe90DaysItem());
        this.inventory.setItem(31, this.createTimeframeAllTimeItem());
        this.inventory.setItem(37, this.createFormatSettingsItem());
        this.inventory.setItem(38, this.createFilterSettingsItem());
        this.inventory.setItem(39, this.createAdvancedOptionsItem());
        this.inventory.setItem(43, this.createPreviewExportItem());
        this.inventory.setItem(44, this.createExecuteExportItem());
        this.inventory.setItem(46, this.createRecentExportsItem());
        this.inventory.setItem(47, this.createExportHistoryItem());
        this.inventory.setItem(48, this.createCleanupExportsItem());
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createRefreshItem());
        this.inventory.setItem(53, this.createExportFolderItem());
    }

    private ItemStack createExportOverviewItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Data export configuration and management");
        lore.add("");
        lore.add("\u00a7e\u00a7lCurrent Selection:");
        lore.add("\u00a7bExport Type: \u00a7f" + this.formatExportType(this.selectedExportType));
        lore.add("\u00a7bTarget: \u00a7f" + (this.selectedPlayer.equals("all") ? "All Players" : this.selectedPlayer));
        lore.add("\u00a7bTimeframe: \u00a7f" + this.formatTimeframe(this.selectedTimeframe));
        lore.add("");
        lore.add("\u00a7bExport Directory: \u00a7f/plugins/Auditor/exports/");
        lore.add("\u00a7bFormat: \u00a7fCSV");
        lore.add("");
        lore.add("\u00a77Configure your export below, then click");
        lore.add("\u00a77the execute button to generate the file");
        return this.createItem(Material.CHEST, "\u00a7f\u00a7lExport Configuration", lore);
    }

    private ItemStack createTransactionExportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export transaction data");
        lore.add("");
        lore.add("\u00a7e\u00a7lTransaction Export Includes:");
        lore.add("\u00a77\u2022 Transaction ID and timestamp");
        lore.add("\u00a77\u2022 Player UUID and name");
        lore.add("\u00a77\u2022 Transaction amount and type");
        lore.add("\u00a77\u2022 Source plugin and command");
        lore.add("\u00a77\u2022 Balance before/after");
        lore.add("\u00a77\u2022 Location data (if enabled)");
        lore.add("\u00a77\u2022 Additional metadata");
        lore.add("");
        lore.add("\u00a7bEstimated Records: \u00a7f" + this.plugin.getDatabase().getTransactionCount(this.selectedTimeframe));
        lore.add("");
        boolean selected = this.selectedExportType.equals("transactions");
        if (selected) {
            lore.add("\u00a7a\u2713 Currently selected");
        } else {
            lore.add("\u00a7eClick to select");
        }
        Material material = selected ? Material.LIME_STAINED_GLASS : Material.EMERALD;
        return this.createItem(material, "\u00a7a\u00a7lTransaction Data", lore);
    }

    private ItemStack createPlayerProfileExportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export player profile data");
        lore.add("");
        lore.add("\u00a7e\u00a7lPlayer Profile Export Includes:");
        lore.add("\u00a77\u2022 Player UUID and name");
        lore.add("\u00a77\u2022 First seen and last activity");
        lore.add("\u00a77\u2022 Total transactions and amounts");
        lore.add("\u00a77\u2022 Largest transaction recorded");
        lore.add("\u00a77\u2022 Risk score and level");
        lore.add("\u00a77\u2022 Active flags");
        lore.add("\u00a77\u2022 Administrative notes");
        lore.add("\u00a77\u2022 Monitoring status");
        lore.add("");
        lore.add("\u00a7bEstimated Records: \u00a7f" + this.getPlayerProfileCount());
        lore.add("");
        boolean selected = this.selectedExportType.equals("profiles");
        if (selected) {
            lore.add("\u00a7a\u2713 Currently selected");
        } else {
            lore.add("\u00a7eClick to select");
        }
        Material material = selected ? Material.LIME_STAINED_GLASS : Material.PLAYER_HEAD;
        return this.createItem(material, "\u00a7b\u00a7lPlayer Profiles", lore);
    }

    private ItemStack createAlertExportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export alert and notification data");
        lore.add("");
        lore.add("\u00a7e\u00a7lAlert Export Includes:");
        lore.add("\u00a77\u2022 Alert ID and type");
        lore.add("\u00a77\u2022 Title and description");
        lore.add("\u00a77\u2022 Severity level");
        lore.add("\u00a77\u2022 Related player UUID");
        lore.add("\u00a77\u2022 Transaction ID (if applicable)");
        lore.add("\u00a77\u2022 Creation timestamp");
        lore.add("\u00a77\u2022 Resolution data");
        lore.add("\u00a77\u2022 Auto-generation flag");
        lore.add("");
        lore.add("\u00a7bActive Alerts: \u00a7f" + this.plugin.getDatabase().getActiveAlerts().size());
        lore.add("\u00a7bTotal Alerts: \u00a7f" + this.getAllAlertsCount());
        lore.add("");
        boolean selected = this.selectedExportType.equals("alerts");
        if (selected) {
            lore.add("\u00a7a\u2713 Currently selected");
        } else {
            lore.add("\u00a7eClick to select");
        }
        Material material = selected ? Material.LIME_STAINED_GLASS : Material.REDSTONE_TORCH;
        return this.createItem(material, "\u00a7c\u00a7lAlert Data", lore);
    }

    private ItemStack createCustomExportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Create custom export with filters");
        lore.add("");
        lore.add("\u00a7e\u00a7lCustom Export Options:");
        lore.add("\u00a77\u2022 Combine multiple data types");
        lore.add("\u00a77\u2022 Apply advanced filters");
        lore.add("\u00a77\u2022 Specify custom date ranges");
        lore.add("\u00a77\u2022 Include/exclude specific fields");
        lore.add("");
        lore.add("\u00a76\u00a7lAdvanced Features:");
        lore.add("\u00a77\u2022 Risk level filtering");
        lore.add("\u00a77\u2022 Transaction type filtering");
        lore.add("\u00a77\u2022 Amount range filtering");
        lore.add("\u00a77\u2022 Player flag filtering");
        lore.add("");
        lore.add("\u00a77This option provides maximum flexibility");
        lore.add("\u00a77for specialized export requirements");
        boolean selected = this.selectedExportType.equals("custom");
        if (selected) {
            lore.add("");
            lore.add("\u00a7a\u2713 Currently selected");
        } else {
            lore.add("");
            lore.add("\u00a7eClick to select");
        }
        Material material = selected ? Material.LIME_STAINED_GLASS : Material.COMMAND_BLOCK;
        return this.createItem(material, "\u00a7d\u00a7lCustom Export", lore);
    }

    private ItemStack createAllPlayersItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export data for all players");
        lore.add("");
        lore.add("\u00a7bTotal Players in Database: \u00a7f" + this.getPlayerProfileCount());
        lore.add("\u00a7bOnline Players: \u00a7f" + Bukkit.getOnlinePlayers().size());
        lore.add("\u00a7bOffline Players: \u00a7f" + (this.getPlayerProfileCount() - Bukkit.getOnlinePlayers().size()));
        lore.add("");
        lore.add("\u00a77This will include all players who have");
        lore.add("\u00a77transaction data in the database");
        lore.add("");
        boolean selected = this.selectedPlayer.equals("all");
        if (selected) {
            lore.add("\u00a7a\u2713 Currently selected");
        } else {
            lore.add("\u00a7eClick to select");
        }
        Material material = selected ? Material.LIME_STAINED_GLASS : Material.EMERALD_BLOCK;
        return this.createItem(material, "\u00a7a\u00a7lAll Players", lore);
    }

    private ItemStack createSpecificPlayerItem() {
        boolean selected;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export data for a specific player");
        lore.add("");
        if (!this.selectedPlayer.equals("all")) {
            lore.add("\u00a7bSelected Player: \u00a7f" + this.selectedPlayer);
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)this.selectedPlayer);
            lore.add("\u00a7bStatus: " + (target.isOnline() ? "\u00a7aOnline" : "\u00a77Offline"));
            lore.add("\u00a7bLast Seen: \u00a7f" + this.formatTime(target.getLastPlayed()));
            lore.add("");
        }
        lore.add("\u00a77Enter a player name to export only");
        lore.add("\u00a77their data. Useful for investigations");
        lore.add("\u00a77or specific player analysis");
        lore.add("");
        lore.add("\u00a7e\u00a7lHow to Select:");
        lore.add("\u00a77Right-click to open player selection");
        lore.add("\u00a77or use /auditor export <type> <player>");
        lore.add("");
        boolean bl = selected = !this.selectedPlayer.equals("all");
        if (selected) {
            lore.add("\u00a7a\u2713 Currently selected: " + this.selectedPlayer);
        } else {
            lore.add("\u00a7eClick to select a specific player");
        }
        Material material = selected ? Material.LIME_STAINED_GLASS : Material.PLAYER_HEAD;
        return this.createItem(material, "\u00a7b\u00a7lSpecific Player", lore);
    }

    private ItemStack createOnlinePlayersItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export data for currently online players");
        lore.add("");
        lore.add("\u00a7bCurrently Online: \u00a7f" + Bukkit.getOnlinePlayers().size());
        lore.add("");
        if (Bukkit.getOnlinePlayers().size() <= 10) {
            lore.add("\u00a7e\u00a7lOnline Players:");
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                lore.add("\u00a77\u2022 \u00a7f" + onlinePlayer.getName());
            }
        } else {
            lore.add("\u00a77Too many players to list");
            lore.add("\u00a77(" + Bukkit.getOnlinePlayers().size() + " players online)");
        }
        lore.add("");
        lore.add("\u00a77Export will include all currently");
        lore.add("\u00a77connected players' data");
        lore.add("");
        lore.add("\u00a7eClick to select online players only");
        return this.createItem(Material.LIME_CONCRETE, "\u00a72\u00a7lOnline Players", lore);
    }

    private ItemStack createTopPlayersItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export data for top players by activity");
        lore.add("");
        lore.add("\u00a7e\u00a7lTop Player Categories:");
        lore.add("\u00a77\u2022 Most transactions");
        lore.add("\u00a77\u2022 Highest spending");
        lore.add("\u00a77\u2022 Largest earnings");
        lore.add("\u00a77\u2022 Recent activity");
        lore.add("");
        lore.add("\u00a7bDefault: \u00a7fTop 100 by transactions");
        lore.add("");
        lore.add("\u00a77This export focuses on the most");
        lore.add("\u00a77active players in your economy");
        lore.add("");
        lore.add("\u00a7eClick to select top players");
        return this.createItem(Material.GOLD_BLOCK, "\u00a76\u00a7lTop Players", lore);
    }

    private ItemStack createTimeframe7DaysItem() {
        boolean selected = this.selectedTimeframe == 7;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export data from the last 7 days");
        lore.add("");
        lore.add("\u00a7bTransactions: \u00a7f" + this.plugin.getDatabase().getTransactionCount(7L));
        lore.add("\u00a7bVolume: \u00a7f$" + this.formatNumber(this.plugin.getDatabase().getTotalTransactionVolume(7L)));
        lore.add("");
        lore.add("\u00a77Good for recent activity analysis");
        lore.add("");
        if (selected) {
            lore.add("\u00a7a\u2713 Currently selected");
        } else {
            lore.add("\u00a7eClick to select");
        }
        Material material = selected ? Material.LIME_STAINED_GLASS : Material.GREEN_STAINED_GLASS;
        return this.createItem(material, "\u00a7a\u00a7l7 Days", lore);
    }

    private ItemStack createTimeframe30DaysItem() {
        boolean selected = this.selectedTimeframe == 30;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export data from the last 30 days");
        lore.add("");
        lore.add("\u00a7bTransactions: \u00a7f" + this.plugin.getDatabase().getTransactionCount(30L));
        lore.add("\u00a7bVolume: \u00a7f$" + this.formatNumber(this.plugin.getDatabase().getTotalTransactionVolume(30L)));
        lore.add("");
        lore.add("\u00a77Ideal for monthly reports");
        lore.add("");
        if (selected) {
            lore.add("\u00a7a\u2713 Currently selected");
        } else {
            lore.add("\u00a7eClick to select");
        }
        Material material = selected ? Material.LIME_STAINED_GLASS : Material.YELLOW_STAINED_GLASS;
        return this.createItem(material, "\u00a7e\u00a7l30 Days", lore);
    }

    private ItemStack createTimeframe90DaysItem() {
        boolean selected = this.selectedTimeframe == 90;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export data from the last 90 days");
        lore.add("");
        lore.add("\u00a7bTransactions: \u00a7f" + this.plugin.getDatabase().getTransactionCount(90L));
        lore.add("\u00a7bVolume: \u00a7f$" + this.formatNumber(this.plugin.getDatabase().getTotalTransactionVolume(90L)));
        lore.add("");
        lore.add("\u00a77Perfect for quarterly analysis");
        lore.add("");
        if (selected) {
            lore.add("\u00a7a\u2713 Currently selected");
        } else {
            lore.add("\u00a7eClick to select");
        }
        Material material = selected ? Material.LIME_STAINED_GLASS : Material.ORANGE_STAINED_GLASS;
        return this.createItem(material, "\u00a76\u00a7l90 Days", lore);
    }

    private ItemStack createTimeframeAllTimeItem() {
        boolean selected = this.selectedTimeframe == 3650;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export all available data");
        lore.add("");
        lore.add("\u00a7bAll Transactions: \u00a7f" + this.plugin.getDatabase().getTransactionCount(3650L));
        lore.add("\u00a7bTotal Volume: \u00a7f$" + this.formatNumber(this.plugin.getDatabase().getTotalTransactionVolume(3650L)));
        lore.add("");
        lore.add("\u00a7c\u00a7lWarning: \u00a77Large exports may take time");
        lore.add("\u00a77and create very large files");
        lore.add("");
        if (selected) {
            lore.add("\u00a7a\u2713 Currently selected");
        } else {
            lore.add("\u00a7eClick to select");
        }
        Material material = selected ? Material.LIME_STAINED_GLASS : Material.RED_STAINED_GLASS;
        return this.createItem(material, "\u00a7c\u00a7lAll Time", lore);
    }

    private ItemStack createFormatSettingsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export format configuration");
        lore.add("");
        lore.add("\u00a7e\u00a7lCurrent Format: \u00a7fCSV");
        lore.add("");
        lore.add("\u00a7b\u00a7lCSV Features:");
        lore.add("\u00a77\u2022 Excel/spreadsheet compatible");
        lore.add("\u00a77\u2022 Human-readable");
        lore.add("\u00a77\u2022 Widely supported");
        lore.add("\u00a77\u2022 Easy to import/analyze");
        lore.add("");
        lore.add("\u00a7e\u00a7lFormat Options:");
        lore.add("\u00a77\u2022 Include headers");
        lore.add("\u00a77\u2022 Custom delimiter");
        lore.add("\u00a77\u2022 Date format customization");
        lore.add("\u00a77\u2022 Number formatting");
        return this.createItem(Material.PAPER, "\u00a7f\u00a7lFormat Settings", lore);
    }

    private ItemStack createFilterSettingsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Advanced filtering options");
        lore.add("");
        lore.add("\u00a7e\u00a7lAvailable Filters:");
        lore.add("\u00a77\u2022 Transaction amount range");
        lore.add("\u00a77\u2022 Transaction type");
        lore.add("\u00a77\u2022 Player risk level");
        lore.add("\u00a77\u2022 Source plugin");
        lore.add("\u00a77\u2022 Location-based");
        lore.add("\u00a77\u2022 Flag-based");
        lore.add("");
        lore.add("\u00a7b\u00a7lCurrent Filters: \u00a77None applied");
        lore.add("");
        lore.add("\u00a7eClick to configure filters");
        return this.createItem(Material.HOPPER, "\u00a77\u00a7lFilter Settings", lore);
    }

    private ItemStack createAdvancedOptionsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Advanced export configuration");
        lore.add("");
        lore.add("\u00a7e\u00a7lAdvanced Options:");
        lore.add("\u00a77\u2022 Include balance snapshots");
        lore.add("\u00a77\u2022 Add calculated fields");
        lore.add("\u00a77\u2022 Include location data");
        lore.add("\u00a77\u2022 Export related alerts");
        lore.add("\u00a77\u2022 Include metadata");
        lore.add("");
        lore.add("\u00a7b\u00a7lFile Options:");
        lore.add("\u00a77\u2022 Compression (ZIP)");
        lore.add("\u00a77\u2022 File splitting (large exports)");
        lore.add("\u00a77\u2022 Custom filename");
        lore.add("");
        lore.add("\u00a7eClick to configure advanced options");
        return this.createItem(Material.REDSTONE, "\u00a7c\u00a7lAdvanced Options", lore);
    }

    private ItemStack createPreviewExportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Preview export before generation");
        lore.add("");
        lore.add("\u00a7e\u00a7lPreview Shows:");
        lore.add("\u00a77\u2022 Estimated file size");
        lore.add("\u00a77\u2022 Record count");
        lore.add("\u00a77\u2022 Column headers");
        lore.add("\u00a77\u2022 Sample data (first 10 rows)");
        lore.add("\u00a77\u2022 Export time estimate");
        lore.add("");
        lore.add("\u00a7bEstimated Records: \u00a7f" + this.getEstimatedRecordCount());
        lore.add("\u00a7bEstimated Size: \u00a7f" + this.getEstimatedFileSize());
        lore.add("");
        lore.add("\u00a7eClick to preview export");
        return this.createItem(Material.REDSTONE_TORCH, "\u00a79\u00a7lPreview Export", lore);
    }

    private ItemStack createExecuteExportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Generate and save export file");
        lore.add("");
        lore.add("\u00a7e\u00a7lExport Configuration:");
        lore.add("\u00a77Type: \u00a7f" + this.formatExportType(this.selectedExportType));
        lore.add("\u00a77Target: \u00a7f" + (this.selectedPlayer.equals("all") ? "All Players" : this.selectedPlayer));
        lore.add("\u00a77Timeframe: \u00a7f" + this.formatTimeframe(this.selectedTimeframe));
        lore.add("\u00a77Format: \u00a7fCSV");
        lore.add("");
        lore.add("\u00a7bEstimated Time: \u00a7f" + this.getEstimatedExportTime());
        lore.add("\u00a7bOutput File: \u00a7f" + this.getOutputFileName());
        lore.add("");
        lore.add("\u00a7a\u00a7lClick to start export");
        return this.createItem(Material.LIME_CONCRETE, "\u00a7a\u00a7lExecute Export", lore);
    }

    private ItemStack createRecentExportsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77View recently generated exports");
        lore.add("");
        File exportsDir = new File(this.plugin.getDataFolder(), "exports");
        if (exportsDir.exists()) {
            File[] files = exportsDir.listFiles((dir, name) -> name.endsWith(".csv"));
            if (files != null && files.length > 0) {
                lore.add("\u00a7e\u00a7lRecent Exports:");
                Arrays.sort(files, (a, b) -> Long.compare(b.lastModified(), a.lastModified()));
                for (int i = 0; i < Math.min(5, files.length); ++i) {
                    File file = files[i];
                    lore.add("\u00a77\u2022 \u00a7f" + file.getName());
                    lore.add("\u00a77  Size: " + this.formatFileSize(file.length()) + " | " + this.formatTime(file.lastModified()));
                }
                if (files.length > 5) {
                    lore.add("\u00a77... and " + (files.length - 5) + " more");
                }
            } else {
                lore.add("\u00a77No export files found");
            }
        } else {
            lore.add("\u00a77Export directory not created yet");
        }
        lore.add("");
        lore.add("\u00a7eClick to manage export files");
        return this.createItem(Material.BOOK, "\u00a76\u00a7lRecent Exports", lore);
    }

    private ItemStack createExportHistoryItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export history and statistics");
        lore.add("");
        lore.add("\u00a7e\u00a7lExport Statistics:");
        lore.add("\u00a77These statistics are estimates");
        lore.add("\u00a77based on available data");
        lore.add("");
        lore.add("\u00a7bTotal Exports: \u00a7f" + this.getTotalExportCount());
        lore.add("\u00a7bLargest Export: \u00a7f" + this.getLargestExportSize());
        lore.add("\u00a7bDisk Usage: \u00a7f" + this.getTotalExportDiskUsage());
        lore.add("");
        lore.add("\u00a77Export history helps track");
        lore.add("\u00a77data usage and file management");
        return this.createItem(Material.CLOCK, "\u00a75\u00a7lExport History", lore);
    }

    private ItemStack createCleanupExportsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Clean up old export files");
        lore.add("");
        File exportsDir = new File(this.plugin.getDataFolder(), "exports");
        if (exportsDir.exists()) {
            File[] files = exportsDir.listFiles((dir, name) -> name.endsWith(".csv"));
            long totalSize = 0L;
            int oldFiles = 0;
            long weekAgo = System.currentTimeMillis() - 604800000L;
            if (files != null) {
                for (File file : files) {
                    totalSize += file.length();
                    if (file.lastModified() >= weekAgo) continue;
                    ++oldFiles;
                }
                lore.add("\u00a7bTotal Files: \u00a7f" + files.length);
                lore.add("\u00a7bFiles > 7 days old: \u00a7f" + oldFiles);
                lore.add("\u00a7bTotal Size: \u00a7f" + this.formatFileSize(totalSize));
            }
        }
        lore.add("");
        lore.add("\u00a7e\u00a7lCleanup Options:");
        lore.add("\u00a77\u2022 Delete files older than 30 days");
        lore.add("\u00a77\u2022 Delete files larger than 100MB");
        lore.add("\u00a77\u2022 Keep only latest 10 exports");
        lore.add("");
        lore.add("\u00a7cClick to open cleanup options");
        return this.createItem(Material.LAVA_BUCKET, "\u00a74\u00a7lCleanup Exports", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to main settings");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack to Settings", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh export data and statistics");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    private ItemStack createExportFolderItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export folder information");
        lore.add("");
        lore.add("\u00a7bFolder Path: \u00a7f/plugins/Auditor/exports/");
        lore.add("");
        File exportsDir = new File(this.plugin.getDataFolder(), "exports");
        if (exportsDir.exists()) {
            lore.add("\u00a7bFolder Status: \u00a7aExists");
            lore.add("\u00a7bWritable: " + (exportsDir.canWrite() ? "\u00a7aYes" : "\u00a7cNo"));
            lore.add("\u00a7bFree Space: \u00a7f" + this.formatFileSize(exportsDir.getFreeSpace()));
        } else {
            lore.add("\u00a7bFolder Status: \u00a77Will be created");
            lore.add("\u00a77Folder is created automatically");
            lore.add("\u00a77when first export is generated");
        }
        lore.add("");
        lore.add("\u00a77Files are saved in CSV format");
        lore.add("\u00a77and can be opened in Excel");
        return this.createItem(Material.ENDER_CHEST, "\u00a7f\u00a7lExport Folder", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 10: {
                this.selectedExportType = "transactions";
                this.refresh();
                break;
            }
            case 11: {
                this.selectedExportType = "profiles";
                this.refresh();
                break;
            }
            case 12: {
                this.selectedExportType = "alerts";
                this.refresh();
                break;
            }
            case 13: {
                this.selectedExportType = "custom";
                this.refresh();
                break;
            }
            case 19: {
                this.selectedPlayer = "all";
                this.refresh();
                break;
            }
            case 20: {
                if (clickType == ClickType.RIGHT) {
                    this.plugin.getGUIManager().openPlayerSelection(this.player);
                    break;
                }
                this.refresh();
                break;
            }
            case 28: {
                this.selectedTimeframe = 7;
                this.refresh();
                break;
            }
            case 29: {
                this.selectedTimeframe = 30;
                this.refresh();
                break;
            }
            case 30: {
                this.selectedTimeframe = 90;
                this.refresh();
                break;
            }
            case 31: {
                this.selectedTimeframe = 3650;
                this.refresh();
                break;
            }
            case 43: {
                this.previewExport();
                break;
            }
            case 44: {
                this.executeExport();
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openSettings(this.player);
                break;
            }
            case 49: {
                this.refresh();
                break;
            }
            default: {
                this.refresh();
            }
        }
    }

    private void previewExport() {
        this.refresh();
    }

    private void executeExport() {
        switch (this.selectedExportType) {
            case "transactions": {
                if (this.selectedPlayer.equals("all")) {
                    this.exporter.exportAllTransactionsCSV(new DataExporter.ExportCallback(){

                        @Override
                        public void onSuccess(String fileName, int recordCount) {
                        }

                        @Override
                        public void onError(String error) {
                        }
                    });
                    break;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)this.selectedPlayer);
                if (target.getUniqueId() == null) break;
                this.exporter.exportTransactionsCSV(target.getUniqueId(), this.selectedPlayer, new DataExporter.ExportCallback(){

                    @Override
                    public void onSuccess(String fileName, int recordCount) {
                    }

                    @Override
                    public void onError(String error) {
                    }
                });
                break;
            }
            case "profiles": {
                this.exporter.exportPlayerProfilesCSV(new DataExporter.ExportCallback(){

                    @Override
                    public void onSuccess(String fileName, int recordCount) {
                    }

                    @Override
                    public void onError(String error) {
                    }
                });
                break;
            }
            case "alerts": {
                this.exporter.exportAlertsCSV(new DataExporter.ExportCallback(){

                    @Override
                    public void onSuccess(String fileName, int recordCount) {
                    }

                    @Override
                    public void onError(String error) {
                    }
                });
            }
        }
        this.refresh();
    }

    private String formatExportType(String type) {
        switch (type) {
            case "transactions": {
                return "Transaction Data";
            }
            case "profiles": {
                return "Player Profiles";
            }
            case "alerts": {
                return "Alert Data";
            }
            case "custom": {
                return "Custom Export";
            }
        }
        return "Unknown";
    }

    private String formatTimeframe(int days) {
        if (days == 7) {
            return "Last 7 Days";
        }
        if (days == 30) {
            return "Last 30 Days";
        }
        if (days == 90) {
            return "Last 90 Days";
        }
        if (days >= 3650) {
            return "All Time";
        }
        return days + " Days";
    }

    private int getPlayerProfileCount() {
        return this.plugin.getDatabase().getTopPlayersByTransactions(10000).size();
    }

    private int getAllAlertsCount() {
        return this.plugin.getDatabase().getActiveAlerts().size();
    }

    private int getEstimatedRecordCount() {
        switch (this.selectedExportType) {
            case "transactions": {
                return this.plugin.getDatabase().getTransactionCount(this.selectedTimeframe);
            }
            case "profiles": {
                return this.getPlayerProfileCount();
            }
            case "alerts": {
                return this.getAllAlertsCount();
            }
        }
        return 0;
    }

    private String getEstimatedFileSize() {
        int records = this.getEstimatedRecordCount();
        int avgRecordSize = this.selectedExportType.equals("transactions") ? 200 : 150;
        long estimatedBytes = records * avgRecordSize;
        return this.formatFileSize(estimatedBytes);
    }

    private String getEstimatedExportTime() {
        int records = this.getEstimatedRecordCount();
        if (records < 1000) {
            return "< 1 second";
        }
        if (records < 10000) {
            return "< 5 seconds";
        }
        if (records < 100000) {
            return "< 30 seconds";
        }
        return "1-5 minutes";
    }

    private String getOutputFileName() {
        String timestamp = String.valueOf(System.currentTimeMillis());
        return "auditor_" + this.selectedExportType + "_" + timestamp + ".csv";
    }

    private String formatFileSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes < 0x40000000L) {
            return bytes / 0x100000L + " MB";
        }
        return bytes / 0x40000000L + " GB";
    }

    private int getTotalExportCount() {
        File exportsDir = new File(this.plugin.getDataFolder(), "exports");
        if (exportsDir.exists()) {
            File[] files = exportsDir.listFiles((dir, name) -> name.endsWith(".csv"));
            return files != null ? files.length : 0;
        }
        return 0;
    }

    private String getLargestExportSize() {
        File[] files;
        File exportsDir = new File(this.plugin.getDataFolder(), "exports");
        if (exportsDir.exists() && (files = exportsDir.listFiles((dir, name) -> name.endsWith(".csv"))) != null) {
            long maxSize = 0L;
            for (File file : files) {
                maxSize = Math.max(maxSize, file.length());
            }
            return this.formatFileSize(maxSize);
        }
        return "0 B";
    }

    private String getTotalExportDiskUsage() {
        File[] files;
        File exportsDir = new File(this.plugin.getDataFolder(), "exports");
        if (exportsDir.exists() && (files = exportsDir.listFiles((dir, name) -> name.endsWith(".csv"))) != null) {
            long totalSize = 0L;
            for (File file : files) {
                totalSize += file.length();
            }
            return this.formatFileSize(totalSize);
        }
        return "0 B";
    }
}

