/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.PlayerProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class FlagManagementGUI
extends BaseGUI {
    private final String targetPlayerName;
    private final UUID targetPlayerUUID;
    private PlayerProfile profile;
    private final List<String> availableFlags = Arrays.asList("SUSPICIOUS", "HIGH_VOLUME", "WATCH_LIST", "BOT_SUSPECTED", "VIP", "TRUSTED", "PATTERN_ANOMALY", "RAPID_TRANSACTIONS", "NEW_PLAYER");

    public FlagManagementGUI(AuditorPlugin plugin, Player player, String targetPlayerName, UUID targetPlayerUUID) {
        super(plugin, player, "\u00a7c\u00a7lFlag Management: " + targetPlayerName, 54);
        this.targetPlayerName = targetPlayerName;
        this.targetPlayerUUID = targetPlayerUUID;
        this.loadPlayerProfile();
    }

    private void loadPlayerProfile() {
        this.profile = this.plugin.getDatabase().getPlayerProfile(this.targetPlayerUUID);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        if (this.profile == null) {
            this.inventory.setItem(22, this.createNoProfileItem());
            this.inventory.setItem(45, this.createBackItem());
            return;
        }
        this.inventory.setItem(4, this.createPlayerInfoItem());
        this.inventory.setItem(20, this.createCurrentStatusItem());
        this.inventory.setItem(22, this.createMonitoringToggleItem());
        this.inventory.setItem(24, this.createRiskAssessmentItem());
        this.setupFlagItems();
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(47, this.createNotesItem());
        this.inventory.setItem(49, this.createRefreshItem());
        this.inventory.setItem(51, this.createSaveItem());
    }

    private void setupFlagItems() {
        List<String> currentFlags = this.getCurrentFlags();
        int[] flagSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 28, 29, 30, 31, 32, 33, 34};
        for (int i = 0; i < Math.min(this.availableFlags.size(), flagSlots.length); ++i) {
            String flag = this.availableFlags.get(i);
            boolean isActive = currentFlags.contains(flag);
            this.inventory.setItem(flagSlots[i], this.createFlagItem(flag, isActive));
        }
    }

    private ItemStack createPlayerInfoItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Player information and statistics");
        lore.add("");
        lore.add("\u00a7bPlayer: \u00a7f" + this.targetPlayerName);
        lore.add("\u00a7bTotal Transactions: \u00a7f" + this.profile.getTotalTransactions());
        lore.add("\u00a7bTotal Spent: \u00a7f$" + this.formatNumber(this.profile.getTotalSpent()));
        lore.add("\u00a7bTotal Earned: \u00a7f$" + this.formatNumber(this.profile.getTotalEarned()));
        lore.add("\u00a7bFirst Seen: \u00a7f" + this.formatTime(this.profile.getFirstSeen()));
        lore.add("\u00a7bLast Activity: \u00a7f" + this.formatTime(this.profile.getLastActivity()));
        return this.createItem(Material.PLAYER_HEAD, "\u00a7b\u00a7l" + this.targetPlayerName, lore);
    }

    private ItemStack createCurrentStatusItem() {
        List<String> currentFlags = this.getCurrentFlags();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Current player status and flags");
        lore.add("");
        lore.add("\u00a7bRisk Level: " + this.getRiskColor(this.profile.getRiskLevel()) + this.profile.getRiskLevel());
        lore.add("\u00a7bRisk Score: \u00a7f" + this.profile.getRiskScore() + "/100");
        lore.add("\u00a7bMonitoring: " + (this.profile.isMonitored() ? "\u00a7aEnabled" : "\u00a77Disabled"));
        lore.add("");
        if (currentFlags.isEmpty()) {
            lore.add("\u00a77No flags currently set");
        } else {
            lore.add("\u00a7e\u00a7lActive Flags:");
            for (String flag : currentFlags) {
                lore.add("\u00a77\u2022 \u00a7c" + flag);
            }
        }
        return this.createItem(Material.REDSTONE_TORCH, "\u00a76\u00a7lCurrent Status", lore);
    }

    private ItemStack createMonitoringToggleItem() {
        boolean isMonitored = this.profile.isMonitored();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Toggle enhanced monitoring for this player");
        lore.add("");
        lore.add("\u00a7bCurrent Status: " + (isMonitored ? "\u00a7aEnabled" : "\u00a77Disabled"));
        lore.add("");
        if (isMonitored) {
            lore.add("\u00a77Enhanced monitoring tracks:");
            lore.add("\u00a77\u2022 All transactions in detail");
            lore.add("\u00a77\u2022 Real-time risk assessment");
            lore.add("\u00a77\u2022 Alert generation");
            lore.add("");
            lore.add("\u00a7cClick to disable monitoring");
        } else {
            lore.add("\u00a77Enable to track this player with:");
            lore.add("\u00a77\u2022 Enhanced transaction logging");
            lore.add("\u00a77\u2022 Real-time anomaly detection");
            lore.add("\u00a77\u2022 Automatic alert generation");
            lore.add("");
            lore.add("\u00a7aClick to enable monitoring");
        }
        Material material = isMonitored ? Material.LIME_STAINED_GLASS : Material.GRAY_STAINED_GLASS;
        return this.createItem(material, "\u00a79\u00a7lMonitoring Toggle", lore);
    }

    private ItemStack createRiskAssessmentItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Detailed risk assessment information");
        lore.add("");
        lore.add("\u00a7bRisk Level: " + this.getRiskColor(this.profile.getRiskLevel()) + this.profile.getRiskLevel());
        lore.add("\u00a7bRisk Score: \u00a7f" + this.profile.getRiskScore() + "/100");
        lore.add("");
        lore.add("\u00a7e\u00a7lRisk Factors:");
        if (this.profile.getRiskScore() >= 80) {
            lore.add("\u00a7c\u2022 Multiple suspicious patterns");
            lore.add("\u00a7c\u2022 Unusual transaction amounts");
            lore.add("\u00a7c\u2022 Rapid transaction frequency");
        } else if (this.profile.getRiskScore() >= 60) {
            lore.add("\u00a76\u2022 Irregular transaction patterns");
            lore.add("\u00a76\u2022 Above-average activity");
        } else if (this.profile.getRiskScore() >= 40) {
            lore.add("\u00a7e\u2022 Minor pattern irregularities");
            lore.add("\u00a7e\u2022 Occasional large transactions");
        } else {
            lore.add("\u00a7a\u2022 Normal behavior patterns");
            lore.add("\u00a7a\u2022 Standard transaction amounts");
        }
        lore.add("");
        lore.add("\u00a77Click to recalculate risk score");
        return this.createItem(Material.REDSTONE_BLOCK, "\u00a74\u00a7lRisk Assessment", lore);
    }

    private ItemStack createFlagItem(String flag, boolean isActive) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77" + this.getFlagDescription(flag));
        lore.add("");
        lore.add("\u00a7bStatus: " + (isActive ? "\u00a7aActive" : "\u00a77Inactive"));
        lore.add("");
        if (isActive) {
            lore.add("\u00a7cClick to remove this flag");
        } else {
            lore.add("\u00a7aClick to add this flag");
        }
        Material material = isActive ? this.getFlagActiveMaterial(flag) : Material.GRAY_STAINED_GLASS;
        String color = isActive ? this.getFlagColor(flag) : "\u00a77";
        return this.createItem(material, color + "\u00a7l" + flag, lore);
    }

    private ItemStack createNotesItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Manage administrative notes");
        lore.add("");
        if (this.profile.getNotes() != null && !this.profile.getNotes().isEmpty()) {
            String[] noteLines;
            lore.add("\u00a7e\u00a7lCurrent Notes:");
            for (String line : noteLines = this.profile.getNotes().split("\\n")) {
                lore.add("\u00a77" + line);
            }
        } else {
            lore.add("\u00a77No notes currently set");
        }
        lore.add("");
        lore.add("\u00a7eClick to manage notes");
        return this.createItem(Material.WRITABLE_BOOK, "\u00a7f\u00a7lAdmin Notes", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to player analysis");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh player data");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    private ItemStack createSaveItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Save all changes");
        lore.add("\u00a77Updates database with current settings");
        return this.createItem(Material.EMERALD_BLOCK, "\u00a7a\u00a7lSave Changes", lore);
    }

    private ItemStack createNoProfileItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77No profile data available");
        lore.add("\u00a77Player may not have any transactions yet");
        return this.createItem(Material.BARRIER, "\u00a7c\u00a7lNo Profile Data", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        if (this.profile == null) {
            if (slot == 45) {
                this.plugin.getGUIManager().openPlayerAnalysis(this.player, this.targetPlayerName);
            }
            return;
        }
        switch (slot) {
            case 22: {
                this.toggleMonitoring();
                break;
            }
            case 24: {
                this.recalculateRiskScore();
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openPlayerAnalysis(this.player, this.targetPlayerName);
                break;
            }
            case 47: {
                this.openNotesManagement();
                break;
            }
            case 49: {
                this.loadPlayerProfile();
                this.refresh();
                this.player.sendMessage("\u00a76[Auditor] \u00a7aPlayer data refreshed!");
                break;
            }
            case 51: {
                this.saveChanges();
                break;
            }
            default: {
                this.handleFlagClick(slot);
            }
        }
    }

    private void handleFlagClick(int slot) {
        int[] flagSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 28, 29, 30, 31, 32, 33, 34};
        for (int i = 0; i < flagSlots.length && i < this.availableFlags.size(); ++i) {
            if (flagSlots[i] != slot) continue;
            String flag = this.availableFlags.get(i);
            this.toggleFlag(flag);
            break;
        }
    }

    private void toggleFlag(String flag) {
        List<String> currentFlags = this.getCurrentFlags();
        if (currentFlags.contains(flag)) {
            currentFlags.remove(flag);
            this.player.sendMessage("\u00a76[Auditor] \u00a7cRemoved flag: \u00a7f" + flag);
        } else {
            currentFlags.add(flag);
            this.player.sendMessage("\u00a76[Auditor] \u00a7aAdded flag: \u00a7f" + flag);
        }
        String flagsString = String.join((CharSequence)",", currentFlags);
        this.plugin.getDatabase().updatePlayerFlags(this.targetPlayerUUID, flagsString);
        this.loadPlayerProfile();
        this.refresh();
    }

    private void toggleMonitoring() {
        boolean newStatus = !this.profile.isMonitored();
        this.plugin.getDatabase().updatePlayerMonitoring(this.targetPlayerUUID, newStatus);
        this.player.sendMessage("\u00a76[Auditor] \u00a7" + (newStatus ? "a" : "c") + (newStatus ? "Enabled" : "Disabled") + " monitoring for " + this.targetPlayerName);
        this.loadPlayerProfile();
        this.refresh();
    }

    private void recalculateRiskScore() {
        this.player.sendMessage("\u00a76[Auditor] \u00a7eRecalculating risk score for " + this.targetPlayerName + "...");
        List<String> currentFlags = this.getCurrentFlags();
        String flagsString = String.join((CharSequence)",", currentFlags);
        this.plugin.getDatabase().updatePlayerFlags(this.targetPlayerUUID, flagsString);
        this.loadPlayerProfile();
        this.refresh();
        this.player.sendMessage("\u00a76[Auditor] \u00a7aRisk score updated! New level: " + this.getRiskColor(this.profile.getRiskLevel()) + this.profile.getRiskLevel() + " \u00a7f(" + this.profile.getRiskScore() + "/100)");
    }

    private void openNotesManagement() {
        this.player.closeInventory();
        this.player.sendMessage("\u00a76[Auditor] \u00a7eNotes Management for " + this.targetPlayerName + ":");
        this.player.sendMessage("\u00a77Use the following commands to manage notes:");
        this.player.sendMessage("\u00a7f/auditor note " + this.targetPlayerName + " add <note> \u00a77- Add a note");
        this.player.sendMessage("\u00a7f/auditor note " + this.targetPlayerName + " remove <index> \u00a77- Remove note by number");
        this.player.sendMessage("\u00a7f/auditor note " + this.targetPlayerName + " clear \u00a77- Clear all notes");
        this.player.sendMessage("\u00a7f/auditor note " + this.targetPlayerName + " list \u00a77- List all notes");
    }

    private void saveChanges() {
        this.player.sendMessage("\u00a76[Auditor] \u00a7aSaving changes for " + this.targetPlayerName + "...");
        this.loadPlayerProfile();
        this.refresh();
        this.player.sendMessage("\u00a76[Auditor] \u00a7aAll changes confirmed and saved!");
        this.player.sendMessage("\u00a77Current flags: " + (this.profile.getFlags() != null && !this.profile.getFlags().isEmpty() ? this.profile.getFlags() : "None"));
        this.player.sendMessage("\u00a77Monitoring: " + (this.profile.isMonitored() ? "\u00a7aEnabled" : "\u00a77Disabled"));
        this.player.sendMessage("\u00a77Risk Level: " + this.getRiskColor(this.profile.getRiskLevel()) + this.profile.getRiskLevel());
    }

    private List<String> getCurrentFlags() {
        if (this.profile.getFlags() == null || this.profile.getFlags().isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(this.profile.getFlags().split(",")));
    }

    private String getFlagDescription(String flag) {
        switch (flag) {
            case "SUSPICIOUS": {
                return "Player has exhibited suspicious behavior patterns";
            }
            case "HIGH_VOLUME": {
                return "Player performs high-volume transactions";
            }
            case "WATCH_LIST": {
                return "Player requires regular monitoring";
            }
            case "BOT_SUSPECTED": {
                return "Automated behavior patterns detected";
            }
            case "VIP": {
                return "Trusted high-value player";
            }
            case "TRUSTED": {
                return "Verified trustworthy player";
            }
            case "PATTERN_ANOMALY": {
                return "Unusual transaction patterns detected";
            }
            case "RAPID_TRANSACTIONS": {
                return "Performs transactions in rapid succession";
            }
            case "NEW_PLAYER": {
                return "Recently joined player";
            }
        }
        return "Custom administrative flag";
    }

    private Material getFlagActiveMaterial(String flag) {
        switch (flag) {
            case "SUSPICIOUS": {
                return Material.RED_STAINED_GLASS;
            }
            case "HIGH_VOLUME": {
                return Material.ORANGE_STAINED_GLASS;
            }
            case "WATCH_LIST": {
                return Material.YELLOW_STAINED_GLASS;
            }
            case "BOT_SUSPECTED": {
                return Material.PURPLE_STAINED_GLASS;
            }
            case "VIP": {
                return Material.GOLD_BLOCK;
            }
            case "TRUSTED": {
                return Material.LIME_STAINED_GLASS;
            }
            case "PATTERN_ANOMALY": {
                return Material.MAGENTA_STAINED_GLASS;
            }
            case "RAPID_TRANSACTIONS": {
                return Material.LIGHT_BLUE_STAINED_GLASS;
            }
            case "NEW_PLAYER": {
                return Material.GREEN_STAINED_GLASS;
            }
        }
        return Material.WHITE_STAINED_GLASS;
    }

    private String getFlagColor(String flag) {
        switch (flag) {
            case "SUSPICIOUS": {
                return "\u00a7c";
            }
            case "HIGH_VOLUME": {
                return "\u00a76";
            }
            case "WATCH_LIST": {
                return "\u00a7e";
            }
            case "BOT_SUSPECTED": {
                return "\u00a75";
            }
            case "VIP": {
                return "\u00a7d";
            }
            case "TRUSTED": {
                return "\u00a7a";
            }
            case "PATTERN_ANOMALY": {
                return "\u00a7d";
            }
            case "RAPID_TRANSACTIONS": {
                return "\u00a7b";
            }
            case "NEW_PLAYER": {
                return "\u00a72";
            }
        }
        return "\u00a7f";
    }

    private String getRiskColor(String riskLevel) {
        switch (riskLevel.toUpperCase()) {
            case "LOW": {
                return "\u00a7a";
            }
            case "MEDIUM": {
                return "\u00a7e";
            }
            case "HIGH": {
                return "\u00a7c";
            }
            case "CRITICAL": {
                return "\u00a74";
            }
        }
        return "\u00a77";
    }
}

