/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.AlertDetailsGUI;
import com.auditor.plugin.gui.AlertsGUI;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.gui.DashboardGUI;
import com.auditor.plugin.gui.ExportSettingsGUI;
import com.auditor.plugin.gui.FlagManagementGUI;
import com.auditor.plugin.gui.IntegrationSettingsGUI;
import com.auditor.plugin.gui.MaintenanceSettingsGUI;
import com.auditor.plugin.gui.NotesManagementGUI;
import com.auditor.plugin.gui.PermissionSettingsGUI;
import com.auditor.plugin.gui.PlayerAnalysisGUI;
import com.auditor.plugin.gui.PlayerSelectionGUI;
import com.auditor.plugin.gui.ReportsGUI;
import com.auditor.plugin.gui.SettingsGUI;
import com.auditor.plugin.gui.StatisticsGUI;
import com.auditor.plugin.gui.TopPlayersGUI;
import com.auditor.plugin.gui.TransactionHistoryGUI;
import com.auditor.plugin.gui.TransactionVolumeGUI;
import com.auditor.plugin.models.Alert;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;

public class GUIManager
implements Listener {
    private final AuditorPlugin plugin;
    private final Map<UUID, BaseGUI> openGUIs;

    public GUIManager(AuditorPlugin plugin) {
        this.plugin = plugin;
        this.openGUIs = new HashMap<UUID, BaseGUI>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openDashboard(Player player) {
        DashboardGUI dashboard = new DashboardGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), dashboard);
        dashboard.open();
    }

    public void openPlayerAnalysis(Player player, String targetPlayerName) {
        PlayerAnalysisGUI analysis = new PlayerAnalysisGUI(this.plugin, player, targetPlayerName);
        this.openGUIs.put(player.getUniqueId(), analysis);
        analysis.open();
    }

    public void openAlerts(Player player) {
        AlertsGUI alerts = new AlertsGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), alerts);
        alerts.open();
    }

    public void openReports(Player player) {
        ReportsGUI reports = new ReportsGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), reports);
        reports.open();
    }

    public void openTransactionVolume(Player player) {
        TransactionVolumeGUI transactionVolume = new TransactionVolumeGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), transactionVolume);
        transactionVolume.open();
    }

    public void openTopPlayers(Player player) {
        TopPlayersGUI topPlayers = new TopPlayersGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), topPlayers);
        topPlayers.open();
    }

    public void openSettings(Player player) {
        SettingsGUI settings = new SettingsGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), settings);
        settings.open();
    }

    public void openPlayerSelection(Player player) {
        PlayerSelectionGUI playerSelection = new PlayerSelectionGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), playerSelection);
        playerSelection.open();
    }

    public void openTransactionHistory(Player player, String targetPlayerName, UUID targetPlayerUUID) {
        TransactionHistoryGUI transactionHistory = new TransactionHistoryGUI(this.plugin, player, targetPlayerName, targetPlayerUUID);
        this.openGUIs.put(player.getUniqueId(), transactionHistory);
        transactionHistory.open();
    }

    public void openFlagManagement(Player player, String targetPlayerName, UUID targetPlayerUUID) {
        FlagManagementGUI flagManagement = new FlagManagementGUI(this.plugin, player, targetPlayerName, targetPlayerUUID);
        this.openGUIs.put(player.getUniqueId(), flagManagement);
        flagManagement.open();
    }

    public void openStatistics(Player player, String statisticsType) {
        StatisticsGUI statistics = new StatisticsGUI(this.plugin, player, statisticsType);
        this.openGUIs.put(player.getUniqueId(), statistics);
        statistics.open();
    }

    public void openAlertDetails(Player player, Alert alert) {
        AlertDetailsGUI alertDetails = new AlertDetailsGUI(this.plugin, player, alert);
        this.openGUIs.put(player.getUniqueId(), alertDetails);
        alertDetails.open();
    }

    public void openPermissionSettings(Player player) {
        PermissionSettingsGUI permissionSettings = new PermissionSettingsGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), permissionSettings);
        permissionSettings.open();
    }

    public void openExportSettings(Player player) {
        ExportSettingsGUI exportSettings = new ExportSettingsGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), exportSettings);
        exportSettings.open();
    }

    public void openIntegrationSettings(Player player) {
        IntegrationSettingsGUI integrationSettings = new IntegrationSettingsGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), integrationSettings);
        integrationSettings.open();
    }

    public void openMaintenanceSettings(Player player) {
        MaintenanceSettingsGUI maintenanceSettings = new MaintenanceSettingsGUI(this.plugin, player);
        this.openGUIs.put(player.getUniqueId(), maintenanceSettings);
        maintenanceSettings.open();
    }

    public void openNotesManagement(Player player, String targetPlayerName, UUID targetPlayerUUID) {
        NotesManagementGUI notesManagement = new NotesManagementGUI(this.plugin, player, targetPlayerName, targetPlayerUUID);
        this.openGUIs.put(player.getUniqueId(), notesManagement);
        notesManagement.open();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        BaseGUI gui = this.openGUIs.get(player.getUniqueId());
        if (gui != null && event.getInventory().equals((Object)gui.getInventory())) {
            event.setCancelled(true);
            gui.handleClick(event.getSlot(), event.getClick());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        BaseGUI gui = this.openGUIs.get(player.getUniqueId());
        if (gui != null && event.getInventory().equals((Object)gui.getInventory())) {
            this.openGUIs.remove(player.getUniqueId());
        }
    }

    public void closeGUI(Player player) {
        BaseGUI gui = this.openGUIs.remove(player.getUniqueId());
        if (gui != null) {
            player.closeInventory();
        }
    }
}

