/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class IntegrationSettingsGUI
extends BaseGUI {
    public IntegrationSettingsGUI(AuditorPlugin plugin, Player player) {
        super(plugin, player, "\u00a75\u00a7lIntegration Settings", 54);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        this.inventory.setItem(4, this.createIntegrationOverviewItem());
        this.inventory.setItem(10, this.createVaultIntegrationItem());
        this.inventory.setItem(11, this.createEconomyPluginItem());
        this.inventory.setItem(12, this.createWorldGuardItem());
        this.inventory.setItem(13, this.createTownyItem());
        this.inventory.setItem(19, this.createDiscordSRVItem());
        this.inventory.setItem(20, this.createDiscordWebhookItem());
        this.inventory.setItem(21, this.createSlackIntegrationItem());
        this.inventory.setItem(22, this.createTelegramItem());
        this.inventory.setItem(28, this.createPlaceholderAPIItem());
        this.inventory.setItem(29, this.createLuckPermsItem());
        this.inventory.setItem(30, this.createEssentialsItem());
        this.inventory.setItem(31, this.createCMIItem());
        this.inventory.setItem(37, this.createMythicMobsItem());
        this.inventory.setItem(38, this.createShopKeepersItem());
        this.inventory.setItem(39, this.createChestShopItem());
        this.inventory.setItem(40, this.createDynmapItem());
        this.inventory.setItem(46, this.createIntegrationConfigItem());
        this.inventory.setItem(47, this.createWebhookTestItem());
        this.inventory.setItem(48, this.createConnectionTestItem());
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createRefreshItem());
        this.inventory.setItem(53, this.createIntegrationGuideItem());
    }

    private ItemStack createIntegrationOverviewItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Plugin integration status overview");
        lore.add("");
        int connectedIntegrations = 0;
        int totalIntegrations = 13;
        if (this.isVaultConnected()) {
            ++connectedIntegrations;
        }
        if (this.isEconomyConnected()) {
            ++connectedIntegrations;
        }
        if (this.isPluginInstalled("WorldGuard")) {
            ++connectedIntegrations;
        }
        if (this.isPluginInstalled("Towny")) {
            ++connectedIntegrations;
        }
        if (this.isPluginInstalled("DiscordSRV")) {
            ++connectedIntegrations;
        }
        if (this.isDiscordWebhookConfigured()) {
            ++connectedIntegrations;
        }
        if (this.isPluginInstalled("PlaceholderAPI")) {
            ++connectedIntegrations;
        }
        if (this.isPluginInstalled("LuckPerms")) {
            ++connectedIntegrations;
        }
        if (this.isPluginInstalled("Essentials")) {
            ++connectedIntegrations;
        }
        if (this.isPluginInstalled("CMI")) {
            ++connectedIntegrations;
        }
        if (this.isPluginInstalled("MythicMobs")) {
            ++connectedIntegrations;
        }
        if (this.isPluginInstalled("ShopKeepers")) {
            ++connectedIntegrations;
        }
        if (this.isPluginInstalled("ChestShop")) {
            ++connectedIntegrations;
        }
        lore.add("\u00a7e\u00a7lIntegration Status:");
        lore.add("\u00a7bConnected: \u00a7a" + connectedIntegrations + " \u00a77/ \u00a7f" + totalIntegrations);
        lore.add("\u00a7bCore Status: " + (this.isVaultConnected() && this.isEconomyConnected() ? "\u00a7aHealthy" : "\u00a7cIssues Detected"));
        lore.add("");
        if (connectedIntegrations >= 8) {
            lore.add("\u00a7a\u00a7lExcellent Integration Coverage!");
            lore.add("\u00a77Your server has comprehensive plugin");
            lore.add("\u00a77integration for optimal functionality");
        } else if (connectedIntegrations >= 4) {
            lore.add("\u00a7e\u00a7lGood Integration Coverage");
            lore.add("\u00a77Most essential plugins are connected");
        } else {
            lore.add("\u00a7c\u00a7lLimited Integration Coverage");
            lore.add("\u00a77Consider installing additional plugins");
            lore.add("\u00a77for enhanced functionality");
        }
        lore.add("");
        lore.add("\u00a77Click integration items below to manage");
        return this.createItem(Material.COMPARATOR, "\u00a75\u00a7lIntegration Overview", lore);
    }

    private ItemStack createVaultIntegrationItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Vault economy API integration");
        lore.add("");
        boolean connected = this.isVaultConnected();
        lore.add("\u00a7bStatus: " + (connected ? "\u00a7aConnected \u2713" : "\u00a7cDisconnected \u2717"));
        if (connected) {
            lore.add("\u00a7bVersion: \u00a7f" + this.getPluginVersion("Vault"));
            lore.add("\u00a7bEconomy Provider: \u00a7f" + this.getEconomyProviderName());
            lore.add("");
            lore.add("\u00a7a\u00a7lVault Features Available:");
            lore.add("\u00a77\u2022 Balance checking");
            lore.add("\u00a77\u2022 Transaction processing");
            lore.add("\u00a77\u2022 Currency formatting");
            lore.add("\u00a77\u2022 Account management");
        } else {
            lore.add("");
            lore.add("\u00a7c\u00a7lVault Required:");
            lore.add("\u00a77Vault is essential for Auditor to function");
            lore.add("\u00a77Download from: spigotmc.org/resources/34315");
            lore.add("");
            lore.add("\u00a77Without Vault, economy monitoring");
            lore.add("\u00a77and transaction tracking will not work");
        }
        lore.add("");
        lore.add("\u00a7eClick to " + (connected ? "test connection" : "view setup guide"));
        Material material = connected ? Material.EMERALD_BLOCK : Material.REDSTONE_BLOCK;
        return this.createItem(material, connected ? "\u00a7a\u00a7lVault Connected" : "\u00a7c\u00a7lVault Missing", lore);
    }

    private ItemStack createEconomyPluginItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Economy plugin integration status");
        lore.add("");
        boolean connected = this.isEconomyConnected();
        String economyPlugin = this.getEconomyProviderName();
        lore.add("\u00a7bStatus: " + (connected ? "\u00a7aConnected \u2713" : "\u00a7cNo Economy Plugin \u2717"));
        if (connected) {
            lore.add("\u00a7bProvider: \u00a7f" + economyPlugin);
            lore.add("\u00a7bVersion: \u00a7f" + this.getPluginVersion(economyPlugin));
            lore.add("");
            lore.add("\u00a7a\u00a7lEconomy Features:");
            lore.add("\u00a77\u2022 Transaction monitoring");
            lore.add("\u00a77\u2022 Balance tracking");
            lore.add("\u00a77\u2022 Economic analysis");
            lore.add("\u00a77\u2022 Automated alerts");
        } else {
            lore.add("");
            lore.add("\u00a7c\u00a7lEconomy Plugin Required:");
            lore.add("\u00a77Popular economy plugins:");
            lore.add("\u00a77\u2022 EssentialsX Economy");
            lore.add("\u00a77\u2022 CMI Economy");
            lore.add("\u00a77\u2022 GriefPrevention Economy");
            lore.add("\u00a77\u2022 TNE (The New Economy)");
            lore.add("");
            lore.add("\u00a77Install an economy plugin for");
            lore.add("\u00a77Auditor to track transactions");
        }
        lore.add("");
        lore.add("\u00a7eClick to view economy details");
        Material material = connected ? Material.GOLD_BLOCK : Material.BARRIER;
        return this.createItem(material, connected ? "\u00a7a\u00a7lEconomy Connected" : "\u00a7c\u00a7lNo Economy Plugin", lore);
    }

    private ItemStack createDiscordSRVItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77DiscordSRV integration for notifications");
        lore.add("");
        boolean installed = this.isPluginInstalled("DiscordSRV");
        lore.add("\u00a7bStatus: " + (installed ? "\u00a7aInstalled \u2713" : "\u00a77Not Installed"));
        if (installed) {
            lore.add("\u00a7bVersion: \u00a7f" + this.getPluginVersion("DiscordSRV"));
            lore.add("");
            lore.add("\u00a7a\u00a7lDiscordSRV Features:");
            lore.add("\u00a77\u2022 Send alerts to Discord channels");
            lore.add("\u00a77\u2022 Economy notifications");
            lore.add("\u00a77\u2022 Admin notifications");
            lore.add("\u00a77\u2022 Formatted embed messages");
            lore.add("");
            lore.add("\u00a7e\u00a7lConfiguration Required:");
            lore.add("\u00a77\u2022 Set up Discord bot");
            lore.add("\u00a77\u2022 Configure channels");
            lore.add("\u00a77\u2022 Enable Auditor integration");
        } else {
            lore.add("");
            lore.add("\u00a7e\u00a7lOptional Integration:");
            lore.add("\u00a77DiscordSRV allows sending economy");
            lore.add("\u00a77alerts and notifications to Discord");
            lore.add("");
            lore.add("\u00a77Download from: spigotmc.org/resources/18494");
            lore.add("");
            lore.add("\u00a77Benefits:");
            lore.add("\u00a77\u2022 Real-time alert notifications");
            lore.add("\u00a77\u2022 Economy status updates");
            lore.add("\u00a77\u2022 Admin team coordination");
        }
        lore.add("");
        lore.add("\u00a7eClick to " + (installed ? "configure integration" : "view setup guide"));
        Material material = installed ? Material.BLUE_STAINED_GLASS : Material.GRAY_STAINED_GLASS;
        return this.createItem(material, installed ? "\u00a79\u00a7lDiscordSRV Available" : "\u00a77\u00a7lDiscordSRV Not Installed", lore);
    }

    private ItemStack createDiscordWebhookItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Discord webhook configuration");
        lore.add("");
        boolean configured = this.isDiscordWebhookConfigured();
        String webhook = this.plugin.getConfigManager().getDiscordWebhook();
        lore.add("\u00a7bStatus: " + (configured ? "\u00a7aConfigured \u2713" : "\u00a77Not Configured"));
        if (configured) {
            lore.add("\u00a7bWebhook URL: \u00a7f" + webhook.substring(0, Math.min(30, webhook.length())) + "...");
            lore.add("");
            lore.add("\u00a7a\u00a7lWebhook Features:");
            lore.add("\u00a77\u2022 Direct channel notifications");
            lore.add("\u00a77\u2022 Critical alert forwarding");
            lore.add("\u00a77\u2022 Custom formatted messages");
            lore.add("\u00a77\u2022 No bot required");
        } else {
            lore.add("");
            lore.add("\u00a7e\u00a7lWebhook Setup:");
            lore.add("\u00a77Webhooks provide simple Discord");
            lore.add("\u00a77integration without a full bot");
            lore.add("");
            lore.add("\u00a77To configure:");
            lore.add("\u00a771. Create webhook in Discord");
            lore.add("\u00a772. Copy webhook URL");
            lore.add("\u00a773. Add to config.yml");
            lore.add("\u00a774. Restart plugin");
        }
        lore.add("");
        lore.add("\u00a7eClick to " + (configured ? "test webhook" : "view setup guide"));
        Material material = configured ? Material.LIME_STAINED_GLASS : Material.YELLOW_STAINED_GLASS;
        return this.createItem(material, configured ? "\u00a7a\u00a7lWebhook Configured" : "\u00a7e\u00a7lWebhook Setup", lore);
    }

    private ItemStack createPlaceholderAPIItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77PlaceholderAPI integration status");
        lore.add("");
        boolean installed = this.isPluginInstalled("PlaceholderAPI");
        lore.add("\u00a7bStatus: " + (installed ? "\u00a7aInstalled \u2713" : "\u00a77Not Installed"));
        if (installed) {
            lore.add("\u00a7bVersion: \u00a7f" + this.getPluginVersion("PlaceholderAPI"));
            lore.add("");
            lore.add("\u00a7a\u00a7lAvailable Placeholders:");
            lore.add("\u00a77\u2022 %auditor_balance%");
            lore.add("\u00a77\u2022 %auditor_transactions%");
            lore.add("\u00a77\u2022 %auditor_risk_level%");
            lore.add("\u00a77\u2022 %auditor_flags%");
            lore.add("\u00a77\u2022 %auditor_monitored%");
            lore.add("");
            lore.add("\u00a7e\u00a7lUsage Examples:");
            lore.add("\u00a77\u2022 Scoreboard displays");
            lore.add("\u00a77\u2022 Tab list formatting");
            lore.add("\u00a77\u2022 Chat prefixes");
            lore.add("\u00a77\u2022 Custom GUI displays");
        } else {
            lore.add("");
            lore.add("\u00a7e\u00a7lOptional Integration:");
            lore.add("\u00a77PlaceholderAPI allows displaying");
            lore.add("\u00a77Auditor data in other plugins");
            lore.add("");
            lore.add("\u00a77Download from: spigotmc.org/resources/6245");
            lore.add("");
            lore.add("\u00a77Use cases:");
            lore.add("\u00a77\u2022 Display economy stats in chat");
            lore.add("\u00a77\u2022 Show risk levels in tab list");
            lore.add("\u00a77\u2022 Custom scoreboard integration");
        }
        lore.add("");
        lore.add("\u00a7eClick to " + (installed ? "view placeholders" : "view setup guide"));
        Material material = installed ? Material.NAME_TAG : Material.PAPER;
        return this.createItem(material, installed ? "\u00a7a\u00a7lPlaceholderAPI Available" : "\u00a77\u00a7lPlaceholderAPI Setup", lore);
    }

    private ItemStack createWorldGuardItem() {
        return this.createPluginIntegrationItem("WorldGuard", Material.SHIELD, "Region-based transaction filtering", "\u2022 Filter transactions by region\n\u2022 Protected area monitoring\n\u2022 Region-specific alerts\n\u2022 Economic zone analysis");
    }

    private ItemStack createTownyItem() {
        return this.createPluginIntegrationItem("Towny", Material.GOLD_BLOCK, "Town and nation economy integration", "\u2022 Town-based transaction tracking\n\u2022 Nation economy monitoring\n\u2022 Tax and upkeep analysis\n\u2022 Inter-town trade tracking");
    }

    private ItemStack createLuckPermsItem() {
        return this.createPluginIntegrationItem("LuckPerms", Material.GOLDEN_SWORD, "Permission management integration", "\u2022 Permission-based monitoring\n\u2022 Group-specific alerts\n\u2022 Permission change tracking\n\u2022 Economy access control");
    }

    private ItemStack createEssentialsItem() {
        return this.createPluginIntegrationItem("Essentials", Material.COMPASS, "Essential commands integration", "\u2022 Command usage tracking\n\u2022 Economy command monitoring\n\u2022 Balance modification alerts\n\u2022 Administrative action logs");
    }

    private ItemStack createCMIItem() {
        return this.createPluginIntegrationItem("CMI", Material.COMMAND_BLOCK, "CMI plugin integration", "\u2022 Enhanced economy features\n\u2022 Advanced command tracking\n\u2022 Multi-world support\n\u2022 Extended monitoring options");
    }

    private ItemStack createMythicMobsItem() {
        return this.createPluginIntegrationItem("MythicMobs", Material.ZOMBIE_HEAD, "MythicMobs economy integration", "\u2022 Mob kill reward tracking\n\u2022 Custom economy events\n\u2022 Mythic drop monitoring\n\u2022 Skill-based economy analysis");
    }

    private ItemStack createShopKeepersItem() {
        return this.createPluginIntegrationItem("Shopkeepers", Material.VILLAGER_SPAWN_EGG, "Shop transaction monitoring", "\u2022 NPC shop tracking\n\u2022 Player shop monitoring\n\u2022 Trade volume analysis\n\u2022 Market trend detection");
    }

    private ItemStack createChestShopItem() {
        return this.createPluginIntegrationItem("ChestShop", Material.CHEST, "Chest shop integration", "\u2022 Shop transaction tracking\n\u2022 Revenue monitoring\n\u2022 Stock level alerts\n\u2022 Market analysis");
    }

    private ItemStack createDynmapItem() {
        return this.createPluginIntegrationItem("dynmap", Material.MAP, "Web map integration", "\u2022 Economic heatmaps\n\u2022 Transaction location mapping\n\u2022 Web-based monitoring\n\u2022 Geographic analysis");
    }

    private ItemStack createSlackIntegrationItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Slack workspace integration");
        lore.add("");
        lore.add("\u00a7bStatus: \u00a77Custom Configuration Required");
        lore.add("");
        lore.add("\u00a7e\u00a7lSlack Integration:");
        lore.add("\u00a77Send economy alerts and notifications");
        lore.add("\u00a77to your team's Slack workspace");
        lore.add("");
        lore.add("\u00a77Setup requires:");
        lore.add("\u00a77\u2022 Slack webhook URL");
        lore.add("\u00a77\u2022 Channel configuration");
        lore.add("\u00a77\u2022 Message formatting setup");
        lore.add("");
        lore.add("\u00a7eClick to configure Slack integration");
        return this.createItem(Material.PURPLE_STAINED_GLASS, "\u00a75\u00a7lSlack Integration", lore);
    }

    private ItemStack createTelegramItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Telegram bot integration");
        lore.add("");
        lore.add("\u00a7bStatus: \u00a77Custom Configuration Required");
        lore.add("");
        lore.add("\u00a7e\u00a7lTelegram Integration:");
        lore.add("\u00a77Send alerts and notifications");
        lore.add("\u00a77to Telegram chats or channels");
        lore.add("");
        lore.add("\u00a77Setup requires:");
        lore.add("\u00a77\u2022 Telegram bot token");
        lore.add("\u00a77\u2022 Chat ID configuration");
        lore.add("\u00a77\u2022 Message formatting");
        lore.add("");
        lore.add("\u00a7eClick to configure Telegram integration");
        return this.createItem(Material.CYAN_STAINED_GLASS, "\u00a7b\u00a7lTelegram Integration", lore);
    }

    private ItemStack createIntegrationConfigItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Integration configuration management");
        lore.add("");
        lore.add("\u00a7e\u00a7lConfiguration Options:");
        lore.add("\u00a77\u2022 Enable/disable integrations");
        lore.add("\u00a77\u2022 Set notification preferences");
        lore.add("\u00a77\u2022 Configure alert thresholds");
        lore.add("\u00a77\u2022 Manage webhook settings");
        lore.add("");
        lore.add("\u00a7b\u00a7lCurrent Settings:");
        lore.add("\u00a77\u2022 Alerts: " + (this.plugin.getConfigManager().isAlertsEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        lore.add("\u00a77\u2022 Webhooks: " + (this.isDiscordWebhookConfigured() ? "\u00a7aConfigured" : "\u00a77Not Set"));
        lore.add("");
        lore.add("\u00a7eClick to modify integration settings");
        return this.createItem(Material.REDSTONE, "\u00a7c\u00a7lIntegration Config", lore);
    }

    private ItemStack createWebhookTestItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Test webhook connections");
        lore.add("");
        lore.add("\u00a7e\u00a7lWebhook Testing:");
        lore.add("\u00a77Send test messages to verify");
        lore.add("\u00a77webhook configuration and connectivity");
        lore.add("");
        lore.add("\u00a7b\u00a7lTest Options:");
        lore.add("\u00a77\u2022 Discord webhook test");
        lore.add("\u00a77\u2022 Slack webhook test");
        lore.add("\u00a77\u2022 Custom webhook test");
        lore.add("");
        lore.add("\u00a7a\u00a7lTest Message Includes:");
        lore.add("\u00a77\u2022 Connection verification");
        lore.add("\u00a77\u2022 Timestamp information");
        lore.add("\u00a77\u2022 Server identification");
        lore.add("");
        lore.add("\u00a7eClick to send test message");
        return this.createItem(Material.REDSTONE_TORCH, "\u00a76\u00a7lTest Webhooks", lore);
    }

    private ItemStack createConnectionTestItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Test all plugin connections");
        lore.add("");
        lore.add("\u00a7e\u00a7lConnection Testing:");
        lore.add("\u00a77Verify integration status and");
        lore.add("\u00a77connection health for all plugins");
        lore.add("");
        lore.add("\u00a7b\u00a7lTest Results Will Show:");
        lore.add("\u00a77\u2022 Plugin detection status");
        lore.add("\u00a77\u2022 Version compatibility");
        lore.add("\u00a77\u2022 API connection health");
        lore.add("\u00a77\u2022 Configuration validity");
        lore.add("");
        lore.add("\u00a7a\u00a7lRecommended Frequency:");
        lore.add("\u00a77\u2022 After plugin updates");
        lore.add("\u00a77\u2022 When adding new plugins");
        lore.add("\u00a77\u2022 During troubleshooting");
        lore.add("");
        lore.add("\u00a7eClick to run connection tests");
        return this.createItem(Material.REDSTONE_TORCH, "\u00a74\u00a7lConnection Test", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to main settings");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack to Settings", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh integration status");
        lore.add("\u00a77Re-scan for installed plugins");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    private ItemStack createIntegrationGuideItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Integration setup guide");
        lore.add("");
        lore.add("\u00a7e\u00a7lSetup Priority:");
        lore.add("\u00a7c1. Vault (Required)");
        lore.add("\u00a7c2. Economy Plugin (Required)");
        lore.add("\u00a763. DiscordSRV (Recommended)");
        lore.add("\u00a7a4. PlaceholderAPI (Optional)");
        lore.add("\u00a7a5. Other Plugins (Optional)");
        lore.add("");
        lore.add("\u00a7b\u00a7lBest Practices:");
        lore.add("\u00a77\u2022 Install core plugins first");
        lore.add("\u00a77\u2022 Test integrations after setup");
        lore.add("\u00a77\u2022 Keep plugins updated");
        lore.add("\u00a77\u2022 Configure webhooks for alerts");
        lore.add("");
        lore.add("\u00a7eClick for detailed setup guide");
        return this.createItem(Material.BOOK, "\u00a7f\u00a7lSetup Guide", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 10: {
                this.testVaultConnection();
                break;
            }
            case 11: {
                this.showEconomyDetails();
                break;
            }
            case 19: {
                this.configureDiscordSRV();
                break;
            }
            case 20: {
                this.testWebhook();
                break;
            }
            case 28: {
                this.showPlaceholderAPI();
                break;
            }
            case 46: {
                this.configureIntegrations();
                break;
            }
            case 47: {
                this.testAllWebhooks();
                break;
            }
            case 48: {
                this.runConnectionTest();
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openSettings(this.player);
                break;
            }
            case 49: {
                this.refresh();
                break;
            }
            case 53: {
                this.showIntegrationGuide();
                break;
            }
            default: {
                this.refresh();
            }
        }
    }

    private ItemStack createPluginIntegrationItem(String pluginName, Material material, String description, String features) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77" + description);
        lore.add("");
        boolean installed = this.isPluginInstalled(pluginName);
        lore.add("\u00a7bStatus: " + (installed ? "\u00a7aInstalled \u2713" : "\u00a77Not Installed"));
        if (installed) {
            lore.add("\u00a7bVersion: \u00a7f" + this.getPluginVersion(pluginName));
            lore.add("");
            lore.add("\u00a7a\u00a7l" + pluginName + " Features:");
            for (String feature : features.split("\n")) {
                lore.add("\u00a77" + feature);
            }
        } else {
            lore.add("");
            lore.add("\u00a7e\u00a7lOptional Integration:");
            lore.add("\u00a77" + pluginName + " integration provides");
            lore.add("\u00a77enhanced functionality when available");
            lore.add("");
            lore.add("\u00a77Features when installed:");
            for (String feature : features.split("\n")) {
                lore.add("\u00a77" + feature);
            }
        }
        lore.add("");
        lore.add("\u00a7eClick to " + (installed ? "configure" : "view details"));
        return this.createItem(material, (installed ? "\u00a7a\u00a7l" : "\u00a77\u00a7l") + pluginName, lore);
    }

    private boolean isVaultConnected() {
        return this.plugin.getVaultHook() != null && this.plugin.getVaultHook().getEconomy() != null;
    }

    private boolean isEconomyConnected() {
        return this.isVaultConnected() && this.plugin.getVaultHook().getEconomy() != null;
    }

    private boolean isPluginInstalled(String pluginName) {
        return Bukkit.getPluginManager().getPlugin(pluginName) != null;
    }

    private String getPluginVersion(String pluginName) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        return plugin != null ? plugin.getDescription().getVersion() : "Unknown";
    }

    private String getEconomyProviderName() {
        if (this.isEconomyConnected()) {
            return this.plugin.getVaultHook().getEconomy().getName();
        }
        return "None";
    }

    private boolean isDiscordWebhookConfigured() {
        String webhook = this.plugin.getConfigManager().getDiscordWebhook();
        return webhook != null && !webhook.isEmpty() && webhook.startsWith("https://discord");
    }

    private void testVaultConnection() {
        this.refresh();
    }

    private void showEconomyDetails() {
        this.refresh();
    }

    private void configureDiscordSRV() {
        this.refresh();
    }

    private void testWebhook() {
        this.refresh();
    }

    private void showPlaceholderAPI() {
        this.refresh();
    }

    private void configureIntegrations() {
        this.refresh();
    }

    private void testAllWebhooks() {
        this.refresh();
    }

    private void runConnectionTest() {
        this.refresh();
    }

    private void showIntegrationGuide() {
        this.refresh();
    }
}

