/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.PlayerProfile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class NotesManagementGUI
extends BaseGUI {
    private final String targetPlayerName;
    private final UUID targetPlayerUUID;
    private PlayerProfile playerProfile;
    private List<AdminNote> playerNotes;
    private int currentPage = 0;
    private static final int NOTES_PER_PAGE = 10;

    public NotesManagementGUI(AuditorPlugin plugin, Player player, String targetPlayerName, UUID targetPlayerUUID) {
        super(plugin, player, "\u00a7e\u00a7lNotes: " + targetPlayerName, 54);
        this.targetPlayerName = targetPlayerName;
        this.targetPlayerUUID = targetPlayerUUID;
        this.loadPlayerData();
    }

    private void loadPlayerData() {
        this.playerProfile = this.plugin.getDatabase().getPlayerProfile(this.targetPlayerUUID);
        this.playerNotes = this.parseNotes(this.playerProfile != null ? this.playerProfile.getNotes() : "");
    }

    private List<AdminNote> parseNotes(String notesString) {
        ArrayList<AdminNote> notes = new ArrayList<AdminNote>();
        if (notesString != null && !notesString.trim().isEmpty()) {
            String[] noteEntries;
            for (String noteEntry : noteEntries = notesString.split("\\|\\|")) {
                AdminNote note;
                if (noteEntry.trim().isEmpty() || (note = AdminNote.fromString(noteEntry)) == null) continue;
                notes.add(note);
            }
        }
        return notes;
    }

    private String serializeNotes(List<AdminNote> notes) {
        if (notes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < notes.size(); ++i) {
            if (i > 0) {
                sb.append("||");
            }
            sb.append(notes.get(i).toString());
        }
        return sb.toString();
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        this.inventory.setItem(4, this.createPlayerInfoItem());
        this.displayNotes();
        this.inventory.setItem(46, this.createAddNoteItem());
        this.inventory.setItem(47, this.createDeleteModeItem());
        this.inventory.setItem(48, this.createClearAllNotesItem());
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createRefreshItem());
        this.inventory.setItem(50, this.createPreviousPageItem());
        this.inventory.setItem(53, this.createNextPageItem());
        this.inventory.setItem(52, this.createNotesSummaryItem());
    }

    private void displayNotes() {
        for (int i = 10; i <= 43; ++i) {
            if (!(i < 17 || i >= 19 && i < 26 || i >= 28 && i < 35) && (i < 37 || i > 43)) continue;
            this.inventory.setItem(i, null);
        }
        int startIndex = this.currentPage * 10;
        int endIndex = Math.min(startIndex + 10, this.playerNotes.size());
        int[] noteSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        for (int i = startIndex; i < endIndex; ++i) {
            int slotIndex = i - startIndex;
            if (slotIndex >= noteSlots.length) continue;
            this.inventory.setItem(noteSlots[slotIndex], this.createNoteItem(this.playerNotes.get(i), i));
        }
    }

    private ItemStack createPlayerInfoItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Administrative notes for player");
        lore.add("");
        lore.add("\u00a7bPlayer: \u00a7f" + this.targetPlayerName);
        lore.add("\u00a7bUUID: \u00a77" + this.targetPlayerUUID.toString().substring(0, 8) + "...");
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)this.targetPlayerUUID);
        lore.add("\u00a7bStatus: " + (target.isOnline() ? "\u00a7aOnline" : "\u00a77Offline"));
        if (!target.isOnline() && target.getLastPlayed() > 0L) {
            lore.add("\u00a7bLast Seen: \u00a7f" + this.formatTime(target.getLastPlayed()));
        }
        lore.add("");
        lore.add("\u00a7e\u00a7lNote Management:");
        lore.add("\u00a77Total Notes: \u00a7f" + this.playerNotes.size());
        lore.add("\u00a77Page: \u00a7f" + (this.currentPage + 1) + "/" + Math.max(1, (int)Math.ceil((double)this.playerNotes.size() / 10.0)));
        lore.add("");
        if (this.playerProfile != null) {
            String riskLevel = this.playerProfile.getRiskLevel();
            lore.add("\u00a7bRisk Level: " + this.getRiskColor(riskLevel) + riskLevel);
            if (this.playerProfile.getFlags() != null && !this.playerProfile.getFlags().isEmpty()) {
                lore.add("\u00a7bFlags: \u00a7f" + this.playerProfile.getFlags().replace(",", ", "));
            }
        }
        return this.createItem(Material.PLAYER_HEAD, "\u00a7e\u00a7lPlayer Notes", lore);
    }

    private ItemStack createNoteItem(AdminNote note, int noteIndex) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Administrative note #" + (noteIndex + 1));
        lore.add("");
        lore.add("\u00a7e\u00a7lNote Content:");
        String[] words = note.getContent().split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() + word.length() + 1 > 40) {
                lore.add("\u00a7f" + line.toString());
                line = new StringBuilder(word);
                continue;
            }
            if (line.length() > 0) {
                line.append(" ");
            }
            line.append(word);
        }
        if (line.length() > 0) {
            lore.add("\u00a7f" + line.toString());
        }
        lore.add("");
        lore.add("\u00a7b\u00a7lNote Details:");
        lore.add("\u00a77Author: \u00a7f" + note.getAuthor());
        lore.add("\u00a77Created: \u00a7f" + this.formatTime(note.getTimestamp()));
        lore.add("\u00a77Type: \u00a7f" + note.getType());
        if (note.isImportant()) {
            lore.add("\u00a7c\u00a7lIMPORTANT NOTE");
        }
        lore.add("");
        lore.add("\u00a77Left-click to edit note");
        lore.add("\u00a77Right-click to delete note");
        lore.add("\u00a77Shift+click to toggle importance");
        Material material = note.isImportant() ? Material.RED_STAINED_GLASS : (note.getType().equals("WARNING") ? Material.ORANGE_STAINED_GLASS : (note.getType().equals("INFO") ? Material.BLUE_STAINED_GLASS : Material.WHITE_STAINED_GLASS));
        String noteTitle = "\u00a7f\u00a7lNote #" + (noteIndex + 1);
        if (note.isImportant()) {
            noteTitle = "\u00a7c\u00a7l[!] " + noteTitle;
        }
        return this.createItem(material, noteTitle, lore);
    }

    private ItemStack createAddNoteItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Add a new administrative note");
        lore.add("");
        lore.add("\u00a7e\u00a7lAdd Note:");
        lore.add("\u00a77Click to add a new note about");
        lore.add("\u00a77this player's behavior, actions,");
        lore.add("\u00a77or other administrative information");
        lore.add("");
        lore.add("\u00a7b\u00a7lNote Types:");
        lore.add("\u00a77\u2022 \u00a7fINFO \u00a77- General information");
        lore.add("\u00a77\u2022 \u00a76WARNING \u00a77- Behavioral warnings");
        lore.add("\u00a77\u2022 \u00a7cALERT \u00a77- Important alerts");
        lore.add("\u00a77\u2022 \u00a7aCOMPLIANCE \u00a77- Rule compliance");
        lore.add("");
        lore.add("\u00a77Notes help staff track player");
        lore.add("\u00a77behavior and make informed decisions");
        lore.add("");
        lore.add("\u00a7a\u00a7lClick to add new note");
        return this.createItem(Material.WRITABLE_BOOK, "\u00a7a\u00a7lAdd Note", lore);
    }

    private ItemStack createDeleteModeItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Toggle note deletion mode");
        lore.add("");
        lore.add("\u00a7e\u00a7lDelete Mode:");
        lore.add("\u00a77When enabled, clicking notes");
        lore.add("\u00a77will delete them instead of editing");
        lore.add("");
        lore.add("\u00a7c\u00a7lWarning:");
        lore.add("\u00a77Deleted notes cannot be recovered");
        lore.add("\u00a77Use with caution");
        lore.add("");
        lore.add("\u00a77Current Mode: \u00a7fEdit Mode");
        lore.add("");
        lore.add("\u00a7eClick to enable delete mode");
        return this.createItem(Material.TNT, "\u00a7c\u00a7lDelete Mode", lore);
    }

    private ItemStack createClearAllNotesItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Clear all notes for this player");
        lore.add("");
        lore.add("\u00a7c\u00a7lClear All Notes:");
        lore.add("\u00a77This will permanently delete");
        lore.add("\u00a77ALL administrative notes for");
        lore.add("\u00a77" + this.targetPlayerName);
        lore.add("");
        lore.add("\u00a7bCurrent Notes: \u00a7f" + this.playerNotes.size());
        lore.add("");
        lore.add("\u00a74\u00a7lDANGER:");
        lore.add("\u00a7cThis action CANNOT be undone!");
        lore.add("\u00a7cAll note history will be lost!");
        lore.add("");
        lore.add("\u00a77Requires confirmation click");
        lore.add("");
        lore.add("\u00a7c\u00a7lClick to clear all notes");
        return this.createItem(Material.LAVA_BUCKET, "\u00a74\u00a7lClear All Notes", lore);
    }

    private ItemStack createPreviousPageItem() {
        boolean hasPrevious;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Go to previous page");
        lore.add("");
        lore.add("\u00a7bCurrent Page: \u00a7f" + (this.currentPage + 1));
        lore.add("\u00a7bTotal Pages: \u00a7f" + Math.max(1, (int)Math.ceil((double)this.playerNotes.size() / 10.0)));
        boolean bl = hasPrevious = this.currentPage > 0;
        if (hasPrevious) {
            lore.add("");
            lore.add("\u00a7eClick to go to previous page");
        } else {
            lore.add("");
            lore.add("\u00a77Already on first page");
        }
        Material material = hasPrevious ? Material.ARROW : Material.GRAY_STAINED_GLASS_PANE;
        return this.createItem(material, hasPrevious ? "\u00a7a\u00a7lPrevious Page" : "\u00a77\u00a7lPrevious Page", lore);
    }

    private ItemStack createNextPageItem() {
        boolean hasNext;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Go to next page");
        lore.add("");
        lore.add("\u00a7bCurrent Page: \u00a7f" + (this.currentPage + 1));
        lore.add("\u00a7bTotal Pages: \u00a7f" + Math.max(1, (int)Math.ceil((double)this.playerNotes.size() / 10.0)));
        boolean bl = hasNext = (this.currentPage + 1) * 10 < this.playerNotes.size();
        if (hasNext) {
            lore.add("");
            lore.add("\u00a7eClick to go to next page");
        } else {
            lore.add("");
            lore.add("\u00a77Already on last page");
        }
        Material material = hasNext ? Material.ARROW : Material.GRAY_STAINED_GLASS_PANE;
        return this.createItem(material, hasNext ? "\u00a7a\u00a7lNext Page" : "\u00a77\u00a7lNext Page", lore);
    }

    private ItemStack createNotesSummaryItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Notes summary and statistics");
        lore.add("");
        lore.add("\u00a7e\u00a7lNotes Summary:");
        lore.add("\u00a7bTotal Notes: \u00a7f" + this.playerNotes.size());
        int infoNotes = 0;
        int warningNotes = 0;
        int alertNotes = 0;
        int complianceNotes = 0;
        int importantNotes = 0;
        for (AdminNote note : this.playerNotes) {
            switch (note.getType()) {
                case "INFO": {
                    ++infoNotes;
                    break;
                }
                case "WARNING": {
                    ++warningNotes;
                    break;
                }
                case "ALERT": {
                    ++alertNotes;
                    break;
                }
                case "COMPLIANCE": {
                    ++complianceNotes;
                }
            }
            if (!note.isImportant()) continue;
            ++importantNotes;
        }
        lore.add("");
        lore.add("\u00a7b\u00a7lBy Type:");
        lore.add("\u00a77\u2022 Info: \u00a7f" + infoNotes);
        lore.add("\u00a77\u2022 Warning: \u00a76" + warningNotes);
        lore.add("\u00a77\u2022 Alert: \u00a7c" + alertNotes);
        lore.add("\u00a77\u2022 Compliance: \u00a7a" + complianceNotes);
        lore.add("");
        lore.add("\u00a7c\u00a7lImportant Notes: \u00a7f" + importantNotes);
        if (!this.playerNotes.isEmpty()) {
            AdminNote latestNote = this.playerNotes.get(this.playerNotes.size() - 1);
            lore.add("");
            lore.add("\u00a7b\u00a7lLatest Note:");
            lore.add("\u00a77Date: \u00a7f" + this.formatTime(latestNote.getTimestamp()));
            lore.add("\u00a77Author: \u00a7f" + latestNote.getAuthor());
        }
        return this.createItem(Material.BOOK, "\u00a76\u00a7lNotes Summary", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to player analysis");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh notes data");
        lore.add("\u00a77Reload from database");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        int[] noteSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        for (int i = 0; i < noteSlots.length; ++i) {
            int noteIndex;
            if (slot != noteSlots[i] || (noteIndex = this.currentPage * 10 + i) >= this.playerNotes.size()) continue;
            this.handleNoteClick(noteIndex, clickType);
            return;
        }
        switch (slot) {
            case 46: {
                this.addNewNote();
                break;
            }
            case 47: {
                this.toggleDeleteMode();
                break;
            }
            case 48: {
                this.clearAllNotes();
                break;
            }
            case 50: {
                if (this.currentPage <= 0) break;
                --this.currentPage;
                this.refresh();
                break;
            }
            case 53: {
                if ((this.currentPage + 1) * 10 >= this.playerNotes.size()) break;
                ++this.currentPage;
                this.refresh();
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openPlayerAnalysis(this.player, this.targetPlayerName);
                break;
            }
            case 49: 
            case 52: {
                this.refresh();
                break;
            }
        }
    }

    private void handleNoteClick(int noteIndex, ClickType clickType) {
        AdminNote note = this.playerNotes.get(noteIndex);
        if (clickType == ClickType.RIGHT) {
            this.deleteNote(noteIndex);
        } else if (clickType == ClickType.SHIFT_LEFT || clickType == ClickType.SHIFT_RIGHT) {
            this.toggleNoteImportance(noteIndex);
        } else {
            this.editNote(noteIndex);
        }
    }

    private void addNewNote() {
        AdminNote newNote = new AdminNote(this.player.getName(), System.currentTimeMillis(), "Sample administrative note added via GUI", "INFO", false);
        this.playerNotes.add(newNote);
        this.saveNotes();
        this.refresh();
    }

    private void editNote(int noteIndex) {
        this.refresh();
    }

    private void deleteNote(int noteIndex) {
        if (noteIndex >= 0 && noteIndex < this.playerNotes.size()) {
            this.playerNotes.remove(noteIndex);
            this.saveNotes();
            int maxPage = Math.max(0, (int)Math.ceil((double)this.playerNotes.size() / 10.0) - 1);
            if (this.currentPage > maxPage) {
                this.currentPage = maxPage;
            }
            this.refresh();
        }
    }

    private void toggleNoteImportance(int noteIndex) {
        if (noteIndex >= 0 && noteIndex < this.playerNotes.size()) {
            AdminNote note = this.playerNotes.get(noteIndex);
            AdminNote updatedNote = new AdminNote(note.getAuthor(), note.getTimestamp(), note.getContent(), note.getType(), !note.isImportant());
            this.playerNotes.set(noteIndex, updatedNote);
            this.saveNotes();
            this.refresh();
        }
    }

    private void toggleDeleteMode() {
        this.refresh();
    }

    private void clearAllNotes() {
        this.playerNotes.clear();
        this.saveNotes();
        this.currentPage = 0;
        this.refresh();
    }

    private void saveNotes() {
        String serializedNotes = this.serializeNotes(this.playerNotes);
        this.plugin.getDatabase().updatePlayerNotes(this.targetPlayerUUID, serializedNotes);
        this.loadPlayerData();
    }

    private String getRiskColor(String riskLevel) {
        switch (riskLevel.toUpperCase()) {
            case "CRITICAL": {
                return "\u00a74";
            }
            case "HIGH": {
                return "\u00a7c";
            }
            case "MEDIUM": {
                return "\u00a76";
            }
            case "LOW": {
                return "\u00a7e";
            }
        }
        return "\u00a7a";
    }

    @Override
    protected String formatTime(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy HH:mm");
        return sdf.format(new Date(timestamp));
    }

    private static class AdminNote {
        private final String author;
        private final long timestamp;
        private final String content;
        private final String type;
        private final boolean important;

        public AdminNote(String author, long timestamp, String content, String type, boolean important) {
            this.author = author;
            this.timestamp = timestamp;
            this.content = content;
            this.type = type;
            this.important = important;
        }

        public String getAuthor() {
            return this.author;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getContent() {
            return this.content;
        }

        public String getType() {
            return this.type;
        }

        public boolean isImportant() {
            return this.important;
        }

        public String toString() {
            return this.author + ";" + this.timestamp + ";" + this.content.replace(";", "\\;").replace("|", "\\|") + ";" + this.type + ";" + this.important;
        }

        public static AdminNote fromString(String noteString) {
            try {
                String[] parts = noteString.split("(?<!\\\\);");
                if (parts.length >= 5) {
                    String author = parts[0];
                    long timestamp = Long.parseLong(parts[1]);
                    String content = parts[2].replace("\\;", ";").replace("\\|", "|");
                    String type = parts[3];
                    boolean important = Boolean.parseBoolean(parts[4]);
                    return new AdminNote(author, timestamp, content, type, important);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

