/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class PermissionSettingsGUI
extends BaseGUI {
    private final Map<String, String> permissionNodes = new HashMap<String, String>();
    private final Map<String, String> permissionDescriptions = new HashMap<String, String>();

    public PermissionSettingsGUI(AuditorPlugin plugin, Player player) {
        super(plugin, player, "\u00a7d\u00a7lPermission Settings", 54);
        this.setupPermissionData();
    }

    private void setupPermissionData() {
        this.permissionNodes.put("auditor.admin", "Full administrative access to all features");
        this.permissionNodes.put("auditor.moderator", "Staff access for viewing and basic management");
        this.permissionNodes.put("auditor.dashboard", "Access to main dashboard");
        this.permissionNodes.put("auditor.player.view", "View player analysis");
        this.permissionNodes.put("auditor.player.others", "Analyze other players");
        this.permissionNodes.put("auditor.alerts.view", "View alerts");
        this.permissionNodes.put("auditor.alerts.manage", "Manage and resolve alerts");
        this.permissionNodes.put("auditor.export", "Export data to files");
        this.permissionNodes.put("auditor.monitor", "Toggle player monitoring");
        this.permissionNodes.put("auditor.flag", "Manage player flags");
        this.permissionNodes.put("auditor.note", "Manage admin notes");
        this.permissionNodes.put("auditor.settings", "Access settings");
        this.permissionNodes.put("auditor.reload", "Reload configuration");
        this.permissionNodes.put("auditor.bypass", "Bypass transaction monitoring");
        this.permissionDescriptions.put("auditor.admin", "Grants full access to all Auditor features including settings, exports, and administrative commands");
        this.permissionDescriptions.put("auditor.moderator", "Provides staff-level access for monitoring and basic management without administrative controls");
        this.permissionDescriptions.put("auditor.dashboard", "Allows access to the main Auditor dashboard interface");
        this.permissionDescriptions.put("auditor.player.view", "Enables viewing of player analysis and transaction data");
        this.permissionDescriptions.put("auditor.player.others", "Permits analyzing other players' data (requires auditor.player.view)");
        this.permissionDescriptions.put("auditor.alerts.view", "Allows viewing of system alerts and notifications");
        this.permissionDescriptions.put("auditor.alerts.manage", "Enables resolving alerts and managing alert settings");
        this.permissionDescriptions.put("auditor.export", "Permits exporting data to CSV and other formats");
        this.permissionDescriptions.put("auditor.monitor", "Allows toggling enhanced monitoring for specific players");
        this.permissionDescriptions.put("auditor.flag", "Enables adding, removing, and managing player flags");
        this.permissionDescriptions.put("auditor.note", "Permits adding and managing administrative notes on players");
        this.permissionDescriptions.put("auditor.settings", "Grants access to plugin settings and configuration");
        this.permissionDescriptions.put("auditor.reload", "Allows reloading plugin configuration files");
        this.permissionDescriptions.put("auditor.bypass", "Excludes the player's transactions from monitoring and analysis");
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        this.inventory.setItem(4, this.createPermissionOverviewItem());
        this.inventory.setItem(10, this.createAdminPermissionsItem());
        this.inventory.setItem(12, this.createModeratorPermissionsItem());
        this.inventory.setItem(14, this.createPlayerPermissionsItem());
        this.inventory.setItem(16, this.createSpecialPermissionsItem());
        this.inventory.setItem(22, this.createCurrentPlayerPermissionsItem());
        this.inventory.setItem(28, this.createOnlinePlayersPermissionsItem());
        this.inventory.setItem(30, this.createPermissionTestingItem());
        this.inventory.setItem(32, this.createPermissionGuideItem());
        this.inventory.setItem(40, this.createPermissionTemplatesItem());
        this.inventory.setItem(42, this.createBulkPermissionItem());
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createRefreshItem());
        this.inventory.setItem(53, this.createPermissionFileItem());
    }

    private ItemStack createPermissionOverviewItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Auditor permission system overview");
        lore.add("");
        lore.add("\u00a7e\u00a7lPermission Hierarchy:");
        lore.add("\u00a7c\u2022 \u00a7fauditor.admin \u00a77(Full Access)");
        lore.add("\u00a76\u2022 \u00a7fauditor.moderator \u00a77(Staff Access)");
        lore.add("\u00a7a\u2022 \u00a7fauditor.dashboard \u00a77(Basic Access)");
        lore.add("");
        lore.add("\u00a7bTotal Permissions: \u00a7f" + this.permissionNodes.size());
        lore.add("\u00a7bOnline with Permissions: \u00a7f" + this.getOnlinePlayersWithPermissions());
        lore.add("");
        lore.add("\u00a77Click categories below to view details");
        return this.createItem(Material.SHIELD, "\u00a7d\u00a7lPermission Overview", lore);
    }

    private ItemStack createAdminPermissionsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Administrative permission nodes");
        lore.add("");
        lore.add("\u00a7c\u00a7lAdmin Permissions:");
        lore.add("\u00a7f\u2022 auditor.admin \u00a77- Full access");
        lore.add("\u00a7f\u2022 auditor.settings \u00a77- Settings access");
        lore.add("\u00a7f\u2022 auditor.reload \u00a77- Reload config");
        lore.add("\u00a7f\u2022 auditor.export \u00a77- Data export");
        lore.add("");
        lore.add("\u00a77These permissions grant administrative");
        lore.add("\u00a77control over the plugin");
        lore.add("");
        lore.add("\u00a7eClick to view detailed descriptions");
        boolean hasAdmin = this.player.hasPermission("auditor.admin");
        Material material = hasAdmin ? Material.REDSTONE_BLOCK : Material.RED_STAINED_GLASS;
        return this.createItem(material, "\u00a7c\u00a7lAdmin Permissions", lore);
    }

    private ItemStack createModeratorPermissionsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Staff and moderation permission nodes");
        lore.add("");
        lore.add("\u00a76\u00a7lModerator Permissions:");
        lore.add("\u00a7f\u2022 auditor.moderator \u00a77- Staff access");
        lore.add("\u00a7f\u2022 auditor.alerts.manage \u00a77- Manage alerts");
        lore.add("\u00a7f\u2022 auditor.monitor \u00a77- Player monitoring");
        lore.add("\u00a7f\u2022 auditor.flag \u00a77- Flag management");
        lore.add("\u00a7f\u2022 auditor.note \u00a77- Note management");
        lore.add("");
        lore.add("\u00a77These permissions are for staff members");
        lore.add("\u00a77who need monitoring capabilities");
        lore.add("");
        lore.add("\u00a7eClick to view detailed descriptions");
        boolean hasModerator = this.player.hasPermission("auditor.moderator");
        Material material = hasModerator ? Material.GOLD_BLOCK : Material.ORANGE_STAINED_GLASS;
        return this.createItem(material, "\u00a76\u00a7lModerator Permissions", lore);
    }

    private ItemStack createPlayerPermissionsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Basic player permission nodes");
        lore.add("");
        lore.add("\u00a7a\u00a7lPlayer Permissions:");
        lore.add("\u00a7f\u2022 auditor.dashboard \u00a77- Dashboard access");
        lore.add("\u00a7f\u2022 auditor.player.view \u00a77- View own data");
        lore.add("\u00a7f\u2022 auditor.player.others \u00a77- View others' data");
        lore.add("\u00a7f\u2022 auditor.alerts.view \u00a77- View alerts");
        lore.add("");
        lore.add("\u00a77These permissions are for regular players");
        lore.add("\u00a77who need basic access to the system");
        lore.add("");
        lore.add("\u00a7eClick to view detailed descriptions");
        boolean hasDashboard = this.player.hasPermission("auditor.dashboard");
        Material material = hasDashboard ? Material.LIME_STAINED_GLASS : Material.GREEN_STAINED_GLASS;
        return this.createItem(material, "\u00a7a\u00a7lPlayer Permissions", lore);
    }

    private ItemStack createSpecialPermissionsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Special and utility permission nodes");
        lore.add("");
        lore.add("\u00a75\u00a7lSpecial Permissions:");
        lore.add("\u00a7f\u2022 auditor.bypass \u00a77- Bypass monitoring");
        lore.add("");
        lore.add("\u00a77Special permissions for specific use cases:");
        lore.add("");
        lore.add("\u00a7e\u00a7lBypass Permission:");
        lore.add("\u00a77Players with auditor.bypass will not");
        lore.add("\u00a77have their transactions monitored or");
        lore.add("\u00a77analyzed by the system");
        lore.add("");
        lore.add("\u00a7c\u00a7lWarning: \u00a77Use bypass permission carefully");
        lore.add("");
        lore.add("\u00a7eClick to view detailed descriptions");
        boolean hasBypass = this.player.hasPermission("auditor.bypass");
        Material material = hasBypass ? Material.PURPLE_STAINED_GLASS : Material.MAGENTA_STAINED_GLASS;
        return this.createItem(material, "\u00a75\u00a7lSpecial Permissions", lore);
    }

    private ItemStack createCurrentPlayerPermissionsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Your current permission status");
        lore.add("");
        lore.add("\u00a7bPlayer: \u00a7f" + this.player.getName());
        lore.add("\u00a7bOperator: " + (this.player.isOp() ? "\u00a7aYes" : "\u00a77No"));
        lore.add("");
        lore.add("\u00a7e\u00a7lYour Permissions:");
        int permissionCount = 0;
        for (String permission : this.permissionNodes.keySet()) {
            if (!this.player.hasPermission(permission)) continue;
            ++permissionCount;
            String status = "\u00a7a\u2713";
            lore.add("\u00a77\u2022 " + status + " \u00a7f" + permission);
        }
        if (permissionCount == 0) {
            lore.add("\u00a77No Auditor permissions detected");
            lore.add("\u00a77Contact an administrator for access");
        }
        lore.add("");
        lore.add("\u00a7bTotal Permissions: \u00a7f" + permissionCount + "/" + this.permissionNodes.size());
        Material material = this.player.isOp() ? Material.COMMAND_BLOCK : (permissionCount > 0 ? Material.EMERALD : Material.BARRIER);
        return this.createItem(material, "\u00a7b\u00a7lYour Permissions", lore);
    }

    private ItemStack createOnlinePlayersPermissionsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Permission status of online players");
        lore.add("");
        int playersWithPermissions = 0;
        int totalOnline = Bukkit.getOnlinePlayers().size();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            boolean hasAnyPermission = false;
            for (String permission : this.permissionNodes.keySet()) {
                if (!onlinePlayer.hasPermission(permission)) continue;
                hasAnyPermission = true;
                break;
            }
            if (!hasAnyPermission && !onlinePlayer.isOp()) continue;
            ++playersWithPermissions;
        }
        lore.add("\u00a7bOnline Players: \u00a7f" + totalOnline);
        lore.add("\u00a7bWith Permissions: \u00a7f" + playersWithPermissions);
        lore.add("\u00a7bWithout Permissions: \u00a7f" + (totalOnline - playersWithPermissions));
        lore.add("");
        if (totalOnline <= 10) {
            lore.add("\u00a7e\u00a7lOnline Players Status:");
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                String status = onlinePlayer.isOp() ? "\u00a7c[OP]" : (onlinePlayer.hasPermission("auditor.admin") ? "\u00a7c[ADMIN]" : (onlinePlayer.hasPermission("auditor.moderator") ? "\u00a76[MOD]" : (onlinePlayer.hasPermission("auditor.dashboard") ? "\u00a7a[USER]" : "\u00a77[NONE]")));
                lore.add("\u00a77\u2022 " + status + " \u00a7f" + onlinePlayer.getName());
            }
        } else {
            lore.add("\u00a77Too many players to list individually");
            lore.add("\u00a77(" + totalOnline + " players online)");
        }
        return this.createItem(Material.PLAYER_HEAD, "\u00a79\u00a7lOnline Players", lore);
    }

    private ItemStack createPermissionTestingItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Test permission functionality");
        lore.add("");
        lore.add("\u00a7e\u00a7lPermission Testing:");
        lore.add("\u00a77Test your permissions by trying");
        lore.add("\u00a77different Auditor commands and features");
        lore.add("");
        lore.add("\u00a7b\u00a7lSuggested Tests:");
        lore.add("\u00a77\u2022 Try opening the dashboard");
        lore.add("\u00a77\u2022 Attempt to view player analysis");
        lore.add("\u00a77\u2022 Check alert access");
        lore.add("\u00a77\u2022 Test flag management");
        lore.add("");
        lore.add("\u00a77Permissions are checked in real-time");
        lore.add("\u00a77when accessing features");
        return this.createItem(Material.COMPASS, "\u00a7e\u00a7lPermission Testing", lore);
    }

    private ItemStack createPermissionGuideItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Permission setup guide");
        lore.add("");
        lore.add("\u00a7e\u00a7lSetup Guide:");
        lore.add("\u00a771. Choose appropriate permission level:");
        lore.add("\u00a77   \u2022 Admin: Full access");
        lore.add("\u00a77   \u2022 Moderator: Staff features");
        lore.add("\u00a77   \u2022 Player: Basic access");
        lore.add("");
        lore.add("\u00a772. Use your permission plugin:");
        lore.add("\u00a77   \u2022 LuckPerms: /lp user <name> permission set");
        lore.add("\u00a77   \u2022 PermissionsEx: /pex user <name> add");
        lore.add("\u00a77   \u2022 GroupManager: /manuadd <name> <group>");
        lore.add("");
        lore.add("\u00a773. Test permissions after assignment");
        lore.add("\u00a774. Use /auditor reload to refresh");
        return this.createItem(Material.BOOK, "\u00a7f\u00a7lSetup Guide", lore);
    }

    private ItemStack createPermissionTemplatesItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Pre-configured permission templates");
        lore.add("");
        lore.add("\u00a7e\u00a7lAvailable Templates:");
        lore.add("");
        lore.add("\u00a7c\u00a7lAdmin Template:");
        lore.add("\u00a77\u2022 auditor.admin");
        lore.add("\u00a77\u2022 (Includes all permissions)");
        lore.add("");
        lore.add("\u00a76\u00a7lModerator Template:");
        lore.add("\u00a77\u2022 auditor.moderator");
        lore.add("\u00a77\u2022 auditor.dashboard");
        lore.add("\u00a77\u2022 auditor.player.view");
        lore.add("\u00a77\u2022 auditor.player.others");
        lore.add("\u00a77\u2022 auditor.alerts.view");
        lore.add("\u00a77\u2022 auditor.alerts.manage");
        lore.add("\u00a77\u2022 auditor.monitor");
        lore.add("\u00a77\u2022 auditor.flag");
        lore.add("\u00a77\u2022 auditor.note");
        lore.add("");
        lore.add("\u00a7a\u00a7lPlayer Template:");
        lore.add("\u00a77\u2022 auditor.dashboard");
        lore.add("\u00a77\u2022 auditor.player.view");
        return this.createItem(Material.WRITABLE_BOOK, "\u00a7d\u00a7lPermission Templates", lore);
    }

    private ItemStack createBulkPermissionItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Bulk permission management tools");
        lore.add("");
        lore.add("\u00a7e\u00a7lBulk Operations:");
        lore.add("\u00a77These operations require external");
        lore.add("\u00a77permission plugins to execute");
        lore.add("");
        lore.add("\u00a7b\u00a7lSuggested Commands:");
        lore.add("\u00a77\u2022 Grant all staff auditor.moderator");
        lore.add("\u00a77\u2022 Give all players auditor.dashboard");
        lore.add("\u00a77\u2022 Remove permissions from group");
        lore.add("");
        lore.add("\u00a7c\u00a7lWarning:");
        lore.add("\u00a77Bulk operations should be performed");
        lore.add("\u00a77through your permission plugin's");
        lore.add("\u00a77group management system");
        lore.add("");
        lore.add("\u00a77This GUI shows current status only");
        return this.createItem(Material.COMMAND_BLOCK, "\u00a75\u00a7lBulk Management", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to main settings");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack to Settings", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh permission data");
        lore.add("\u00a77Updates online player status");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    private ItemStack createPermissionFileItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Permission configuration file info");
        lore.add("");
        lore.add("\u00a7e\u00a7lPlugin Configuration:");
        lore.add("\u00a77Auditor permissions are handled by");
        lore.add("\u00a77your server's permission plugin");
        lore.add("");
        lore.add("\u00a7b\u00a7lCommon Permission Plugins:");
        lore.add("\u00a77\u2022 LuckPerms (Recommended)");
        lore.add("\u00a77\u2022 PermissionsEx");
        lore.add("\u00a77\u2022 GroupManager");
        lore.add("\u00a77\u2022 bPermissions");
        lore.add("");
        lore.add("\u00a77Auditor uses Bukkit's permission API");
        lore.add("\u00a77and works with any compatible plugin");
        return this.createItem(Material.PAPER, "\u00a7f\u00a7lConfiguration Info", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                this.refresh();
                break;
            }
            case 22: {
                this.refresh();
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 40: 
            case 42: 
            case 53: {
                this.refresh();
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openSettings(this.player);
                break;
            }
            case 49: {
                this.refresh();
            }
        }
    }

    private int getOnlinePlayersWithPermissions() {
        int count = 0;
        block0: for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (onlinePlayer.isOp()) {
                ++count;
                continue;
            }
            for (String permission : this.permissionNodes.keySet()) {
                if (!onlinePlayer.hasPermission(permission)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }
}

